/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.Cookie;
import HTTPClient.CookiePolicyHandler;
import HTTPClient.CookiePrompter;
import HTTPClient.HttpClientUtil;
import HTTPClient.RoRequest;
import HTTPClient.RoResponse;

class DefaultCookiePolicyHandler
implements CookiePolicyHandler {
    private String[] accept_domains = new String[0];
    private String[] reject_domains = new String[0];
    private static CookiePrompter prompter = null;

    DefaultCookiePolicyHandler() {
        String list;
        try {
            list = System.getProperty("HTTPClient.cookies.hosts.accept");
        }
        catch (Exception e) {
            list = null;
        }
        String[] domains = HttpClientUtil.splitProperty(list);
        for (int idx = 0; idx < domains.length; ++idx) {
            this.addAcceptDomain(domains[idx].toLowerCase());
        }
        try {
            list = System.getProperty("HTTPClient.cookies.hosts.reject");
        }
        catch (Exception e) {
            list = null;
        }
        domains = HttpClientUtil.splitProperty(list);
        for (int idx = 0; idx < domains.length; ++idx) {
            this.addRejectDomain(domains[idx].toLowerCase());
        }
    }

    public boolean acceptCookie(Cookie cookie, RoRequest req, RoResponse resp) {
        int idx;
        String server = req.getConnection().getHost();
        if (server.indexOf(46) == -1) {
            server = server + ".local";
        }
        for (idx = 0; idx < this.reject_domains.length; ++idx) {
            if (this.reject_domains[idx].length() != 0 && (this.reject_domains[idx].charAt(0) != '.' || !server.endsWith(this.reject_domains[idx])) && (this.reject_domains[idx].charAt(0) == '.' || !server.equals(this.reject_domains[idx]))) continue;
            return false;
        }
        for (idx = 0; idx < this.accept_domains.length; ++idx) {
            if (this.accept_domains[idx].length() != 0 && (this.accept_domains[idx].charAt(0) != '.' || !server.endsWith(this.accept_domains[idx])) && (this.accept_domains[idx].charAt(0) == '.' || !server.equals(this.accept_domains[idx]))) continue;
            return true;
        }
        if (prompter == null) {
            return true;
        }
        return prompter.accept(cookie, this, server);
    }

    public boolean sendCookie(Cookie cookie, RoRequest req) {
        return true;
    }

    void addAcceptDomain(String domain) {
        if (domain.indexOf(46) == -1) {
            domain = domain + ".local";
        }
        for (int idx = 0; idx < this.accept_domains.length; ++idx) {
            if (domain.endsWith(this.accept_domains[idx])) {
                return;
            }
            if (!this.accept_domains[idx].endsWith(domain)) continue;
            this.accept_domains[idx] = domain;
            return;
        }
        this.accept_domains = HttpClientUtil.resizeArray(this.accept_domains, this.accept_domains.length + 1);
        this.accept_domains[this.accept_domains.length - 1] = domain;
    }

    void addRejectDomain(String domain) {
        if (domain.indexOf(46) == -1) {
            domain = domain + ".local";
        }
        for (int idx = 0; idx < this.reject_domains.length; ++idx) {
            if (domain.endsWith(this.reject_domains[idx])) {
                return;
            }
            if (!this.reject_domains[idx].endsWith(domain)) continue;
            this.reject_domains[idx] = domain;
            return;
        }
        this.reject_domains = HttpClientUtil.resizeArray(this.reject_domains, this.reject_domains.length + 1);
        this.reject_domains[this.reject_domains.length - 1] = domain;
    }
}

