/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.AnonLib;
import anon.client.AbstractDataChain;
import anon.client.AbstractDataChannel;
import anon.client.FixedRatioChannelsDescription;
import anon.client.IDataChannelFactory;
import anon.client.KeyExchangeManager;
import anon.client.Multiplexer;
import anon.client.SimulatedLimitedDataChannel;
import anon.client.UnlimitedDataChannel;
import anon.client.crypto.DataChannelCipher;
import anon.client.crypto.DataChannelCipherSDK;
import anon.client.crypto.DefaultMixCipher;
import anon.client.crypto.FirstMixCipher;
import anon.client.crypto.IDataChannelChipher;
import anon.client.crypto.IMixCipher;
import anon.client.crypto.ISymCipher;
import anon.client.crypto.KeyPool;
import anon.client.crypto.LastMixCipher;
import anon.client.crypto.MixCipherChain;
import anon.client.crypto.SymCipherFactory;

public class DefaultDataChannelFactory
implements IDataChannelFactory {
    private static final int SYMMETRIC_CIPHER_KEY_LENGTH = 16;
    private static final int SYMMETRIC_CIPHER_BLOCK_LENGTH = 16;
    private KeyExchangeManager m_keyExchangeManager;
    private Multiplexer m_multiplexer;

    public DefaultDataChannelFactory(KeyExchangeManager a_keyExchangeManager, Multiplexer a_multiplexer) {
        this.m_keyExchangeManager = a_keyExchangeManager;
        this.m_multiplexer = a_multiplexer;
    }

    public AbstractDataChannel createDataChannel(int a_channelId, AbstractDataChain a_parentDataChain) {
        IMixCipher[] mixCiphers = new IMixCipher[this.m_keyExchangeManager.getMixParameters().length];
        for (int i = 0; i < mixCiphers.length; ++i) {
            byte[] channelKeys;
            ISymCipher channelCipher;
            if (i == 0 && this.m_keyExchangeManager.getFirstMixSymmetricCipher() != null) {
                int symCipherAlgType = this.m_keyExchangeManager.getMixParameters()[i].getSymChannelCipherAlgorithm();
                channelCipher = SymCipherFactory.createSymCipher(symCipherAlgType);
                if (this.m_keyExchangeManager.isProtocolWithEnhancedChannelEncryption()) {
                    channelKeys = new byte[32];
                    KeyPool.getKey(channelKeys);
                    KeyPool.getKey(channelKeys, 16);
                } else {
                    channelKeys = new byte[16];
                    KeyPool.getKey(channelKeys);
                }
                channelCipher.setEncryptionKeysAES(channelKeys);
                byte[] iv2Buffer = new byte[16];
                for (int j = 0; j < iv2Buffer.length; ++j) {
                    iv2Buffer[j] = -1;
                }
                channelCipher.setIV2(iv2Buffer);
                mixCiphers[i] = new FirstMixCipher(this.m_keyExchangeManager.getFirstMixSymmetricCipher(), channelCipher);
                continue;
            }
            if (i == mixCiphers.length - 1 && this.m_keyExchangeManager.isProtocolWithIntegrityCheck()) {
                byte[] channelKeys2;
                IDataChannelChipher channelCipher2 = AnonLib.USE_SDK_GCM ? new DataChannelCipherSDK() : new DataChannelCipher();
                if (this.m_keyExchangeManager.isProtocolWithEnhancedChannelEncryption()) {
                    channelKeys2 = new byte[32];
                    KeyPool.getKey(channelKeys2);
                    KeyPool.getKey(channelKeys2, 16);
                } else {
                    channelKeys2 = new byte[16];
                    KeyPool.getKey(channelKeys2);
                }
                channelCipher2.setEncryptionKeysAES(channelKeys2);
                mixCiphers[i] = new LastMixCipher(this.m_keyExchangeManager.getMixParameters()[i], channelCipher2, this.m_keyExchangeManager.isDebug());
                continue;
            }
            int alg = this.m_keyExchangeManager.getMixParameters()[i].getSymChannelCipherAlgorithm();
            channelCipher = SymCipherFactory.createSymCipher(alg);
            if (this.m_keyExchangeManager.isProtocolWithEnhancedChannelEncryption()) {
                channelKeys = new byte[32];
                KeyPool.getKey(channelKeys);
                KeyPool.getKey(channelKeys, 16);
            } else {
                channelKeys = new byte[16];
                KeyPool.getKey(channelKeys);
            }
            channelCipher.setEncryptionKeysAES(channelKeys);
            mixCiphers[i] = new DefaultMixCipher(this.m_keyExchangeManager.getMixParameters()[i], channelCipher);
        }
        FixedRatioChannelsDescription channelsDescription = this.m_keyExchangeManager.getFixedRatioChannelsDescription();
        if (channelsDescription == null) {
            return new UnlimitedDataChannel(a_channelId, this.m_multiplexer, a_parentDataChain, new MixCipherChain(mixCiphers));
        }
        return new SimulatedLimitedDataChannel(a_channelId, this.m_multiplexer, a_parentDataChain, new MixCipherChain(mixCiphers), channelsDescription.getChannelDownstreamPackets(), channelsDescription.getChannelTimeout());
    }
}

