/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.AbstractDataChain;
import anon.client.AbstractDataChannel;
import anon.client.DataChainErrorListener;
import anon.client.DataChainInputStreamQueueEntry;
import anon.client.DataChainSendOrderStructure;
import anon.client.IDataChannelCreator;
import anon.client.IntegrityErrorListener;
import anon.client.InternalChannelMessage;
import anon.client.InternalChannelMessageQueue;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import logging.LogHolder;
import logging.LogType;

public final class SingleChannelDataChain
extends AbstractDataChain {
    private static final int FLAG_FLOW_CONTROL = 32768;
    private static final int CLOSE_CELL_CONNECTION_ERROR = 1;
    private static final short FLAG_INTEGRITY_ERROR = 16384;
    private static final int CHAIN_HEADER_LEN = 3;
    private int m_chainType;
    private boolean m_supportFlowControl;
    private boolean m_supportUpstreamFlowControl;
    private AbstractDataChannel m_associatedChannel;
    private boolean m_firstUpstreamPacket;
    private int m_downstreamSendMeCount;
    private int m_upstreamSendMeCount;
    private int m_downstreamSendMeLimit;
    private int m_upstreamSendMeLimit;
    private Object m_oSyncUpstreamFlowControl;
    private boolean m_bWithIntegrityCheck;
    private InternalChannelMessageQueue m_internalChannelMessageQueue;

    public SingleChannelDataChain(IDataChannelCreator a_channelCreator, DataChainErrorListener a_errorListener, IntegrityErrorListener a_integrityErrorListener, int a_chainType, boolean a_supportFlowControl, boolean a_supportUpstreamFlowControl, int upstreamSendMe, int downstreamSendMe, boolean a_enhancedChannelEncryption, boolean a_withIntegrityCheck) {
        super(a_channelCreator, a_errorListener, a_integrityErrorListener);
        this.m_chainType = a_chainType;
        this.m_supportFlowControl = a_supportFlowControl;
        this.m_supportUpstreamFlowControl = a_supportUpstreamFlowControl;
        this.m_bWithIntegrityCheck = a_withIntegrityCheck;
        this.m_associatedChannel = this.createDataChannel();
        this.m_internalChannelMessageQueue = this.m_associatedChannel.getChannelMessageQueue();
        this.m_firstUpstreamPacket = true;
        this.m_downstreamSendMeCount = 0;
        this.m_downstreamSendMeLimit = downstreamSendMe;
        this.m_upstreamSendMeCount = 0;
        this.m_upstreamSendMeLimit = upstreamSendMe;
        this.m_oSyncUpstreamFlowControl = new Object();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutputBlockSize() {
        int channelPacketSize = 0;
        AbstractDataChannel abstractDataChannel = this.m_associatedChannel;
        synchronized (abstractDataChannel) {
            channelPacketSize = this.m_associatedChannel.getNextPacketRecommandedOutputBlocksize();
        }
        return Math.max(0, channelPacketSize - 3);
    }

    public void createPacketPayload(DataChainSendOrderStructure a_order) {
        if (a_order.getOrderData() != null) {
            int dataLength;
            int dataLengthField = dataLength = Math.min(a_order.getOrderData().length, a_order.getChannelCell().length - 3);
            if (this.m_supportFlowControl && a_order.getAdditionalProtocolData() instanceof Boolean && ((Boolean)a_order.getAdditionalProtocolData()).booleanValue()) {
                dataLengthField |= 0x8000;
            }
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream();
            DataOutputStream dataStream = new DataOutputStream(byteStream);
            try {
                dataStream.writeShort(dataLengthField);
                dataStream.flush();
                if (this.m_firstUpstreamPacket) {
                    byteStream.write(this.m_chainType);
                    this.m_firstUpstreamPacket = false;
                } else {
                    byteStream.write(0);
                }
                byteStream.write(a_order.getOrderData(), 0, dataLength);
                byteStream.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
            System.arraycopy(byteStream.toByteArray(), 0, a_order.getChannelCell(), 0, byteStream.toByteArray().length);
            a_order.setProcessedBytes(dataLength);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            while (this.m_internalChannelMessageQueue == null) {
                Thread.sleep(10L);
            }
            while (!Thread.interrupted()) {
                InternalChannelMessage currentMessage = null;
                currentMessage = this.m_internalChannelMessageQueue.waitForNextMessage();
                byte[] packetData = currentMessage.getMessageData();
                if (packetData != null && !currentMessage.getMixCipherChain().decryptPacket(packetData)) {
                    this.closeDataChain();
                    this.propagateIntegrityError(-33);
                    continue;
                }
                switch (currentMessage.getMessageCode()) {
                    case 1: {
                        ChainCell dataCell;
                        try {
                            ++this.m_downstreamSendMeCount;
                            dataCell = new ChainCell(packetData);
                            if (this.m_supportFlowControl && this.m_downstreamSendMeCount >= this.m_downstreamSendMeLimit) {
                                LogHolder.log(7, LogType.NET, "FlowControl: Will sent sendme - and download packet counter is: " + this.m_downstreamSendMeCount);
                                DataChainSendOrderStructure order = new DataChainSendOrderStructure(new byte[0]);
                                order.setAdditionalProtocolData(new Boolean(true));
                                this.orderPacket(order);
                                this.m_downstreamSendMeCount = 0;
                            }
                            if (this.m_supportUpstreamFlowControl && dataCell.isFlowControlFlagSet()) {
                                Object object = this.m_oSyncUpstreamFlowControl;
                                synchronized (object) {
                                    LogHolder.log(7, LogType.NET, "got sendme - and upstream packet counter is: " + this.m_upstreamSendMeCount);
                                    this.m_upstreamSendMeCount = Math.max(0, this.m_upstreamSendMeCount - this.m_upstreamSendMeLimit);
                                    this.m_oSyncUpstreamFlowControl.notifyAll();
                                }
                            }
                            this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(1, dataCell.getRawData(), 3, dataCell.getPayloadLength()));
                        }
                        catch (InvalidChainCellException e) {
                            this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException(e.toString())));
                        }
                        break;
                    }
                    case 2: {
                        ChainCell dataCell;
                        this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(2));
                        try {
                            if (packetData != null) {
                                dataCell = new ChainCell(packetData);
                                if (dataCell.getPayloadLength() == 0 && dataCell.getPayloadType() == 1) {
                                    this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException("SingleChannelDataChain: run(): Last mix signaled connection error.")));
                                    this.propagateConnectionError();
                                }
                                if (dataCell.isIntegrityErrorFlagSet() && this.m_bWithIntegrityCheck) {
                                    this.propagateIntegrityError(-34);
                                }
                            }
                        }
                        catch (InvalidChainCellException e) {
                            this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException(e.toString())));
                        }
                        Thread.currentThread().interrupt();
                        break;
                    }
                    case 3: {
                        this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException("SingleChannelDataChain: run(): Channel signaled an exception - closing chain.")));
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void orderPacket(DataChainSendOrderStructure a_order) {
        Object object;
        if (!(!this.m_supportUpstreamFlowControl || a_order.getAdditionalProtocolData() instanceof Boolean && ((Boolean)a_order.getAdditionalProtocolData()).booleanValue())) {
            object = this.m_oSyncUpstreamFlowControl;
            synchronized (object) {
                while (this.m_upstreamSendMeCount > 2 * this.m_upstreamSendMeLimit && !this.isClosed()) {
                    try {
                        this.m_oSyncUpstreamFlowControl.wait();
                    }
                    catch (Exception exception) {}
                }
                ++this.m_upstreamSendMeCount;
            }
        }
        object = this.m_associatedChannel;
        synchronized (object) {
            this.m_associatedChannel.processSendOrder(a_order);
        }
    }

    protected void outputStreamClosed() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeDataChain() {
        Object object = this.m_associatedChannel;
        synchronized (object) {
            try {
                this.m_associatedChannel.organizeChannelClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        object = this.m_oSyncUpstreamFlowControl;
        synchronized (object) {
            this.m_oSyncUpstreamFlowControl.notifyAll();
        }
    }

    private final class ChainCell {
        private static final int DATALENGTH_MASK = 1023;
        private byte[] m_rawData;
        private int m_payloadLen;
        private int m_payloadType;
        private boolean m_flowControlFlagSet;
        private boolean m_integrityErrorFlagSet;

        public ChainCell(byte[] a_rawData) throws InvalidChainCellException {
            if (a_rawData.length < 3) {
                throw new InvalidChainCellException("SingleChannelDataChain: ChainCell: Constructor: Length of ChainCell must be at least 3 bytes.");
            }
            int lengthAndFlagsField = (a_rawData[0] << 8 | a_rawData[1] & 0xFF) & 0xFFFF;
            this.m_payloadType = a_rawData[2] & 0xFF;
            this.m_flowControlFlagSet = false;
            this.m_integrityErrorFlagSet = false;
            int flags = lengthAndFlagsField & 0xFFFFFC00;
            if (SingleChannelDataChain.this.m_supportFlowControl && (flags & 0x8000) == 32768) {
                this.m_flowControlFlagSet = true;
            }
            if ((flags & 0x4000) == 16384) {
                this.m_integrityErrorFlagSet = true;
            }
            this.m_payloadLen = lengthAndFlagsField & 0x3FF;
            int dataOffset = 3;
            if (dataOffset + this.m_payloadLen > a_rawData.length) {
                throw new InvalidChainCellException("SingleChannelDataChain: ChainCell: Constructor: ChainCell has invalid length-field.");
            }
            this.m_rawData = a_rawData;
        }

        public byte[] getRawData() {
            return this.m_rawData;
        }

        public int getPayloadType() {
            return this.m_payloadType;
        }

        public int getPayloadLength() {
            return this.m_payloadLen;
        }

        public boolean isFlowControlFlagSet() {
            return this.m_flowControlFlagSet;
        }

        public boolean isIntegrityErrorFlagSet() {
            return this.m_integrityErrorFlagSet;
        }
    }

    private class InvalidChainCellException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public InvalidChainCellException(String a_message) {
            super(a_message);
        }
    }
}

