/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class ControlChannelCipher {
    GCMBlockCipher m_sentEngine = new GCMBlockCipher(new AESFastEngine());
    GCMBlockCipher m_recvEngine = new GCMBlockCipher(new AESFastEngine());
    long m_EncMsgCounter = 0L;
    long m_DecMsgCounter = 0L;
    byte[] m_sentKey;
    byte[] m_recvKey;

    public synchronized int setSentKey(byte[] key, int offset, int len) {
        try {
            this.m_sentKey = new byte[16];
            System.arraycopy(key, offset, this.m_sentKey, 0, 16);
            this.m_EncMsgCounter = 0L;
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public synchronized int setRecvKey(byte[] key, int offset, int len) {
        try {
            this.m_recvKey = new byte[16];
            System.arraycopy(key, offset, this.m_recvKey, 0, 16);
            this.m_DecMsgCounter = 0L;
            return 0;
        }
        catch (Exception e) {
            return -1;
        }
    }

    private byte[] createIV(long counter) {
        byte[] iv = new byte[12];
        for (int i = 0; i < 8; ++i) {
            iv[i] = 0;
        }
        iv[8] = (byte)(counter >> 24 & 0xFFL);
        iv[9] = (byte)(counter >> 16 & 0xFFL);
        iv[10] = (byte)(counter >> 8 & 0xFFL);
        iv[11] = (byte)(counter & 0xFFL);
        return iv;
    }

    public void encryptGCM1(byte[] from, int ifrom, byte[] to, int ito, int len) throws Exception {
        byte[] iv = this.createIV(this.m_EncMsgCounter);
        ++this.m_EncMsgCounter;
        this.m_sentEngine.init(true, new AEADParameters(new KeyParameter(this.m_sentKey), 128, iv, null));
        int outlen = this.m_sentEngine.processBytes(from, ifrom, len, to, ito);
        this.m_sentEngine.doFinal(to, ito + outlen);
    }

    public void decryptGCM2(byte[] from, int ifrom, byte[] to, int ito, int len) throws Exception {
        byte[] iv = this.createIV(this.m_DecMsgCounter);
        ++this.m_DecMsgCounter;
        this.m_recvEngine.init(false, new AEADParameters(new KeyParameter(this.m_recvKey), 128, iv, null));
        int declen = this.m_recvEngine.processBytes(from, ifrom, len, to, ito);
        this.m_recvEngine.doFinal(to, ito + declen);
    }

    public int getEncryptedOutputSize(int inputlength) {
        return inputlength + 16;
    }

    public int getDecryptedOutputSize(int enclength) {
        return enclength - 16;
    }
}

