/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import anon.client.crypto.IMixCipher;
import java.util.Vector;

public class MixCipherChain {
    private IMixCipher[] m_cipherChain;

    public MixCipherChain(IMixCipher[] a_cipherChain) {
        this.m_cipherChain = a_cipherChain;
    }

    public byte[] encryptPacket(byte[] a_plainPacket, int a_virtualPacketLength, Vector a_sendCallbackHandlers) {
        byte[] encryptedPacket = a_plainPacket;
        for (int i = this.m_cipherChain.length - 1; i >= 0; --i) {
            encryptedPacket = this.m_cipherChain[i].encrypt(encryptedPacket, a_virtualPacketLength, a_sendCallbackHandlers);
        }
        return encryptedPacket;
    }

    public int getNextPacketEncryptionOverhead() {
        int overhead = 0;
        for (int i = this.m_cipherChain.length - 1; i >= 0; --i) {
            overhead += this.m_cipherChain[i].getNextPacketEncryptionOverhead();
        }
        return overhead;
    }

    public boolean decryptPacket(byte[] m_packet) {
        boolean bSuccess = true;
        for (int i = 0; i < this.m_cipherChain.length; ++i) {
            bSuccess = bSuccess && this.m_cipherChain[i].decrypt(m_packet);
        }
        return bSuccess;
    }
}

