/*
 * Decompiled with CFR 0.152.
 */
package anon.client.crypto;

import anon.client.crypto.ISymCipher;
import org.bouncycastle.crypto.engines.AESFastEngine;
import org.bouncycastle.crypto.params.KeyParameter;

public final class SymCipher
implements ISymCipher {
    public static final int NO_ENCRYPTION = 0;
    public static final int OFB = 1;
    public static final int CTR = 2;
    public static final int UNKNOWN_ALGORITHM = -1;
    AESFastEngine m_aesEngine1 = new AESFastEngine();
    AESFastEngine m_aesEngine2 = new AESFastEngine();
    byte[] m_iv1 = new byte[16];
    byte[] m_iv2 = null;
    byte[] m_aesKeys = null;

    public SymCipher() {
        int i;
        for (i = 0; i < 16; ++i) {
            this.m_iv1[i] = 0;
        }
        this.m_iv2 = new byte[16];
        for (i = 0; i < 16; ++i) {
            this.m_iv2[i] = 0;
        }
    }

    public synchronized int setEncryptionKeyAES(byte[] key) {
        return this.setEncryptionKeyAES(key, 0, 16);
    }

    public synchronized int setEncryptionKeyAES(byte[] key, int offset, int len) {
        try {
            this.m_aesKeys = new byte[16];
            System.arraycopy(key, offset, this.m_aesKeys, 0, 16);
            this.m_aesEngine1.init(true, new KeyParameter(this.m_aesKeys));
            this.m_aesEngine2.init(true, new KeyParameter(this.m_aesKeys));
            if (len == 16) {
                for (int i = 0; i < 16; ++i) {
                    this.m_iv1[i] = 0;
                    this.m_iv2[i] = 0;
                }
            } else {
                for (int i = 0; i < 16; ++i) {
                    this.m_iv1[i] = key[16 + i + offset];
                    this.m_iv2[i] = key[16 + i + offset];
                }
            }
            return 0;
        }
        catch (Exception e) {
            this.m_aesKeys = null;
            return -1;
        }
    }

    public synchronized int setEncryptionKeysAES(byte[] keys) {
        try {
            if (keys.length == 16) {
                return this.setEncryptionKeyAES(keys);
            }
            this.m_aesKeys = new byte[32];
            System.arraycopy(keys, 0, this.m_aesKeys, 0, 32);
            this.m_aesEngine1.init(true, new KeyParameter(this.m_aesKeys, 0, 16));
            this.m_aesEngine2.init(true, new KeyParameter(this.m_aesKeys, 16, 16));
            for (int i = 0; i < 16; ++i) {
                this.m_iv1[i] = 0;
                this.m_iv2[i] = 0;
            }
            return 0;
        }
        catch (Exception e) {
            this.m_aesKeys = null;
            return -1;
        }
    }

    public byte[] getKeys() {
        return this.m_aesKeys;
    }

    public synchronized void setIV2(byte[] buff) {
        for (int i = 0; i < 16; ++i) {
            this.m_iv2[i] = buff[i];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encryptAES1(byte[] src, int s_offset, byte[] dest, int d_offset, int len) {
        AESFastEngine aESFastEngine;
        len = s_offset + len;
        while (s_offset < len - 15) {
            aESFastEngine = this.m_aesEngine1;
            synchronized (aESFastEngine) {
                this.m_aesEngine1.processBlock(this.m_iv1, 0, this.m_iv1, 0);
            }
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[0]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[1]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[2]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[3]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[4]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[5]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[6]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[7]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[8]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[9]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[10]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[11]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[12]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[13]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[14]);
            dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[15]);
        }
        if (s_offset < len) {
            aESFastEngine = this.m_aesEngine1;
            synchronized (aESFastEngine) {
                this.m_aesEngine1.processBlock(this.m_iv1, 0, this.m_iv1, 0);
            }
            len -= s_offset;
            for (int k = 0; k < len; ++k) {
                dest[d_offset++] = (byte)(src[s_offset++] ^ this.m_iv1[k]);
            }
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int encryptAES2(byte[] buff) {
        AESFastEngine aESFastEngine;
        int i = 0;
        int len = buff.length;
        while (i < len - 15) {
            aESFastEngine = this.m_aesEngine2;
            synchronized (aESFastEngine) {
                this.m_aesEngine2.processBlock(this.m_iv2, 0, this.m_iv2, 0);
            }
            int n = i++;
            buff[n] = (byte)(buff[n] ^ this.m_iv2[0]);
            int n2 = i++;
            buff[n2] = (byte)(buff[n2] ^ this.m_iv2[1]);
            int n3 = i++;
            buff[n3] = (byte)(buff[n3] ^ this.m_iv2[2]);
            int n4 = i++;
            buff[n4] = (byte)(buff[n4] ^ this.m_iv2[3]);
            int n5 = i++;
            buff[n5] = (byte)(buff[n5] ^ this.m_iv2[4]);
            int n6 = i++;
            buff[n6] = (byte)(buff[n6] ^ this.m_iv2[5]);
            int n7 = i++;
            buff[n7] = (byte)(buff[n7] ^ this.m_iv2[6]);
            int n8 = i++;
            buff[n8] = (byte)(buff[n8] ^ this.m_iv2[7]);
            int n9 = i++;
            buff[n9] = (byte)(buff[n9] ^ this.m_iv2[8]);
            int n10 = i++;
            buff[n10] = (byte)(buff[n10] ^ this.m_iv2[9]);
            int n11 = i++;
            buff[n11] = (byte)(buff[n11] ^ this.m_iv2[10]);
            int n12 = i++;
            buff[n12] = (byte)(buff[n12] ^ this.m_iv2[11]);
            int n13 = i++;
            buff[n13] = (byte)(buff[n13] ^ this.m_iv2[12]);
            int n14 = i++;
            buff[n14] = (byte)(buff[n14] ^ this.m_iv2[13]);
            int n15 = i++;
            buff[n15] = (byte)(buff[n15] ^ this.m_iv2[14]);
            int n16 = i++;
            buff[n16] = (byte)(buff[n16] ^ this.m_iv2[15]);
        }
        if (i < len) {
            aESFastEngine = this.m_aesEngine2;
            synchronized (aESFastEngine) {
                this.m_aesEngine2.processBlock(this.m_iv2, 0, this.m_iv2, 0);
            }
            len -= i;
            for (int k = 0; k < len; ++k) {
                int n = i++;
                buff[n] = (byte)(buff[n] ^ this.m_iv2[k]);
            }
        }
        return 0;
    }

    public static int getAlgorithmForName(String strAlg) {
        if (strAlg == null) {
            return -1;
        }
        if (strAlg.equals("AES/OFB/ANON")) {
            return 1;
        }
        if (strAlg.equals("AES/CTR")) {
            return 2;
        }
        if (strAlg.equals("NULL")) {
            return 0;
        }
        return -1;
    }
}

