/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto.tinytls.ciphersuites;

import anon.crypto.tinytls.TLSException;
import anon.crypto.tinytls.ciphersuites.CipherSuite;
import anon.crypto.tinytls.keyexchange.DHE_DSS_Key_Exchange;
import anon.util.ByteArrayUtil;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.modes.CBCBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;

public class DHE_DSS_WITH_3DES_CBC_SHA
extends CipherSuite {
    public DHE_DSS_WITH_3DES_CBC_SHA() throws TLSException {
        super(new byte[]{0, 19});
        this.m_ciphersuitename = "TLS_DHE_DSS_WITH_3DES_CBC_SHA";
        this.setKeyExchangeAlgorithm(new DHE_DSS_Key_Exchange());
    }

    protected void calculateKeys(byte[] keys, boolean forclient) {
        this.m_clientwritekey = ByteArrayUtil.copy(keys, 40, 24);
        this.m_serverwritekey = ByteArrayUtil.copy(keys, 64, 24);
        this.m_clientwriteIV = ByteArrayUtil.copy(keys, 88, 8);
        this.m_serverwriteIV = ByteArrayUtil.copy(keys, 96, 8);
        if (forclient) {
            this.m_clientmacsecret = ByteArrayUtil.copy(keys, 0, 20);
            this.m_servermacsecret = ByteArrayUtil.copy(keys, 20, 20);
            this.m_encryptcipher = new CBCBlockCipher(new DESedeEngine());
            this.m_encryptcipher.init(true, new ParametersWithIV(new KeyParameter(this.m_clientwritekey), this.m_clientwriteIV));
            this.m_decryptcipher = new CBCBlockCipher(new DESedeEngine());
            this.m_decryptcipher.init(false, new ParametersWithIV(new KeyParameter(this.m_serverwritekey), this.m_serverwriteIV));
        } else {
            this.m_servermacsecret = ByteArrayUtil.copy(keys, 0, 20);
            this.m_clientmacsecret = ByteArrayUtil.copy(keys, 20, 20);
            this.m_encryptcipher = new CBCBlockCipher(new DESedeEngine());
            this.m_encryptcipher.init(true, new ParametersWithIV(new KeyParameter(this.m_serverwritekey), this.m_serverwriteIV));
            this.m_decryptcipher = new CBCBlockCipher(new DESedeEngine());
            this.m_decryptcipher.init(false, new ParametersWithIV(new KeyParameter(this.m_clientwritekey), this.m_clientwriteIV));
        }
    }
}

