/*
 * Decompiled with CFR 0.152.
 */
package anon.forward.client;

import anon.infoservice.InfoServiceHolder;
import anon.util.XMLUtil;
import anon.util.captcha.IImageEncodedCaptcha;
import anon.util.captcha.ZipBinaryImageCaptchaClient;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ForwarderInformationGrabber {
    public static final int RETURN_SUCCESS = 0;
    public static final int RETURN_INFOSERVICE_ERROR = 1;
    public static final int RETURN_UNKNOWN_ERROR = 2;
    public static final int RETURN_NO_CAPTCHA_IMPLEMENTATION = 3;
    private int m_errorCode;
    private IImageEncodedCaptcha m_captcha = null;

    public ForwarderInformationGrabber() {
        Element japForwarderNode = InfoServiceHolder.getInstance().getForwarder();
        if (japForwarderNode != null) {
            NodeList captchaEncodedNodes = japForwarderNode.getElementsByTagName("CaptchaEncoded");
            if (captchaEncodedNodes.getLength() > 0) {
                Element captchaEncodedNode = (Element)captchaEncodedNodes.item(0);
                this.m_errorCode = this.findCaptchaImplementation(captchaEncodedNode);
            } else {
                this.m_errorCode = 2;
            }
        } else {
            this.m_errorCode = 1;
        }
    }

    public ForwarderInformationGrabber(String a_xmlData) {
        try {
            Document doc = XMLUtil.toXMLDocument(a_xmlData);
            NodeList japForwarderNodes = doc.getElementsByTagName("JapForwarder");
            if (japForwarderNodes.getLength() > 0) {
                Element japForwarderNode = (Element)japForwarderNodes.item(0);
                NodeList captchaEncodedNodes = japForwarderNode.getElementsByTagName("CaptchaEncoded");
                if (captchaEncodedNodes.getLength() > 0) {
                    Element captchaEncodedNode = (Element)captchaEncodedNodes.item(0);
                    this.m_errorCode = this.findCaptchaImplementation(captchaEncodedNode);
                } else {
                    this.m_errorCode = 2;
                }
            } else {
                this.m_errorCode = 2;
            }
        }
        catch (Exception e) {
            this.m_errorCode = 2;
        }
    }

    public int getErrorCode() {
        return this.m_errorCode;
    }

    public IImageEncodedCaptcha getCaptcha() {
        return this.m_captcha;
    }

    private int findCaptchaImplementation(Element a_captchaEncodedNode) {
        int returnCode = 2;
        NodeList captchaDataFormatNodes = a_captchaEncodedNode.getElementsByTagName("CaptchaDataFormat");
        if (captchaDataFormatNodes.getLength() > 0) {
            Element captchaDataFormatNode = (Element)captchaDataFormatNodes.item(0);
            if ("ZIP_BINARY_IMAGE".equals(captchaDataFormatNode.getFirstChild().getNodeValue())) {
                try {
                    this.m_captcha = new ZipBinaryImageCaptchaClient(a_captchaEncodedNode);
                    returnCode = 0;
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.MISC, "Error while creating the captcha implementation!", e);
                    returnCode = 2;
                }
            } else {
                returnCode = 3;
            }
        } else {
            returnCode = 2;
        }
        return returnCode;
    }
}

