/*
 * Decompiled with CFR 0.152.
 */
package anon.forward.client;

import anon.util.IProgressCapsule;
import java.util.Observable;

public class ProgressCounter
extends Observable {
    private ProgressCount m_capsule = new ProgressCount(1000000);
    private static final int MAXIMUM_PROTOCOLMESSAGE_SIZE = 1000000;
    private static final int MINIMUM_PACKET = 0;

    public void setMax(int a_maximum) {
        this.m_capsule.setMaximum(a_maximum);
    }

    public void incrValue() {
        this.incrValue(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void incrValue(int a_incrValue) {
        ProgressCount progressCount = this.m_capsule;
        synchronized (progressCount) {
            if (this.m_capsule.getStatus() == 1) {
                this.m_capsule.incrValue(a_incrValue);
                this.setChanged();
                this.notifyObservers(this.m_capsule);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ProgressCount progressCount = this.m_capsule;
        synchronized (progressCount) {
            this.m_capsule.setStatus(0);
        }
    }

    private class ProgressCount
    implements IProgressCapsule {
        private int m_maxPacket;
        private int m_counterValue;
        private int m_status;

        ProgressCount(int a_max) {
            this.m_maxPacket = a_max;
            this.reset();
        }

        public void reset() {
            this.m_counterValue = 0;
            this.m_status = 1;
        }

        public int getMinimum() {
            return 0;
        }

        public int getValue() {
            return this.m_counterValue;
        }

        public int getStatus() {
            return this.m_status;
        }

        public void setStatus(int a_status) {
            this.m_status = a_status;
        }

        public String getMessage() {
            return null;
        }

        public int getMaximum() {
            return this.m_maxPacket;
        }

        public void setMaximum(int a_maximum) {
            this.m_maxPacket = a_maximum;
        }

        public void incrValue(int a_incrValue) {
            this.m_counterValue += a_incrValue;
        }
    }
}

