/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.infoservice.AbstractDistributableDatabaseEntry;
import anon.util.Base64;
import anon.util.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ANONAddress
extends AbstractDistributableDatabaseEntry {
    public static final String XML_ELEMENT_NAME = "ANONAddress";
    private static final long MAX_STORAGE_TIME_IN_MILLI_SECONDS = 604800000L;
    private static final int MAX_ADDRESS_SIZE = 32;
    private static final int MAX_BLINDED_KEY_SIZE = 32;
    private static final int MAX_XML_STRUCT_SIZE = 264;
    private String m_strID;
    private Element m_xmlStructure;
    private byte[] m_bytesPostData;
    private long m_lastUpdate;
    private String m_strAddress;
    private byte[] m_arBlindedKey;

    public ANONAddress(String id, Element a_elemAnonAddressRootNode) throws Exception {
        super(0L);
        this.m_strID = id;
        if (a_elemAnonAddressRootNode == null || !XML_ELEMENT_NAME.equals(a_elemAnonAddressRootNode.getNodeName())) {
            throw new Exception("ANONAddress - wrong root XML node name");
        }
        Node elemAddress = XMLUtil.getFirstChildByName(a_elemAnonAddressRootNode, "Address");
        this.m_strAddress = XMLUtil.parseValue(elemAddress, (String)null);
        Node elemBlindedKey = XMLUtil.getFirstChildByName(a_elemAnonAddressRootNode, "BlindedKey");
        String strBlindedKey = XMLUtil.parseValue(elemBlindedKey, (String)null);
        if (strBlindedKey != null) {
            this.m_arBlindedKey = Base64.decode(strBlindedKey);
        }
        if (this.m_strAddress == null && this.m_arBlindedKey == null) {
            throw new Exception("ANONAddress - not <Address> or <BlindedKey> information given");
        }
        if (this.m_strAddress != null && this.m_strAddress.length() > 32) {
            throw new Exception("ANONAddress - <Address> to large");
        }
        if (this.m_arBlindedKey != null && this.m_arBlindedKey.length > 32) {
            throw new Exception("ANONAddress - <BlindedKey> to large");
        }
        Node elemLastUpdate = XMLUtil.getFirstChildByName(a_elemAnonAddressRootNode, "LastUpdate");
        this.m_lastUpdate = XMLUtil.parseValue(elemLastUpdate, -1L);
        if (this.m_lastUpdate < 0L) {
            throw new Exception("ANONAddress - not <LastUpdate> information given");
        }
        this.m_lastUpdate *= 1000L;
        this.m_xmlStructure = a_elemAnonAddressRootNode;
        this.m_bytesPostData = super.getPostData();
        if (this.m_bytesPostData.length > 264) {
            throw new Exception("ANONAddress - XML struct to large");
        }
        Node elemExpire = XMLUtil.getFirstChildByName(a_elemAnonAddressRootNode, "Expire");
        long lExpire = XMLUtil.parseValue(elemExpire, -1L);
        if ((lExpire *= 1000L) < 0L || lExpire > System.currentTimeMillis() + 604800000L) {
            lExpire = System.currentTimeMillis() + 604800000L;
        }
        this.setExpireTime(lExpire);
    }

    public ANONAddress(String id, String addr, byte[] arBlindedKey) {
        super(System.currentTimeMillis() + 604800000L);
        this.m_strID = id;
        this.m_lastUpdate = System.currentTimeMillis();
        this.m_strAddress = addr;
        this.m_arBlindedKey = arBlindedKey;
        this.m_xmlStructure = this.toXMLElement();
        this.m_bytesPostData = super.getPostData();
    }

    private Element toXMLElement() {
        Element elemAddr;
        Document doc = XMLUtil.createDocument();
        Element elemRoot = XMLUtil.createChildElement(doc, XML_ELEMENT_NAME);
        if (this.m_strAddress != null) {
            elemAddr = XMLUtil.createChildElement(elemRoot, "Address");
            XMLUtil.setValue((Node)elemAddr, this.m_strAddress);
        }
        if (this.m_arBlindedKey != null) {
            elemAddr = XMLUtil.createChildElement(elemRoot, "BlindedKey");
            String strBlindedKey = Base64.encode(this.m_arBlindedKey, false);
            XMLUtil.setValue((Node)elemAddr, strBlindedKey);
        }
        Element elemLastUpdate = XMLUtil.createChildElement(elemRoot, "LastUpdate");
        XMLUtil.setValue((Node)elemLastUpdate, this.m_lastUpdate / 1000L);
        Element elemExpire = XMLUtil.createChildElement(elemRoot, "Expire");
        XMLUtil.setValue((Node)elemExpire, this.getExpireTime() / 1000L);
        return elemRoot;
    }

    public String getPostFile() {
        return "/anonaddress/" + this.m_strID;
    }

    public Element getXmlStructure() {
        return this.m_xmlStructure;
    }

    public byte[] getPostData() {
        return this.m_bytesPostData;
    }

    public String getId() {
        return this.m_strID;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public long getVersionNumber() {
        return this.m_lastUpdate;
    }

    public static String getXmlElementName() {
        return XML_ELEMENT_NAME;
    }

    public String getAddress() {
        return this.m_strAddress;
    }

    public byte[] getBlindeyKey() {
        return this.m_arBlindedKey;
    }
}

