/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.fec;

import anon.mixminion.fec.FECCode;
import anon.mixminion.fec.FECMath;
import anon.mixminion.fec.PureCode;
import anon.util.ByteArrayUtil;

public class Pure16Code
extends PureCode {
    protected static final FECMath fecMath = new FECMath(16);

    public Pure16Code(int k, int n) {
        super(k, n, fecMath.createEncodeMatrix(k, n));
    }

    public void encode(byte[][] src, int[] srcOff, byte[][] repair, int[] repairOff, int[] index, int packetLength) {
        int i;
        if (packetLength % 2 != 0) {
            throw new IllegalArgumentException("For 16 bit codes, buffers must be 16 bit aligned.");
        }
        char[][] srcChars = new char[src.length][];
        int[] srcCharsOff = new int[src.length];
        int numChars = packetLength / 2;
        char[] repairChars = new char[numChars];
        for (i = 0; i < srcChars.length; ++i) {
            srcChars[i] = new char[numChars];
            ByteArrayUtil.byteArrayToCharArray(src[i], srcOff[i], srcChars[i], 0, packetLength);
            srcCharsOff[i] = 0;
        }
        for (i = 0; i < repair.length; ++i) {
            if (index[i] < this.k) {
                System.arraycopy(src[index[i]], srcOff[index[i]], repair[i], repairOff[i], packetLength);
                continue;
            }
            this.encode(srcChars, srcCharsOff, repairChars, 0, index[i], numChars);
            ByteArrayUtil.charArrayToByteArray(repairChars, 0, repair[i], repairOff[i], packetLength);
        }
    }

    protected void encode(char[][] src, int[] srcOff, char[] repair, int repairOff, int index, int numChars) {
        int pos = index * this.k;
        ByteArrayUtil.bzero(repair, repairOff, numChars);
        for (int i = 0; i < this.k; ++i) {
            fecMath.addMul(repair, repairOff, src[i], srcOff[i], this.encMatrix[pos + i], numChars);
        }
    }

    public void decode(byte[][] pkts, int[] pktsOff, int[] index, int packetLength, boolean inOrder) {
        if (packetLength % 2 != 0) {
            throw new IllegalArgumentException("For 16 bit codes, buffers must be 16 bit aligned.");
        }
        if (!inOrder) {
            FECCode.shuffle(pkts, pktsOff, index, this.k);
        }
        char[][] pktsChars = new char[pkts.length][];
        int[] pktsCharsOff = new int[pkts.length];
        int numChars = packetLength / 2;
        for (int i = 0; i < pktsChars.length; ++i) {
            pktsChars[i] = new char[numChars];
            ByteArrayUtil.byteArrayToCharArray(pkts[i], pktsOff[i], pktsChars[i], 0, packetLength);
            pktsCharsOff[i] = 0;
        }
        char[][] result = this.decode(pktsChars, pktsCharsOff, index, numChars);
        for (int i = 0; i < result.length; ++i) {
            if (result[i] == null) continue;
            ByteArrayUtil.charArrayToByteArray(result[i], 0, pkts[i], pktsOff[i], packetLength);
            index[i] = i;
        }
    }

    protected char[][] decode(char[][] pkts, int[] pktsOff, int[] index, int numChars) {
        char[] decMatrix = fecMath.createDecodeMatrix(this.encMatrix, index, this.k, this.n);
        char[][] tmpPkts = new char[this.k][];
        for (int row = 0; row < this.k; ++row) {
            if (index[row] < this.k) continue;
            tmpPkts[row] = new char[numChars];
            for (int col = 0; col < this.k; ++col) {
                fecMath.addMul(tmpPkts[row], 0, pkts[col], pktsOff[col], decMatrix[row * this.k + col], numChars);
            }
        }
        return tmpPkts;
    }

    public String toString() {
        return new String("Pure16Code[k=" + this.k + ",n=" + this.n + "]");
    }
}

