/*
 * Decompiled with CFR 0.152.
 */
package anon.mixminion.fec;

import anon.mixminion.fec.FECCode;
import anon.mixminion.fec.FECMath;
import anon.util.ByteArrayUtil;

public class PureCode
extends FECCode {
    public static final int FEC_MAGIC = -20181524;
    protected static final FECMath fecMath = new FECMath(8);
    protected char[] encMatrix;

    public PureCode(int k, int n) {
        this(k, n, fecMath.createEncodeMatrix(k, n));
    }

    public PureCode(int k, int n, char[] encMatrix) {
        super(k, n);
        this.encMatrix = encMatrix;
    }

    public void encode(byte[][] src, int[] srcOff, byte[][] repair, int[] repairOff, int[] index, int packetLength) {
        for (int i = 0; i < repair.length; ++i) {
            this.encode(src, srcOff, repair[i], repairOff[i], index[i], packetLength);
        }
    }

    protected void encode(byte[][] src, int[] srcOff, byte[] repair, int repairOff, int index, int packetLength) {
        if (index < this.k) {
            System.arraycopy(src[index], srcOff[index], repair, repairOff, packetLength);
        } else {
            int pos = index * this.k;
            ByteArrayUtil.bzero(repair, repairOff, packetLength);
            for (int i = 0; i < this.k; ++i) {
                fecMath.addMul(repair, repairOff, src[i], srcOff[i], (byte)this.encMatrix[pos + i], packetLength);
            }
        }
    }

    public void decode(byte[][] pkts, int[] pktsOff, int[] index, int packetLength, boolean shuffled) {
        int row;
        if (!shuffled) {
            FECCode.shuffle(pkts, pktsOff, index, this.k);
        }
        char[] decMatrix = fecMath.createDecodeMatrix(this.encMatrix, index, this.k, this.n);
        byte[][] tmpPkts = new byte[this.k][];
        for (row = 0; row < this.k; ++row) {
            if (index[row] < this.k) continue;
            tmpPkts[row] = new byte[packetLength];
            for (int col = 0; col < this.k; ++col) {
                fecMath.addMul(tmpPkts[row], 0, pkts[col], pktsOff[col], (byte)decMatrix[row * this.k + col], packetLength);
            }
        }
        for (row = 0; row < this.k; ++row) {
            if (index[row] < this.k) continue;
            System.arraycopy(tmpPkts[row], 0, pkts[row], pktsOff[row], packetLength);
            index[row] = row;
        }
    }

    public String toString() {
        return new String("PureCode[k=" + this.k + ",n=" + this.n + "]");
    }
}

