/*
 * Decompiled with CFR 0.152.
 */
package captcha.graphics;

import Jama.Matrix;
import captcha.graphics.ImageFactory;
import captcha.graphics.Quadrangle;
import java.awt.Color;
import java.awt.Image;
import java.awt.image.MemoryImageSource;
import java.awt.image.PixelGrabber;

public class PerspectiveProjection {
    private Matrix m_projectionMatrix;

    public PerspectiveProjection(Quadrangle a_orig, Quadrangle a_image) {
        double[][] coefficients = new double[12][12];
        for (int i = 0; i < 12; ++i) {
            for (int j = 0; j < 12; ++j) {
                coefficients[i][j] = 0.0;
            }
        }
        double[][] absolute = new double[12][1];
        for (int i = 0; i < 12; ++i) {
            absolute[i][0] = 0.0;
        }
        coefficients[0][0] = 1.0;
        coefficients[0][1] = a_orig.getX0();
        coefficients[0][2] = a_orig.getY0();
        absolute[0][0] = 1.0;
        coefficients[1][3] = 1.0;
        coefficients[1][4] = a_orig.getX0();
        coefficients[1][5] = a_orig.getY0();
        absolute[1][0] = a_image.getX0();
        coefficients[2][6] = 1.0;
        coefficients[2][7] = a_orig.getX0();
        coefficients[2][8] = a_orig.getY0();
        absolute[2][0] = a_image.getY0();
        coefficients[3][0] = 1.0;
        coefficients[3][1] = a_orig.getX1();
        coefficients[3][2] = a_orig.getY1();
        coefficients[3][9] = -1.0;
        coefficients[4][3] = 1.0;
        coefficients[4][4] = a_orig.getX1();
        coefficients[4][5] = a_orig.getY1();
        coefficients[4][9] = -a_image.getX1();
        coefficients[5][6] = 1.0;
        coefficients[5][7] = a_orig.getX1();
        coefficients[5][8] = a_orig.getY1();
        coefficients[5][9] = -a_image.getY1();
        coefficients[6][0] = 1.0;
        coefficients[6][1] = a_orig.getX2();
        coefficients[6][2] = a_orig.getY2();
        coefficients[6][10] = -1.0;
        coefficients[7][3] = 1.0;
        coefficients[7][4] = a_orig.getX2();
        coefficients[7][5] = a_orig.getY2();
        coefficients[7][10] = -a_image.getX2();
        coefficients[8][6] = 1.0;
        coefficients[8][7] = a_orig.getX2();
        coefficients[8][8] = a_orig.getY2();
        coefficients[8][10] = -a_image.getY2();
        coefficients[9][0] = 1.0;
        coefficients[9][1] = a_orig.getX3();
        coefficients[9][2] = a_orig.getY3();
        coefficients[9][11] = -1.0;
        coefficients[10][3] = 1.0;
        coefficients[10][4] = a_orig.getX3();
        coefficients[10][5] = a_orig.getY3();
        coefficients[10][11] = -a_image.getX3();
        coefficients[11][6] = 1.0;
        coefficients[11][7] = a_orig.getX3();
        coefficients[11][8] = a_orig.getY3();
        coefficients[11][11] = -a_image.getY3();
        Matrix solution = new Matrix(coefficients).solve(new Matrix(absolute));
        double[][] projectionMatrix = new double[3][3];
        projectionMatrix[0][0] = solution.get(0, 0);
        projectionMatrix[0][1] = solution.get(1, 0);
        projectionMatrix[0][2] = solution.get(2, 0);
        projectionMatrix[1][0] = solution.get(3, 0);
        projectionMatrix[1][1] = solution.get(4, 0);
        projectionMatrix[1][2] = solution.get(5, 0);
        projectionMatrix[2][0] = solution.get(6, 0);
        projectionMatrix[2][1] = solution.get(7, 0);
        projectionMatrix[2][2] = solution.get(8, 0);
        this.m_projectionMatrix = new Matrix(projectionMatrix);
    }

    public Image transform(Image a_input, Color a_defaultColor) throws Exception {
        int i;
        int height = a_input.getHeight(null);
        int width = a_input.getWidth(null);
        double[][] coordinates = new double[3][height * width];
        for (int i2 = 0; i2 < height; ++i2) {
            for (int j = 0; j < width; ++j) {
                coordinates[0][i2 * width + j] = 1.0;
                coordinates[1][i2 * width + j] = j;
                coordinates[2][i2 * width + j] = i2;
            }
        }
        Matrix imageCoordinates = this.m_projectionMatrix.times(new Matrix(coordinates));
        double[][] normalImageCoordinates = new double[2][width * height];
        for (int i3 = 0; i3 < width * height; ++i3) {
            normalImageCoordinates[0][i3] = imageCoordinates.get(1, i3) / imageCoordinates.get(0, i3);
            normalImageCoordinates[1][i3] = imageCoordinates.get(2, i3) / imageCoordinates.get(0, i3);
        }
        int[] imageMap = new int[width * height];
        double[] distanceMap = new double[width * height];
        for (i = 0; i < width * height; ++i) {
            imageMap[i] = -1;
        }
        for (i = 0; i < width * height; ++i) {
            double exactX = normalImageCoordinates[0][i];
            double exactY = normalImageCoordinates[1][i];
            int x = (int)Math.round(exactX);
            int y = (int)Math.round(exactY);
            if (x < 0 || x >= width || y < 0 || y >= height) continue;
            double distance = Math.sqrt((exactX - (double)x) * (exactX - (double)x) + (exactY - (double)y) * (exactY - (double)y));
            if (imageMap[y * width + x] == -1) {
                imageMap[y * width + x] = i;
                distanceMap[y * width + x] = distance;
                continue;
            }
            if (!(distance < distanceMap[y * width + x])) continue;
            imageMap[y * width + x] = i;
            distanceMap[y * width + x] = distance;
        }
        PixelGrabber originalImage = new PixelGrabber(a_input, 0, 0, width, height, true);
        originalImage.grabPixels();
        int[] originalImagePixels = (int[])originalImage.getPixels();
        int[] outputImagePixels = new int[width * height];
        for (int i4 = 0; i4 < width * height; ++i4) {
            outputImagePixels[i4] = imageMap[i4] > -1 ? originalImagePixels[imageMap[i4]] : a_defaultColor.getRGB();
        }
        MemoryImageSource outputImage = new MemoryImageSource(width, height, outputImagePixels, 0, width);
        return ImageFactory.createImage(outputImage);
    }
}

