/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.multicast.messages;

import anon.crypto.SignatureVerifier;
import anon.crypto.XMLSignature;
import anon.util.XMLUtil;
import infoservice.agreement.multicast.AgreementMessageTypes;
import infoservice.agreement.multicast.interfaces.IAgreementMessage;
import infoservice.agreement.multicast.messages.AMessage;
import infoservice.agreement.multicast.messages.CommitMessage;
import infoservice.agreement.multicast.messages.ConfirmationMessage;
import infoservice.agreement.multicast.messages.EchoMessage;
import infoservice.agreement.multicast.messages.InitMessage;
import infoservice.agreement.multicast.messages.RejectMessage;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EchoMulticastMessageFactory {
    private static final EchoMulticastMessageFactory m_instance = new EchoMulticastMessageFactory();

    public static EchoMulticastMessageFactory getInstance() {
        return m_instance;
    }

    public synchronized IAgreementMessage parseMessage(Document a_doc) {
        Node echo;
        InitMessage tmpMsg;
        Node rootNode = a_doc.getFirstChild();
        Node tmp = XMLUtil.getFirstChildByName(rootNode, "RoundNr");
        String lastCommonRandom = this.getNodeValue(tmp);
        tmp = XMLUtil.getFirstChildByName(rootNode, "Initiator");
        String initiatorsId = this.getNodeValue(tmp);
        tmp = XMLUtil.getFirstChildByName(rootNode, "Message");
        String proposal = this.getNodeValue(tmp);
        String nodeName = rootNode.getNodeName();
        String senderId = "";
        boolean senderOk = false;
        if (!AgreementMessageTypes.getTypeAsString(0).equalsIgnoreCase(nodeName)) {
            tmp = XMLUtil.getFirstChildByName(rootNode, "SenderId");
            senderId = this.getNodeValue(tmp);
            senderOk = this.checkOriginator(rootNode, senderId);
        } else {
            senderOk = this.checkOriginator(rootNode, initiatorsId);
        }
        if (!senderOk) {
            return null;
        }
        AMessage message = null;
        if (AgreementMessageTypes.getTypeAsString(0).equalsIgnoreCase(nodeName)) {
            message = new InitMessage(initiatorsId, proposal, lastCommonRandom);
        } else if (AgreementMessageTypes.getTypeAsString(1).equalsIgnoreCase(nodeName)) {
            tmpMsg = new InitMessage(initiatorsId, proposal, lastCommonRandom);
            message = new EchoMessage(tmpMsg, senderId);
            message.setXmlDocument(a_doc);
        } else if (AgreementMessageTypes.getTypeAsString(2).equalsIgnoreCase(nodeName)) {
            AMessage tmpMsg2;
            tmp = XMLUtil.getFirstChildByName(rootNode, "EchoMessages");
            echo = tmp.getFirstChild();
            Hashtable<String, EchoMessage> echoMessages = new Hashtable<String, EchoMessage>();
            do {
                tmpMsg2 = this.createEchoMessage(echo);
                echoMessages.put(tmpMsg2.getHashKey(), (EchoMessage)tmpMsg2);
            } while ((echo = echo.getNextSibling()) != null);
            tmpMsg2 = new InitMessage(initiatorsId, proposal, lastCommonRandom);
            message = new CommitMessage((InitMessage)tmpMsg2, senderId, echoMessages);
        } else if (AgreementMessageTypes.getTypeAsString(3).equalsIgnoreCase(nodeName)) {
            tmpMsg = new InitMessage(initiatorsId, proposal, lastCommonRandom);
            message = new RejectMessage(tmpMsg, senderId, lastCommonRandom);
        } else if (AgreementMessageTypes.getTypeAsString(4).equalsIgnoreCase(nodeName)) {
            AMessage tmpMsg3;
            tmp = XMLUtil.getFirstChildByName(rootNode, "EchoMessages");
            echo = tmp.getFirstChild();
            Hashtable<String, EchoMessage> echoMessages = new Hashtable<String, EchoMessage>();
            do {
                tmpMsg3 = this.createEchoMessage(echo);
                echoMessages.put(tmpMsg3.getHashKey(), (EchoMessage)tmpMsg3);
            } while ((echo = echo.getNextSibling()) != null);
            tmpMsg3 = new InitMessage(initiatorsId, proposal, lastCommonRandom);
            message = new ConfirmationMessage(new CommitMessage((InitMessage)tmpMsg3, senderId, echoMessages), senderId);
        } else {
            LogHolder.log(3, LogType.ALL, "Couldn't determine type of agreement message: " + nodeName);
            return null;
        }
        boolean sigOk = false;
        sigOk = SignatureVerifier.getInstance().verifyXml((Element)rootNode, 2);
        if (message != null) {
            message.setSignatureOk(sigOk);
        }
        return message;
    }

    private synchronized String getNodeValue(Node tmp) {
        String value = XMLUtil.parseValue(tmp, null);
        if (value == null) {
            LogHolder.log(1, LogType.NET, "Unable to get value from node  " + tmp.getNodeName());
            return "";
        }
        return value;
    }

    private boolean checkOriginator(Node a_node, String a_sender) {
        String ski = "";
        try {
            XMLSignature t = XMLSignature.getUnverified(a_node);
            if (t != null) {
                ski = t.getXORofSKIs();
            }
        }
        catch (Exception t) {
            // empty catch block
        }
        boolean ok = a_sender.equalsIgnoreCase(ski);
        if (!ok) {
            LogHolder.log(1, LogType.NET, "Possibly forged message received! SenderID: " + a_sender + " was signed with a certificate with SKI: " + ski + ")");
        }
        return ok;
    }

    private synchronized EchoMessage createEchoMessage(Node a_node) {
        Node tmp = XMLUtil.getFirstChildByName(a_node, "RoundNr");
        String lastCommonRandom = this.getNodeValue(tmp);
        tmp = XMLUtil.getFirstChildByName(a_node, "Initiator");
        String initiatorsId = this.getNodeValue(tmp);
        tmp = XMLUtil.getFirstChildByName(a_node, "Message");
        String proposal = this.getNodeValue(tmp);
        boolean sigOk = false;
        sigOk = SignatureVerifier.getInstance().verifyXml((Element)a_node, 2);
        InitMessage tmpMsg = new InitMessage(initiatorsId, proposal, lastCommonRandom);
        tmp = XMLUtil.getFirstChildByName(a_node, "SenderId");
        String senderId = this.getNodeValue(tmp);
        if (!this.checkOriginator(a_node, senderId)) {
            return null;
        }
        EchoMessage message = new EchoMessage(tmpMsg, senderId);
        message.setXmlDocument(a_node.getOwnerDocument());
        message.setSignatureOk(sigOk);
        return message;
    }
}

