/*
 * Decompiled with CFR 0.152.
 */
package infoservice.agreement.paxos;

import infoservice.agreement.common.TimeoutThread;
import infoservice.agreement.paxos.PaxosExecution;
import infoservice.agreement.paxos.PaxosObject;
import infoservice.agreement.paxos.messages.CollectMessage;
import infoservice.agreement.paxos.messages.FreezeProofMessage;
import infoservice.agreement.paxos.messages.PaxosMessage;
import infoservice.dynamic.DynamicConfiguration;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public class PaxosRound
extends PaxosObject {
    private TimeoutThread m_timeout;
    private PaxosMessage m_proposal = null;
    private Hashtable m_weakMessages = new Hashtable();
    private Hashtable m_strongMessages = new Hashtable();
    private Hashtable m_decideMessages = new Hashtable();
    private Vector m_freezeMessages = new Vector();
    private Vector m_freezeProofMessages = new Vector();
    private PaxosExecution m_execution;
    private String m_weakAccepted = null;
    private String m_strongAccepted = null;
    private boolean m_freezed = false;
    private int m_roundNumber = -1;
    private String m_leaderId;
    private String m_decided;
    private boolean m_collected = false;
    private boolean m_aborted = false;

    public PaxosRound(PaxosExecution a_execution, int a_round, String a_leaderId) {
        this.m_timeout = a_round == 0 ? new TimeoutThread(a_execution.getPaxosInstance().getAcceptor(), this, DynamicConfiguration.getInstance().getPassivePhaseLength() + DynamicConfiguration.getInstance().getPaxosRoundTimeout()) : new TimeoutThread(a_execution.getPaxosInstance().getAcceptor(), this, DynamicConfiguration.getInstance().getPaxosRoundTimeout());
        this.m_timeout.start();
        this.m_execution = a_execution;
        this.m_roundNumber = a_round;
        this.m_leaderId = a_leaderId;
    }

    public String getLeaderId() {
        return this.m_leaderId;
    }

    public int getRoundNumber() {
        return this.m_roundNumber;
    }

    public boolean addProposal(PaxosMessage a_msg) {
        if (this.m_proposal == null && a_msg.belongsTo(this.m_execution)) {
            this.m_proposal = a_msg;
            return true;
        }
        return false;
    }

    public PaxosExecution getExecution() {
        return this.m_execution;
    }

    public boolean addWeakMessage(PaxosMessage a_msg) {
        return this.addMessage(this.m_weakMessages, a_msg);
    }

    public boolean addStrongMessage(PaxosMessage a_msg) {
        return this.addMessage(this.m_strongMessages, a_msg);
    }

    public boolean addDecideMessage(PaxosMessage a_msg) {
        return this.addMessage(this.m_decideMessages, a_msg);
    }

    public boolean addFreezeMessage(PaxosMessage a_msg) {
        if (!this.m_freezeMessages.contains(a_msg) && a_msg.belongsTo(this.m_execution)) {
            this.m_freezeMessages.add(a_msg);
            return true;
        }
        return false;
    }

    public void weakAccept(String a_proposal) {
        this.m_weakAccepted = a_proposal;
    }

    public void strongAccept(String a_proposal) {
        this.m_strongAccepted = a_proposal;
    }

    public String getWeakAccepted() {
        return this.m_weakAccepted;
    }

    public String getStrongAccepted() {
        return this.m_strongAccepted;
    }

    public boolean isWeakAccepted() {
        return this.m_weakAccepted != null;
    }

    public int getWeakMessageCount(String a_proposal) {
        Vector tmp = (Vector)this.m_weakMessages.get(a_proposal);
        if (tmp == null) {
            return 0;
        }
        return tmp.size();
    }

    public int getStrongMessageCount(String a_proposal) {
        Vector tmp = (Vector)this.m_strongMessages.get(a_proposal);
        if (tmp == null) {
            return 0;
        }
        return tmp.size();
    }

    public int getDecideMessageCount(String a_proposal) {
        Vector tmp = (Vector)this.m_decideMessages.get(a_proposal);
        if (tmp == null) {
            return 0;
        }
        return tmp.size();
    }

    public int getTotalDecideMessageCount() {
        int count = 0;
        Enumeration en = this.m_decideMessages.keys();
        while (en.hasMoreElements()) {
            Object key = en.nextElement();
            Vector tmp = (Vector)this.m_decideMessages.get(key);
            count += tmp.size();
        }
        return count;
    }

    public int getFreezeMessageCount() {
        return this.m_freezeMessages.size();
    }

    private boolean addMessage(Hashtable a_messages, PaxosMessage a_msg) {
        if (!a_msg.belongsTo(this)) {
            return false;
        }
        Vector tmp = null;
        if (!a_messages.containsKey(a_msg.getProposal())) {
            tmp = new Vector();
            a_messages.put(a_msg.getProposal(), tmp);
        }
        if (!(tmp = (Vector)a_messages.get(a_msg.getProposal())).contains(a_msg)) {
            tmp.add(a_msg);
            return true;
        }
        return false;
    }

    public void decide(String a_proposal) {
        this.m_decided = a_proposal;
        this.m_timeout.cancel();
        this.getExecution().decide(a_proposal);
    }

    public boolean isDecided() {
        return this.m_decided != null;
    }

    public boolean isStrongAccepted() {
        return this.m_strongAccepted != null;
    }

    public void freeze() {
        this.m_freezed = true;
        this.m_timeout.cancel();
    }

    public boolean isFrozen() {
        return this.m_freezed;
    }

    public boolean addProof(FreezeProofMessage a_msg) {
        if (a_msg.isSignatureOk() && !this.m_freezeProofMessages.contains(a_msg)) {
            this.m_freezeProofMessages.add(a_msg);
            return true;
        }
        return false;
    }

    public int getFreezeProofMessageCount() {
        return this.m_freezeProofMessages.size();
    }

    public boolean acc(String a_proposal) {
        if (a_proposal == null) {
            return false;
        }
        int count = 0;
        Enumeration en = this.m_freezeProofMessages.elements();
        while (en.hasMoreElements()) {
            FreezeProofMessage msg = (FreezeProofMessage)en.nextElement();
            if (!a_proposal.equals(msg.getWeakValue())) continue;
            ++count;
        }
        return count > this.getExecution().getPaxosInstance().getAcceptor().getF();
    }

    public Vector getAcc() {
        Vector<String> result = new Vector<String>();
        Enumeration en = this.m_freezeProofMessages.elements();
        while (en.hasMoreElements()) {
            String strong;
            FreezeProofMessage msg = (FreezeProofMessage)en.nextElement();
            String weak = msg.getWeakValue();
            if (this.poss(weak) && !result.contains(weak)) {
                result.add(weak);
            }
            if (!this.poss(strong = msg.getStrongValue()) || result.contains(strong)) continue;
            result.add(strong);
        }
        return result;
    }

    public Vector getPoss() {
        Vector<String> result = new Vector<String>();
        Enumeration en = this.m_freezeProofMessages.elements();
        while (en.hasMoreElements()) {
            String strong;
            FreezeProofMessage msg = (FreezeProofMessage)en.nextElement();
            String weak = msg.getWeakValue();
            if (this.poss(weak) && !result.contains(weak)) {
                result.add(weak);
            }
            if (!this.poss(strong = msg.getStrongValue()) || result.contains(strong)) continue;
            result.add(strong);
        }
        return result;
    }

    public boolean poss(String a_proposal) {
        if (a_proposal == null) {
            return false;
        }
        int countWeak = 0;
        int countStrong = 0;
        Enumeration en = this.m_freezeProofMessages.elements();
        while (en.hasMoreElements()) {
            FreezeProofMessage msg = (FreezeProofMessage)en.nextElement();
            if (a_proposal.equals(msg.getWeakValue())) {
                ++countWeak;
            }
            if (!a_proposal.equals(msg.getStrongValue())) continue;
            ++countStrong;
        }
        return countWeak > this.getExecution().getPaxosInstance().getAcceptor().getQuorumStrong() || countStrong > this.getExecution().getPaxosInstance().getAcceptor().getF();
    }

    public boolean isGood(String a_value) {
        if (a_value == null) {
            return false;
        }
        String calculatedGood = this.m_execution.getGoodProposal(this.m_roundNumber);
        return calculatedGood.equals(a_value);
    }

    public Vector getFreezeProofs() {
        return this.m_freezeProofMessages;
    }

    public boolean addCollectMessage(CollectMessage a_msg) {
        if (!this.m_collected) {
            this.m_freezeProofMessages.addAll(a_msg.getProofs());
            this.m_collected = true;
            return true;
        }
        return false;
    }

    public boolean isAborted() {
        return this.m_aborted;
    }

    public void abort() {
        this.m_aborted = true;
        this.m_timeout.cancel();
    }
}

