/*
 * Decompiled with CFR 0.152.
 */
package infoservice.mailsystem.central;

import anon.crypto.SignatureVerifier;
import anon.infoservice.Database;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.ListenerInterface;
import infoservice.Configuration;
import infoservice.mailsystem.central.MailSystemLog;
import java.io.FileInputStream;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.mail.Session;
import logging.LogHolder;
import logging.LogType;

public class MailContext {
    public static final long MAIL_ADDRESSES_TIMEOUT = 600000L;
    public static final int MAXIMUM_NUMBER_OF_REQUESTS = 5;
    public static final long BAN_PERIOD = 600000L;
    private static final long INFOSERVICE_TIMEOUT = 1471228928000L;
    private static MailContext ms_mcInstance = null;
    private Session m_mailSession;
    private int m_centralProcessPort;

    private MailContext(String a_configFile) throws Exception {
        Properties mailConfig = new Properties();
        mailConfig.put("mail.stmp.sendpartial", "true");
        mailConfig.put("mail.transport.protocol", "smtp");
        mailConfig.load(new FileInputStream(a_configFile));
        LogHolder.setLogInstance(new MailSystemLog(mailConfig));
        LogHolder.setDetailLevel(Integer.parseInt(mailConfig.getProperty("messageDetailLevel", "0").trim()));
        this.m_mailSession = Session.getInstance(mailConfig);
        this.m_centralProcessPort = Integer.parseInt(mailConfig.getProperty("MailSystemMainProcessPort").trim());
        if (this.m_centralProcessPort < 1 || this.m_centralProcessPort > 65535) {
            throw new Exception("MailSystemMainProcessPort is invalid.");
        }
        SignatureVerifier.getInstance().setCheckSignatures(true);
        String checkSignatures = mailConfig.getProperty("checkSignatures");
        if (checkSignatures != null && checkSignatures.equalsIgnoreCase("false")) {
            SignatureVerifier.getInstance().setCheckSignatures(false);
            LogHolder.log(4, LogType.MISC, "Disabling signature verification for all documents.");
        }
        LogHolder.log(7, LogType.MISC, "Loading certificates...");
        Configuration.loadTrustedCertificateFiles(mailConfig, "trustedInfoServiceRootCertificateFiles", 5, "infoservice root", true);
        String infoServiceList = mailConfig.getProperty("MailSystemInfoServiceList");
        if (infoServiceList != null) {
            infoServiceList = infoServiceList.trim();
            StringTokenizer stInfoServiceList = new StringTokenizer(infoServiceList, ",");
            while (stInfoServiceList.hasMoreTokens()) {
                StringTokenizer stCurrentInfoService = new StringTokenizer(stInfoServiceList.nextToken(), ":");
                InfoServiceDBEntry entry = new InfoServiceDBEntry(null, null, new ListenerInterface(stCurrentInfoService.nextToken().trim(), Integer.parseInt(stCurrentInfoService.nextToken().trim())).toVector(), true, true, 0L, 0L, false, null);
                entry.setUserDefined(true);
                Database.getInstance(InfoServiceDBEntry.class).update(entry);
            }
        }
        InfoServiceHolder.getInstance().setChangeInfoServices(true);
    }

    public static void createInstance(String a_configFile) throws Exception {
        ms_mcInstance = new MailContext(a_configFile);
    }

    public static MailContext getInstance() {
        return ms_mcInstance;
    }

    public Session getSession() {
        return this.m_mailSession;
    }

    public int getCentralProcessPort() {
        return this.m_centralProcessPort;
    }
}

