/*
 * Decompiled with CFR 0.152.
 */
package infoservice.performance;

import anon.infoservice.AbstractDatabaseEntry;
import anon.util.Base64;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.util.Random;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PerformanceToken
extends AbstractDatabaseEntry
implements IXMLEncodable {
    public static final int PERFORMANCE_TOKEN_TTL = 120000;
    public static final int PERFORMANCE_TOKEN_BASE_LENGTH = 16;
    public static final String XML_ELEMENT_NAME = "PerformanceToken";
    public static final String XML_ELEMENT_ID = "Id";
    private static Random ms_rnd = new Random();
    private String m_id;
    private long m_lastUpdate;

    public PerformanceToken() {
        super(System.currentTimeMillis() + 120000L);
        this.m_lastUpdate = System.currentTimeMillis();
        byte[] token = new byte[16];
        ms_rnd.nextBytes(token);
        this.m_id = Base64.encode(token, false) + Base64.encodeString(String.valueOf(System.currentTimeMillis()));
    }

    public PerformanceToken(Element a_node) throws XMLParseException {
        super(-1L);
        this.m_lastUpdate = -1L;
        XMLUtil.assertNodeName(a_node, XML_ELEMENT_NAME);
        Node token = XMLUtil.getFirstChildByName(a_node, XML_ELEMENT_ID);
        XMLUtil.assertNotNull(token);
        this.m_id = XMLUtil.parseValue(token, "");
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    @Override
    public long getVersionNumber() {
        return this.m_lastUpdate;
    }

    @Override
    public Element toXmlElement(Document a_doc) {
        Element elem = a_doc.createElement(XML_ELEMENT_NAME);
        Element elemToken = a_doc.createElement(XML_ELEMENT_ID);
        XMLUtil.setValue((Node)elemToken, this.m_id);
        elem.appendChild(elemToken);
        return elem;
    }
}

