/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import java.util.Enumeration;
import java.util.Hashtable;

class CIHashtable
extends Hashtable {
    public CIHashtable(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public CIHashtable(int initialCapacity) {
        super(initialCapacity);
    }

    public CIHashtable() {
    }

    public Object get(String key) {
        return super.get(new CIString(key));
    }

    public Object put(String key, Object value) {
        return super.put(new CIString(key), value);
    }

    public boolean containsKey(String key) {
        return super.contains(new CIString(key));
    }

    public Object remove(String key) {
        return super.remove(new CIString(key));
    }

    public Enumeration keys() {
        return new CIHashtableEnumeration(super.keys());
    }

    private static final class CIString {
        private String string;
        private int hash;
        private static final char[] lc = new char[256];

        public CIString(String string) {
            this.string = string;
            this.hash = CIString.calcHashCode(string);
        }

        public final String getString() {
            return this.string;
        }

        public int hashCode() {
            return this.hash;
        }

        private static final int calcHashCode(String str) {
            int hash2 = 0;
            char[] llc = lc;
            int len = str.length();
            for (int idx = 0; idx < len; ++idx) {
                hash2 = 31 * hash2 + llc[str.charAt(idx)];
            }
            return hash2;
        }

        public boolean equals(Object obj) {
            if (obj != null) {
                if (obj instanceof CIString) {
                    return this.string.equalsIgnoreCase(((CIString)obj).string);
                }
                if (obj instanceof String) {
                    return this.string.equalsIgnoreCase((String)obj);
                }
            }
            return false;
        }

        public String toString() {
            return this.string;
        }

        static {
            for (char idx = '\u0000'; idx < '\u0100'; idx = (char)(idx + '\u0001')) {
                CIString.lc[idx] = Character.toLowerCase(idx);
            }
        }
    }

    private static class CIHashtableEnumeration
    implements Enumeration {
        Enumeration HTEnum;

        public CIHashtableEnumeration(Enumeration enumer) {
            this.HTEnum = enumer;
        }

        public boolean hasMoreElements() {
            return this.HTEnum.hasMoreElements();
        }

        public Object nextElement() {
            Object tmp = this.HTEnum.nextElement();
            if (tmp instanceof CIString) {
                return ((CIString)tmp).getString();
            }
            return tmp;
        }
    }
}

