/*
 * Decompiled with CFR 0.152.
 */
package HTTPClient;

import HTTPClient.CIHashtable;
import HTTPClient.GlobalConstants;
import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import HTTPClient.HttpClientURI;
import HTTPClient.HttpClientUtil;
import HTTPClient.HttpHeaderElement;
import HTTPClient.ModuleException;
import HTTPClient.NVPair;
import HTTPClient.ParseException;
import HTTPClient.Request;
import HTTPClient.RespInputStream;
import HTTPClient.RoResponse;
import HTTPClient.StreamDemultiplexor;
import java.io.ByteArrayInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.SequenceInputStream;
import java.net.ProtocolException;
import java.util.Date;
import java.util.Vector;

public final class Response
implements RoResponse,
GlobalConstants,
Cloneable {
    private HTTPConnection connection;
    private StreamDemultiplexor stream_handler;
    HTTPResponse http_resp;
    int timeout = 0;
    public InputStream inp_stream;
    private RespInputStream resp_inp_stream = null;
    private String method;
    String resource;
    private boolean used_proxy;
    private boolean sent_entity;
    int StatusCode = 0;
    String ReasonLine;
    String Version;
    HttpClientURI EffectiveURI = null;
    CIHashtable Headers = new CIHashtable();
    CIHashtable Trailers = new CIHashtable();
    int ContentLength = -1;
    int cd_type = 0;
    byte[] Data = null;
    boolean reading_headers = false;
    boolean got_headers = false;
    boolean got_trailers = false;
    private boolean interrupted = false;
    private IOException exception = null;
    boolean final_resp = false;
    boolean retry = false;
    private byte[] buf = new byte[600];
    private char[] hdrs = new char[600];
    private int buf_pos = 0;
    private int hdr_pos = 0;
    private boolean reading_lines = false;
    char[] trailers;
    Request req = null;
    boolean isFirstResponse = false;

    Response(Request request, boolean used_proxy, StreamDemultiplexor stream_handler) throws IOException {
        this.connection = request.getConnection();
        this.method = request.getMethod();
        this.resource = request.getRequestURI();
        this.used_proxy = used_proxy;
        this.stream_handler = stream_handler;
        this.sent_entity = request.getData() != null;
        stream_handler.register(this, request);
        this.resp_inp_stream = stream_handler.getStream(this);
        this.inp_stream = this.resp_inp_stream;
    }

    Response(Request request, InputStream is) {
        this.connection = request.getConnection();
        this.method = request.getMethod();
        this.resource = request.getRequestURI();
        this.used_proxy = false;
        this.stream_handler = null;
        this.sent_entity = request.getData() != null;
        this.inp_stream = is;
    }

    public Response(String version, int status, String reason, NVPair[] headers, byte[] data, InputStream is, int cont_len) {
        this.Version = version;
        this.StatusCode = status;
        this.ReasonLine = reason;
        if (headers != null) {
            for (int idx = 0; idx < headers.length; ++idx) {
                this.setHeader(headers[idx].getName(), headers[idx].getValue());
            }
        }
        if (data != null) {
            this.Data = data;
        } else if (is == null) {
            this.Data = new byte[0];
        } else {
            this.inp_stream = is;
            this.ContentLength = cont_len;
        }
        this.got_headers = true;
        this.got_trailers = true;
    }

    public final int getStatusCode() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.StatusCode;
    }

    public final String getReasonLine() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.ReasonLine;
    }

    public final String getVersion() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.Version;
    }

    int getContinue() throws IOException {
        this.getHeaders(false);
        return this.StatusCode;
    }

    public final HttpClientURI getEffectiveURI() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.EffectiveURI;
    }

    public void setEffectiveURI(HttpClientURI final_uri) {
        this.EffectiveURI = final_uri;
    }

    public String getHeader(String hdr) throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return (String)this.Headers.get(hdr.trim());
    }

    public int getHeaderAsInt(String hdr) throws IOException, NumberFormatException {
        return Integer.parseInt(this.getHeader(hdr));
    }

    public Date getHeaderAsDate(String hdr) throws IOException, IllegalArgumentException {
        Date date;
        String raw_date = this.getHeader(hdr);
        if (raw_date == null) {
            return null;
        }
        if (raw_date.toUpperCase().indexOf("GMT") == -1) {
            raw_date = raw_date + " GMT";
        }
        try {
            date = HttpClientUtil.parseDate(raw_date);
        }
        catch (IllegalArgumentException iae) {
            long time;
            try {
                time = Long.parseLong(raw_date);
            }
            catch (NumberFormatException nfe) {
                throw iae;
            }
            if (time < 0L) {
                time = 0L;
            }
            date = new Date(time * 1000L);
        }
        return date;
    }

    public void setHeader(String header, String value) {
        this.Headers.put(header.trim(), value.trim());
    }

    public void deleteHeader(String header) {
        this.Headers.remove(header.trim());
    }

    public String getTrailer(String trailer) throws IOException {
        if (!this.got_trailers) {
            this.getTrailers();
        }
        return (String)this.Trailers.get(trailer.trim());
    }

    public int getTrailerAsInt(String trailer) throws IOException, NumberFormatException {
        return Integer.parseInt(this.getTrailer(trailer));
    }

    public Date getTrailerAsDate(String trailer) throws IOException, IllegalArgumentException {
        Date date;
        String raw_date = this.getTrailer(trailer);
        if (raw_date == null) {
            return null;
        }
        if (raw_date.toUpperCase().indexOf("GMT") == -1) {
            raw_date = raw_date + " GMT";
        }
        try {
            date = HttpClientUtil.parseDate(raw_date);
        }
        catch (IllegalArgumentException iae) {
            long time;
            try {
                time = Long.parseLong(raw_date);
            }
            catch (NumberFormatException nfe) {
                throw iae;
            }
            if (time < 0L) {
                time = 0L;
            }
            date = new Date(time * 1000L);
        }
        return date;
    }

    public void setTrailer(String trailer, String value) {
        this.Trailers.put(trailer.trim(), value.trim());
    }

    public void deleteTrailer(String trailer) {
        this.Trailers.remove(trailer.trim());
    }

    public synchronized byte[] getData() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        if (this.Data == null || this.interrupted) {
            try {
                this.readResponseData(this.inp_stream);
            }
            catch (InterruptedIOException ie) {
                throw ie;
            }
            catch (IOException ioe) {
                try {
                    this.inp_stream.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ioe;
            }
            this.inp_stream.close();
        }
        return this.Data;
    }

    public synchronized InputStream getInputStream() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        if (this.Data == null) {
            return this.inp_stream;
        }
        return new ByteArrayInputStream(this.Data);
    }

    public synchronized boolean hasEntity() throws IOException {
        if (!this.got_headers) {
            this.getHeaders(true);
        }
        return this.cd_type != 2;
    }

    public void setRetryRequest(boolean flag) {
        this.retry = flag;
    }

    public boolean retryRequest() {
        return this.retry;
    }

    private synchronized void getHeaders(boolean skip_cont) throws IOException {
        if (this.got_headers) {
            return;
        }
        if (this.exception != null) {
            throw (IOException)this.exception.fillInStackTrace();
        }
        this.reading_headers = true;
        try {
            do {
                this.Headers.clear();
                char[] headers = this.readResponseHeaders(this.inp_stream);
                this.parseResponseHeaders(headers);
            } while (this.StatusCode == 100 && skip_cont || this.StatusCode > 101 && this.StatusCode < 200);
        }
        catch (IOException ioe) {
            if (!(ioe instanceof InterruptedIOException)) {
                this.exception = ioe;
            }
            if (ioe instanceof ProtocolException) {
                this.cd_type = 3;
                if (this.stream_handler != null) {
                    this.stream_handler.markForClose(this);
                }
            }
            throw ioe;
        }
        finally {
            this.reading_headers = false;
        }
        if (this.StatusCode == 100) {
            return;
        }
        this.got_headers = true;
        boolean te_chunked = false;
        boolean te_is_identity = true;
        boolean ct_mpbr = false;
        Vector te_hdr = null;
        try {
            te_hdr = HttpClientUtil.parseHeader(this.getHeader("Transfer-Encoding"));
        }
        catch (ParseException pe) {
            // empty catch block
        }
        if (te_hdr != null) {
            te_chunked = ((HttpHeaderElement)te_hdr.lastElement()).getName().equalsIgnoreCase("chunked");
            for (int idx = 0; idx < te_hdr.size(); ++idx) {
                if (((HttpHeaderElement)te_hdr.elementAt(idx)).getName().equalsIgnoreCase("identity")) {
                    te_hdr.removeElementAt(idx--);
                    continue;
                }
                te_is_identity = false;
            }
        }
        try {
            String hdr = this.getHeader("Content-Type");
            if (hdr != null) {
                Vector phdr = HttpClientUtil.parseHeader(hdr);
                ct_mpbr = phdr.contains(new HttpHeaderElement("multipart/byteranges")) || phdr.contains(new HttpHeaderElement("multipart/x-byteranges"));
            }
        }
        catch (ParseException pe) {
            // empty catch block
        }
        if (this.method.equals("HEAD") || this.ContentLength == 0 || this.StatusCode < 200 || this.StatusCode == 204 || this.StatusCode == 205 || this.StatusCode == 304) {
            this.Data = new byte[0];
            this.cd_type = 2;
            this.inp_stream.close();
        } else if (te_chunked) {
            this.cd_type = 5;
            te_hdr.removeElementAt(te_hdr.size() - 1);
            if (te_hdr.size() > 0) {
                this.setHeader("Transfer-Encoding", HttpClientUtil.assembleHeader(te_hdr));
            } else {
                this.deleteHeader("Transfer-Encoding");
            }
        } else if (this.ContentLength != -1 && te_is_identity) {
            this.cd_type = 4;
        } else if (ct_mpbr && te_is_identity) {
            this.cd_type = 6;
        } else {
            this.cd_type = 3;
            this.ContentLength = -1;
            if (this.stream_handler != null) {
                this.stream_handler.markForClose(this);
            }
            if (this.Version.equals("HTTP/0.9")) {
                this.inp_stream = new SequenceInputStream(new ByteArrayInputStream(this.Data), this.inp_stream);
                this.Data = null;
            }
        }
        if (this.isFirstResponse && !this.connection.handleFirstRequest(this.req, this)) {
            Response resp;
            try {
                resp = this.connection.sendRequest(this.req, this.timeout);
            }
            catch (ModuleException me) {
                throw new IOException(me.toString());
            }
            resp.getVersion();
            this.StatusCode = resp.StatusCode;
            this.ReasonLine = resp.ReasonLine;
            this.Version = resp.Version;
            this.EffectiveURI = resp.EffectiveURI;
            this.ContentLength = resp.ContentLength;
            this.Headers = resp.Headers;
            this.inp_stream = resp.inp_stream;
            this.Data = resp.Data;
            this.req = null;
        }
        if (this.connection.ServerProtocolVersion < 65537) {
            String name;
            Vector pco;
            try {
                pco = HttpClientUtil.parseHeader(this.getHeader("Connection"));
            }
            catch (ParseException pe) {
                pco = null;
            }
            if (pco != null) {
                if (this.connection.getProxyHost() != null) {
                    pco.removeAllElements();
                }
                for (int idx = 0; idx < pco.size(); ++idx) {
                    name = ((HttpHeaderElement)pco.elementAt(idx)).getName();
                    if (name.equalsIgnoreCase("keep-alive")) continue;
                    pco.removeElementAt(idx);
                    this.deleteHeader(name);
                    --idx;
                }
                if (pco.size() > 0) {
                    this.setHeader("Connection", HttpClientUtil.assembleHeader(pco));
                } else {
                    this.deleteHeader("Connection");
                }
            }
            try {
                pco = HttpClientUtil.parseHeader(this.getHeader("Proxy-Connection"));
            }
            catch (ParseException pe) {
                pco = null;
            }
            if (pco != null) {
                if (this.connection.getProxyHost() == null) {
                    pco.removeAllElements();
                }
                for (int idx = 0; idx < pco.size(); ++idx) {
                    name = ((HttpHeaderElement)pco.elementAt(idx)).getName();
                    if (name.equalsIgnoreCase("keep-alive")) continue;
                    pco.removeElementAt(idx);
                    this.deleteHeader(name);
                    --idx;
                }
                if (pco.size() > 0) {
                    this.setHeader("Proxy-Connection", HttpClientUtil.assembleHeader(pco));
                } else {
                    this.deleteHeader("Proxy-Connection");
                }
            }
        } else {
            this.deleteHeader("Proxy-Connection");
        }
    }

    private char[] readResponseHeaders(InputStream inp) throws IOException {
        if (!this.reading_lines) {
            this.cd_type = 0;
            if (this.buf_pos == 0) {
                int c;
                do {
                    if ((c = inp.read()) != -1) continue;
                    throw new EOFException("Encountered premature EOF while reading Version");
                } while (Character.isWhitespace((char)(c & 0xFF)));
                this.buf[0] = (byte)(c & 0xFF);
                this.buf_pos = 1;
            }
            while (this.buf_pos < 5) {
                int got = inp.read(this.buf, this.buf_pos, 5 - this.buf_pos);
                if (got == -1) {
                    throw new EOFException("Encountered premature EOF while reading Version");
                }
                this.buf_pos += got;
            }
            for (int idx = 0; idx < this.buf_pos; ++idx) {
                this.hdrs[this.hdr_pos++] = (char)(this.buf[idx] & 0xFF);
            }
            this.reading_lines = true;
        }
        if (this.hdrs[0] == 'H' && this.hdrs[1] == 'T' && this.hdrs[2] == 'T' && this.hdrs[3] == 'P' && (this.hdrs[4] == '/' || this.hdrs[4] == ' ')) {
            this.cd_type = 1;
            this.readHeaderBlock(inp);
        }
        this.buf_pos = 0;
        this.reading_lines = false;
        char[] tmp = HttpClientUtil.resizeArray(this.hdrs, this.hdr_pos);
        this.hdr_pos = 0;
        return tmp;
    }

    void readTrailers(InputStream inp) throws IOException {
        try {
            this.readHeaderBlock(inp);
            this.trailers = HttpClientUtil.resizeArray(this.hdrs, this.hdr_pos);
        }
        catch (IOException ioe) {
            if (!(ioe instanceof InterruptedIOException)) {
                this.exception = ioe;
            }
            throw ioe;
        }
    }

    private void readHeaderBlock(InputStream inp) throws IOException {
        int got;
        while ((got = inp.read(this.buf, 0, this.buf.length)) > 0) {
            if (this.hdr_pos + got > this.hdrs.length) {
                this.hdrs = HttpClientUtil.resizeArray(this.hdrs, (this.hdr_pos + got) * 2);
            }
            for (int idx = 0; idx < got; ++idx) {
                this.hdrs[this.hdr_pos++] = (char)(this.buf[idx] & 0xFF);
            }
        }
        this.hdr_pos -= 2;
    }

    private void parseResponseHeaders(char[] headers) throws ProtocolException {
        if (headers[0] != 'H' || headers[1] != 'T' || headers[2] != 'T' || headers[3] != 'P' || headers[4] != '/' && headers[4] != ' ') {
            this.Version = "HTTP/0.9";
            this.StatusCode = 200;
            this.ReasonLine = "OK";
            this.Data = new byte[headers.length];
            for (int idx = 0; idx < this.Data.length; ++idx) {
                this.Data[idx] = (byte)headers[idx];
            }
            return;
        }
        int beg = 0;
        int end = HttpClientUtil.findSpace(headers, beg);
        this.Version = end - beg > 4 ? new String(headers, beg, end - beg) : "HTTP/1.0";
        beg = HttpClientUtil.skipSpace(headers, end);
        if (beg == (end = HttpClientUtil.findSpace(headers, beg))) {
            throw new ProtocolException("Invalid HTTP status line received: no status code found in '" + new String(headers) + "'");
        }
        try {
            this.StatusCode = Integer.parseInt(new String(headers, beg, end - beg));
        }
        catch (NumberFormatException nfe) {
            throw new ProtocolException("Invalid HTTP status line received: status code '" + new String(headers, beg, end - beg) + "' not a number in '" + new String(headers) + "'");
        }
        beg = end;
        while (end < headers.length && headers[end] != '\r' && headers[end] != '\n') {
            ++end;
        }
        this.ReasonLine = new String(headers, beg, end - beg).trim();
        if (this.StatusCode >= 300 && this.sent_entity && this.stream_handler != null) {
            this.stream_handler.markForClose(this);
        }
        this.parseHeaderFields(headers, HttpClientUtil.skipSpace(headers, end), this.Headers);
        if (this.Headers.get("Trailer") != null && this.resp_inp_stream != null) {
            this.resp_inp_stream.dontTruncate();
        }
        boolean vers = !this.Version.equals("HTTP/0.9") && !this.Version.equals("HTTP/1.0");
        try {
            String con = (String)this.Headers.get("Connection");
            String pcon = (String)this.Headers.get("Proxy-Connection");
            if (!((!vers || con == null || !HttpClientUtil.hasToken(con, "close")) && (vers || !this.used_proxy && con != null && HttpClientUtil.hasToken(con, "keep-alive") || this.used_proxy && pcon != null && HttpClientUtil.hasToken(pcon, "keep-alive")) || this.stream_handler == null)) {
                this.stream_handler.markForClose(this);
            }
        }
        catch (ParseException pe) {
            // empty catch block
        }
    }

    private synchronized void getTrailers() throws IOException {
        if (this.got_trailers) {
            return;
        }
        if (this.exception != null) {
            throw (IOException)this.exception.fillInStackTrace();
        }
        try {
            if (this.trailers == null && this.resp_inp_stream != null) {
                this.resp_inp_stream.readAll(this.timeout);
            }
            if (this.trailers != null) {
                this.parseHeaderFields(this.trailers, 0, this.Trailers);
            }
        }
        catch (IOException ioe) {
            if (!(ioe instanceof InterruptedIOException)) {
                this.exception = ioe;
            }
            throw ioe;
        }
        this.got_trailers = true;
    }

    private void parseHeaderFields(char[] hdrs, int beg, CIHashtable list) throws ProtocolException {
        int end = beg;
        int len = hdrs.length;
        while (end < len) {
            while (end < len && !Character.isWhitespace(hdrs[end]) && hdrs[end] != ':') {
                ++end;
            }
            String hdr_name = new String(hdrs, beg, end - beg);
            while (end < len && Character.isWhitespace(hdrs[end])) {
                ++end;
            }
            String hdr_value = "";
            if (hdrs[end - 1] != '\n') {
                for (beg = end < len && hdrs[end] == ':' && hdrs[end - 1] != '\n' ? end + 1 : end; beg < len && Character.isWhitespace(hdrs[beg]); ++beg) {
                }
                for (end = beg; end < len && hdrs[end] != '\n'; ++end) {
                }
                hdr_value = hdrs[end - 1] == '\r' ? new String(hdrs, beg, end - 1 - beg) : new String(hdrs, beg, end - beg);
                ++end;
                while (end < len && (hdrs[end] == ' ' || hdrs[end] == '\t')) {
                    for (beg = end + 1; beg < len && (hdrs[beg] == ' ' || hdrs[beg] == '\t'); ++beg) {
                    }
                    for (end = beg; end < len && hdrs[end] != '\n'; ++end) {
                    }
                    hdr_value = hdrs[end - 1] == '\r' ? hdr_value + ' ' + new String(hdrs, beg, end - 1 - beg) : hdr_value + ' ' + new String(hdrs, beg, end - beg);
                    ++end;
                }
                beg = end;
            }
            if (hdr_name.equalsIgnoreCase("Content-length")) {
                try {
                    this.ContentLength = Integer.parseInt(hdr_value.trim());
                    if (this.ContentLength < 0) {
                        throw new NumberFormatException();
                    }
                }
                catch (NumberFormatException nfe) {
                    throw new ProtocolException("Invalid Content-length header received: '" + hdr_value + "'");
                }
                list.put(hdr_name, hdr_value);
                continue;
            }
            String old_value = (String)list.get(hdr_name);
            if (old_value == null) {
                list.put(hdr_name, hdr_value);
                continue;
            }
            list.put(hdr_name, old_value + ", " + hdr_value);
        }
    }

    private void readResponseData(InputStream inp) throws IOException {
        if (this.Data == null) {
            this.Data = new byte[0];
        }
        int off = this.Data.length;
        try {
            this.interrupted = false;
            if (this.getHeader("Content-Length") != null && this.ContentLength != -1 && this.getHeader("Transfer-Encoding") == null) {
                int rcvd = 0;
                this.Data = HttpClientUtil.resizeArray(this.Data, this.ContentLength);
                while ((rcvd = inp.read(this.Data, off += rcvd, this.ContentLength - off)) != -1 && off + rcvd < this.ContentLength) {
                }
                if (rcvd == -1) {
                    this.Data = HttpClientUtil.resizeArray(this.Data, off);
                }
            } else {
                int inc = 1000;
                int rcvd = 0;
                do {
                    this.Data = HttpClientUtil.resizeArray(this.Data, (off += rcvd) + inc);
                } while ((rcvd = inp.read(this.Data, off, inc)) != -1);
                this.Data = HttpClientUtil.resizeArray(this.Data, off);
            }
        }
        catch (InterruptedIOException iioe) {
            this.Data = HttpClientUtil.resizeArray(this.Data, off);
            this.interrupted = true;
            throw iioe;
        }
        catch (IOException ioe) {
            this.Data = HttpClientUtil.resizeArray(this.Data, off);
            throw ioe;
        }
        finally {
            if (!this.interrupted) {
                try {
                    inp.close();
                }
                catch (IOException ioe) {}
            }
        }
    }

    void markAsFirstResponse(Request req) {
        this.req = req;
        this.isFirstResponse = true;
    }

    public Object clone() {
        Response cl;
        try {
            cl = (Response)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new InternalError(cnse.toString());
        }
        cl.Headers = (CIHashtable)this.Headers.clone();
        cl.Trailers = (CIHashtable)this.Trailers.clone();
        return cl;
    }
}

