/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.AbstractChannel;
import anon.client.AbstractControlChannel;
import anon.client.AbstractDataChain;
import anon.client.AbstractDataChannel;
import anon.client.IDataChannelCreator;
import anon.client.IDataChannelFactory;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Hashtable;
import logging.LogHolder;
import logging.LogType;

public class ChannelTable
implements IDataChannelCreator {
    public static final int CONTROL_CHANNEL_ID_PAY = 2;
    public static final int CONTROL_CHANNEL_ID_REPLAY = 3;
    public static final int CONTROL_CHANNEL_ID_DUMMY = 4;
    public static final int CONTROL_CHANNEL_ID_TEST = 255;
    private static final int MAX_OPEN_DATACHANNELS = 50;
    private static final int MIN_RESERVED_CHANNEL_ID = 0;
    private static final int MAX_RESERVED_CHANNEL_ID = 255;
    private IDataChannelFactory m_dataChannelFactory;
    private Hashtable m_channelTable;
    private Hashtable m_channelTableControl;
    private volatile int m_availableDataChannels;
    private SecureRandom m_channelIdGenerator;
    private volatile boolean m_tableClosed;

    public ChannelTable(IDataChannelFactory a_dataChannelFactory, SecureRandom a_channelIdGenerator, int maxDataChannels) {
        this.m_dataChannelFactory = a_dataChannelFactory;
        this.m_channelTable = new Hashtable();
        this.m_channelTableControl = new Hashtable();
        this.m_availableDataChannels = maxDataChannels == -1 ? 50 : maxDataChannels;
        this.m_channelIdGenerator = a_channelIdGenerator;
        this.m_tableClosed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractChannel getChannel(int a_channelId) {
        AbstractChannel returnedChannel = null;
        Hashtable hashtable = this.m_channelTable;
        synchronized (hashtable) {
            returnedChannel = (AbstractChannel)this.m_channelTable.get(new Integer(a_channelId));
        }
        return returnedChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannel(int a_channelId) {
        Hashtable hashtable = this.m_channelTable;
        synchronized (hashtable) {
            if (!this.m_tableClosed) {
                AbstractChannel removedChannel = (AbstractChannel)this.m_channelTable.remove(new Integer(a_channelId));
                this.m_channelTableControl.remove(new Integer(a_channelId));
                if (removedChannel instanceof AbstractDataChannel) {
                    ++this.m_availableDataChannels;
                    this.m_channelTable.notifyAll();
                }
                if (removedChannel != null) {
                    LogHolder.log(7, LogType.NET, "ChannelTable: removeChannel(): Removed channel with ID '" + Integer.toString(a_channelId) + "' from table.");
                }
            }
        }
    }

    public boolean isSendingControlMessage() {
        Enumeration enumChannels = ((Hashtable)this.m_channelTableControl.clone()).elements();
        while (enumChannels.hasMoreElements()) {
            if (!((AbstractControlChannel)enumChannels.nextElement()).isSending()) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerControlChannel(int a_channelId, AbstractControlChannel a_controlChannel) {
        Hashtable hashtable = this.m_channelTable;
        synchronized (hashtable) {
            if (!this.m_tableClosed) {
                this.m_channelTable.put(new Integer(a_channelId), a_controlChannel);
                this.m_channelTableControl.put(new Integer(a_channelId), a_controlChannel);
                LogHolder.log(7, LogType.NET, "ChannelTable: registerControlChannel(): Registered ControlChannel with ID '" + Integer.toString(a_channelId) + "'.");
            } else {
                a_controlChannel.multiplexerClosed();
            }
        }
    }

    public boolean isControlChannelId(int a_channelId) {
        return a_channelId > 0 && a_channelId <= 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractDataChannel createDataChannel(AbstractDataChain a_parentDataChain) {
        AbstractDataChannel createdChannel = null;
        Hashtable hashtable = this.m_channelTable;
        synchronized (hashtable) {
            try {
                while (this.m_availableDataChannels <= 0 && !this.m_tableClosed) {
                    this.m_channelTable.wait();
                }
                if (!this.m_tableClosed) {
                    int channelId = this.getFreeChannelId();
                    createdChannel = this.m_dataChannelFactory.createDataChannel(channelId, a_parentDataChain);
                    this.m_channelTable.put(new Integer(channelId), createdChannel);
                    --this.m_availableDataChannels;
                    LogHolder.log(7, LogType.NET, "ChannelTable: createDataChannel(): Created DataChannel with ID '" + Integer.toString(channelId) + "'.");
                } else {
                    createdChannel = this.m_dataChannelFactory.createDataChannel(0, a_parentDataChain);
                    createdChannel.multiplexerClosed();
                }
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        return createdChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeChannelTable() {
        Hashtable hashtable = this.m_channelTable;
        synchronized (hashtable) {
            this.m_tableClosed = true;
            Enumeration channels = this.m_channelTable.elements();
            while (channels.hasMoreElements()) {
                AbstractChannel currentChannel = (AbstractChannel)channels.nextElement();
                currentChannel.multiplexerClosed();
            }
            this.m_channelTable.clear();
            this.m_channelTableControl.clear();
            this.m_availableDataChannels = 50;
            LogHolder.log(7, LogType.NET, "ChannelTable: closeChannelTable(): Removed all channels from table.");
            this.m_channelTable.notifyAll();
        }
    }

    private int getFreeChannelId() {
        int channelId = 0;
        while ((channelId = this.m_channelIdGenerator.nextInt()) >= 0 && channelId <= 255 || this.getChannel(channelId) != null) {
        }
        return channelId;
    }
}

