/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.AbstractChannel;
import anon.client.ChannelTable;
import anon.client.DefaultDataChannelFactory;
import anon.client.ISendCallbackHandler;
import anon.client.KeyExchangeManager;
import anon.client.MixPacket;
import anon.client.PacketProcessedEvent;
import anon.client.crypto.ControlChannelCipher;
import anon.client.crypto.ISymCipher;
import anon.util.Base64;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class Multiplexer
extends Observable
implements Runnable {
    private Vector m_sendJobQueue;
    private Vector m_controlMessageQueue;
    private Object m_waitQueueObject;
    private ChannelTable m_channelTable;
    private InputStream m_inputStream;
    private OutputStream m_outputStream;
    private ISymCipher m_inputStreamCipher;
    private ISymCipher m_outputStreamCipher;
    private ControlChannelCipher m_controlchannelCiper;
    private Object m_internalEventSynchronization = new Object();
    private boolean m_bClosed = false;
    private boolean m_bWithIntegrityCheck;
    private boolean m_bDebug = false;

    public Multiplexer(InputStream a_inputStream, OutputStream a_outputStream, KeyExchangeManager a_keyExchangeManager, SecureRandom a_channelIdGenerator) {
        this.m_sendJobQueue = new Vector();
        this.m_controlMessageQueue = new Vector();
        this.m_waitQueueObject = new Object();
        this.m_channelTable = new ChannelTable(new DefaultDataChannelFactory(a_keyExchangeManager, this), a_channelIdGenerator, a_keyExchangeManager.getMaxOpenChannels());
        this.m_inputStream = a_inputStream;
        this.m_inputStreamCipher = a_keyExchangeManager.getMultiplexerInputStreamCipher();
        this.m_outputStream = a_outputStream;
        this.m_outputStreamCipher = a_keyExchangeManager.getMultiplexerOutputStreamCipher();
        this.m_controlchannelCiper = a_keyExchangeManager.getControlChannelCipher();
        this.m_bWithIntegrityCheck = a_keyExchangeManager.isProtocolWithIntegrityCheck();
        this.m_bDebug = a_keyExchangeManager.isDebug();
        Thread downstreamThread = new Thread((Runnable)this, "Multiplexer: Receive-Thread");
        downstreamThread.setDaemon(true);
        downstreamThread.start();
    }

    public boolean isSendingControlMessage() {
        return this.m_channelTable.isSendingControlMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendPacket(MixPacket a_mixPacket) throws IOException {
        Object object;
        Object nextLockObject3;
        Object object2;
        Object ownSynchronizationObject = new Object();
        boolean bIsControlChPacket = this.m_channelTable.isControlChannelId(a_mixPacket.getChannelId());
        Vector waitQueue = bIsControlChPacket ? this.m_controlMessageQueue : this.m_sendJobQueue;
        Object object3 = ownSynchronizationObject;
        synchronized (object3) {
            boolean waitForAccess = false;
            object2 = this.m_waitQueueObject;
            synchronized (object2) {
                if (!bIsControlChPacket) {
                    if (this.m_controlMessageQueue.size() > 0 || this.m_sendJobQueue.size() > 0) {
                        waitForAccess = true;
                    }
                } else if (this.m_controlMessageQueue.size() > 0) {
                    waitForAccess = true;
                    LogHolder.log(4, LogType.NET, "Control channel congestion");
                }
                waitQueue.addElement(ownSynchronizationObject);
            }
            if (waitForAccess) {
                try {
                    ownSynchronizationObject.wait();
                }
                catch (InterruptedException e) {
                    Object nextLockObject2 = null;
                    Object object4 = this.m_waitQueueObject;
                    synchronized (object4) {
                        waitQueue.removeElement(ownSynchronizationObject);
                        if (this.m_controlMessageQueue.size() > 0) {
                            nextLockObject2 = this.m_controlMessageQueue.firstElement();
                        } else if (this.m_sendJobQueue.size() > 0) {
                            nextLockObject2 = this.m_sendJobQueue.firstElement();
                        }
                    }
                    if (nextLockObject2 != null) {
                        object4 = nextLockObject2;
                        synchronized (object4) {
                            nextLockObject2.notify();
                        }
                    }
                    throw new InterruptedIOException(e.toString());
                }
            }
        }
        Enumeration sendCallbackHandlers = a_mixPacket.getSendCallbackHandlers().elements();
        while (sendCallbackHandlers.hasMoreElements()) {
            ((ISendCallbackHandler)sendCallbackHandlers.nextElement()).finalizePacket(a_mixPacket);
        }
        byte[] packetData = a_mixPacket.getRawPacket();
        if (this.m_outputStreamCipher != null) {
            this.m_outputStreamCipher.encryptAES1(packetData, 0, packetData, 0, 16);
        }
        try {
            this.m_outputStream.write(packetData);
            this.m_outputStream.flush();
            LogHolder.log(7, LogType.TRANSPORT, "PacketSent at time: " + System.currentTimeMillis());
            object2 = this.m_internalEventSynchronization;
            synchronized (object2) {
                this.setChanged();
                if (bIsControlChPacket) {
                    this.notifyObservers(PacketProcessedEvent.PPE_CONTROL_PACKET_SENT);
                } else {
                    this.notifyObservers(PacketProcessedEvent.PPE_DATA_PACKET_SENT);
                }
            }
            Object var15_17 = null;
            nextLockObject3 = null;
            object = this.m_waitQueueObject;
        }
        catch (Throwable throwable) {
            Object var15_18 = null;
            Object nextLockObject3 = null;
            Object object5 = this.m_waitQueueObject;
            synchronized (object5) {
                waitQueue.removeElement(ownSynchronizationObject);
                if (this.m_controlMessageQueue.size() > 0) {
                    nextLockObject3 = this.m_controlMessageQueue.firstElement();
                } else if (this.m_sendJobQueue.size() > 0) {
                    nextLockObject3 = this.m_sendJobQueue.firstElement();
                } else {
                    this.m_waitQueueObject.notify();
                }
            }
            if (nextLockObject3 != null) {
                object5 = nextLockObject3;
                synchronized (object5) {
                    nextLockObject3.notify();
                }
            }
            throw throwable;
        }
        synchronized (object) {
            waitQueue.removeElement(ownSynchronizationObject);
            if (this.m_controlMessageQueue.size() > 0) {
                nextLockObject3 = this.m_controlMessageQueue.firstElement();
            } else if (this.m_sendJobQueue.size() > 0) {
                nextLockObject3 = this.m_sendJobQueue.firstElement();
            } else {
                this.m_waitQueueObject.notify();
            }
        }
        if (nextLockObject3 != null) {
            object = nextLockObject3;
            synchronized (object) {
                nextLockObject3.notify();
            }
        }
    }

    protected void close() {
        this.m_bClosed = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        int iPacketCounter = 0;
        while (true) {
            try {
                Object object;
                int channelId;
                while (true) {
                    AbstractChannel channel;
                    MixPacket receivedPacket = new MixPacket(this.m_inputStream, this.m_inputStreamCipher);
                    ++iPacketCounter;
                    channelId = receivedPacket.getChannelId();
                    if (this.m_bDebug) {
                        LogHolder.log(7, LogType.NET, "AN.ON debug packet received (PacketCounter: " + iPacketCounter + ", Channel:" + channelId + "): " + Base64.encode(receivedPacket.getPayloadData(), 0, MixPacket.getPayloadSize(), false));
                    }
                    if ((channel = this.m_channelTable.getChannel(channelId)) == null) break;
                    object = this.m_internalEventSynchronization;
                    synchronized (object) {
                        this.setChanged();
                        if (this.m_channelTable.isControlChannelId(channelId)) {
                            this.notifyObservers(PacketProcessedEvent.PPE_CONTROL_PACKET_RECEIVED);
                        } else {
                            this.notifyObservers(PacketProcessedEvent.PPE_DATA_PACKET_RECEIVED);
                        }
                    }
                    channel.processReceivedPacket(receivedPacket);
                }
                if (LogHolder.isLogged(6, LogType.NET)) {
                    LogHolder.log(6, LogType.NET, "Received a packet for unknown channel '" + Long.toString((long)channelId & 0xFFFFFFL) + "' Maybe we have already closed it and do not want to get more data for it.");
                }
                object = this.m_internalEventSynchronization;
                synchronized (object) {
                    this.setChanged();
                    if (this.m_channelTable.isControlChannelId(channelId)) {
                        this.notifyObservers(PacketProcessedEvent.PPE_CONTROL_PACKET_DISCARDED);
                    } else {
                        this.notifyObservers(PacketProcessedEvent.PPE_DATA_PACKET_DISCARDED);
                    }
                }
            }
            catch (IOException e) {
                if (this.m_bClosed) {
                    if (LogHolder.isLogged(5, LogType.NET)) {
                        LogHolder.log(5, LogType.NET, Thread.currentThread().getName() + ": terminated!", e);
                    }
                } else {
                    LogHolder.log(2, LogType.NET, Thread.currentThread().getName() + ": terminated!", e);
                }
                this.m_channelTable.closeChannelTable();
                return;
            }
        }
    }

    public ChannelTable getChannelTable() {
        return this.m_channelTable;
    }

    public ControlChannelCipher getControlChannelCipher() {
        return this.m_controlchannelCiper;
    }

    public boolean isProtocolWithIntegrityCheck() {
        return this.m_bWithIntegrityCheck;
    }

    public boolean isDebug() {
        return this.m_bDebug;
    }
}

