/*
 * Decompiled with CFR 0.152.
 */
package anon.forward.server;

import anon.forward.server.DefaultProtocolHandler;
import anon.forward.server.ForwardScheduler;
import anon.forward.server.IProtocolHandler;
import anon.transport.address.Endpoint;
import anon.transport.connection.IStreamConnection;
import java.io.InputStream;
import logging.LogHolder;
import logging.LogType;

public class ForwardConnection {
    private IStreamConnection m_clientConnection;
    private IProtocolHandler m_serverConnection;
    private ForwardScheduler m_parentScheduler;
    private boolean m_closeConnection;
    private int m_transferFromClient;
    private int m_transferFromServer;
    private Thread m_clientReadThread;
    private Thread m_serverReadThread;
    private Thread m_timeoutThread;

    public ForwardConnection(IStreamConnection a_clientConnection, ForwardScheduler a_parentScheduler) throws Exception {
        this.m_clientConnection = a_clientConnection;
        this.m_parentScheduler = a_parentScheduler;
        this.m_serverConnection = new DefaultProtocolHandler(this);
        this.m_transferFromServer = 0;
        this.m_transferFromClient = 0;
        this.m_closeConnection = false;
        this.m_clientReadThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                InputStream inFromClient = ForwardConnection.this.m_clientConnection.getInputStream();
                while (!ForwardConnection.this.m_closeConnection) {
                    block19: {
                        byte[] bufferClient = null;
                        int len = 1;
                        if (ForwardConnection.this.m_transferFromClient > 0) {
                            int availableData = 0;
                            try {
                                availableData = inFromClient.available();
                            }
                            catch (Exception e) {
                                LogHolder.log(3, LogType.NET, e);
                                ForwardConnection.this.closeConnection();
                            }
                            len = Math.max(Math.min(ForwardConnection.this.m_transferFromClient, availableData), len);
                            Thread e = ForwardConnection.this.m_clientReadThread;
                            synchronized (e) {
                                ForwardConnection.this.m_transferFromClient = 0;
                            }
                        }
                        bufferClient = new byte[len];
                        try {
                            int readBytes = inFromClient.read(bufferClient);
                            LogHolder.log(7, LogType.FORWARDING, "ForwardingConnection Client --> Server: We read " + readBytes + " Bytes");
                            if (readBytes == -1) {
                                LogHolder.log(7, LogType.TRANSPORT, "Close connection with client");
                                ForwardConnection.this.closeConnection();
                                break block19;
                            }
                            if (readBytes < bufferClient.length) {
                                byte[] tempBuffer = new byte[readBytes];
                                System.arraycopy(bufferClient, 0, tempBuffer, 0, readBytes);
                                bufferClient = tempBuffer;
                            }
                            if (readBytes <= 0) break block19;
                            try {
                                ForwardConnection.this.m_timeoutThread.interrupt();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            ForwardConnection.this.m_parentScheduler.getStatistics().incrementTransferVolume(readBytes);
                            LogHolder.log(7, LogType.FORWARDING, readBytes + " bytes send to the server (forward from client)");
                            ForwardConnection.this.m_serverConnection.write(bufferClient);
                        }
                        catch (Exception e) {
                            LogHolder.log(3, LogType.NET, e);
                            ForwardConnection.this.closeConnection();
                        }
                    }
                    Thread thread = ForwardConnection.this.m_clientReadThread;
                    synchronized (thread) {
                        if (!ForwardConnection.this.m_closeConnection) {
                            try {
                                ForwardConnection.this.m_clientReadThread.wait();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }, "Client to server forwarding");
        this.m_clientReadThread.setDaemon(true);
        this.m_serverReadThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                while (!ForwardConnection.this.m_closeConnection) {
                    Thread thread;
                    block19: {
                        byte[] bufferServer = null;
                        thread = ForwardConnection.this.m_serverReadThread;
                        synchronized (thread) {
                            bufferServer = new byte[ForwardConnection.this.m_transferFromServer];
                            try {
                                int availableData = ForwardConnection.this.m_serverConnection.available();
                                if (bufferServer.length > availableData) {
                                    bufferServer = new byte[availableData];
                                }
                            }
                            catch (Exception e) {
                                LogHolder.log(3, LogType.NET, e);
                                ForwardConnection.this.closeConnection();
                            }
                            ForwardConnection.this.m_transferFromServer = 0;
                        }
                        try {
                            int readBytes = ForwardConnection.this.m_serverConnection.read(bufferServer);
                            if (readBytes == -1) {
                                ForwardConnection.this.closeConnection();
                                break block19;
                            }
                            if (readBytes < bufferServer.length) {
                                byte[] tempBuffer = new byte[readBytes];
                                System.arraycopy(bufferServer, 0, tempBuffer, 0, readBytes);
                                bufferServer = tempBuffer;
                            }
                            if (readBytes <= 0) break block19;
                            try {
                                ForwardConnection.this.m_timeoutThread.interrupt();
                            }
                            catch (Exception e) {
                                // empty catch block
                            }
                            ForwardConnection.this.m_parentScheduler.getStatistics().incrementTransferVolume(readBytes);
                            LogHolder.log(7, LogType.FORWARDING, readBytes + " bytes send to the client (forward from )");
                            ForwardConnection.this.m_clientConnection.getOutputStream().write(bufferServer);
                            ForwardConnection.this.m_clientConnection.getOutputStream().flush();
                        }
                        catch (Exception e) {
                            LogHolder.log(3, LogType.NET, e);
                            ForwardConnection.this.closeConnection();
                        }
                    }
                    thread = ForwardConnection.this.m_serverReadThread;
                    synchronized (thread) {
                        if (!ForwardConnection.this.m_closeConnection) {
                            try {
                                ForwardConnection.this.m_serverReadThread.wait();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
        }, "Server to client forwarding");
        this.m_serverReadThread.setDaemon(true);
        this.m_timeoutThread = new Thread(new Runnable(){

            public void run() {
                while (!ForwardConnection.this.m_closeConnection) {
                    try {
                        Thread.sleep(200000L);
                        ForwardConnection.this.closeConnection();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }, "Client timeout thread");
        this.m_timeoutThread.setDaemon(true);
        this.m_clientReadThread.start();
        this.m_serverReadThread.start();
        this.m_timeoutThread.start();
    }

    public int getAvailableBytes() {
        int availableBytes = 0;
        try {
            availableBytes = this.m_clientConnection.getInputStream().available() + this.m_serverConnection.available();
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.NET, e);
            this.closeConnection();
        }
        return availableBytes;
    }

    public ForwardScheduler getParentScheduler() {
        return this.m_parentScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeConnection() {
        boolean alreadyClosed = false;
        Thread thread = this.m_serverReadThread;
        synchronized (thread) {
            Thread thread2 = this.m_clientReadThread;
            synchronized (thread2) {
                alreadyClosed = this.m_closeConnection;
                this.m_closeConnection = true;
            }
        }
        if (!alreadyClosed) {
            try {
                this.m_clientConnection.close();
                if (this.m_serverConnection != null) {
                    this.m_serverConnection.close();
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            this.m_parentScheduler.removeConnection(this);
            Thread e = this.m_clientReadThread;
            synchronized (e) {
                this.m_clientReadThread.notify();
            }
            e = this.m_serverReadThread;
            synchronized (e) {
                this.m_serverReadThread.notify();
            }
            try {
                this.m_timeoutThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void allowTransfer(int a_transferBytes) {
        int transferFromServer = 0;
        int transferFromClient = 0;
        transferFromServer = a_transferBytes / 2;
        transferFromClient = a_transferBytes / 2;
        Thread thread = this.m_clientReadThread;
        synchronized (thread) {
            this.m_transferFromClient = transferFromClient;
            this.m_clientReadThread.notify();
        }
        thread = this.m_serverReadThread;
        synchronized (thread) {
            this.m_transferFromServer = transferFromServer;
            this.m_serverReadThread.notify();
        }
    }

    public String toString() {
        return Endpoint.toURN(this.m_clientConnection.getRemoteAddress());
    }
}

