/*
 * Decompiled with CFR 0.152.
 */
package anon.forward.server;

import anon.infoservice.Database;
import anon.infoservice.InfoServiceDBEntry;
import anon.util.XMLUtil;
import java.util.Observable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ServerSocketPropagandist
extends Observable
implements Runnable {
    public static final int STATE_REGISTERED = 0;
    public static final int STATE_CONNECTING = 1;
    public static final int STATE_RECONNECTING = 2;
    public static final int STATE_HALTED = 3;
    public static final int RETURN_SUCCESS = 0;
    public static final int RETURN_VERIFICATION_ERROR = 1;
    public static final int RETURN_INFOSERVICE_ERROR = 2;
    public static final int RETURN_UNKNOWN_ERROR = 3;
    private static final int RETURN_FORWARDERID_ERROR = 4;
    private static final int FORWARDER_VERIFY_ERROR_CODE = 1;
    private static final int FORWARDER_RENEW_ERROR_CODE = 11;
    private static final long FORWARDER_RENEW_PERIOD = 600000L;
    private int m_portNumber;
    private InfoServiceDBEntry m_infoService;
    private String m_forwarderId;
    private int m_currentErrorCode;
    private Thread m_propagandaThread;
    private int m_currentConnectionState;
    static /* synthetic */ Class class$anon$infoservice$InfoServiceDBEntry;

    public ServerSocketPropagandist(int a_portNumber) {
        this(a_portNumber, null);
    }

    public ServerSocketPropagandist(int a_portNumber, InfoServiceDBEntry a_infoService) {
        this.m_portNumber = a_portNumber;
        this.m_infoService = a_infoService;
        this.m_propagandaThread = new Thread(this);
        this.m_propagandaThread.setName("ServerSocketPropagandist");
        this.m_propagandaThread.setDaemon(true);
        this.m_currentErrorCode = this.announceNewForwarder();
        this.m_currentConnectionState = this.m_currentErrorCode != 0 ? 1 : 0;
        this.m_propagandaThread.start();
    }

    public int getPort() {
        return this.m_portNumber;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopPropaganda() {
        Thread thread = this.m_propagandaThread;
        synchronized (thread) {
            try {
                this.m_propagandaThread.interrupt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public int getCurrentState() {
        return this.m_currentConnectionState;
    }

    public int getCurrentErrorCode() {
        return this.m_currentErrorCode;
    }

    public InfoServiceDBEntry getInfoService() {
        return this.m_infoService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean stopPropaganda = false;
        while (!stopPropaganda) {
            Thread thread = this.m_propagandaThread;
            synchronized (thread) {
                try {
                    stopPropaganda = Thread.interrupted();
                    if (!stopPropaganda) {
                        this.m_propagandaThread.wait(600000L);
                    }
                }
                catch (InterruptedException e) {
                    stopPropaganda = true;
                }
            }
            if (stopPropaganda) continue;
            boolean notifyObservers = false;
            if (this.m_currentConnectionState == 0 && this.renewForwarder() != 0) {
                this.m_currentConnectionState = 2;
                notifyObservers = true;
            }
            if (this.m_currentConnectionState != 1 && this.m_currentConnectionState != 2) continue;
            int currentErrorCode = this.announceNewForwarder();
            if (currentErrorCode == 0) {
                this.m_currentConnectionState = 0;
                notifyObservers = true;
            }
            if (currentErrorCode != this.m_currentErrorCode) {
                notifyObservers = true;
            }
            this.m_currentErrorCode = currentErrorCode;
            if (!notifyObservers) continue;
            this.setChanged();
            this.notifyObservers(null);
        }
        this.m_currentConnectionState = 3;
        this.m_currentErrorCode = 0;
        this.setChanged();
        this.notifyObservers(null);
    }

    private int announceNewForwarder() {
        int iLastResult = 3;
        if (this.m_infoService != null) {
            return this.announceNewForwarder(this.m_infoService);
        }
        Vector vecInfoServices = Database.getInstance(class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = ServerSocketPropagandist.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry).getEntryList();
        for (int i = 0; i < vecInfoServices.size(); ++i) {
            InfoServiceDBEntry infoservice = (InfoServiceDBEntry)vecInfoServices.elementAt(i);
            int iCurrentResult = infoservice.hasPrimaryForwarderList() ? this.announceNewForwarder(infoservice) : 2;
            if (iLastResult == 0 || iCurrentResult == 3) continue;
            iLastResult = iCurrentResult;
        }
        return iLastResult;
    }

    private int announceNewForwarder(InfoServiceDBEntry a_infoService) {
        int returnValue;
        block13: {
            returnValue = 3;
            try {
                Document doc = XMLUtil.createDocument();
                Element japForwarderNode = doc.createElement("JapForwarder");
                Element plainInformationNode = doc.createElement("PlainInformation");
                Element portNode = doc.createElement("Port");
                portNode.appendChild(doc.createTextNode(Integer.toString(this.m_portNumber)));
                plainInformationNode.appendChild(portNode);
                japForwarderNode.appendChild(plainInformationNode);
                doc.appendChild(japForwarderNode);
                try {
                    Element answerJapForwarderNode = a_infoService.postNewForwarder(japForwarderNode);
                    if (answerJapForwarderNode == null) {
                        return 2;
                    }
                    NodeList answerPlainInformationNodes = answerJapForwarderNode.getElementsByTagName("PlainInformation");
                    if (answerPlainInformationNodes.getLength() == 0) {
                        NodeList answerErrorInformationNodes = answerJapForwarderNode.getElementsByTagName("ErrorInformation");
                        if (answerErrorInformationNodes.getLength() == 0) {
                            returnValue = 3;
                            break block13;
                        }
                        Element answerErrorInformationNode = (Element)answerErrorInformationNodes.item(0);
                        NodeList answerErrorNodes = answerErrorInformationNode.getElementsByTagName("Error");
                        if (answerErrorNodes.getLength() == 0) {
                            returnValue = 3;
                            break block13;
                        }
                        Element answerErrorNode = (Element)answerErrorNodes.item(0);
                        try {
                            if (Integer.parseInt(answerErrorNode.getAttribute("code")) == 1) {
                                returnValue = 1;
                                break block13;
                            }
                            returnValue = 3;
                            LogHolder.log(3, LogType.NET, "ServerSocketPropagandist: announceNewForwarder: The infoservice returned an unknwon error: Errorcode " + Integer.parseInt(answerErrorNode.getAttribute("code")) + ": " + answerErrorNode.getFirstChild().getNodeValue());
                        }
                        catch (Exception e) {
                            returnValue = 3;
                            LogHolder.log(3, LogType.NET, "ServerSocketPropagandist: announceNewForwarder: Error while parsing the error information returned by the infoservice: " + e.toString());
                        }
                        break block13;
                    }
                    Element answerPlainInformationNode = (Element)answerPlainInformationNodes.item(0);
                    NodeList answerForwarderNodes = answerPlainInformationNode.getElementsByTagName("Forwarder");
                    if (answerForwarderNodes.getLength() == 0) {
                        returnValue = 3;
                        LogHolder.log(3, LogType.NET, "ServerSocketPropagandist: announceNewForwarder: Error while parsing the infoservice answer (Forwarder node).");
                        break block13;
                    }
                    Element answerForwarderNode = (Element)answerForwarderNodes.item(0);
                    String answerId = answerForwarderNode.getAttribute("id");
                    if (answerId == null || new String("").equals(answerId)) {
                        returnValue = 3;
                        LogHolder.log(3, LogType.NET, "ServerSocketPropagandist: announceNewForwarder: Got an invalid id from the infoservice.");
                        break block13;
                    }
                    this.m_forwarderId = answerId;
                    returnValue = 0;
                }
                catch (Exception e) {
                    returnValue = 2;
                    LogHolder.log(3, LogType.NET, "ServerSocketPropagandist: announceNewForwarder: InfoService communication error: " + e.toString());
                }
            }
            catch (Exception e) {
                returnValue = 3;
                LogHolder.log(3, LogType.NET, "ServerSocketPropagandist: announceNewForwarder: Unexpected error while creating the request document: " + e.toString());
            }
        }
        return returnValue;
    }

    private int renewForwarder() {
        int iLastResult = 3;
        if (this.m_infoService != null) {
            return this.renewForwarder(this.m_infoService);
        }
        Vector vecInfoServices = Database.getInstance(class$anon$infoservice$InfoServiceDBEntry == null ? (class$anon$infoservice$InfoServiceDBEntry = ServerSocketPropagandist.class$("anon.infoservice.InfoServiceDBEntry")) : class$anon$infoservice$InfoServiceDBEntry).getEntryList();
        for (int i = 0; i < vecInfoServices.size(); ++i) {
            InfoServiceDBEntry infoservice = (InfoServiceDBEntry)vecInfoServices.elementAt(i);
            int iCurrentResult = infoservice.hasPrimaryForwarderList() ? this.renewForwarder(infoservice) : 2;
            if (iLastResult == 0 || iCurrentResult == 3) continue;
            iLastResult = iCurrentResult;
        }
        return iLastResult;
    }

    private int renewForwarder(InfoServiceDBEntry a_infoService) {
        int returnValue;
        block11: {
            returnValue = 3;
            try {
                Document doc = XMLUtil.createDocument();
                Element japForwarderNode = doc.createElement("JapForwarder");
                Element plainInformationNode = doc.createElement("PlainInformation");
                Element forwarderNode = doc.createElement("Forwarder");
                forwarderNode.setAttribute("id", this.m_forwarderId);
                plainInformationNode.appendChild(forwarderNode);
                japForwarderNode.appendChild(plainInformationNode);
                doc.appendChild(japForwarderNode);
                try {
                    Element answerJapForwarderNode = a_infoService.postRenewForwarder(japForwarderNode);
                    if (answerJapForwarderNode == null) {
                        return 2;
                    }
                    NodeList answerErrorInformationNodes = answerJapForwarderNode.getElementsByTagName("ErrorInformation");
                    if (answerErrorInformationNodes.getLength() == 0) {
                        returnValue = 0;
                        break block11;
                    }
                    Element answerErrorInformationNode = (Element)answerErrorInformationNodes.item(0);
                    NodeList answerErrorNodes = answerErrorInformationNode.getElementsByTagName("Error");
                    if (answerErrorNodes.getLength() == 0) {
                        returnValue = 3;
                        break block11;
                    }
                    Element answerErrorNode = (Element)answerErrorNodes.item(0);
                    try {
                        if (Integer.parseInt(answerErrorNode.getAttribute("code")) == 11) {
                            returnValue = 4;
                        } else {
                            returnValue = 3;
                            LogHolder.log(3, LogType.NET, "ServerSocketPropagandist: renewForwarder: The infoservice returned an unknwon error: Errorcode " + Integer.parseInt(answerErrorNode.getAttribute("code")) + ": " + answerErrorNode.getFirstChild().getNodeValue());
                        }
                    }
                    catch (Exception e) {
                        returnValue = 3;
                        LogHolder.log(3, LogType.NET, "ServerSocketPropagandist: renewForwarder: Error while parsing the error information returned by the infoservice: " + e.toString());
                    }
                }
                catch (Exception e) {
                    returnValue = 2;
                    LogHolder.log(3, LogType.NET, "ServerSocketPropagandist: renewForwarder: InfoService communication error: " + e.toString());
                }
            }
            catch (Exception e) {
                returnValue = 3;
                LogHolder.log(3, LogType.NET, "ServerSocketPropagandist: renewForwarder: Unexpected error while creating the request document: " + e.toString());
            }
        }
        return returnValue;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

