/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.util.MyStringBuilder;
import anon.util.XMLUtil;
import java.io.UnsupportedEncodingException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.w3c.dom.Document;

public final class HttpResponseStructure {
    public static final int HTTP_RETURN_OK = 200;
    public static final int HTTP_RETURN_ACCEPTED = 202;
    public static final int HTTP_RETURN_BAD_REQUEST = 400;
    public static final int HTTP_RETURN_NOT_FOUND = 404;
    public static final int HTTP_RETURN_INTERNAL_SERVER_ERROR = 500;
    public static final int HTTP_TYPE_TEXT_PLAIN = 0;
    public static final int HTTP_TYPE_TEXT_HTML = 1;
    public static final int HTTP_TYPE_TEXT_XML = 2;
    public static final int HTTP_TYPE_APPLICATION_JNLP = 10;
    public static final int HTTP_ENCODING_PLAIN = 0;
    public static final int HTTP_ENCODING_ZLIB = 1;
    public static final int HTTP_ENCODING_GZIP = 2;
    public static final int HTTP_TYPE_NO_TYPE = -1;
    public static final String HTTP_11_STRING = "HTTP/1.1 ";
    public static final String HTTP_CRLF_STRING = "\r\n";
    public static final String HTTP_RETURN_OK_STRING = "200 OK";
    public static final String HTTP_RETURN_ACCEPTED_STRING = "202 Accepted";
    public static final String HTTP_RETURN_BAD_REQUEST_STRING = "400 Bad Request";
    public static final String HTTP_RETURN_NOT_FOUND_STRING = "404 Not Found";
    public static final String HTTP_RETURN_INTERNAL_SERVER_ERROR_STRING = "500 Internal Server Error";
    public static final String HTTP_HEADER_TYPE_STRING = "Content-type: ";
    public static final String HTTP_HEADER_ENCODING_STRING = "Content-Encoding: ";
    public static final String HTTP_HEADER_LENGTH_STRING = "Content-length: ";
    public static final String HTTP_HEADER_DATE_STRING = "Date: ";
    public static final String HTTP_HEADER_EXPIRES_STRING = "Expires: ";
    public static final String HTTP_HEADER_CACHE_CONTROL_STRING = "Cache-Control: ";
    public static final String HTTP_HEADER_PRAGMA_STRING = "Pragma: ";
    public static final String HTTP_HEADER_CACHE_CONTROL_STRINGS = "Cache-Control: no-cache\r\nPragma: no-cache\r\n";
    public static final String HTTP_ENCODING_ZLIB_STRING = "deflate";
    public static final String HTTP_ENCODING_GZIP_STRING = "gzip";
    public static final String HTTP_TYPE_APPLICATION_JNLP_STRING = "application/x-java-jnlp-file";
    public static final String HTTP_TYPE_TEXT_PLAIN_STRING = "text/plain";
    public static final String HTTP_TYPE_TEXT_HTML_STRING = "text/html";
    public static final String HTTP_TYPE_TEXT_XML_STRING = "text/xml";
    public static final String HTML_NOT_FOUND = "<HTML><TITLE>404 File Not Found</TITLE><H1>404 File Not Found</H1><P>File not found on this server.</P></HTML>";
    public static final String HTML_BAD_REQUEST = "<HTML><TITLE>400 Bad Request</TITLE><H1>400 Bad Request</H1><P>Your request has been rejected by the server.</P></HTML>";
    public static final String HTML_INTERNAL_SERVER_ERROR = "<HTML><TITLE>500 Internal Server Error</TITLE><H1>500 Internal Server Error</H1><P>Error while processing the request on the server.</P></HTML>";
    private byte[] m_httpReturnData;

    public HttpResponseStructure(int a_returnCode) {
        this.m_httpReturnData = a_returnCode == 200 ? this.createHttpMessage(200, -1, 0, null, false) : (a_returnCode == 202 ? this.createHttpMessage(202, -1, 0, null, false) : (a_returnCode == 400 ? this.createHttpMessage(400, 1, 0, HTML_BAD_REQUEST.getBytes(), false) : (a_returnCode == 404 ? this.createHttpMessage(404, 1, 0, HTML_NOT_FOUND.getBytes(), false) : this.createHttpMessage(500, 1, 0, HTML_INTERNAL_SERVER_ERROR.getBytes(), false))));
    }

    public HttpResponseStructure(Document a_xmlDocument) {
        this(a_xmlDocument, 0);
    }

    public HttpResponseStructure(Document a_xmlDocument, int a_supportedEncodings) {
        String xmlString = XMLUtil.toString(a_xmlDocument);
        if (xmlString == null) {
            this.m_httpReturnData = this.createHttpMessage(500, 1, 0, HTML_INTERNAL_SERVER_ERROR.getBytes(), false);
        } else {
            try {
                this.m_httpReturnData = this.createHttpMessage(200, 2, a_supportedEncodings, xmlString.getBytes("UTF8"), false);
            }
            catch (UnsupportedEncodingException ex) {
                this.m_httpReturnData = this.createHttpMessage(200, 2, a_supportedEncodings, xmlString.getBytes(), false);
            }
        }
    }

    public HttpResponseStructure(int a_httpDataType, int a_httpEncoding, String a_httpData) {
        try {
            this.m_httpReturnData = this.createHttpMessage(200, a_httpDataType, a_httpEncoding, a_httpData.getBytes("UTF8"), false);
        }
        catch (UnsupportedEncodingException ex) {
            this.m_httpReturnData = this.createHttpMessage(200, a_httpDataType, a_httpEncoding, a_httpData.getBytes(), false);
        }
    }

    public HttpResponseStructure(int a_httpDataType, int a_httpEncoding, byte[] a_httpData) {
        this.m_httpReturnData = this.createHttpMessage(200, a_httpDataType, a_httpEncoding, a_httpData, false);
    }

    public HttpResponseStructure(int a_httpDataType, int a_httpEncoding, String a_httpData, boolean a_onlyHeader) {
        this.m_httpReturnData = this.createHttpMessage(200, a_httpDataType, a_httpEncoding, a_httpData.getBytes(), a_onlyHeader);
    }

    public HttpResponseStructure(int httpReturnCode, String httpData) {
        this.m_httpReturnData = this.createHttpMessage(httpReturnCode, 1, 0, httpData.getBytes(), false);
    }

    public byte[] getResponseData() {
        return this.m_httpReturnData;
    }

    private byte[] createHttpMessage(int a_httpReturnCode, int a_httpDataType, int a_httpEncoding, byte[] a_httpData, boolean a_onlyHeader) {
        return this.createHttpMessage(a_httpReturnCode, a_httpDataType, a_httpEncoding, a_httpData, a_onlyHeader, null);
    }

    private byte[] createHttpMessage(int a_httpReturnCode, int a_httpDataType, int a_httpEncoding, byte[] a_httpData, boolean a_onlyHeader, DateFormat dateFormat) {
        MyStringBuilder httpHeader = new MyStringBuilder(2048);
        httpHeader.append(HTTP_11_STRING);
        if (a_httpReturnCode == 200) {
            httpHeader.append(HTTP_RETURN_OK_STRING);
        } else if (a_httpReturnCode == 202) {
            httpHeader.append(HTTP_RETURN_ACCEPTED_STRING);
        } else if (a_httpReturnCode == 400) {
            httpHeader.append(HTTP_RETURN_BAD_REQUEST_STRING);
        } else if (a_httpReturnCode == 404) {
            httpHeader.append(HTTP_RETURN_NOT_FOUND_STRING);
        } else if (a_httpReturnCode == 500) {
            httpHeader.append(HTTP_RETURN_INTERNAL_SERVER_ERROR_STRING);
        }
        httpHeader.append(HTTP_CRLF_STRING);
        if (a_httpData != null) {
            httpHeader.append(HTTP_HEADER_LENGTH_STRING);
            httpHeader.append(a_httpData.length);
            httpHeader.append(HTTP_CRLF_STRING);
        }
        if (a_httpDataType != -1) {
            httpHeader.append(HTTP_HEADER_TYPE_STRING);
            if (a_httpDataType == 0) {
                httpHeader.append(HTTP_TYPE_TEXT_PLAIN_STRING);
            } else if (a_httpDataType == 1) {
                httpHeader.append(HTTP_TYPE_TEXT_HTML_STRING);
            } else if (a_httpDataType == 2) {
                httpHeader.append(HTTP_TYPE_TEXT_XML_STRING);
            } else if (a_httpDataType == 10) {
                httpHeader.append(HTTP_TYPE_APPLICATION_JNLP_STRING);
            }
            httpHeader.append(HTTP_CRLF_STRING);
        }
        if (a_httpEncoding != 0) {
            httpHeader.append(HTTP_HEADER_ENCODING_STRING);
            if (a_httpEncoding == 1) {
                httpHeader.append(HTTP_ENCODING_ZLIB_STRING);
            } else if (a_httpEncoding == 2) {
                httpHeader.append(HTTP_ENCODING_GZIP_STRING);
            }
            httpHeader.append(HTTP_CRLF_STRING);
        }
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.US);
            dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
        }
        String currentDate = dateFormat.format(new Date());
        httpHeader.append(HTTP_HEADER_EXPIRES_STRING);
        httpHeader.append(currentDate);
        httpHeader.append(HTTP_CRLF_STRING);
        httpHeader.append(HTTP_HEADER_DATE_STRING);
        httpHeader.append(currentDate);
        httpHeader.append(HTTP_CRLF_STRING);
        httpHeader.append(HTTP_HEADER_CACHE_CONTROL_STRINGS);
        httpHeader.append(HTTP_CRLF_STRING);
        byte[] createdHttpResponse = null;
        if (a_httpData != null && !a_onlyHeader) {
            byte[] headerData;
            try {
                headerData = httpHeader.toString().getBytes("UTF8");
            }
            catch (UnsupportedEncodingException ex) {
                headerData = httpHeader.toString().getBytes();
            }
            createdHttpResponse = new byte[headerData.length + a_httpData.length];
            System.arraycopy(headerData, 0, createdHttpResponse, 0, headerData.length);
            System.arraycopy(a_httpData, 0, createdHttpResponse, headerData.length, a_httpData.length);
        } else {
            try {
                createdHttpResponse = httpHeader.toString().getBytes("UTF8");
            }
            catch (UnsupportedEncodingException ex) {
                createdHttpResponse = httpHeader.toString().getBytes();
            }
        }
        return createdHttpResponse;
    }
}

