/*
 * Decompiled with CFR 0.152.
 */
package gui;

import gui.dialog.JAPDialog;
import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.TextArea;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class ClipFrame
extends JAPDialog
implements ActionListener,
ItemListener {
    private TextArea m_TextArea;
    private Choice chooser;
    private ClipChoice[] choices;

    public ClipFrame(Component a_owner, String title, boolean open, ClipChoice[] choices) {
        super(a_owner, title);
        this.init(open, choices);
    }

    public ClipFrame(Component a_owner, String title, boolean open) {
        super(a_owner, title);
        this.init(open, null);
    }

    private void init(boolean open, ClipChoice[] c) {
        this.choices = c;
        if (this.choices == null) {
            this.chooser = null;
        } else {
            this.chooser = new Choice();
            for (int i = 0; i < this.choices.length; ++i) {
                this.chooser.add(this.choices[i].name);
            }
            this.getContentPane().add((Component)this.chooser, "North");
            this.chooser.addItemListener(this);
        }
        this.m_TextArea = new TextArea(30, 80);
        this.m_TextArea.setText("");
        this.getContentPane().add((Component)this.m_TextArea, "Center");
        if (open) {
            Button b = new Button("Open");
            b.addActionListener(this);
            b.setActionCommand("open");
            this.getContentPane().add((Component)b, "South");
        }
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                ClipFrame.this.dispose();
            }
        });
        this.pack();
    }

    public void setText(String data) {
        this.m_TextArea.setText(data);
    }

    public String getText() {
        return this.m_TextArea.getText();
    }

    public void actionPerformed(ActionEvent ae) {
        if (ae.getActionCommand().equals("open")) {
            if (this.m_TextArea.getText().equals("")) {
                JAPDialog.showErrorDialog((Component)this.getOwner(), "The Text Area is empty!");
            } else {
                this.dispose();
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        this.setText(this.choices[this.chooser.getSelectedIndex()].text);
    }

    public static class ClipChoice {
        public String name;
        public String text;

        public ClipChoice(String n, String t) {
            this.name = n;
            this.text = t;
        }
    }
}

