/*
 * Decompiled with CFR 0.152.
 */
package jap.forward;

import anon.util.XMLUtil;
import jap.JAPModel;
import jap.forward.JAPRoutingConnectionClass;
import jap.forward.JAPRoutingMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAPRoutingConnectionClassSelector
extends Observable {
    public static final int CONNECTION_CLASS_ISDN64 = 0;
    public static final int CONNECTION_CLASS_ISDN128 = 1;
    public static final int CONNECTION_CLASS_DSL128 = 2;
    public static final int CONNECTION_CLASS_DSL192 = 3;
    public static final int CONNECTION_CLASS_DSL256 = 4;
    public static final int CONNECTION_CLASS_DSL384 = 5;
    public static final int CONNECTION_CLASS_DSL512 = 6;
    public static final int CONNECTION_CLASS_1MBIT = 7;
    public static final int CONNECTION_CLASS_USER = 8;
    private Hashtable m_connectionClasses = new Hashtable();
    private int m_currentConnectionClass;

    public JAPRoutingConnectionClassSelector() {
        this.m_connectionClasses.put(new Integer(0), new JAPRoutingConnectionClass(0, "routingConnectionClassIsdn64", 8000, 50));
        this.m_connectionClasses.put(new Integer(1), new JAPRoutingConnectionClass(1, "routingConnectionClassIsdn128", 16000, 50));
        this.m_connectionClasses.put(new Integer(2), new JAPRoutingConnectionClass(2, "routingConnectionClassDsl128", 16000, 50));
        this.m_connectionClasses.put(new Integer(3), new JAPRoutingConnectionClass(3, "routingConnectionClassDsl192", 24000, 50));
        this.m_connectionClasses.put(new Integer(4), new JAPRoutingConnectionClass(4, "routingConnectionClassDsl256", 32000, 50));
        this.m_connectionClasses.put(new Integer(5), new JAPRoutingConnectionClass(5, "routingConnectionClassDsl384", 48000, 50));
        this.m_connectionClasses.put(new Integer(6), new JAPRoutingConnectionClass(6, "routingConnectionClassDsl512", 64000, 50));
        this.m_connectionClasses.put(new Integer(7), new JAPRoutingConnectionClass(7, "routingConnectionClass1Mbit", 125000, 50));
        this.m_connectionClasses.put(new Integer(8), new JAPRoutingConnectionClass(8, "routingConnectionClassUser", 16000, 50));
        this.m_currentConnectionClass = 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JAPRoutingConnectionClass getCurrentConnectionClass() {
        JAPRoutingConnectionClass returnValue = null;
        Hashtable hashtable = this.m_connectionClasses;
        synchronized (hashtable) {
            returnValue = (JAPRoutingConnectionClass)this.m_connectionClasses.get(new Integer(this.m_currentConnectionClass));
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentConnectionClass(int a_connectionClass) {
        JAPRoutingConnectionClass newConnectionClass = null;
        Hashtable hashtable = this.m_connectionClasses;
        synchronized (hashtable) {
            newConnectionClass = (JAPRoutingConnectionClass)this.m_connectionClasses.get(new Integer(a_connectionClass));
            if (newConnectionClass != null) {
                boolean connectionClassWasChanged = false;
                boolean userOrBandwidthValuesWereChanged = false;
                if (this.m_currentConnectionClass != a_connectionClass) {
                    connectionClassWasChanged = true;
                }
                this.m_currentConnectionClass = a_connectionClass;
                if (JAPModel.getInstance().getRoutingSettings().getBandwidth() != newConnectionClass.getCurrentBandwidth() || JAPModel.getInstance().getRoutingSettings().getAllowedConnections() != newConnectionClass.getMaxSimultaneousConnections()) {
                    userOrBandwidthValuesWereChanged = true;
                }
                JAPModel.getInstance().getRoutingSettings().setBandwidth(newConnectionClass.getCurrentBandwidth());
                JAPModel.getInstance().getRoutingSettings().setAllowedConnections(newConnectionClass.getMaxSimultaneousConnections());
                if (connectionClassWasChanged) {
                    this.setChanged();
                    this.notifyObservers(new JAPRoutingMessage(6));
                }
                if (userOrBandwidthValuesWereChanged) {
                    this.setChanged();
                    this.notifyObservers(new JAPRoutingMessage(7));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getConnectionClasses() {
        Vector returnValue = new Vector();
        Hashtable hashtable = this.m_connectionClasses;
        synchronized (hashtable) {
            Enumeration connectionClasses = this.m_connectionClasses.elements();
            while (connectionClasses.hasMoreElements()) {
                returnValue.addElement(connectionClasses.nextElement());
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getSettingsAsXml(Document a_doc) {
        Element connectionClassSettingsNode = a_doc.createElement("ConnectionClassSettings");
        Element connectionClassesNode = a_doc.createElement("ConnectionClasses");
        Element currentConnectionClassNode = a_doc.createElement("CurrentConnectionClass");
        Hashtable hashtable = this.m_connectionClasses;
        synchronized (hashtable) {
            Enumeration connectionClasses = this.getConnectionClasses().elements();
            while (connectionClasses.hasMoreElements()) {
                connectionClassesNode.appendChild(((JAPRoutingConnectionClass)connectionClasses.nextElement()).getSettingsAsXml(a_doc));
            }
            XMLUtil.setValue((Node)currentConnectionClassNode, this.m_currentConnectionClass);
        }
        connectionClassSettingsNode.appendChild(connectionClassesNode);
        connectionClassSettingsNode.appendChild(currentConnectionClassNode);
        return connectionClassSettingsNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean loadSettingsFromXml(Element a_connectionClassSettingsNode) {
        boolean noError = true;
        Element connectionClassesNode = (Element)XMLUtil.getFirstChildByName(a_connectionClassSettingsNode, "ConnectionClasses");
        if (connectionClassesNode == null) {
            LogHolder.log(3, LogType.MISC, "JAPRoutingConnectionClassSelector: loadSettingsFromXml: Error in XML structure (ConnectionClasses node): Using default connection classes.");
            noError = false;
        } else {
            NodeList connectionClassNodes = connectionClassesNode.getElementsByTagName("ConnectionClass");
            for (int i = 0; i < connectionClassNodes.getLength(); ++i) {
                Element connectionClassNode = (Element)connectionClassNodes.item(i);
                Element classIdentifierNode = (Element)XMLUtil.getFirstChildByName(connectionClassNode, "ClassIdentifier");
                if (classIdentifierNode == null) {
                    LogHolder.log(3, LogType.MISC, "JAPRoutingConnectionClassSelector: loadSettingsFromXml: Error in XML structure (ClassIdentifier node): Skipping this connection class.");
                    noError = false;
                    continue;
                }
                try {
                    int classIdentifier = Integer.parseInt(XMLUtil.parseValue((Node)classIdentifierNode, "NOT_A_NUMBER"));
                    JAPRoutingConnectionClass currentConnectionClass = null;
                    Hashtable hashtable = this.m_connectionClasses;
                    synchronized (hashtable) {
                        currentConnectionClass = (JAPRoutingConnectionClass)this.m_connectionClasses.get(new Integer(classIdentifier));
                    }
                    if (currentConnectionClass != null) {
                        noError = currentConnectionClass.loadSettingsFromXml(connectionClassNode);
                        continue;
                    }
                    LogHolder.log(3, LogType.MISC, "JAPRoutingConnectionClassSelector: loadSettingsFromXml: The connection class " + Integer.toString(classIdentifier) + " is not known in the system. Skipping the entry.");
                    noError = false;
                    continue;
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.MISC, "JAPRoutingConnectionClassSelector: loadSettingsFromXml: Error while loading settings for a connection class. Skipping this class. (" + e.toString() + ")");
                    noError = false;
                }
            }
        }
        Element currentConnectionClassNode = (Element)XMLUtil.getFirstChildByName(a_connectionClassSettingsNode, "CurrentConnectionClass");
        if (currentConnectionClassNode == null) {
            LogHolder.log(3, LogType.MISC, "JAPRoutingConnectionClassSelector: loadSettingsFromXml: Error in XML structure (CurrentConnectionClass node): Using default value.");
            noError = false;
        } else {
            try {
                int currentConnectionClass = Integer.parseInt(XMLUtil.parseValue((Node)currentConnectionClassNode, "NOT_A_NUMBER"));
                Hashtable hashtable = this.m_connectionClasses;
                synchronized (hashtable) {
                    if (this.m_connectionClasses.get(new Integer(currentConnectionClass)) != null) {
                        this.setCurrentConnectionClass(currentConnectionClass);
                    } else {
                        this.setCurrentConnectionClass(this.m_currentConnectionClass);
                        LogHolder.log(3, LogType.MISC, "JAPRoutingConnectionClassSelector: loadSettingsFromXml: The specified current connection class doesn't exist: Using default value.");
                        noError = false;
                    }
                }
            }
            catch (Exception e) {
                this.setCurrentConnectionClass(this.m_currentConnectionClass);
                LogHolder.log(3, LogType.MISC, "JAPRoutingConnectionClassSelector: loadSettingsFromXml: Invalid value of the current connection class setting: Using default value. (" + e.toString() + ")");
                noError = false;
            }
        }
        return noError;
    }
}

