/*
 * Decompiled with CFR 0.152.
 */
package jap.forward;

import anon.forward.server.ServerSocketPropagandist;
import anon.util.JAPMessages;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;

public class JAPRoutingInfoServiceRegistrationTableModel
extends AbstractTableModel
implements Observer {
    private static final long serialVersionUID = 1L;
    private Vector m_propagandaInstances = new Vector();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePropagandaInstancesList(Vector a_newPropagandaInstancesList) {
        Enumeration propagandists = a_newPropagandaInstancesList.elements();
        Vector vector = this.m_propagandaInstances;
        synchronized (vector) {
            int addedRows = 0;
            while (propagandists.hasMoreElements()) {
                ServerSocketPropagandist currentPropagandist = (ServerSocketPropagandist)propagandists.nextElement();
                if (this.m_propagandaInstances.contains(currentPropagandist)) continue;
                currentPropagandist.addObserver(this);
                if (currentPropagandist.getCurrentState() != 3) {
                    this.m_propagandaInstances.addElement(currentPropagandist);
                    ++addedRows;
                    continue;
                }
                currentPropagandist.deleteObserver(this);
            }
            if (addedRows > 0) {
                this.fireTableRowsInserted(this.m_propagandaInstances.size() - addedRows, this.m_propagandaInstances.size() - 1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable a_notifier, Object a_message) {
        Vector vector = this.m_propagandaInstances;
        synchronized (vector) {
            if (this.m_propagandaInstances.contains(a_notifier)) {
                if (((ServerSocketPropagandist)a_notifier).getCurrentState() == 3) {
                    a_notifier.deleteObserver(this);
                    int row = this.m_propagandaInstances.indexOf(a_notifier);
                    this.m_propagandaInstances.removeElement(a_notifier);
                    this.fireTableRowsDeleted(row, row);
                } else {
                    int row = this.m_propagandaInstances.indexOf(a_notifier);
                    this.fireTableRowsUpdated(row, row);
                }
            }
        }
    }

    public int getRowCount() {
        return this.m_propagandaInstances.size();
    }

    public int getColumnCount() {
        return 2;
    }

    public String getColumnName(int a_column) {
        String returnValue = null;
        if (a_column == 0) {
            returnValue = JAPMessages.getString("routingInfoServiceRegistrationTableColumn0Name");
        }
        if (a_column == 1) {
            returnValue = JAPMessages.getString("routingInfoServiceRegistrationTableColumn1Name");
        }
        return returnValue;
    }

    public Object getValueAt(int a_row, int a_column) {
        String returnValue = null;
        ServerSocketPropagandist selectedPropagandist = (ServerSocketPropagandist)this.m_propagandaInstances.elementAt(a_row);
        if (a_column == 0) {
            returnValue = selectedPropagandist.getInfoService().getName();
        }
        if (a_column == 1) {
            if (selectedPropagandist.getCurrentState() == 0) {
                returnValue = JAPMessages.getString("routingInfoServiceRegistrationTableStateRegistrated");
            }
            if (selectedPropagandist.getCurrentState() == 1) {
                returnValue = JAPMessages.getString("routingInfoServiceRegistrationTableStateConnecting");
            }
            if (selectedPropagandist.getCurrentState() == 2) {
                returnValue = JAPMessages.getString("routingInfoServiceRegistrationTableStateReconnecting");
            }
            if (selectedPropagandist.getCurrentState() == 3) {
                returnValue = JAPMessages.getString("routingInfoServiceRegistrationTableStateHalted");
            }
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearPropagandaInstancesTable() {
        Vector vector = this.m_propagandaInstances;
        synchronized (vector) {
            int propagandaInstancesCount = this.m_propagandaInstances.size();
            if (propagandaInstancesCount > 0) {
                Enumeration propagandaInstances = this.m_propagandaInstances.elements();
                while (propagandaInstances.hasMoreElements()) {
                    ServerSocketPropagandist currentPropagandaInstance = (ServerSocketPropagandist)propagandaInstances.nextElement();
                    currentPropagandaInstance.deleteObserver(this);
                }
                this.m_propagandaInstances.removeAllElements();
                this.fireTableRowsDeleted(0, propagandaInstancesCount - 1);
            }
        }
    }
}

