/*
 * Decompiled with CFR 0.152.
 */
package jap.forward;

import anon.forward.server.ServerSocketPropagandist;
import anon.infoservice.Database;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.InfoServiceHolder;
import anon.util.XMLUtil;
import jap.JAPModel;
import jap.forward.JAPRoutingMessage;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JAPRoutingRegistrationInfoServices
extends Observable
implements Observer,
Runnable {
    private static final long INFOSERVICELIST_UPDATE_INTERVAL = 600000L;
    Hashtable m_registrationInfoServices = new Hashtable();
    boolean m_registerAtAllAvailableInfoServices = true;
    boolean m_propagandaIsRunning = false;
    Vector m_runningInfoServiceRegistrations = new Vector();
    Thread m_updateInfoServiceListThread = null;
    static /* synthetic */ Class class$anon$infoservice$InfoServiceDBEntry;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void update(Observable a_notifier, Object a_message) {
        block23: {
            if (a_notifier == JAPModel.getInstance().getRoutingSettings()) {
                try {
                    Vector vector;
                    JAPRoutingRegistrationInfoServices jAPRoutingRegistrationInfoServices;
                    if (((JAPRoutingMessage)a_message).getMessageCode() == 2) {
                        jAPRoutingRegistrationInfoServices = this;
                        synchronized (jAPRoutingRegistrationInfoServices) {
                            vector = this.m_runningInfoServiceRegistrations;
                            synchronized (vector) {
                                Enumeration startedPropagandists = ((Vector)((JAPRoutingMessage)a_message).getMessageData()).elements();
                                while (startedPropagandists.hasMoreElements()) {
                                    InfoServiceDBEntry currentInfoService = ((ServerSocketPropagandist)startedPropagandists.nextElement()).getInfoService();
                                    if (this.m_runningInfoServiceRegistrations.contains(currentInfoService.getId())) continue;
                                    this.m_runningInfoServiceRegistrations.addElement(currentInfoService.getId());
                                }
                            }
                        }
                    }
                    if (((JAPRoutingMessage)a_message).getMessageCode() == 4) {
                        jAPRoutingRegistrationInfoServices = this;
                        synchronized (jAPRoutingRegistrationInfoServices) {
                            this.m_propagandaIsRunning = true;
                            if (this.m_registerAtAllAvailableInfoServices) {
                                this.startInfoServiceListUpdateThread();
                            }
                        }
                    }
                    if (((JAPRoutingMessage)a_message).getMessageCode() != 5) break block23;
                    jAPRoutingRegistrationInfoServices = this;
                    synchronized (jAPRoutingRegistrationInfoServices) {
                        if (this.m_registerAtAllAvailableInfoServices) {
                            this.stopInfoServiceListUpdateThread();
                        }
                        this.m_propagandaIsRunning = false;
                        vector = this.m_runningInfoServiceRegistrations;
                        synchronized (vector) {
                            this.m_runningInfoServiceRegistrations.removeAllElements();
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegistrationInfoServices(Vector a_infoServices) {
        Object object = this.m_registrationInfoServices;
        synchronized (object) {
            this.m_registrationInfoServices.clear();
            Enumeration newRegistrationInfoServices = a_infoServices.elements();
            while (newRegistrationInfoServices.hasMoreElements()) {
                InfoServiceDBEntry currentInfoService = (InfoServiceDBEntry)newRegistrationInfoServices.nextElement();
                if (!currentInfoService.hasPrimaryForwarderList()) continue;
                this.m_registrationInfoServices.put(currentInfoService.getId(), currentInfoService);
            }
        }
        object = this;
        synchronized (object) {
            if (!this.m_registerAtAllAvailableInfoServices) {
                Vector vector = this.m_runningInfoServiceRegistrations;
                synchronized (vector) {
                    Enumeration registrationInfoServices = this.m_registrationInfoServices.elements();
                    while (registrationInfoServices.hasMoreElements()) {
                        InfoServiceDBEntry currentInfoService = (InfoServiceDBEntry)registrationInfoServices.nextElement();
                        if (this.m_runningInfoServiceRegistrations.contains(currentInfoService.getId())) continue;
                        JAPModel.getInstance().getRoutingSettings().addPropagandaInstance(currentInfoService);
                        if (!this.m_propagandaIsRunning) continue;
                        this.m_runningInfoServiceRegistrations.addElement(currentInfoService.getId());
                    }
                }
            }
            this.setChanged();
            this.notifyObservers(new JAPRoutingMessage(12));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addToRegistrationInfoServices(InfoServiceDBEntry a_infoService) {
        if (a_infoService != null && a_infoService.hasPrimaryForwarderList()) {
            Object object = this.m_registrationInfoServices;
            synchronized (object) {
                this.m_registrationInfoServices.put(a_infoService.getId(), a_infoService);
            }
            object = this;
            synchronized (object) {
                if (!this.m_registerAtAllAvailableInfoServices) {
                    Vector vector = this.m_runningInfoServiceRegistrations;
                    synchronized (vector) {
                        if (!this.m_runningInfoServiceRegistrations.contains(a_infoService.getId())) {
                            JAPModel.getInstance().getRoutingSettings().addPropagandaInstance(a_infoService);
                            if (this.m_propagandaIsRunning) {
                                this.m_runningInfoServiceRegistrations.addElement(a_infoService.getId());
                            }
                        }
                    }
                }
                this.setChanged();
                this.notifyObservers(new JAPRoutingMessage(12));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromRegistrationInfoServices(String a_infoServiceId) {
        if (a_infoServiceId != null) {
            boolean infoServiceRemoved = false;
            Object object = this.m_registrationInfoServices;
            synchronized (object) {
                if (this.m_registrationInfoServices.remove(a_infoServiceId) != null) {
                    infoServiceRemoved = true;
                }
            }
            if (infoServiceRemoved) {
                object = this;
                synchronized (object) {
                    this.setChanged();
                    this.notifyObservers(new JAPRoutingMessage(12));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRegistrationInfoServices() {
        Vector resultValue = new Vector();
        Hashtable hashtable = this.m_registrationInfoServices;
        synchronized (hashtable) {
            Enumeration registrationInfoServices = this.m_registrationInfoServices.elements();
            while (registrationInfoServices.hasMoreElements()) {
                resultValue.addElement(registrationInfoServices.nextElement());
            }
        }
        return resultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector getRegistrationInfoServicesForStartup() {
        Vector resultValue = new Vector();
        JAPRoutingRegistrationInfoServices jAPRoutingRegistrationInfoServices = this;
        synchronized (jAPRoutingRegistrationInfoServices) {
            resultValue = this.m_registerAtAllAvailableInfoServices ? InfoServiceHolder.getInstance().getInfoservicesWithForwarderList() : this.getRegistrationInfoServices();
        }
        return resultValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRegisterAtAllAvailableInfoServices(boolean a_registerAtAllAvailableInfoServices) {
        JAPRoutingRegistrationInfoServices jAPRoutingRegistrationInfoServices = this;
        synchronized (jAPRoutingRegistrationInfoServices) {
            if (this.m_registerAtAllAvailableInfoServices != a_registerAtAllAvailableInfoServices) {
                this.m_registerAtAllAvailableInfoServices = a_registerAtAllAvailableInfoServices;
                if (this.m_propagandaIsRunning) {
                    if (a_registerAtAllAvailableInfoServices) {
                        this.startInfoServiceListUpdateThread();
                    } else {
                        this.stopInfoServiceListUpdateThread();
                    }
                }
                this.setChanged();
                this.notifyObservers(new JAPRoutingMessage(11));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean getRegisterAtAllAvailableInfoServices() {
        boolean returnValue = false;
        JAPRoutingRegistrationInfoServices jAPRoutingRegistrationInfoServices = this;
        synchronized (jAPRoutingRegistrationInfoServices) {
            returnValue = this.m_registerAtAllAvailableInfoServices;
        }
        return returnValue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Element getSettingsAsXml(Document a_doc) {
        Element infoServiceRegistrationSettingsNode = a_doc.createElement("InfoServiceRegistrationSettings");
        Element useAllPrimaryInfoServicesNode = a_doc.createElement("UseAllPrimaryInfoServices");
        Element registrationInfoServicesNode = a_doc.createElement("RegistrationInfoServices");
        JAPRoutingRegistrationInfoServices jAPRoutingRegistrationInfoServices = this;
        synchronized (jAPRoutingRegistrationInfoServices) {
            XMLUtil.setValue((Node)useAllPrimaryInfoServicesNode, this.getRegisterAtAllAvailableInfoServices());
            Enumeration registrationInfoServices = this.getRegistrationInfoServices().elements();
            while (registrationInfoServices.hasMoreElements()) {
                registrationInfoServicesNode.appendChild(((InfoServiceDBEntry)registrationInfoServices.nextElement()).toXmlElement(a_doc));
            }
        }
        infoServiceRegistrationSettingsNode.appendChild(useAllPrimaryInfoServicesNode);
        infoServiceRegistrationSettingsNode.appendChild(registrationInfoServicesNode);
        return infoServiceRegistrationSettingsNode;
    }

    public boolean loadSettingsFromXml(Element a_infoServiceRegistrationSettingsNode) {
        boolean noError = true;
        Element useAllPrimaryInfoServicesNode = (Element)XMLUtil.getFirstChildByName(a_infoServiceRegistrationSettingsNode, "UseAllPrimaryInfoServices");
        if (useAllPrimaryInfoServicesNode == null) {
            LogHolder.log(3, LogType.MISC, "JAPRoutingRegistrationInfoServices: loadSettingsFromXml: Error in XML structure (UseAllPrimaryInfoServices node): Using default setting.");
            noError = false;
        } else {
            this.setRegisterAtAllAvailableInfoServices(XMLUtil.parseValue((Node)useAllPrimaryInfoServicesNode, this.getRegisterAtAllAvailableInfoServices()));
        }
        Element registrationInfoServicesNode = (Element)XMLUtil.getFirstChildByName(a_infoServiceRegistrationSettingsNode, "RegistrationInfoServices");
        if (registrationInfoServicesNode == null) {
            LogHolder.log(3, LogType.MISC, "JAPRoutingRegistrationInfoServices: loadSettingsFromXml: Error in XML structure (RegistrationInfoServices node): Skip loading of registration infoservices.");
            noError = false;
        } else {
            NodeList infoServiceNodes = registrationInfoServicesNode.getElementsByTagName("InfoService");
            Vector<InfoServiceDBEntry> registrationInfoServices = new Vector<InfoServiceDBEntry>();
            for (int i = 0; i < infoServiceNodes.getLength(); ++i) {
                Element infoServiceNode = (Element)infoServiceNodes.item(i);
                try {
                    InfoServiceDBEntry currentInfoService = new InfoServiceDBEntry(infoServiceNode, Long.MAX_VALUE);
                    InfoServiceDBEntry updatedInfoService = (InfoServiceDBEntry)Database.getInstance(class$anon$infoservice$InfoServiceDBEntry == null ? JAPRoutingRegistrationInfoServices.class$("anon.infoservice.InfoServiceDBEntry") : class$anon$infoservice$InfoServiceDBEntry).getEntryById(currentInfoService.getId());
                    if (updatedInfoService != null) {
                        currentInfoService = updatedInfoService;
                    }
                    if (currentInfoService.hasPrimaryForwarderList()) {
                        registrationInfoServices.addElement(currentInfoService);
                        continue;
                    }
                    LogHolder.log(3, LogType.MISC, "JAPRoutingRegistrationInfoServices: loadSettingsFromXml: Error while loading one registration InfoService: The InfoService " + currentInfoService.getName() + " has no primary forwarder list: Skipping this infoservice.");
                    noError = false;
                    continue;
                }
                catch (Exception e) {
                    LogHolder.log(3, LogType.MISC, "JAPRoutingRegistrationInfoServices: loadSettingsFromXml: Error while loading one registration InfoService: Skipping this infoservice (" + e.toString() + ").");
                    noError = false;
                }
            }
            this.setRegistrationInfoServices(registrationInfoServices);
        }
        return noError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean stopThread = false;
        while (!stopThread) {
            Hashtable runningInfoServicesList;
            Thread thread = this.m_updateInfoServiceListThread;
            synchronized (thread) {
                stopThread = Thread.interrupted();
                if (!stopThread) {
                    try {
                        this.m_updateInfoServiceListThread.wait(600000L);
                    }
                    catch (Exception e) {
                        stopThread = true;
                    }
                }
            }
            if (stopThread || (runningInfoServicesList = InfoServiceHolder.getInstance().getInfoServices()) == null) continue;
            Enumeration runningInfoServices = runningInfoServicesList.elements();
            while (runningInfoServices.hasMoreElements()) {
                InfoServiceDBEntry currentInfoService = (InfoServiceDBEntry)runningInfoServices.nextElement();
                if (!currentInfoService.hasPrimaryForwarderList()) continue;
                Vector vector = this.m_runningInfoServiceRegistrations;
                synchronized (vector) {
                    if (!this.m_runningInfoServiceRegistrations.contains(currentInfoService.getId())) {
                        JAPModel.getInstance().getRoutingSettings().addPropagandaInstance(currentInfoService);
                        this.m_runningInfoServiceRegistrations.addElement(currentInfoService.getId());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startInfoServiceListUpdateThread() {
        JAPRoutingRegistrationInfoServices jAPRoutingRegistrationInfoServices = this;
        synchronized (jAPRoutingRegistrationInfoServices) {
            if (this.m_updateInfoServiceListThread == null) {
                LogHolder.log(6, LogType.MISC, "JAPRoutingRegistrationInfoServices: startInfoServiceListUpdateThread: The infoservice registration management thread is started.");
                this.m_updateInfoServiceListThread = new Thread(this);
                this.m_updateInfoServiceListThread.setDaemon(true);
                this.m_updateInfoServiceListThread.start();
            } else {
                LogHolder.log(6, LogType.MISC, "JAPRoutingRegistrationInfoServices: startInfoServiceListUpdateThread: The infoservice registration management thread was already started.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopInfoServiceListUpdateThread() {
        LogHolder.log(6, LogType.MISC, "JAPRoutingRegistrationInfoServices: stopInfoServiceListUpdateThread: Shutdown the infoservice registration management thread...");
        JAPRoutingRegistrationInfoServices jAPRoutingRegistrationInfoServices = this;
        synchronized (jAPRoutingRegistrationInfoServices) {
            if (this.m_updateInfoServiceListThread != null) {
                Thread thread = this.m_updateInfoServiceListThread;
                synchronized (thread) {
                    this.m_updateInfoServiceListThread.interrupt();
                }
                try {
                    this.m_updateInfoServiceListThread.join();
                    LogHolder.log(6, LogType.MISC, "JAPRoutingRegistrationInfoServices: stopInfoServiceListUpdateThread: Infoservice registration management thread halted.");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.m_updateInfoServiceListThread = null;
            } else {
                LogHolder.log(6, LogType.MISC, "JAPRoutingRegistrationInfoServices: stopInfoServiceListUpdateThread: Infoservice registration management thread was not running.");
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

