/*
 * Decompiled with CFR 0.152.
 */
package jap.pay;

import HTTPClient.ForbiddenIOException;
import anon.client.TrustModel;
import anon.crypto.AsymmetricCryptoKeyPair;
import anon.infoservice.Database;
import anon.pay.PayAccount;
import anon.pay.PayAccountsFile;
import anon.pay.PaymentInstanceDBEntry;
import anon.util.BooleanVariable;
import anon.util.IProgressCapsule;
import anon.util.IReturnRunnable;
import anon.util.JAPMessages;
import gui.dialog.DialogContentPane;
import gui.dialog.DialogContentPaneOptions;
import gui.dialog.JAPDialog;
import gui.dialog.SimpleWizardContentPane;
import gui.dialog.WorkerContentPane;
import jap.JAPController;
import jap.JAPModel;
import jap.gui.LinkRegistrator;
import jap.pay.PaymentInstancePanel;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import logging.LogHolder;
import logging.LogType;

public class AccountCreator {
    private static final String MSG_COUPON_INCOMPLETE = (class$jap$pay$AccountCreator == null ? (class$jap$pay$AccountCreator = AccountCreator.class$("jap.pay.AccountCreator")) : class$jap$pay$AccountCreator).getName() + ".couponIncomplete";
    private static final String MSG_COUPON_NULL = (class$jap$pay$AccountCreator == null ? (class$jap$pay$AccountCreator = AccountCreator.class$("jap.pay.AccountCreator")) : class$jap$pay$AccountCreator).getName() + ".couponNull";
    private static final String MSG_ACCOUNT_OVERVIEW = (class$jap$pay$AccountCreator == null ? (class$jap$pay$AccountCreator = AccountCreator.class$("jap.pay.AccountCreator")) : class$jap$pay$AccountCreator).getName() + ".accountOverview";
    private static final String MSG_LOOKING_FOR_PAYMENT_INSTANCES = (class$jap$pay$AccountCreator == null ? (class$jap$pay$AccountCreator = AccountCreator.class$("jap.pay.AccountCreator")) : class$jap$pay$AccountCreator).getName() + ".paneLookingForPIs";
    private static final String MSG_PAYMENT_SELECTION = (class$jap$pay$AccountCreator == null ? (class$jap$pay$AccountCreator = AccountCreator.class$("jap.pay.AccountCreator")) : class$jap$pay$AccountCreator).getName() + ".paymentSelection";
    private static final String MSG_ALLOW_NON_ANONYMOUS_INFOSERVICE = (class$jap$pay$AccountCreator == null ? (class$jap$pay$AccountCreator = AccountCreator.class$("jap.pay.AccountCreator")) : class$jap$pay$AccountCreator).getName() + ".allowNonAnonymousInfoService";
    public static final String MSG_WAITING_FOR_TRANSACTION = (class$jap$pay$AccountCreator == null ? (class$jap$pay$AccountCreator = AccountCreator.class$("jap.pay.AccountCreator")) : class$jap$pay$AccountCreator).getName() + ".waitingForTransaction";
    private static final String MSG_TRANSACTION_FINISHED = (class$jap$pay$AccountCreator == null ? (class$jap$pay$AccountCreator = AccountCreator.class$("jap.pay.AccountCreator")) : class$jap$pay$AccountCreator).getName() + ".finishedTransaction";
    private static final String MSG_TRANSACTION_FINISHED_TEST = (class$jap$pay$AccountCreator == null ? (class$jap$pay$AccountCreator = AccountCreator.class$("jap.pay.AccountCreator")) : class$jap$pay$AccountCreator).getName() + ".finishedTransactionTest";
    private static final String MSG_COUPON_REDEEMED = (class$jap$pay$AccountCreator == null ? (class$jap$pay$AccountCreator = AccountCreator.class$("jap.pay.AccountCreator")) : class$jap$pay$AccountCreator).getName() + ".redeemedCoupon";
    private static final String MSG_WAITING_FOR_PAYMENT = (class$jap$pay$AccountCreator == null ? (class$jap$pay$AccountCreator = AccountCreator.class$("jap.pay.AccountCreator")) : class$jap$pay$AccountCreator).getName() + ".waitingForPayment";
    public static final int PAYMENT_OPTIONAL = 0;
    public static final int PAYMENT_RECOMMENDED = 1;
    public static final int PAYMENT_FORCED = 2;
    static /* synthetic */ Class class$jap$pay$AccountCreator;
    static /* synthetic */ Class class$anon$pay$PaymentInstanceDBEntry;
    static /* synthetic */ Class class$jap$pay$AccountCreator$RunAccountCreator;

    private AccountCreator() {
    }

    public static Vector getCurrentPaymentInstances() {
        PaymentInstanceDBEntry pi = (PaymentInstanceDBEntry)Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = AccountCreator.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getEntryById(JAPController.getInstance().getCurrentMixCascade().getPIID());
        Vector vecEntries = PayAccountsFile.getInstance().getPaymentInstances(pi == null || !pi.isTest());
        return vecEntries;
    }

    private static boolean isPaymentRecommended() {
        return true;
    }

    public static boolean checkValidAccount() {
        return AccountCreator.checkValidAccount(null);
    }

    public static boolean checkValidAccount(String a_strPIID) {
        if (a_strPIID != null) {
            return PayAccountsFile.getInstance().getChargedAccount(a_strPIID) != null;
        }
        Vector vecPIs = AccountCreator.getCurrentPaymentInstances();
        boolean bValidAccount = false;
        String strPIID = JAPController.getInstance().getCurrentMixCascade().getPIID();
        if (strPIID != null && strPIID.trim().length() == 0) {
            strPIID = null;
        }
        for (int i = 0; i < vecPIs.size(); ++i) {
            PaymentInstanceDBEntry pi = (PaymentInstanceDBEntry)vecPIs.elementAt(i);
            if ((strPIID != null || pi.isTest()) && (strPIID == null || !strPIID.equals(pi.getId())) || PayAccountsFile.getInstance().getChargedAccount(pi.getId()) == null) continue;
            bValidAccount = true;
            break;
        }
        return bValidAccount;
    }

    public static DialogContentPane createAccountPanes(JAPDialog a_dialog, DialogContentPane.Layout a_layout, DialogContentPane a_previousContentPane, final String a_strMessage, final LinkRegistrator a_registrator, final IProgressCapsule a_resettable, final int a_iPaymentOption, final BooleanVariable a_bStartClicked) {
        final Hashtable hashPIs = new Hashtable();
        final Vector vecKey = new Vector();
        final RunAccountCreator runCheckCoupon = new RunAccountCreator(hashPIs, vecKey);
        Runnable runFindPaymentInstances = new Runnable(){

            public void run() {
                Thread tRun = new Thread(new Runnable(){

                    public void run() {
                        JAPController.getInstance().updatePaymentInstances(false);
                    }
                });
                tRun.start();
                try {
                    tRun.join(25000L);
                }
                catch (InterruptedException e) {
                    LogHolder.log(3, LogType.GUI, e);
                }
            }
        };
        WorkerContentPane paneFindPaymentInstances = new WorkerContentPane(a_dialog, JAPMessages.getString(MSG_LOOKING_FOR_PAYMENT_INSTANCES), a_layout, a_previousContentPane, runFindPaymentInstances){

            public boolean isSkippedAsPreviousContentPane() {
                return a_iPaymentOption != 2 || this.isSkipped();
            }

            private boolean isSkipped() {
                return a_iPaymentOption == 0 && !AccountCreator.isPaymentRecommended() || Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = AccountCreator.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getNumberOfEntries() > 0;
            }

            public boolean isSkippedAsNextContentPane() {
                return this.isSkipped();
            }
        };
        paneFindPaymentInstances.setDefaultButtonOperation(8 | (a_iPaymentOption == 2 ? 32768 : 32) | 0x100);
        final IReturnRunnable runCreateAccountKeys = new IReturnRunnable(){
            private String strError;

            public void run() {
                this.strError = null;
                if (vecKey.size() > 0) {
                    return;
                }
                AsymmetricCryptoKeyPair keyPair = PayAccountsFile.getInstance().createAccountKeyPair();
                if (keyPair != null) {
                    vecKey.addElement(keyPair);
                } else {
                    this.strError = JAPMessages.getString(PayAccountsFile.MSG_CREATING_KEY_PAIR_ERROR);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object getValue() {
                Vector vector = vecKey;
                synchronized (vector) {
                    if (vecKey.size() > 0) {
                        return vecKey.elementAt(0);
                    }
                    return this.strError;
                }
            }
        };
        SimpleWizardContentPane paneCheckPIExists = new SimpleWizardContentPane(a_dialog, JAPMessages.getString(PayAccountsFile.MSG_NO_PAYMENT_INSTANCE), a_layout, paneFindPaymentInstances){
            private JCheckBox m_jbInfoService;

            public DialogContentPane.CheckError checkUpdate() {
                JAPController.getInstance().forceAnonymityTestRedirect(false);
                String strMessage = "<b><font color=\"red\">" + JAPMessages.getString(PayAccountsFile.MSG_NO_PAYMENT_INSTANCE) + "</font></b>";
                this.getContentPane().removeAll();
                if (JAPModel.getInstance().getInfoServiceAnonymousConnectionSetting() == 1 && !JAPController.getInstance().isAnonConnected()) {
                    strMessage = strMessage + "<br/><br/>" + JAPMessages.getString(PayAccountsFile.MSG_ERROR_ALLOW_NON_ANONYMOUS_OR_CONNECT_INFOSERVICE);
                    this.m_jbInfoService = new JCheckBox(JAPMessages.getString(MSG_ALLOW_NON_ANONYMOUS_INFOSERVICE));
                    this.getContentPane().add(this.m_jbInfoService);
                } else {
                    this.m_jbInfoService = null;
                }
                this.setText(strMessage);
                return null;
            }

            public DialogContentPane.CheckError checkNo() {
                return this.checkYesOK();
            }

            public DialogContentPane.CheckError checkYesOK() {
                if (this.m_jbInfoService != null && this.m_jbInfoService.isSelected()) {
                    JAPModel.getInstance().setInfoServiceAnonymousConnectionSetting(0);
                }
                return null;
            }

            private boolean isSkipped() {
                return a_iPaymentOption != 2 || Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = AccountCreator.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getNumberOfEntries() > 0;
            }

            public boolean isSkippedAsNextContentPane() {
                return this.isSkipped();
            }

            public boolean isSkippedAsPreviousContentPane() {
                return this.isSkipped();
            }

            public boolean isMoveBackAllowed() {
                return a_iPaymentOption != 2;
            }
        };
        paneCheckPIExists.setDefaultButtonOperation(0x80 | (a_iPaymentOption == 2 ? 32768 : 65536) | 0x100);
        final SimpleWizardContentPane panePaymentSelection = new SimpleWizardContentPane(a_dialog, (a_strMessage != null ? a_strMessage + " " : "") + JAPMessages.getString(MSG_PAYMENT_SELECTION), a_layout, new DialogContentPaneOptions("premium", (DialogContentPane)paneCheckPIExists)){

            public boolean isSkippedAsNextContentPane() {
                if (a_iPaymentOption == 2) {
                    Vector vecEntries = AccountCreator.getPaymentInstances(a_iPaymentOption);
                    for (int i = 0; i < vecEntries.size(); ++i) {
                        if (((PaymentInstanceDBEntry)vecEntries.elementAt(i)).getWebshopURL() != null) continue;
                        return true;
                    }
                } else if (a_iPaymentOption == 1 && a_resettable.getStatus() == 0) {
                    return true;
                }
                return false;
            }

            public boolean isSkippedAsPreviousContentPane() {
                boolean bHasCode = false;
                Enumeration enumPIs = hashPIs.elements();
                while (enumPIs.hasMoreElements()) {
                    if (((PaymentInstancePanel)enumPIs.nextElement()).getCode() == null) continue;
                    bHasCode = true;
                    break;
                }
                return this.isSkippedAsNextContentPane() || a_iPaymentOption == 1 && !bHasCode || a_iPaymentOption == 2 && Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = AccountCreator.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getNumberOfEntries() == 0;
            }

            public DialogContentPane.CheckError checkUpdate() {
                return AccountCreator.showContents(this, a_resettable, a_iPaymentOption, hashPIs, a_strMessage, a_registrator, false);
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public DialogContentPane.CheckError checkYesOK() {
                DialogContentPane.CheckError error = null;
                boolean bCodeEntered = false;
                if (hashPIs.size() == 0) {
                    return null;
                }
                Enumeration enumPIs = hashPIs.elements();
                while (enumPIs.hasMoreElements()) {
                    PaymentInstancePanel panelPI = (PaymentInstancePanel)enumPIs.nextElement();
                    if (bCodeEntered) {
                        panelPI.clearCode();
                        continue;
                    }
                    if (!panelPI.isComplete()) {
                        error = new DialogContentPane.CheckError(JAPMessages.getString(MSG_COUPON_INCOMPLETE));
                    } else if (a_iPaymentOption == 2 && panelPI.getCode() == null) {
                        error = new DialogContentPane.CheckError(JAPMessages.getString(MSG_COUPON_NULL));
                    }
                    if (panelPI.getCode() == null) continue;
                    bCodeEntered = true;
                }
                if (error == null) {
                    BooleanVariable booleanVariable = a_bStartClicked;
                    synchronized (booleanVariable) {
                        a_bStartClicked.set(true);
                    }
                }
                this.setDefaultButtonOperation((a_iPaymentOption == 1 && !bCodeEntered ? 128 : 8) | (a_iPaymentOption == 2 ? 32768 : 65536) | 0x100);
                return error;
            }
        };
        panePaymentSelection.setDefaultButtonOperation(8 | (a_iPaymentOption == 2 ? 32768 : 65536) | 0x100);
        AccountCreator.showContents(panePaymentSelection, a_resettable, a_iPaymentOption, hashPIs, a_strMessage, a_registrator, true);
        WorkerContentPane paneCreateAccountKeys = new WorkerContentPane(a_dialog, JAPMessages.getString(PayAccountsFile.MSG_CREATING_KEY_PAIR), a_layout, panePaymentSelection, runCreateAccountKeys){

            public DialogContentPane.CheckError checkUpdate() {
                JAPController.getInstance().blockDirectProxy(true);
                return super.checkUpdate();
            }

            public boolean isSkippedAsNextContentPane() {
                if (panePaymentSelection.isSkippedAsNextContentPane()) {
                    return true;
                }
                if (vecKey.size() > 0) {
                    return true;
                }
                Enumeration enumPIs = hashPIs.elements();
                while (enumPIs.hasMoreElements()) {
                    PaymentInstancePanel panelPI = (PaymentInstancePanel)enumPIs.nextElement();
                    if (!panelPI.isComplete() || panelPI.getCode() == null) continue;
                    return false;
                }
                return true;
            }

            public boolean hideButtonCancel() {
                return true;
            }
        };
        paneCreateAccountKeys.setDefaultButtonOperation(8 | (a_iPaymentOption == 2 ? 32768 : 512) | 0x100);
        final WorkerContentPane paneCheckCoupon = new WorkerContentPane(a_dialog, JAPMessages.getString(PayAccountsFile.MSG_VERIFYING_COUPON), a_layout, paneCreateAccountKeys, runCheckCoupon, runCheckCoupon){

            public boolean isSkippedAsNextContentPane() {
                if (panePaymentSelection.isSkippedAsNextContentPane()) {
                    return true;
                }
                if (runCreateAccountKeys.getValue() == null) {
                    return true;
                }
                Enumeration enumPIs = hashPIs.elements();
                while (enumPIs.hasMoreElements()) {
                    PaymentInstancePanel panelPI = (PaymentInstancePanel)enumPIs.nextElement();
                    if (!panelPI.isComplete() || panelPI.getCode() == null) continue;
                    return false;
                }
                return true;
            }

            public DialogContentPane.CheckError checkUpdate() {
                if (runCreateAccountKeys.getValue() != null && runCreateAccountKeys.getValue() instanceof String) {
                    return new DialogContentPane.CheckError((String)runCreateAccountKeys.getValue());
                }
                JAPController.getInstance().blockDirectProxy(true);
                return super.checkUpdate();
            }

            public Object getValue() {
                return runCheckCoupon.getError();
            }

            public boolean isMoveBackAllowed() {
                return a_iPaymentOption != 2;
            }
        };
        paneCheckCoupon.setDefaultButtonOperation(8 | (a_iPaymentOption == 2 ? 32768 : 512) | 0x100);
        SimpleWizardContentPane paneFinished = new SimpleWizardContentPane(a_dialog, "Test", a_layout, new DialogContentPaneOptions("premium", (DialogContentPane)paneCheckCoupon)){

            public boolean hideButtonCancel() {
                return !this.hasNextContentPane();
            }

            public DialogContentPane.CheckError checkUpdate() {
                if (paneCheckCoupon.getValue() != null && paneCheckCoupon.getValue() instanceof String) {
                    String strError = paneCheckCoupon.getValue().toString();
                    runCheckCoupon.reset();
                    return new DialogContentPane.CheckError(strError);
                }
                String strText = "<font color =\"green\"><b>" + (runCheckCoupon.getCreatedAccount().isWaitingForTransaction() ? JAPMessages.getString(MSG_WAITING_FOR_PAYMENT) : JAPMessages.getString(MSG_COUPON_REDEEMED)) + "</b></font><br/><br/>";
                PaymentInstanceDBEntry pi = (PaymentInstanceDBEntry)Database.getInstance(class$anon$pay$PaymentInstanceDBEntry == null ? (class$anon$pay$PaymentInstanceDBEntry = AccountCreator.class$("anon.pay.PaymentInstanceDBEntry")) : class$anon$pay$PaymentInstanceDBEntry).getEntryById(runCheckCoupon.getCreatedAccount().getPIID());
                strText = runCheckCoupon.getCreatedAccount().isWaitingForTransaction() ? strText + JAPMessages.getString(MSG_WAITING_FOR_TRANSACTION) : (pi == null || !pi.isTest() ? strText + JAPMessages.getString(MSG_TRANSACTION_FINISHED) : strText + JAPMessages.getString(MSG_TRANSACTION_FINISHED_TEST));
                this.setText(strText);
                runCheckCoupon.reset();
                return null;
            }

            public boolean isSkippedAsNextContentPane() {
                if (panePaymentSelection.isSkippedAsNextContentPane()) {
                    return true;
                }
                return a_iPaymentOption != 2 && runCheckCoupon.getCreatedAccount() == null && paneCheckCoupon.getValue() == null;
            }

            public boolean isSkippedAsPreviousContentPane() {
                return true;
            }
        };
        paneFinished.setDefaultButtonOperation((a_iPaymentOption == 2 ? 8192 : (a_iPaymentOption == 1 ? 128 : 8)) | (a_iPaymentOption == 2 ? 32768 : 65536) | 0x100);
        JPanel contentPane = new JPanel();
        paneFinished.getContentPane().add(contentPane);
        if (a_iPaymentOption != 2) {
            contentPane.setLayout(new GridBagLayout());
            GridBagConstraints constraints = new GridBagConstraints();
            constraints.gridx = 0;
            constraints.gridy = -1;
            constraints.anchor = 17;
            a_registrator.addBrowserInstallationInfo(contentPane, constraints, JAPMessages.getString(MSG_ACCOUNT_OVERVIEW) + "...", "CONF_PAYMENT", false, 2);
        }
        SimpleWizardContentPane paneDummy = new SimpleWizardContentPane(a_dialog, "Test", a_layout, new DialogContentPaneOptions("payment", (DialogContentPane)paneFinished)){

            public boolean isMoveForwardAllowed() {
                return this.getNextContentPane() != null && (a_iPaymentOption != 2 || panePaymentSelection.isSkippedAsNextContentPane());
            }

            public boolean isSkippedAsNextContentPane() {
                return a_iPaymentOption != 2 || panePaymentSelection.isSkippedAsNextContentPane();
            }

            public boolean isSkippedAsPreviousContentPane() {
                return true;
            }
        };
        paneDummy.setDefaultButton(a_iPaymentOption == 1 ? 128 : 8 | (a_iPaymentOption == 2 ? 32768 : 65536) | 0x100);
        a_dialog.addWindowListener(new WindowAdapter(){

            public void windowClosed(WindowEvent a_event) {
                runCheckCoupon.deleteUnusedAccounts();
            }
        });
        return paneDummy;
    }

    private static DialogContentPane.CheckError showContents(DialogContentPane a_pane, IProgressCapsule a_resettable, int a_iPaymentOption, Hashtable hashPIs, String a_strMessage, LinkRegistrator a_registrator, boolean a_bDummy) {
        int i;
        PaymentInstanceDBEntry entryPI;
        Vector<PaymentInstanceDBEntry> vecEntries;
        JAPController.getInstance().blockDirectProxy(false);
        if (a_resettable != null) {
            a_resettable.reset();
        }
        a_pane.getContentPane().removeAll();
        JPanel contentPane = new JPanel();
        a_pane.getContentPane().add(contentPane);
        contentPane.setLayout(new GridBagLayout());
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = -1;
        constraints.anchor = 17;
        if (a_bDummy) {
            vecEntries = new Vector<PaymentInstanceDBEntry>();
            entryPI = new PaymentInstanceDBEntry("ID", "Dummy", null, new Vector().elements(), "0.0", 0L, 0L, null, null, null, null, null, null, null);
            vecEntries.addElement(entryPI);
            entryPI = new PaymentInstanceDBEntry("ID2", "Dummy2", null, new Vector().elements(), "0.0", 0L, 0L, null, null, null, null, null, null, null);
            vecEntries.addElement(entryPI);
        } else {
            vecEntries = AccountCreator.getPaymentInstances(a_iPaymentOption);
        }
        hashPIs.clear();
        for (int i2 = 0; i2 < vecEntries.size(); ++i2) {
            entryPI = (PaymentInstanceDBEntry)vecEntries.elementAt(i2);
            if (hashPIs.containsKey(entryPI.getId())) continue;
            hashPIs.put(entryPI.getId(), new PaymentInstancePanel(entryPI, a_registrator));
        }
        Enumeration enumEntries = hashPIs.elements();
        String message = a_strMessage;
        if (message == null) {
            message = "";
        }
        if (hashPIs.size() == 0) {
            a_pane.setText(message);
            ++constraints.gridy;
            contentPane.add((Component)new JLabel(" "), constraints);
        } else {
            a_pane.setText(message + " " + JAPMessages.getString(MSG_PAYMENT_SELECTION));
        }
        boolean bHasAccount = false;
        for (i = 0; i < vecEntries.size(); ++i) {
            if (PayAccountsFile.getInstance().getChargedAccount(((PaymentInstanceDBEntry)vecEntries.elementAt(i)).getId()) == null) continue;
            bHasAccount = true;
            break;
        }
        while (enumEntries.hasMoreElements()) {
            PaymentInstancePanel entryPanel = (PaymentInstancePanel)enumEntries.nextElement();
            entryPanel.setHeadlineVisible(hashPIs.size() > 1);
            ++constraints.gridy;
            contentPane.add((Component)entryPanel, constraints);
            if (!enumEntries.hasMoreElements()) continue;
            ++constraints.gridy;
            contentPane.add((Component)new JLabel(" "), constraints);
        }
        if (a_bDummy) {
            for (i = 0; i < vecEntries.size(); ++i) {
                hashPIs.remove(((PaymentInstanceDBEntry)vecEntries.elementAt(i)).getId());
            }
        }
        if (a_iPaymentOption == 1 && hashPIs.size() == 0) {
            return new DialogContentPane.CheckError(JAPMessages.getString(PayAccountsFile.MSG_NO_PAYMENT_INSTANCE));
        }
        return null;
    }

    private static Vector getPaymentInstances(int a_iPaymentOption) {
        if (a_iPaymentOption == 0 && !AccountCreator.isPaymentRecommended()) {
            return new Vector();
        }
        return AccountCreator.getCurrentPaymentInstances();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class RunAccountCreator
    extends Observable
    implements Runnable,
    IProgressCapsule {
        private static final String MSG_ERROR_TIMED_OUT = (class$jap$pay$AccountCreator$RunAccountCreator == null ? (class$jap$pay$AccountCreator$RunAccountCreator = AccountCreator.class$("jap.pay.AccountCreator$RunAccountCreator")) : class$jap$pay$AccountCreator$RunAccountCreator).getName() + ".errorTimedOut";
        private static final String MSG_ERROR_INTERRUPTED = (class$jap$pay$AccountCreator$RunAccountCreator == null ? (class$jap$pay$AccountCreator$RunAccountCreator = AccountCreator.class$("jap.pay.AccountCreator$RunAccountCreator")) : class$jap$pay$AccountCreator$RunAccountCreator).getName() + ".errorInterrupted";
        private static final int MAX_SECONDS = 120;
        private Hashtable m_hashPayAccounts = new Hashtable();
        private String m_strError;
        private Vector m_vecKeys;
        private Hashtable m_hashPIs;
        private PayAccount m_createdAccount;
        private long m_startTime;
        private int m_status;
        private String m_strMessage;

        public RunAccountCreator(Hashtable a_hashPIs, Vector a_vecKeys) {
            this.m_vecKeys = a_vecKeys;
            this.m_hashPIs = a_hashPIs;
            this.m_status = -1;
        }

        protected void finalize() {
            this.deleteUnusedAccounts();
        }

        public void reset() {
            this.m_strError = null;
            this.m_status = -1;
            this.m_createdAccount = null;
        }

        public PayAccount getCreatedAccount() {
            return this.m_createdAccount;
        }

        public void deleteUnusedAccounts() {
            if (this.m_hashPayAccounts == null) {
                return;
            }
            Enumeration enumAccounts = this.m_hashPayAccounts.elements();
            while (enumAccounts.hasMoreElements()) {
                PayAccount account = (PayAccount)enumAccounts.nextElement();
                account.unlock();
                if (account.getTransaction() != null) continue;
                PayAccountsFile.getInstance().deleteAccount(account);
            }
        }

        public int getMaximum() {
            return 120;
        }

        public int getMinimum() {
            return 0;
        }

        public int getValue() {
            return (int)((System.currentTimeMillis() - this.m_startTime) / 1000L);
        }

        public int getStatus() {
            return this.m_status;
        }

        public String getMessage() {
            String message = this.m_strMessage;
            if (message != null) {
                return JAPMessages.getString(message) + "...";
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void showMessage(String a_strMessage) {
            this.m_strMessage = a_strMessage;
            RunAccountCreator runAccountCreator = this;
            synchronized (runAccountCreator) {
                this.setChanged();
                this.notifyObservers(this);
            }
        }

        public String getError() {
            String error = this.m_strError;
            if (error != null) {
                error = JAPMessages.getString(error);
            }
            return error;
        }

        private void checkDirectContact() throws DirectContactException {
            if (!JAPController.getInstance().isAnonConnected() && JAPModel.getInstance().getPaymentAnonymousConnectionSetting() == 1) {
                throw new DirectContactException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void runInternal() throws DirectContactException {
            Enumeration enumPIs = this.m_hashPIs.elements();
            PaymentInstancePanel panelPI = null;
            this.m_createdAccount = null;
            this.m_status = 1;
            this.showMessage(PayAccountsFile.MSG_VERIFYING_COUPON);
            while (enumPIs.hasMoreElements() && (!(panelPI = (PaymentInstancePanel)enumPIs.nextElement()).isComplete() || panelPI.getCode() == null)) {
                panelPI = null;
            }
            if (panelPI == null) {
                return;
            }
            PayAccount account = (PayAccount)this.m_hashPayAccounts.get(panelPI.getPaymentInstance().getId());
            if (account != null && account.isCharged(new Timestamp(System.currentTimeMillis()))) {
                this.m_hashPayAccounts.remove(panelPI.getPaymentInstance().getId());
                account = null;
            }
            if (account != null) {
                this.checkDirectContact();
                this.showMessage(PayAccountsFile.MSG_UPDATING_ACCOUNT_DATA);
                try {
                    account.fetchAccountInfo(true);
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.GUI, e);
                    this.checkDirectContact();
                    this.m_strError = PayAccountsFile.MSG_UPDATING_ACCOUNT_DATA_ERROR;
                    return;
                }
                if (account.isCharged(new Timestamp(System.currentTimeMillis()))) {
                    this.m_hashPayAccounts.remove(panelPI.getPaymentInstance().getId());
                    account = null;
                }
            }
            if (account == null) {
                AsymmetricCryptoKeyPair keyPair = null;
                Vector vector = this.m_vecKeys;
                synchronized (vector) {
                    if (this.m_vecKeys.size() == 0) {
                        this.m_strError = PayAccountsFile.MSG_CREATING_KEY_PAIR_ERROR;
                    } else {
                        keyPair = (AsymmetricCryptoKeyPair)this.m_vecKeys.elementAt(0);
                    }
                }
                if (keyPair != null) {
                    this.checkDirectContact();
                    this.showMessage(PayAccountsFile.MSG_CREATING_ACCOUNT);
                    try {
                        try {
                            account = PayAccountsFile.getInstance().createAccount(panelPI.getPaymentInstance(), keyPair, null, true);
                        }
                        catch (ForbiddenIOException a_e) {
                            this.m_strError = PayAccountsFile.MSG_CREATING_ACCOUNT_ERROR_FORBIDDEN;
                            throw a_e;
                        }
                        catch (IOException a_e) {
                            this.m_strError = PayAccountsFile.MSG_CREATING_ACCOUNT_ERROR_UNREACHABLE;
                            throw a_e;
                        }
                        catch (Exception a_e) {
                            this.m_strError = PayAccountsFile.MSG_CREATING_ACCOUNT_ERROR;
                            throw a_e;
                        }
                    }
                    catch (Exception e) {
                        LogHolder.log(2, LogType.GUI, e);
                        this.checkDirectContact();
                        account = null;
                    }
                    if (account != null) {
                        this.m_vecKeys.removeAllElements();
                        this.showMessage(PayAccountsFile.MSG_SAVING_CONFIG_FILE);
                        if (JAPController.getInstance().saveConfigFile()) {
                            this.m_strError = PayAccountsFile.MSG_SAVING_CONFIG_FILE_ERROR;
                            account = null;
                        } else {
                            this.m_hashPayAccounts.put(panelPI.getPaymentInstance().getId(), account);
                        }
                    }
                }
            }
            if (account != null) {
                try {
                    this.checkDirectContact();
                    this.showMessage(PayAccountsFile.MSG_ACTIVATING_COUPON);
                    if (PayAccountsFile.getInstance().activateCouponCode(panelPI.getCode(), account, true)) {
                        this.checkDirectContact();
                        if (PayAccountsFile.getInstance().activateCouponCode(panelPI.getCode(), account, false)) {
                            account.unlock();
                            panelPI.clearCode();
                            this.m_hashPayAccounts.remove(account.getBI().getId());
                            this.showMessage(PayAccountsFile.MSG_SAVING_CONFIG_FILE);
                            JAPController.getInstance().saveConfigFile();
                            JAPController.getInstance().setAllowPaidServices(true);
                            if (account.isCharged() && !TrustModel.getCurrentTrustModel().isTrusted(JAPController.getInstance().getCurrentMixCascade())) {
                                JAPController.getInstance().switchToNextMixCascade();
                            }
                            this.m_createdAccount = account;
                            this.m_status = 0;
                        } else {
                            this.checkDirectContact();
                            this.m_strError = PayAccountsFile.MSG_ACTIVATING_COUPON_ERROR;
                        }
                    } else {
                        this.checkDirectContact();
                        this.m_strError = !PayAccountsFile.getInstance().isNewUserAllowed(panelPI.getCode()) ? PayAccountsFile.MSG_ACTIVATING_COUPON_NOT_A_NEW_USER : PayAccountsFile.MSG_ACTIVATING_COUPON_NOT_ACCEPTED;
                        this.m_status = 3;
                    }
                }
                catch (DirectContactException a_e) {
                    this.m_status = 3;
                    throw a_e;
                }
                catch (Exception a_e) {
                    LogHolder.log(2, LogType.GUI, a_e);
                    this.m_status = 3;
                    this.checkDirectContact();
                    this.m_strError = PayAccountsFile.MSG_ACTIVATING_COUPON_ERROR;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            this.m_strError = null;
            this.m_startTime = System.currentTimeMillis();
            this.m_status = -1;
            boolean bInterrupted = false;
            Thread thRun = new Thread(){

                public void run() {
                    try {
                        RunAccountCreator.this.runInternal();
                    }
                    catch (DirectContactException a_ex) {
                        RunAccountCreator.this.m_strError = PayAccountsFile.MSG_ERROR_ALLOW_NON_ANONYMOUS_OR_CONNECT;
                        RunAccountCreator.this.m_status = 3;
                    }
                }
            };
            thRun.start();
            try {
                do {
                    Thread.sleep(250L);
                    RunAccountCreator runAccountCreator = this;
                    synchronized (runAccountCreator) {
                        if (Thread.currentThread().isInterrupted()) {
                            throw new InterruptedException();
                        }
                        this.setChanged();
                        this.notifyObservers(this);
                    }
                } while (this.getValue() < this.getMaximum() && thRun.isAlive());
            }
            catch (InterruptedException a_e) {
                bInterrupted = true;
                this.m_strError = MSG_ERROR_INTERRUPTED;
                this.m_status = 2;
            }
            while (thRun.isAlive()) {
                if (!bInterrupted) {
                    this.m_strError = MSG_ERROR_TIMED_OUT;
                    this.m_status = 3;
                }
                thRun.interrupt();
                try {
                    Thread.sleep(200L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.m_strError == null) {
                this.m_status = 0;
            }
        }

        private static class DirectContactException
        extends Exception {
            private DirectContactException() {
            }
        }
    }
}

