/*
 * Decompiled with CFR 0.152.
 */
package misc;

import HTTPClient.HTTPConnection;
import HTTPClient.HTTPResponse;
import anon.client.AnonClient;
import anon.crypto.SignatureVerifier;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.InfoServiceDBEntry;
import anon.infoservice.InfoServiceHolder;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascade;
import anon.infoservice.ProxyInterface;
import anon.infoservice.SimpleMixCascadeContainer;
import anon.proxy.AnonProxy;
import anon.tor.TorAnonServerDescription;
import jap.JAPDebug;
import java.io.IOException;
import java.net.ServerSocket;
import java.util.Random;
import logging.LogHolder;
import logging.LogType;

public final class SOCKSTest {
    public static void main(String[] args) throws IOException, Exception {
        SOCKSTest t = new SOCKSTest();
        t.doIt();
    }

    public void doIt() throws IOException, Exception {
        JAPDebug log = JAPDebug.getInstance();
        log.setLogLevel(7);
        log.setLogType(LogType.TOR);
        LogHolder.setLogInstance(log);
        LogHolder.setDetailLevel(0);
        LogHolder.log(7, LogType.TOR, "Start stress testr!");
        ServerSocket listener = new ServerSocket(4007);
        InfoServiceHolder.getInstance().setPreferredInfoService(new InfoServiceDBEntry("infoservice.inf.tu-dresden.de", 80));
        AnonClient.setLoginTimeout(40000);
        AnonProxy proxy = new AnonProxy(listener, null, 0);
        TorAnonServerDescription td = new TorAnonServerDescription("141.76.45.45", 9030, true);
        td.setMaxConnectionsPerRoute(100);
        td.setMaxRouteLen(2);
        proxy.setTorParams(td);
        SignatureVerifier.getInstance().setCheckSignatures(false);
        proxy.start(new SimpleMixCascadeContainer(new MixCascade("mix.inf.tu-dresden.de", 6544)));
        proxy.setDummyTraffic(60000);
        Random rnd = new Random();
        Thread.sleep(20000L);
        LogHolder.log(7, LogType.TOR, "Stress test building connection");
        for (int i = 0; i < 1000; ++i) {
            new SocksHttpConnection("anon.inf.tu-dresden.de", 80, "/bl.gif");
            Thread.sleep(450L);
        }
    }

    private final class SocksHttpConnection
    implements Runnable {
        private String m_strHost;
        private int m_Port;
        private String m_strFile;

        SocksHttpConnection(String host, int port, String file) {
            this.m_strHost = host;
            this.m_Port = port;
            this.m_strFile = file;
            Thread t = new Thread(this);
            t.setDaemon(true);
            t.start();
        }

        public void run() {
            try {
                HTTPConnection conn = HTTPConnectionFactory.getInstance().createHTTPConnection(new ListenerInterface(this.m_strHost, this.m_Port), new ProxyInterface("127.0.0.1", 4007, 3, null));
                conn.setTimeout(60000);
                HTTPResponse resp = conn.Get(this.m_strFile);
                if (resp.getStatusCode() != 200) {
                    LogHolder.log(4, LogType.TOR, "Error getting Web page!");
                } else {
                    LogHolder.log(4, LogType.TOR, "Successfull getting Web page!");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LogHolder.log(4, LogType.TOR, "Exception getting Web page! - " + e.getMessage());
            }
        }
    }
}

