/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import HTTPClient.HTTPConnection;
import HTTPClient.ThreadInterruptedIOException;
import anon.AnonChannel;
import anon.AnonServerDescription;
import anon.AnonService;
import anon.AnonServiceEventListener;
import anon.IServiceContainer;
import anon.NotConnectedToMixException;
import anon.client.DataChainErrorListener;
import anon.client.DummyTrafficControlChannel;
import anon.client.FixedRatioChannelsDescription;
import anon.client.IntegrityErrorListener;
import anon.client.KeyExchangeManager;
import anon.client.MixPacket;
import anon.client.MixParameters;
import anon.client.Multiplexer;
import anon.client.PacketCounter;
import anon.client.SequentialChannelDataChain;
import anon.client.SingleChannelDataChain;
import anon.client.SocketHandler;
import anon.client.TestControlChannel;
import anon.client.TrustModel;
import anon.client.TypeFilterDataChain;
import anon.client.replay.ReplayControlChannel;
import anon.client.replay.TimestampUpdater;
import anon.error.AlreadyConnectedException;
import anon.error.AnonServiceException;
import anon.error.ConnectionEstablishmentTimeoutException;
import anon.error.IntegrityCheckException;
import anon.error.InvalidServiceException;
import anon.error.ParseServiceException;
import anon.error.ServiceInterruptedException;
import anon.infoservice.Database;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.IMutableProxyInterface;
import anon.infoservice.ImmutableProxyInterface;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascade;
import anon.infoservice.RandomListenerInterfaceSwitcher;
import anon.pay.AIControlChannel;
import anon.pay.IAIEventListener;
import anon.pay.PayAccount;
import anon.proxy.DirectProxy;
import anon.terms.TermsAndConditionConfirmation;
import anon.terms.TermsAndConditionsReadException;
import anon.transport.connection.ConnectionException;
import anon.transport.connection.IStreamConnection;
import anon.transport.connection.SocketConnection;
import anon.util.JobQueue;
import anon.util.XMLParseException;
import java.io.IOException;
import java.net.ConnectException;
import java.net.Socket;
import java.security.SecureRandom;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class AnonClient
implements AnonService,
Observer,
DataChainErrorListener,
IntegrityErrorListener {
    private static boolean ENABLE_CONTROL_CHANNEL_TEST = false;
    private static boolean ms_bIsTestInstance = false;
    private static boolean ms_bIsTestInstanceSet = false;
    public static final int DEFAULT_LOGIN_TIMEOUT = 30000;
    private static final int FAST_LOGIN_TIMEOUT = 4000;
    private static final int CONNECT_TIMEOUT = 8000;
    public static final long DEFAULT_BLOCK_TIMEOUT = 180000L;
    private long m_msBlockTimeout = 180000L;
    private static int m_loginTimeout = 30000;
    private static int m_loginTimeoutFastAvailable;
    private static boolean ms_bBlockOnHttpError;
    private static int ms_preferredConnectionPort;
    private static Vector ms_vecTimedOutPorts;
    private Multiplexer m_multiplexer;
    private static JobQueue ms_queuePacketCount;
    private IMutableProxyInterface m_proxyInterface;
    private Object m_internalSynchronization;
    private IServiceContainer m_serviceContainer;
    private Thread m_threadInitialise;
    private Object SYNC_SHUTDOWN = new Object();
    private Object m_internalSynchronizationForSocket;
    private Object m_internalSynchronizationForDummyTraffic;
    private SocketHandler m_socketHandler;
    private Vector m_eventListeners;
    private PacketCounter m_packetCounter;
    private DummyTrafficControlChannel m_dummyTrafficControlChannel;
    private int m_dummyTrafficInterval = 30000;
    private KeyExchangeManager m_keyExchangeManager;
    private IStreamConnection m_streamConnection;
    private boolean m_connected;
    private MixCascade m_currentService;
    private DirectProxy m_directProxy;
    private boolean m_bDebug = false;
    static /* synthetic */ Class class$anon$infoservice$MixCascade;

    public AnonClient(DirectProxy a_directProxy) {
        this.m_directProxy = a_directProxy;
        this.m_socketHandler = null;
        this.m_multiplexer = null;
        this.m_packetCounter = null;
        this.m_dummyTrafficControlChannel = null;
        this.m_dummyTrafficInterval = -1;
        this.m_keyExchangeManager = null;
        this.m_streamConnection = null;
        this.m_internalSynchronization = new Object();
        this.m_internalSynchronizationForSocket = new Object();
        this.m_internalSynchronizationForDummyTraffic = new Object();
        this.m_eventListeners = new Vector();
        this.m_connected = false;
        this.m_proxyInterface = new IMutableProxyInterface.DummyMutableProxyInterface();
        this.m_bDebug = false;
    }

    public AnonClient(DirectProxy a_directProxy, IStreamConnection a_theConnection, MixCascade a_currentService) {
        this(a_directProxy);
        this.m_streamConnection = a_theConnection;
        this.m_currentService = a_currentService;
        TrustModel.cleanAttributeWhitelist(this.m_currentService);
    }

    public void setDebug(boolean bDebug) {
        this.m_bDebug = bDebug;
    }

    public static void setTestInstance(boolean a_bTestInstance) {
        if (!ms_bIsTestInstanceSet) {
            ms_bIsTestInstance = a_bTestInstance;
            ms_bIsTestInstanceSet = true;
        }
    }

    public static boolean isTestInstance() {
        return ms_bIsTestInstance;
    }

    public MixCascade getCurrentService() {
        return this.m_currentService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void initialize(final AnonServerDescription a_mixCascade, final IServiceContainer a_serviceContainer, final TermsAndConditionConfirmation termsConfirmation, final boolean a_bIsReconnect) throws AnonServiceException {
        if (!(a_mixCascade instanceof MixCascade)) {
            throw new InvalidServiceException(a_mixCascade);
        }
        if (this.isConnected()) {
            throw new AlreadyConnectedException(a_mixCascade);
        }
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            this.m_currentService = (MixCascade)a_mixCascade;
            TrustModel.cleanAttributeWhitelist(this.m_currentService);
            this.m_serviceContainer = a_serviceContainer;
        }
        StatusThread run = new StatusThread(){
            AnonServiceException status = null;

            public AnonServiceException getStatus() {
                return this.status;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = AnonClient.this.m_internalSynchronization;
                synchronized (object) {
                    if (AnonClient.this.isConnected()) {
                        LogHolder.log(3, LogType.NET, "AnonClient was already connected when connecting!");
                        this.status = new AlreadyConnectedException(a_mixCascade);
                        Thread thread = AnonClient.this.m_threadInitialise;
                        synchronized (thread) {
                            AnonClient.this.m_threadInitialise.notifyAll();
                        }
                        return;
                    }
                    IStreamConnection connectionToMixCascade = null;
                    if (AnonClient.this.m_streamConnection != null) {
                        connectionToMixCascade = AnonClient.this.m_streamConnection;
                        AnonClient.this.m_streamConnection = null;
                    } else {
                        try {
                            a_serviceContainer.getTrustModel().checkTrust((MixCascade)a_mixCascade);
                            connectionToMixCascade = AnonClient.this.connectMixCascade((MixCascade)a_mixCascade, AnonClient.this.m_proxyInterface.getProxyInterface(false).getProxyInterface(), a_serviceContainer, a_bIsReconnect);
                        }
                        catch (InterruptedException a_e) {
                            this.status = new ServiceInterruptedException(a_mixCascade);
                            Thread thread = AnonClient.this.m_threadInitialise;
                            synchronized (thread) {
                                AnonClient.this.m_threadInitialise.notifyAll();
                            }
                            return;
                        }
                        catch (AnonServiceException a_e) {
                            this.status = a_e;
                            Thread thread = AnonClient.this.m_threadInitialise;
                            synchronized (thread) {
                                AnonClient.this.m_threadInitialise.notifyAll();
                            }
                            return;
                        }
                    }
                    if (connectionToMixCascade == null) {
                        this.status = new AnonServiceException(a_mixCascade, "Could not connect to service " + a_mixCascade + "  for an unknown reason.", -6);
                        Thread a_e = AnonClient.this.m_threadInitialise;
                        synchronized (a_e) {
                            AnonClient.this.m_threadInitialise.notifyAll();
                        }
                        return;
                    }
                    try {
                        AnonClient.this.initializeProtocol(connectionToMixCascade, (MixCascade)a_mixCascade, a_serviceContainer, termsConfirmation);
                    }
                    catch (AnonServiceException a_e) {
                        this.status = a_e;
                    }
                    Thread thread = AnonClient.this.m_threadInitialise;
                    synchronized (thread) {
                        AnonClient.this.m_threadInitialise.notifyAll();
                    }
                }
            }
        };
        Object object2 = this.SYNC_SHUTDOWN;
        synchronized (object2) {
            this.m_threadInitialise = new Thread(run);
        }
        this.m_threadInitialise.start();
        try {
            this.m_threadInitialise.join();
        }
        catch (InterruptedException ex) {
            Thread thread = this.m_threadInitialise;
            synchronized (thread) {
                while (this.m_threadInitialise.isAlive()) {
                    this.m_threadInitialise.interrupt();
                    try {
                        this.m_threadInitialise.wait(500L);
                    }
                    catch (InterruptedException ex1) {}
                }
            }
            throw new ServiceInterruptedException(a_mixCascade);
        }
        if (run.getStatus() != null) {
            throw run.getStatus();
        }
    }

    public static void setLoginTimeout(int a_loginTimeoutMS) {
        if (a_loginTimeoutMS >= 1000) {
            m_loginTimeout = a_loginTimeoutMS;
        }
    }

    public static void setBlockOnHttpConnectionError(boolean a_bBlock) {
        ms_bBlockOnHttpError = a_bBlock;
    }

    public static boolean isBlockedOnHttpConnectionError() {
        return ms_bBlockOnHttpError;
    }

    private static void resetInternalLoginTimeout() {
        int maxLoginTimeoutFastAvailable = 30;
        m_loginTimeoutFastAvailable = Math.max(m_loginTimeout / 1000, m_loginTimeout / 4000);
        if (m_loginTimeoutFastAvailable > maxLoginTimeoutFastAvailable) {
            m_loginTimeoutFastAvailable = maxLoginTimeoutFastAvailable;
        }
    }

    private static int getInternalLoginTimeout(IServiceContainer a_serviceContainer) {
        if (a_serviceContainer != null && m_loginTimeoutFastAvailable > 0 && a_serviceContainer.isReconnectedAutomatically() && a_serviceContainer.isServiceAutoSwitched()) {
            --m_loginTimeoutFastAvailable;
            return 4000;
        }
        return m_loginTimeout;
    }

    public static int getLoginTimeout() {
        return m_loginTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setProxy(IMutableProxyInterface a_proxyInterface) {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            this.m_proxyInterface = a_proxyInterface == null ? new IMutableProxyInterface.DummyMutableProxyInterface() : a_proxyInterface;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean a_bResetTransferredBytes) {
        Object object;
        Object object2 = this.m_internalSynchronizationForSocket;
        synchronized (object2) {
            if (this.m_socketHandler != null) {
                this.m_socketHandler.deleteObservers();
            }
        }
        object2 = this.m_internalSynchronization;
        synchronized (object2) {
            if (this.m_multiplexer != null) {
                this.m_multiplexer.close();
            }
        }
        object2 = this.m_internalSynchronizationForSocket;
        synchronized (object2) {
            if (this.m_socketHandler != null) {
                this.m_socketHandler.closeSocket();
                this.m_socketHandler = null;
            }
        }
        object2 = this.SYNC_SHUTDOWN;
        synchronized (object2) {
            if (this.m_threadInitialise != null) {
                object = this.m_threadInitialise;
                synchronized (object) {
                    while (this.m_threadInitialise.isAlive()) {
                        this.m_threadInitialise.interrupt();
                        try {
                            this.m_threadInitialise.wait(100L);
                        }
                        catch (InterruptedException e) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }
        object2 = this.m_internalSynchronization;
        synchronized (object2) {
            if (this.m_multiplexer != null) {
                this.m_multiplexer.deleteObservers();
            }
            this.m_multiplexer = null;
            this.m_connected = false;
            object = this.m_internalSynchronizationForDummyTraffic;
            synchronized (object) {
                if (this.m_dummyTrafficControlChannel != null) {
                    this.m_dummyTrafficControlChannel.stop();
                    this.m_dummyTrafficControlChannel = null;
                }
            }
            if (this.m_packetCounter != null) {
                this.m_packetCounter.deleteObserver(this);
                if (a_bResetTransferredBytes) {
                    this.m_packetCounter = null;
                }
            }
            if (this.m_keyExchangeManager != null) {
                this.m_keyExchangeManager.removeCertificateLock();
                this.m_keyExchangeManager = null;
            }
            if (this.m_directProxy != null) {
                this.m_directProxy.start();
            }
        }
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    public boolean isSendingControlMessage() {
        Multiplexer multiplexer = this.m_multiplexer;
        if (multiplexer == null) {
            return false;
        }
        return multiplexer.isSendingControlMessage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnonChannel createChannel(int a_type) throws ConnectException {
        Multiplexer multiplexer = null;
        KeyExchangeManager keyExchangeManager = null;
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            if (this.m_multiplexer == null) {
                throw new NotConnectedToMixException("AnonClient: createChannel(): The AN.ON client is currently not connected to a mixcascade.");
            }
            multiplexer = this.m_multiplexer;
            keyExchangeManager = this.m_keyExchangeManager;
        }
        FixedRatioChannelsDescription channelsDescription = keyExchangeManager.getFixedRatioChannelsDescription();
        if (channelsDescription == null) {
            return new SingleChannelDataChain(multiplexer.getChannelTable(), this, this, a_type, keyExchangeManager.isChainProtocolWithFlowControl(), keyExchangeManager.isChainProtocolWithUpstreamFlowControl(), keyExchangeManager.getUpstreamSendMe(), keyExchangeManager.getDownstreamSendMe(), keyExchangeManager.isProtocolWithEnhancedChannelEncryption(), keyExchangeManager.isProtocolWithIntegrityCheck());
        }
        return new TypeFilterDataChain(new SequentialChannelDataChain(multiplexer.getChannelTable(), this, this, channelsDescription.getChainTimeout()), a_type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(AnonServiceEventListener a_eventListener) {
        Vector vector = this.m_eventListeners;
        synchronized (vector) {
            this.m_eventListeners.addElement(a_eventListener);
        }
    }

    public void removeEventListeners() {
        this.m_eventListeners.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(AnonServiceEventListener a_eventListener) {
        Vector vector = this.m_eventListeners;
        synchronized (vector) {
            this.m_eventListeners.removeElement(a_eventListener);
        }
    }

    private void reconnect(final MixCascade a_cascade, final IOException a_argument) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AnonClient.this.shutdown(!AnonClient.this.m_serviceContainer.isReconnectedAutomatically());
                Vector vector = AnonClient.this.m_eventListeners;
                synchronized (vector) {
                    final Enumeration eventListenersList = AnonClient.this.m_eventListeners.elements();
                    Thread notificationThread = new Thread(new Runnable(){

                        public void run() {
                            if (a_argument != null) {
                                LogHolder.log(4, LogType.NET, a_argument);
                            }
                            while (eventListenersList.hasMoreElements()) {
                                ((AnonServiceEventListener)eventListenersList.nextElement()).connectionError(new AnonServiceException(a_cascade, "Reconnect..."));
                            }
                        }
                    }, "ConnectionError notification");
                    notificationThread.setDaemon(true);
                    notificationThread.start();
                }
            }
        }).start();
    }

    public void update(Observable a_object, Object a_argument) {
        if (a_object == this.m_socketHandler && a_argument instanceof IOException) {
            this.reconnect(this.getCurrentService(), (IOException)a_argument);
        } else if (a_object == this.m_packetCounter) {
            JobQueue.Job notificationThread = new JobQueue.Job(true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runJob() {
                    Vector eventListeners = AnonClient.this.m_eventListeners;
                    PacketCounter packetCounter = AnonClient.this.m_packetCounter;
                    if (eventListeners != null && packetCounter != null) {
                        Vector vector = eventListeners;
                        synchronized (vector) {
                            Enumeration eventListenersList = eventListeners.elements();
                            while (eventListenersList.hasMoreElements()) {
                                ((AnonServiceEventListener)eventListenersList.nextElement()).packetMixed(packetCounter.getProcessedPackets() * (long)MixPacket.getPacketSize());
                            }
                        }
                    }
                }
            };
            ms_queuePacketCount.addJob(notificationThread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataChainErrorSignaled(AnonServiceException a_e) {
        AnonServiceException e = a_e;
        if (e == null) {
            e = new AnonServiceException(this.getCurrentService(), "Proxy at the last mix was nuked!");
        }
        final AnonServiceException exception = e;
        Vector vector = this.m_eventListeners;
        synchronized (vector) {
            final Enumeration eventListenersList = this.m_eventListeners.elements();
            Thread notificationThread = new Thread(new Runnable(){

                public void run() {
                    while (eventListenersList.hasMoreElements()) {
                        ((AnonServiceEventListener)eventListenersList.nextElement()).dataChainErrorSignaled(exception);
                    }
                }
            }, "AnonClient: DataChainErrorSignaled notification");
            notificationThread.setDaemon(true);
            notificationThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void integrityErrorSignaled(final int a_iErrorCode) {
        Vector vector = this.m_eventListeners;
        synchronized (vector) {
            final Enumeration eventListenersList = this.m_eventListeners.elements();
            Thread notificationThread = new Thread(new Runnable(){

                public void run() {
                    while (eventListenersList.hasMoreElements()) {
                        ((AnonServiceEventListener)eventListenersList.nextElement()).integrityErrorSignaled(new IntegrityCheckException((AnonServerDescription)AnonClient.this.getCurrentService(), a_iErrorCode));
                    }
                }
            }, "AnonClient: integrityErrorSignaled notification");
            notificationThread.setDaemon(true);
            notificationThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDummyTraffic(int a_interval) {
        Object object = this.m_internalSynchronizationForDummyTraffic;
        synchronized (object) {
            this.m_dummyTrafficInterval = a_interval;
            if (this.m_dummyTrafficControlChannel != null) {
                this.m_dummyTrafficControlChannel.setDummyTrafficInterval(a_interval);
            }
        }
    }

    public void setInterfaceBlockTimout(long msTimeOut) {
        this.m_msBlockTimeout = msTimeOut;
    }

    public SocketHandler getConnectionToMixCascade() {
        return this.m_socketHandler;
    }

    private IStreamConnection connectMixCascade(final MixCascade a_mixCascade, ImmutableProxyInterface a_proxyInterface, IServiceContainer a_serviceContainer, final boolean a_bIsReconnect) throws InterruptedException, AnonServiceException {
        ListenerInterface nextInterface;
        LogHolder.log(7, LogType.NET, "Trying to connect to MixCascade '" + a_mixCascade.toString() + "'...");
        Thread notificationThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Vector vector = AnonClient.this.m_eventListeners;
                synchronized (vector) {
                    Enumeration eventListenersList = AnonClient.this.m_eventListeners.elements();
                    while (eventListenersList.hasMoreElements()) {
                        ((AnonServiceEventListener)eventListenersList.nextElement()).connecting(a_mixCascade, a_bIsReconnect);
                    }
                }
            }
        }, "AnonClient: Connecting notification");
        notificationThread.setDaemon(true);
        notificationThread.start();
        Socket connectedSocket = null;
        RandomListenerInterfaceSwitcher interfaceSwitcher = new RandomListenerInterfaceSwitcher(a_mixCascade.getListenerInterfaces(), ms_preferredConnectionPort, 2, ms_vecTimedOutPorts);
        boolean bTried = false;
        while ((nextInterface = interfaceSwitcher.getNextInterface()) != null && nextInterface.isValid() && connectedSocket == null && !Thread.currentThread().isInterrupted()) {
            a_serviceContainer.getTrustModel().checkTrust(a_mixCascade);
            bTried = true;
            LogHolder.log(6, LogType.NET, "Trying cascade connection (Preferred port: " + ms_preferredConnectionPort + ") to interface: " + nextInterface);
            try {
                HTTPConnection connection = HTTPConnectionFactory.getInstance().createHTTPConnection(nextInterface, a_proxyInterface);
                connection.setTimeout(8000);
                connectedSocket = connection.Connect();
            }
            catch (Exception a_e) {
                if (a_e instanceof ThreadInterruptedIOException) {
                    LogHolder.log(5, LogType.NET, "Interrupted while connecting to MixCascade '" + a_mixCascade.toString() + "'.");
                    throw new InterruptedException();
                }
                int loglevel = 3;
                try {
                    if (a_mixCascade.getListenerInterface(0).getHost().equals("0.0.0.0")) {
                        loglevel = 6;
                    }
                }
                catch (Exception a_e2) {
                    // empty catch block
                }
                if (ms_bBlockOnHttpError || ListenerInterface.isBlockingRecommended(a_e)) {
                    nextInterface.blockInterface(this.m_msBlockTimeout);
                }
                LogHolder.log(loglevel, LogType.NET, "Error while connecting to MixCascade " + a_mixCascade.toString() + " via " + nextInterface.toString() + "!", a_e);
            }
        }
        if (connectedSocket != null) {
            if (ms_preferredConnectionPort != connectedSocket.getPort()) {
                ms_preferredConnectionPort = connectedSocket.getPort();
                LogHolder.log(5, LogType.NET, "New preferred cascade connection port is: " + ms_preferredConnectionPort);
            }
            LogHolder.log(7, LogType.NET, "Connection to MixCascade '" + a_mixCascade.toString() + "' successfully established - starting key-exchange...");
            return new SocketConnection(connectedSocket);
        }
        int loglevel = 3;
        try {
            if (a_mixCascade.getListenerInterface(0).getHost().equals("0.0.0.0")) {
                loglevel = 6;
            }
        }
        catch (Exception a_e) {
            // empty catch block
        }
        String strNoInterfaces = "";
        if (!bTried) {
            strNoInterfaces = " No listener interfaces available!";
        }
        LogHolder.log(loglevel, LogType.NET, "Failed to connect to MixCascade '" + a_mixCascade.toString() + "'." + strNoInterfaces);
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeProtocol(IStreamConnection a_connectionToMixCascade, final MixCascade a_mixCascade, final IServiceContainer a_serviceContainer, final TermsAndConditionConfirmation termsConfirmation) throws AnonServiceException {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            Object e2;
            try {
                try {
                    a_connectionToMixCascade.setTimeout(AnonClient.getInternalLoginTimeout(a_serviceContainer));
                }
                catch (ConnectionException e2) {
                    // empty catch block
                }
                e2 = this.m_internalSynchronizationForSocket;
                synchronized (e2) {
                    if (this.m_socketHandler != null) {
                        this.m_socketHandler.deleteObservers();
                    }
                    this.m_socketHandler = new SocketHandler(a_connectionToMixCascade);
                }
                final Vector exceptionCache = new Vector();
                Thread loginThread = new Thread(new Runnable(){

                    public void run() {
                        boolean tcRetry = true;
                        int tctry = 0;
                        try {
                            while (tcRetry) {
                                try {
                                    AnonClient.this.m_keyExchangeManager = new KeyExchangeManager(AnonClient.this.m_socketHandler.getInputStream(), AnonClient.this.m_socketHandler.getOutputStream(), a_mixCascade, a_serviceContainer.getTrustModel(), AnonClient.this.m_bDebug);
                                    tcRetry = false;
                                }
                                catch (TermsAndConditionsReadException tcie) {
                                    if (!termsConfirmation.confirmTermsAndConditions(tcie.getOperators(), tcie.getTermsTermsAndConditonsToRead())) {
                                        a_serviceContainer.keepCurrentService(false);
                                        throw new InterruptedException("Client rejected T&C after reading.");
                                    }
                                    if (++tctry > 1) {
                                        LogHolder.log(3, LogType.NET, "Requesting t&cs after the first try is not allowed!");
                                        throw new InterruptedException("A second tc request must never be sent.");
                                    }
                                    AnonClient.this.m_socketHandler = new SocketHandler(AnonClient.this.connectMixCascade(a_mixCascade, AnonClient.this.m_proxyInterface.getProxyInterface(false).getProxyInterface(), a_serviceContainer, true));
                                }
                            }
                        }
                        catch (Exception a_e) {
                            exceptionCache.addElement(a_e);
                        }
                    }
                }, "Login Thread");
                loginThread.start();
                loginThread.join();
                if (exceptionCache.size() > 0) {
                    throw (Exception)exceptionCache.firstElement();
                }
            }
            catch (AnonServiceException e3) {
                LogHolder.log(3, LogType.NET, e3);
                this.closeSocketHandler();
                throw e3;
            }
            catch (InterruptedException a_e) {
                LogHolder.log(6, LogType.NET, a_e);
                this.closeSocketHandler();
                throw new ServiceInterruptedException(a_mixCascade);
            }
            catch (XMLParseException a_e) {
                LogHolder.log(3, LogType.NET, a_e);
                this.closeSocketHandler();
                throw new ParseServiceException(a_mixCascade, a_e.getMessage());
            }
            catch (Exception a_e) {
                LogHolder.log(3, LogType.NET, a_e);
                this.closeSocketHandler();
                Class<?> classSocketTimeoutException = null;
                try {
                    classSocketTimeoutException = Class.forName("java.net.SocketTimeoutException");
                }
                catch (ClassNotFoundException e1) {
                    LogHolder.log(6, LogType.NET, "Old JRE does not have SocketTimeoutException. Please update your Java ASAP!");
                }
                if (classSocketTimeoutException != null && classSocketTimeoutException.isInstance(a_e)) {
                    if (ms_preferredConnectionPort > 0) {
                        ms_vecTimedOutPorts.addElement(new Integer(ms_preferredConnectionPort));
                    }
                    ms_preferredConnectionPort = 0;
                    throw new ConnectionEstablishmentTimeoutException(a_mixCascade);
                }
                throw new AnonServiceException(a_mixCascade, a_e.getMessage());
            }
            try {
                a_connectionToMixCascade.setTimeout(0);
            }
            catch (ConnectionException e4) {
                // empty catch block
            }
            this.m_multiplexer = new Multiplexer(this.m_socketHandler.getInputStream(), this.m_socketHandler.getOutputStream(), this.m_keyExchangeManager, new SecureRandom());
            this.m_socketHandler.addObserver(this);
            this.m_packetCounter = this.m_packetCounter != null ? new PacketCounter(this.m_packetCounter.getProcessedPackets()) : new PacketCounter();
            this.m_multiplexer.addObserver(this.m_packetCounter);
            this.m_packetCounter.addObserver(this);
            e2 = this.m_internalSynchronizationForDummyTraffic;
            synchronized (e2) {
                this.m_dummyTrafficControlChannel = new DummyTrafficControlChannel(this.m_multiplexer, a_serviceContainer);
                this.m_dummyTrafficControlChannel.setDummyTrafficInterval(this.m_dummyTrafficInterval);
            }
            if (ENABLE_CONTROL_CHANNEL_TEST) {
                TestControlChannel t = new TestControlChannel(this.m_multiplexer, a_serviceContainer);
                t.setMessageInterval(30000);
            }
            try {
                this.finishInitialization(this.m_multiplexer, this.m_keyExchangeManager, this.m_packetCounter, a_serviceContainer, this.m_keyExchangeManager.getConnectedCascade());
            }
            catch (AnonServiceException a_e) {
                this.shutdown(!a_serviceContainer.isReconnectedAutomatically());
                throw a_e;
            }
            this.m_currentService = Database.getInstance(class$anon$infoservice$MixCascade == null ? (class$anon$infoservice$MixCascade = AnonClient.class$("anon.infoservice.MixCascade")) : class$anon$infoservice$MixCascade).getEntryById(this.m_keyExchangeManager.getConnectedCascade().getId()) == null || !a_mixCascade.getId().equals(this.m_keyExchangeManager.getConnectedCascade().getId()) ? this.m_keyExchangeManager.getConnectedCascade() : a_mixCascade;
            TrustModel.cleanAttributeWhitelist(this.m_currentService);
            if (this.m_directProxy != null) {
                this.m_directProxy.stop();
            }
            this.connectionEstablished(this.m_currentService);
        }
    }

    private void connectionEstablished(final AnonServerDescription a_serverDescription) {
        AnonClient.resetInternalLoginTimeout();
        this.m_connected = true;
        TrustModel.cleanAttributeWhitelist(null);
        Thread notificationThread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Vector vector = AnonClient.this.m_eventListeners;
                synchronized (vector) {
                    Enumeration eventListenersList = AnonClient.this.m_eventListeners.elements();
                    while (eventListenersList.hasMoreElements()) {
                        ((AnonServiceEventListener)eventListenersList.nextElement()).connectionEstablished(a_serverDescription);
                    }
                }
            }
        }, "AnonClient: ConnectionEstablished notification");
        notificationThread.setDaemon(true);
        notificationThread.start();
        LogHolder.log(6, LogType.NET, "Connected to MixCascade '" + a_serverDescription.toString() + "'!");
    }

    private void finishInitialization(Multiplexer a_multiplexer, KeyExchangeManager a_keyExchangeManager, PacketCounter a_packetCounter, IServiceContainer a_serviceContainer, MixCascade a_cascade) throws AnonServiceException {
        if (a_keyExchangeManager.isProtocolWithTimestamp()) {
            MixParameters[] mixesWithReplayDetection = a_keyExchangeManager.getMixParameters();
            if (a_keyExchangeManager.getFirstMixSymmetricCipher() != null) {
                mixesWithReplayDetection = new MixParameters[a_keyExchangeManager.getMixParameters().length - 1];
                for (int i = 0; i < a_keyExchangeManager.getMixParameters().length - 1; ++i) {
                    mixesWithReplayDetection[i] = a_keyExchangeManager.getMixParameters()[i + 1];
                }
            }
            try {
                new TimestampUpdater(mixesWithReplayDetection, new ReplayControlChannel(a_multiplexer, a_serviceContainer));
            }
            catch (Exception e) {
                LogHolder.log(3, LogType.NET, "Fetching of timestamps failed - closing connection.", e);
                throw new AnonServiceException(a_cascade, "Fetching of timestamps failed - closing connection.");
            }
        }
        if (a_keyExchangeManager.isPaymentRequired()) {
            AIControlChannel aiControlChannel = new AIControlChannel(a_multiplexer, a_packetCounter, a_serviceContainer, a_cascade);
            aiControlChannel.addAIListener(new IAIEventListener(){

                public void accountEmpty(PayAccount a_account, MixCascade a_cascade) {
                    LogHolder.log(4, LogType.PAY, "Account empty: " + a_account + " Reconnect!");
                    AnonClient.this.reconnect(a_cascade, null);
                }

                public void accountChanged(PayAccount a_account, MixCascade a_cascade) {
                    LogHolder.log(4, LogType.PAY, "Account changed: " + a_account + " Reconnect!");
                    AnonClient.this.reconnect(a_cascade, null);
                }
            });
            aiControlChannel.setAILoginTimeout(m_loginTimeout);
            aiControlChannel.sendAccountCert();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocketHandler() {
        Object object = this.m_internalSynchronizationForSocket;
        synchronized (object) {
            if (this.m_socketHandler != null) {
                this.m_socketHandler.closeSocket();
                this.m_socketHandler = null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ms_preferredConnectionPort = 0;
        ms_vecTimedOutPorts = new Vector();
        ms_queuePacketCount = new JobQueue("AnonClient Packet count updater");
        AnonClient.resetInternalLoginTimeout();
    }

    private static interface StatusThread
    extends Runnable {
        public AnonServiceException getStatus();
    }
}

