/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.crypto.SymCipher;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class MixPacket {
    private static final int PACKET_SIZE = 998;
    private static final int NON_DATA_LENGTH = 6;
    public static final short FLAG_CHANNEL_DATA = 0;
    public static final short FLAG_CHANNEL_CLOSE = 1;
    public static final short FLAG_CHANNEL_OPEN = 8;
    public static final short FLAG_CHANNEL_DUMMY = 16;
    public static final short FLAG_DEBUG = 32;
    private static final SecureRandom ms_secureRandom = new SecureRandom();
    private int m_channelId;
    private short m_channelFlags;
    private byte[] m_payloadData;
    private Vector m_sendCallbackHandlers = new Vector();

    public static int getPacketSize() {
        return 998;
    }

    public static int getPayloadSize() {
        return 992;
    }

    public MixPacket(InputStream a_inputStream, SymCipher a_inputStreamCipher) throws IOException {
        byte[] rawPacket = new byte[998];
        DataInputStream sourceStream = new DataInputStream(a_inputStream);
        try {
            sourceStream.readFully(rawPacket);
            LogHolder.log(7, LogType.TRANSPORT, "PacketReceived: " + System.currentTimeMillis());
        }
        catch (EOFException eofe) {
            LogHolder.log(4, LogType.NET, Thread.currentThread().getName() + ": received a truncated packet from a mix: ", eofe);
            throw eofe;
        }
        catch (IOException a_e) {
            try {
                Class<?> classSocketTimeoutException = Class.forName("java.net.SocketTimeoutException");
                if (!classSocketTimeoutException.isAssignableFrom(a_e.getClass())) {
                    throw a_e;
                }
                sourceStream.readFully(rawPacket);
            }
            catch (ClassNotFoundException e) {
                throw a_e;
            }
        }
        if (a_inputStreamCipher != null) {
            a_inputStreamCipher.encryptAES1(rawPacket, 0, rawPacket, 0, 16);
        }
        DataInputStream packetDataStream = new DataInputStream(new ByteArrayInputStream(rawPacket, 0, 6));
        this.m_channelId = packetDataStream.readInt();
        this.m_channelFlags = packetDataStream.readShort();
        this.m_payloadData = new byte[rawPacket.length - 6];
        System.arraycopy(rawPacket, 6, this.m_payloadData, 0, rawPacket.length - 6);
    }

    public MixPacket(int a_channelId) {
        this.m_channelId = a_channelId;
        this.m_channelFlags = 0;
        this.m_payloadData = new byte[992];
        ms_secureRandom.nextBytes(this.m_payloadData);
    }

    public int getChannelId() {
        return this.m_channelId;
    }

    public short getChannelFlags() {
        return this.m_channelFlags;
    }

    public void setChannelFlags(short a_channelFlags) {
        this.m_channelFlags = a_channelFlags;
    }

    public byte[] getPayloadData() {
        return this.m_payloadData;
    }

    public byte[] getRawPacket() {
        ByteArrayOutputStream packetHeaderStream = new ByteArrayOutputStream();
        DataOutputStream packetHeaderDataStream = new DataOutputStream(packetHeaderStream);
        try {
            packetHeaderDataStream.writeInt(this.m_channelId);
            packetHeaderDataStream.writeShort(this.m_channelFlags);
            packetHeaderDataStream.flush();
        }
        catch (IOException e) {
            // empty catch block
        }
        byte[] rawPacket = new byte[998];
        byte[] packetHeader = packetHeaderStream.toByteArray();
        System.arraycopy(packetHeader, 0, rawPacket, 0, packetHeader.length);
        System.arraycopy(this.m_payloadData, 0, rawPacket, packetHeader.length, this.m_payloadData.length);
        return rawPacket;
    }

    public Vector getSendCallbackHandlers() {
        return this.m_sendCallbackHandlers;
    }
}

