/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AsymmetricCryptoKeyPair;
import anon.crypto.ByteSignature;
import anon.crypto.CertificationRequestInfo;
import anon.crypto.IMyPublicKey;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

final class CertificationRequest
extends DERSequence {
    private CertificationRequestInfo m_certificationRequestInfo;
    private DERBitString m_signature;

    public CertificationRequest(CertificationRequestInfo a_certificationRequestInfo, AsymmetricCryptoKeyPair a_keyPair) {
        super(CertificationRequest.createRequest(a_certificationRequestInfo, a_keyPair.getPrivate().getSignatureAlgorithm().getIdentifier(), new DERBitString(ByteSignature.sign(CertificationRequest.DERtoBytes(a_certificationRequestInfo), a_keyPair))));
        this.m_certificationRequestInfo = a_certificationRequestInfo;
        this.m_signature = new DERBitString(ByteSignature.sign(CertificationRequest.DERtoBytes(a_certificationRequestInfo), a_keyPair));
    }

    CertificationRequest(ASN1Sequence a_sequence) {
        super(CertificationRequest.createRequest((ASN1Sequence)a_sequence.getObjectAt(0), AlgorithmIdentifier.getInstance(a_sequence.getObjectAt(1)), (DERBitString)a_sequence.getObjectAt(2)));
        this.m_certificationRequestInfo = new CertificationRequestInfo((ASN1Sequence)a_sequence.getObjectAt(0));
        this.m_signature = (DERBitString)a_sequence.getObjectAt(2);
    }

    public IMyPublicKey getPublicKey() {
        return this.m_certificationRequestInfo.getPublicKey();
    }

    public CertificationRequestInfo getCertificationRequestInfo() {
        return this.m_certificationRequestInfo;
    }

    public boolean verify() {
        byte[] input = CertificationRequest.DERtoBytes(this.m_certificationRequestInfo);
        byte[] sig = this.m_signature.getBytes();
        IMyPublicKey testKey = this.getPublicKey();
        return ByteSignature.verify(input, sig, testKey);
    }

    private static ASN1EncodableVector createRequest(ASN1Sequence a_certificationRequestInfo, AlgorithmIdentifier a_algorithmIdentifier, DERBitString a_signature) {
        ASN1EncodableVector certificateRequest = new ASN1EncodableVector();
        certificateRequest.add(a_certificationRequestInfo);
        certificateRequest.add(a_algorithmIdentifier);
        certificateRequest.add(a_signature);
        return certificateRequest;
    }

    private static byte[] DERtoBytes(ASN1Encodable a_object) {
        ByteArrayOutputStream DERasBytes = new ByteArrayOutputStream();
        try {
            new DEROutputStream(DERasBytes).writeObject(a_object);
        }
        catch (IOException a_e) {
            throw new RuntimeException("Could not write DER data to bytes.");
        }
        return DERasBytes.toByteArray();
    }
}

