/*
 * Decompiled with CFR 0.152.
 */
package anon.infoservice;

import anon.crypto.CertPath;
import anon.crypto.IVerifyable;
import anon.crypto.JAPCertificate;
import anon.crypto.MultiCertPath;
import anon.crypto.SignatureVerifier;
import anon.crypto.XMLSignature;
import anon.infoservice.AbstractDistributableCertifiedDatabaseEntry;
import anon.infoservice.DataRetentionInformation;
import anon.infoservice.Database;
import anon.infoservice.ListenerInterface;
import anon.infoservice.MixCascadeExitAddresses;
import anon.infoservice.ServiceLocation;
import anon.infoservice.ServiceOperator;
import anon.infoservice.ServiceSoftware;
import anon.pay.xml.XMLPriceCertificate;
import anon.terms.TermsAndConditionsMixInfo;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MixInfo
extends AbstractDistributableCertifiedDatabaseEntry
implements IVerifyable,
Database.IWebInfo {
    public static final String NAME_TYPE_MIX = "Mix";
    public static final String NAME_TYPE_OPERATOR = "Operator";
    public static final String XML_ELEMENT_CONTAINER_NAME = "Mixes";
    public static final String XML_ELEMENT_NAME = "Mix";
    public static final String XML_ELEMENT_MIX_NAME = "Name";
    public static final String XML_ATTRIBUTE_NAME_FOR_CASCADE = "forCascade";
    public static final String XML_ELEM_PREMIUM_REMINDER = "PaymentReminderProbability";
    public static final String XML_ELEMENT_WEBINFO_CONTAINER = "MixWebInfos";
    public static final String INFOSERVICE_COMMAND_WEBINFOS = "/mixwebinfos";
    public static final String INFOSERVICE_COMMAND_WEBINFO = "/mixwebinfo/";
    private static final String XML_ELEMENT_WEBINFO = "MixWebInfo";
    private static final String XML_ELEM_SERVER_MONITORING = "ServerMonitoring";
    private static final String XML_ATTR_PAYMENT = "payment";
    public static final int FIRST_MIX = 0;
    public static final int MIDDLE_MIX = 1;
    public static final int LAST_MIX = 2;
    private int m_type;
    private int m_iPremiumProbability = -1;
    private DataRetentionInformation m_drInfo;
    private boolean m_bPayment = false;
    private boolean m_dynamic = false;
    private boolean m_bSocks = false;
    private final Vector m_vecVisibleAdresses = new Vector();
    private final Vector m_vecListenerAdresses = new Vector();
    private final Vector m_vecListenerInterfaces = new Vector();
    private final Vector m_vecListenerMonitoring = new Vector();
    private String m_mixId;
    private long m_lastUpdate;
    private long m_serial;
    private String m_name;
    private String m_nameFragmentForCascade;
    private boolean m_bUseCascadeNameFragment = false;
    private ServiceLocation m_mixLocation;
    private ServiceOperator m_mixOperator;
    private ServiceSoftware m_mixSoftware;
    private boolean m_freeMix;
    private Element m_xmlStructure;
    private MultiCertPath m_mixCertPath;
    private XMLPriceCertificate m_priceCert;
    private long m_prepaidInterval;
    private XMLSignature m_mixSignature;
    private boolean m_bFromCascade;
    private TermsAndConditionsMixInfo m_mixTnCInfo = null;
    static /* synthetic */ Class class$anon$infoservice$ServiceOperator;

    public MixInfo(Element a_mixNode) throws XMLParseException {
        this(a_mixNode, 0L);
    }

    public MixInfo(Element a_mixNode, long a_expireTime) throws XMLParseException {
        this(a_mixNode, a_expireTime, false);
    }

    public MixInfo(MultiCertPath a_certPath) {
        super(Long.MAX_VALUE);
        if (a_certPath == null) {
            throw new IllegalArgumentException("No Mix cert path!");
        }
        Vector<JAPCertificate> certificates = new Vector<JAPCertificate>();
        Vector certPaths = a_certPath.getPaths();
        for (int i = 0; i < certPaths.size(); ++i) {
            certificates.addElement(((CertPath)certPaths.elementAt(i)).getFirstCertificate());
        }
        this.m_mixId = JAPCertificate.calculateXORofSKIs(certificates);
        this.m_name = a_certPath.getSubject().getCommonName();
        if (this.m_name == null) {
            this.m_name = "Mix";
        }
        this.m_type = -1;
        this.m_bFromCascade = true;
        this.m_mixCertPath = a_certPath;
        this.m_lastUpdate = 0L;
        this.m_serial = 0L;
        CertPath path = a_certPath.getPath();
        this.m_mixLocation = new ServiceLocation(null, path.getFirstCertificate());
        this.m_mixOperator = new ServiceOperator(null, a_certPath, 0L);
        this.m_freeMix = false;
        this.m_prepaidInterval = 4000000L;
    }

    public MixInfo(String a_mixID, MultiCertPath a_certPath, XMLPriceCertificate a_priceCert, long a_prepaidInterval) {
        super(Long.MAX_VALUE);
        this.m_mixId = a_mixID;
        this.m_name = a_mixID;
        this.m_type = -1;
        this.m_bFromCascade = true;
        this.m_mixCertPath = a_certPath;
        this.m_lastUpdate = 0L;
        this.m_serial = 0L;
        JAPCertificate cert = null;
        if (a_certPath != null) {
            cert = a_certPath.getPath().getFirstCertificate();
        }
        this.m_mixLocation = new ServiceLocation(null, cert);
        this.m_mixOperator = new ServiceOperator(null, a_certPath, 0L);
        this.m_freeMix = false;
        this.m_priceCert = a_priceCert;
        if (this.m_priceCert != null) {
            this.m_bPayment = true;
        }
        this.m_prepaidInterval = a_prepaidInterval;
    }

    public MixInfo(Element a_mixNode, long a_expireTime, boolean a_bFromCascade) throws XMLParseException {
        super(a_expireTime <= 0L ? System.currentTimeMillis() + 900000L : a_expireTime);
        this.m_bFromCascade = a_bFromCascade;
        this.m_mixId = XMLUtil.parseAttribute((Node)a_mixNode, "id", null);
        if (this.m_mixId == null) {
            throw new XMLParseException("##__null__##", "id");
        }
        try {
            this.m_mixSignature = SignatureVerifier.getInstance().getVerifiedXml(a_mixNode, 1);
            if (this.m_mixSignature != null) {
                this.m_mixCertPath = this.m_mixSignature.getMultiCertPath();
            } else {
                LogHolder.log(7, LogType.MISC, "No signature node found while looking for MixCascade certificate.");
            }
        }
        catch (Exception e) {
            LogHolder.log(3, LogType.MISC, "Error while looking for appended certificates in the MixInfo structure: " + e.toString());
        }
        if (!this.checkId()) {
            throw new XMLParseException("##__root__##", "Malformed Mix ID: " + this.m_mixId);
        }
        this.m_iPremiumProbability = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_mixNode, XML_ELEM_PREMIUM_REMINDER), -1);
        this.m_bSocks = XMLUtil.parseAttribute(XMLUtil.getFirstChildByName(a_mixNode, "Proxies"), "socks5Support", false);
        Node operatorNode = XMLUtil.getFirstChildByName(a_mixNode, NAME_TYPE_OPERATOR);
        Node locationNode = XMLUtil.getFirstChildByName(a_mixNode, "Location");
        Node lastUpdateNode = XMLUtil.getFirstChildByName(a_mixNode, "LastUpdate");
        Node softwareNode = XMLUtil.getFirstChildByName(a_mixNode, "Software");
        Node prepaidIntervalNode = XMLUtil.getFirstChildByName(a_mixNode, "PrepaidIntervalKbytes");
        Node priceCertNode = XMLUtil.getFirstChildByName(a_mixNode, "PriceCertificate");
        if (priceCertNode != null) {
            this.m_priceCert = new XMLPriceCertificate((Element)priceCertNode);
            if (!this.m_priceCert.getSubjectKeyIdentifier().equals(this.getId())) {
                String message = "SKI in price certificate differs from Mix ID! SKI: $" + this.m_priceCert.getSubjectKeyIdentifier() + "$ MixID: $" + this.getId() + "$";
                LogHolder.log(3, LogType.PAY, message);
            }
        }
        if (a_expireTime < Long.MAX_VALUE) {
            this.parseVisibleAdresses(a_mixNode);
            this.parseListenerAdresses(a_mixNode);
        }
        Element listenerInterfacesNode = (Element)XMLUtil.getFirstChildByName(a_mixNode, "ListenerInterfaces");
        XMLUtil.assertNotNull(listenerInterfacesNode);
        NodeList listenerInterfaceNodes = listenerInterfacesNode.getElementsByTagName("ListenerInterface");
        if (listenerInterfaceNodes.getLength() == 0) {
            throw new XMLParseException("First Mix has no ListenerInterfaces in its XML structure.");
        }
        for (int i = 0; i < listenerInterfaceNodes.getLength(); ++i) {
            this.m_vecListenerInterfaces.addElement(new ListenerInterface((Element)listenerInterfaceNodes.item(i)));
        }
        Element elemMonitoring = (Element)XMLUtil.getFirstChildByName(a_mixNode, XML_ELEM_SERVER_MONITORING);
        if (elemMonitoring != null) {
            listenerInterfacesNode = (Element)XMLUtil.getFirstChildByName(elemMonitoring, "ListenerInterfaces");
            if (listenerInterfacesNode != null) {
                listenerInterfaceNodes = listenerInterfacesNode.getElementsByTagName("ListenerInterface");
                for (int i = 0; i < listenerInterfaceNodes.getLength(); ++i) {
                    this.m_vecListenerMonitoring.addElement(new ListenerInterface((Element)listenerInterfaceNodes.item(i)));
                }
            } else {
                String host = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemMonitoring, "Host"), null);
                int port = XMLUtil.parseValue(XMLUtil.getFirstChildByName(elemMonitoring, "Port"), -1);
                if (host != null && port >= 0) {
                    this.m_vecListenerMonitoring.addElement(new ListenerInterface(host, port));
                }
            }
        }
        if (!a_bFromCascade) {
            Node typeNode = XMLUtil.getFirstChildByName(a_mixNode, "MixType");
            XMLUtil.assertNotNull(typeNode);
            this.m_type = this.parseMixType(XMLUtil.parseValue(typeNode, null));
            this.m_bPayment = XMLUtil.parseAttribute(typeNode, XML_ATTR_PAYMENT, false);
            this.m_dynamic = XMLUtil.parseValue(XMLUtil.getFirstChildByName(a_mixNode, "Dynamic"), false);
            if (softwareNode == null) {
                throw new XMLParseException("Software", this.m_mixId);
            }
            if (lastUpdateNode == null) {
                throw new XMLParseException("LastUpdate", this.m_mixId);
            }
            this.m_lastUpdate = XMLUtil.parseValue(lastUpdateNode, 0L);
        } else {
            this.m_lastUpdate = System.currentTimeMillis() - 900000L;
        }
        this.m_prepaidInterval = XMLUtil.parseValue(prepaidIntervalNode, 4000L) * 1000L;
        this.m_serial = XMLUtil.parseValue(lastUpdateNode, 0L);
        Node tncInfoRoot = XMLUtil.getFirstChildByName(a_mixNode, "TermsAndConditionsInfos");
        TermsAndConditionsMixInfo termsAndConditionsMixInfo = this.m_mixTnCInfo = tncInfoRoot != null ? new TermsAndConditionsMixInfo(tncInfoRoot) : null;
        if (softwareNode != null) {
            this.m_mixSoftware = new ServiceSoftware(softwareNode);
        }
        CertPath path = null;
        if (this.m_mixCertPath != null) {
            path = this.m_mixCertPath.getPath();
        }
        if (path != null) {
            this.m_mixLocation = new ServiceLocation(locationNode, path.getFirstCertificate());
            this.m_mixOperator = new ServiceOperator(operatorNode, this.m_mixCertPath, this.m_lastUpdate);
        } else {
            this.m_mixLocation = new ServiceLocation(locationNode, null);
            this.m_mixOperator = new ServiceOperator(operatorNode, null, this.m_lastUpdate);
        }
        Node nodeDR = XMLUtil.getFirstChildByName(a_mixNode, "DataRetention");
        if (nodeDR != null) {
            if (this.m_mixOperator.getOrganization() != null && (this.m_mixOperator.getOrganization().indexOf("JAP-Team") >= 0 || this.m_mixOperator.getOrganization().indexOf("Independent Centre") >= 0) && XMLUtil.getFirstChildByName(nodeDR, "Description") == null) {
                nodeDR = XMLUtil.importNode(XMLUtil.createDocument(), nodeDR, true);
                Element elemDesc = nodeDR.getOwnerDocument().createElement("Description");
                XMLUtil.setAttribute(elemDesc, "lang", "en");
                Element elemURL = nodeDR.getOwnerDocument().createElement("URL");
                XMLUtil.setValue((Node)elemURL, "http://anon.inf.tu-dresden.de/dataretention_en.html");
                elemDesc.appendChild(elemURL);
                nodeDR.appendChild(elemDesc);
                elemDesc = nodeDR.getOwnerDocument().createElement("Description");
                XMLUtil.setAttribute(elemDesc, "lang", "de");
                elemURL = nodeDR.getOwnerDocument().createElement("URL");
                XMLUtil.setValue((Node)elemURL, "http://anon.inf.tu-dresden.de/dataretention_de.html");
                elemDesc.appendChild(elemURL);
                nodeDR.appendChild(elemDesc);
            }
            this.m_drInfo = new DataRetentionInformation((Element)nodeDR);
        }
        ServiceOperator currentSO = (ServiceOperator)Database.getInstance(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = MixInfo.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator).getEntryById(this.m_mixOperator.getId());
        if (this.m_mixOperator.getCertPath() != null && this.m_mixOperator.getCertPath().getPaths() != null && this.m_mixOperator.getCertPath().getPaths().size() > 0) {
            if (currentSO == null || currentSO.getCertPath() == null || currentSO.getCertPath().getPaths() == null || currentSO.getCertPath().getPaths().size() == 0 || currentSO.getOrganization() == null) {
                Database.getInstance(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = MixInfo.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator).update(this.m_mixOperator);
            } else {
                Vector vecNewCertPaths = this.m_mixOperator.getCertPath().getPaths();
                Vector vecOldCertPaths = currentSO.getCertPath().getPaths();
                for (int i = 0; i < vecNewCertPaths.size(); ++i) {
                    if (vecNewCertPaths.size() < i + 1 || vecOldCertPaths.size() < i + 1) {
                        if (vecNewCertPaths.size() <= vecOldCertPaths.size()) break;
                        Database.getInstance(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = MixInfo.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator).update(this.m_mixOperator);
                        break;
                    }
                    JAPCertificate certNew = ((CertPath)vecNewCertPaths.elementAt(i)).getSecondCertificate();
                    JAPCertificate certCurrent = ((CertPath)vecOldCertPaths.elementAt(i)).getSecondCertificate();
                    if (certNew == null) break;
                    if (certCurrent != null && !certNew.getValidity().getValidTo().after(certCurrent.getValidity().getValidTo())) continue;
                    Database.getInstance(class$anon$infoservice$ServiceOperator == null ? (class$anon$infoservice$ServiceOperator = MixInfo.class$("anon.infoservice.ServiceOperator")) : class$anon$infoservice$ServiceOperator).update(this.m_mixOperator);
                    break;
                }
            }
        }
        this.m_freeMix = false;
        this.m_xmlStructure = a_mixNode;
        Node nameNode = XMLUtil.getFirstChildByName(a_mixNode, XML_ELEMENT_MIX_NAME);
        this.m_name = XMLUtil.parseValue(nameNode, null);
        String nameType = XMLUtil.parseAttribute(nameNode, XML_ATTRIBUTE_NAME_FOR_CASCADE, "");
        if (nameType.equals(NAME_TYPE_OPERATOR) && this.m_mixOperator != null) {
            this.m_nameFragmentForCascade = this.m_mixOperator != null ? this.m_mixOperator.getCommonName() : null;
            this.m_bUseCascadeNameFragment = true;
        } else if (nameType.equals("Mix") && this.m_mixLocation != null) {
            this.m_nameFragmentForCascade = this.m_mixLocation.getCommonName();
            this.m_bUseCascadeNameFragment = true;
        }
        if (this.m_nameFragmentForCascade != null && this.m_nameFragmentForCascade.equals("AN.ON Operator Certificate")) {
            this.m_nameFragmentForCascade = this.m_mixLocation != null && this.m_mixLocation.getCommonName() != null && !this.m_mixLocation.getCommonName().startsWith("<Mix id=") ? this.m_mixLocation.getCommonName() : null;
        }
        if (this.m_nameFragmentForCascade == null || this.m_nameFragmentForCascade.startsWith("<Mix id=")) {
            if (this.m_name != null) {
                this.m_nameFragmentForCascade = this.m_name;
            } else {
                LogHolder.log(4, LogType.MISC, "Could not set cascade name fragment for Mix!");
                this.m_nameFragmentForCascade = "Unknown Mix";
            }
        }
        if (this.m_name == null) {
            this.m_name = this.m_mixLocation != null && this.m_mixLocation.getCommonName() != null && !this.m_mixLocation.getCommonName().startsWith("<Mix id=") ? this.m_mixLocation.getCommonName() : this.m_nameFragmentForCascade;
        }
    }

    public int getPremiumProbability() {
        if (this.m_iPremiumProbability >= 0) {
            return 0;
        }
        return this.m_iPremiumProbability;
    }

    private void parseListenerAdresses(Node nodeMix) {
        this.parseVisibleAdresses(nodeMix, "ListenerInterfaces", "ListenerInterface", this.m_vecListenerAdresses);
    }

    private void parseVisibleAdresses(Node nodeMix) {
        Node nodeTmp = XMLUtil.getFirstChildByName(nodeMix, "Proxies");
        if (nodeTmp == null) {
            return;
        }
        nodeTmp = XMLUtil.getFirstChildByName(nodeTmp, "Proxy");
        while (nodeTmp != null) {
            if (nodeTmp.getNodeName().equals("Proxy")) {
                this.parseVisibleAdresses(nodeTmp, "VisibleAddresses", "VisibleAddress", this.m_vecVisibleAdresses);
            }
            nodeTmp = XMLUtil.getNextSibling(nodeTmp);
        }
    }

    private void parseVisibleAdresses(Node nodeMix, String a_containerName, String a_nodeName, Vector a_storage) {
        Node nodeVisibleAddresses = XMLUtil.getFirstChildByName(nodeMix, a_containerName);
        Node nodeVisibleAddress = XMLUtil.getFirstChildByName(nodeVisibleAddresses, a_nodeName);
        while (nodeVisibleAddress != null) {
            Node nodeHost;
            String strHost;
            if (nodeVisibleAddress.getNodeName().equals(a_nodeName) && (strHost = XMLUtil.parseValue(nodeHost = XMLUtil.getFirstChildByName(nodeVisibleAddress, "Host"), null)) != null) {
                try {
                    InetAddress address = InetAddress.getByName(strHost);
                    if (MixCascadeExitAddresses.isValidAddress(address) && !a_storage.contains(address)) {
                        a_storage.addElement(address);
                    }
                }
                catch (UnknownHostException a_e) {
                    LogHolder.log(6, LogType.NET, a_e);
                }
                catch (Exception e) {
                    LogHolder.log(2, LogType.NET, e);
                }
            }
            nodeVisibleAddress = XMLUtil.getNextSibling(nodeVisibleAddress);
        }
    }

    private int parseMixType(String nodeValue) throws XMLParseException {
        if ("FirstMix".equals(nodeValue)) {
            return 0;
        }
        if ("MiddleMix".equals(nodeValue)) {
            return 1;
        }
        if ("LastMix".equals(nodeValue)) {
            return 2;
        }
        throw new XMLParseException("MixType", "Unkonwn type: " + nodeValue);
    }

    public boolean isPersistanceDeletionAllowed() {
        return XMLUtil.getStorageMode() == 2;
    }

    public void deletePersistence() {
        if (this.isPersistanceDeletionAllowed()) {
            this.m_mixSignature = null;
            this.m_xmlStructure = null;
        }
    }

    public Vector getVisibleAddresses() {
        return (Vector)this.m_vecVisibleAdresses.clone();
    }

    public Vector getListenerAddresses() {
        return (Vector)this.m_vecListenerAdresses.clone();
    }

    public Vector getListenerInterfaces() {
        return (Vector)this.m_vecListenerInterfaces.clone();
    }

    public Vector getMonitoringListenerInterfaces() {
        return (Vector)this.m_vecListenerMonitoring.clone();
    }

    public String getId() {
        return this.m_mixId;
    }

    public boolean isSocks5Supported() {
        return this.m_bSocks;
    }

    public boolean isFromCascade() {
        return this.m_bFromCascade;
    }

    public long getLastUpdate() {
        return this.m_lastUpdate;
    }

    public long getVersionNumber() {
        return this.m_serial;
    }

    public String getName() {
        return this.m_name;
    }

    public DataRetentionInformation getDataRetentionInformation() {
        return this.m_drInfo;
    }

    public boolean isVerified() {
        if (this.m_mixCertPath != null) {
            return this.m_mixCertPath.isVerified();
        }
        return false;
    }

    public boolean isValid() {
        if (this.m_mixCertPath != null) {
            return this.m_mixCertPath.isValid(new Date());
        }
        return false;
    }

    public XMLPriceCertificate getPriceCertificate() {
        return this.m_priceCert;
    }

    public long getPrepaidInterval() {
        return this.m_prepaidInterval;
    }

    public void setPriceCertificate(XMLPriceCertificate newPriceCert) {
        this.m_priceCert = newPriceCert;
    }

    public MultiCertPath getCertPath() {
        return this.m_mixCertPath;
    }

    public XMLSignature getSignature() {
        return this.m_mixSignature;
    }

    public ServiceLocation getServiceLocation() {
        return this.m_mixLocation;
    }

    public ServiceOperator getServiceOperator() {
        return this.m_mixOperator;
    }

    public ServiceSoftware getServiceSoftware() {
        return this.m_mixSoftware;
    }

    public boolean isFreeMix() {
        return this.m_freeMix;
    }

    public void setFreeMix(boolean a_freeMix) {
        this.m_freeMix = a_freeMix;
    }

    public String getPostFile() {
        String postFileName = "/helo";
        if (this.isFreeMix()) {
            postFileName = "/configure";
        }
        return postFileName;
    }

    public Element getXmlStructure() {
        return this.m_xmlStructure;
    }

    public int getType() {
        return this.m_type;
    }

    public boolean isPayment() {
        return this.m_bPayment;
    }

    public String getTypeAsString() {
        switch (this.m_type) {
            case 0: {
                return "First Mix";
            }
            case 1: {
                return "Middle Mix";
            }
            case 2: {
                return "Last Mix";
            }
        }
        return "Unknown type!";
    }

    public boolean isDynamic() {
        return this.m_dynamic;
    }

    public String getFirstHostName() throws Exception {
        for (int i = 0; i < this.m_vecListenerInterfaces.size(); ++i) {
            ListenerInterface listenInterface = (ListenerInterface)this.m_vecListenerInterfaces.elementAt(i);
            if (listenInterface.isHidden()) continue;
            return listenInterface.getHost();
        }
        return "";
    }

    public int getFirstPort() throws Exception {
        for (int i = 0; i < this.m_vecListenerInterfaces.size(); ++i) {
            ListenerInterface listenInterface = (ListenerInterface)this.m_vecListenerInterfaces.elementAt(i);
            if (listenInterface.isHidden()) continue;
            return listenInterface.getPort();
        }
        return -1;
    }

    public boolean isCascadaNameFragmentUsed() {
        return this.m_bUseCascadeNameFragment;
    }

    public String getNameFragmentForCascade() {
        return this.m_nameFragmentForCascade;
    }

    public TermsAndConditionsMixInfo getTermsAndConditionMixInfo() {
        return this.m_mixTnCInfo;
    }

    public Element getWebInfo(Document webInfoDoc) {
        if (webInfoDoc == null) {
            return null;
        }
        Element rootElement = webInfoDoc.createElement(XML_ELEMENT_WEBINFO);
        XMLUtil.setAttribute(rootElement, XML_ATTR_PAYMENT, this.isPayment());
        XMLUtil.setAttribute(rootElement, "id", this.getId());
        Element currentMixOperatorElement = null;
        Element currentMixLocationElement = null;
        if (this.getCertPath() == null) {
            return null;
        }
        XMLUtil.createChildElementWithValue(rootElement, XML_ELEMENT_MIX_NAME, this.getName());
        CertPath path = this.getCertPath().getPath();
        currentMixOperatorElement = new ServiceOperator(null, this.getCertPath(), 0L).toXMLElement(webInfoDoc);
        currentMixLocationElement = new ServiceLocation(null, path.getFirstCertificate()).toXMLElement(webInfoDoc);
        if (currentMixOperatorElement != null) {
            rootElement.appendChild(currentMixOperatorElement);
        }
        if (currentMixLocationElement != null) {
            rootElement.appendChild(currentMixLocationElement);
        }
        this.appendListenerInterfaces(rootElement, this.m_vecListenerInterfaces);
        if (this.m_vecListenerMonitoring.size() > 0) {
            this.appendListenerInterfaces(XMLUtil.createChildElement(rootElement, XML_ELEM_SERVER_MONITORING), this.m_vecListenerMonitoring);
        }
        rootElement.appendChild(this.m_mixCertPath.toXmlElement(webInfoDoc));
        return rootElement;
    }

    private void appendListenerInterfaces(Element a_rootElement, Vector a_listenerInterfaces) {
        Element listenerInterfaces = XMLUtil.createChildElement(a_rootElement, "ListenerInterfaces");
        Hashtable<String, Element> hashInterfaceHosts = new Hashtable<String, Element>();
        Hashtable<String, Element> hashHiddenInterfaceHosts = new Hashtable<String, Element>();
        Hashtable<String, Element> hashVirtualInterfaceHosts = new Hashtable<String, Element>();
        for (int i = 0; i < a_listenerInterfaces.size(); ++i) {
            Element elemInterface;
            ListenerInterface listenerInterface = (ListenerInterface)a_listenerInterfaces.elementAt(i);
            if (listenerInterface.isHidden() && hashHiddenInterfaceHosts.containsKey(listenerInterface.getHost())) {
                elemInterface = (Element)hashHiddenInterfaceHosts.get(listenerInterface.getHost());
            } else if (listenerInterface.isVirtual() && hashVirtualInterfaceHosts.containsKey(listenerInterface.getHost())) {
                elemInterface = (Element)hashVirtualInterfaceHosts.get(listenerInterface.getHost());
            } else if (hashInterfaceHosts.containsKey(listenerInterface.getHost())) {
                elemInterface = (Element)hashInterfaceHosts.get(listenerInterface.getHost());
            } else {
                elemInterface = XMLUtil.createChildElement(listenerInterfaces, "ListenerInterface");
                if (listenerInterface.isVirtual()) {
                    XMLUtil.setAttribute(elemInterface, "virtual", listenerInterface.isVirtual());
                    hashVirtualInterfaceHosts.put(listenerInterface.getHost(), elemInterface);
                } else if (listenerInterface.isHidden()) {
                    XMLUtil.setAttribute(elemInterface, "hidden", listenerInterface.isHidden());
                    hashHiddenInterfaceHosts.put(listenerInterface.getHost(), elemInterface);
                } else {
                    hashInterfaceHosts.put(listenerInterface.getHost(), elemInterface);
                }
                XMLUtil.setAttribute(elemInterface, "Host", listenerInterface.getHost());
            }
            if (listenerInterface.getProtocol() == 5) continue;
            XMLUtil.createChildElementWithValue(elemInterface, "Port", "" + listenerInterface.getPort());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

