/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import anon.client.PacketCounter;
import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.MyDSAPrivateKey;
import anon.crypto.MyRSAPrivateKey;
import anon.crypto.XMLEncryption;
import anon.pay.BIConnection;
import anon.pay.IAccountListener;
import anon.pay.IMessageListener;
import anon.pay.PayAccountsFile;
import anon.pay.PayMessage;
import anon.pay.PaymentInstanceDBEntry;
import anon.pay.Transaction;
import anon.pay.xml.XMLAccountCertificate;
import anon.pay.xml.XMLAccountInfo;
import anon.pay.xml.XMLBalance;
import anon.pay.xml.XMLEasyCC;
import anon.pay.xml.XMLGenericStrings;
import anon.pay.xml.XMLGenericText;
import anon.pay.xml.XMLTransCert;
import anon.util.Base64;
import anon.util.IMiscPasswordReader;
import anon.util.IXMLEncodable;
import anon.util.XMLParseException;
import anon.util.XMLUtil;
import anon.util.ZLibTools;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class PayAccount
implements IXMLEncodable {
    public static final String XML_ELEMENT_NAME = "Account";
    private static final String XML_ATTR_ACTIVE = "active";
    private static final String XML_BACKUP_DONE = "backupDone";
    public static final long ACCOUNT_MIN_UPDATE_INTERVAL_MS = 900000L;
    public static final long ACCOUNT_MAX_UPDATE_INTERVAL_MS = 3600000L;
    private final Object SYNC_BYTES = new Object();
    private static final long NEW_ACCOUNT_EXPIRATION_TIME = 1209600000L;
    private static final String VERSION = "1.1";
    private static final long TIMEOUT_BLOCKED = 900000L;
    private Vector m_transCerts;
    private XMLAccountCertificate m_accountCertificate;
    private XMLAccountInfo m_accountInfo;
    private XMLGenericText m_terms;
    private IMyPrivateKey m_privateKey;
    private Document m_encryptedPrivateKey;
    private long m_currentBytes;
    private boolean m_bLocked = false;
    private Vector m_accountListeners = new Vector();
    private Vector m_messageListeners = new Vector();
    private long m_lBackupDone = 0L;
    private long m_lastAccountInfoUpdate = 0L;
    private boolean m_bAccountInfoUpdateRunning = false;
    private Object SYNC_ACCOUNT_INFO_UPDATE = new Object();
    private long m_tBlocked = 0L;
    private boolean m_bStatusUnknown = false;
    private Calendar m_termsDate;
    public static final int MAX_KBYTES_COUNTING_AS_EMPTY = 5000;
    private long m_mySpent;
    private PaymentInstanceDBEntry m_theBI;
    private String m_strBiID;

    public boolean isWaitingForTransaction() {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        return !this.isBlocked() && !this.isCharged(now) && !this.isUsed() && !this.hasExpired(now) && !this.isTransactionExpired();
    }

    public boolean isTransactionExpired() {
        XMLAccountInfo info = this.m_accountInfo;
        if (info == null) {
            return this.hasExpired();
        }
        if (this.getCurrentCredit() > 0L || this.getCurrentSpent() > 0L || info.getAllCCsTransferredBytes() > 0L) {
            return false;
        }
        if (this.getTransaction() != null) {
            if (this.getTransaction().isUsed()) {
                return false;
            }
            return this.getTransaction().hasExpired();
        }
        return true;
    }

    public PayAccount(Element elemRoot, IMiscPasswordReader a_passwordReader) throws Exception {
        this.setValues(elemRoot, a_passwordReader);
    }

    public PayAccount(XMLAccountCertificate certificate, IMyPrivateKey privateKey, PaymentInstanceDBEntry theBI, XMLGenericText terms, boolean a_bLock) {
        this.m_accountCertificate = certificate;
        this.m_privateKey = privateKey;
        this.m_transCerts = new Vector();
        this.m_theBI = theBI;
        this.m_strBiID = theBI.getId();
        this.m_bLocked = a_bLock;
        this.setTerms(terms);
    }

    private void setValues(Element elemRoot, IMiscPasswordReader a_passwordReader) throws Exception {
        Element elemTerms;
        XMLUtil.assertNodeName(elemRoot, XML_ELEMENT_NAME);
        boolean bActive = XMLUtil.parseAttribute((Node)elemRoot, XML_ATTR_ACTIVE, true);
        boolean bBackupDone = XMLUtil.parseAttribute((Node)elemRoot, XML_BACKUP_DONE, false);
        this.m_lBackupDone = bBackupDone ? System.currentTimeMillis() : XMLUtil.parseAttribute((Node)elemRoot, XML_BACKUP_DONE, 0L);
        this.m_transCerts = new Vector();
        Element elemTrs = (Element)XMLUtil.getFirstChildByName(elemRoot, "TransferCertificates");
        Element elemTr = (Element)XMLUtil.getFirstChildByName(elemTrs, "TransferCertificate");
        while (elemTr != null) {
            this.m_transCerts.addElement(new XMLTransCert(elemTr));
            elemTr = (Element)XMLUtil.getNextSiblingByName(elemTr, "TransferCertificate");
        }
        Element elemAccCert = (Element)XMLUtil.getFirstChildByName(elemRoot, "AccountCertificate");
        this.m_accountCertificate = new XMLAccountCertificate(elemAccCert);
        Element elemAccInfo = (Element)XMLUtil.getFirstChildByName(elemRoot, "AccountInfo");
        if (elemAccInfo != null) {
            this.m_accountInfo = new XMLAccountInfo(elemAccInfo);
            this.m_accountInfo.setAccountCallback(this);
            if (this.m_accountInfo.getBalance() != null) {
                this.setBlocked(this.m_accountInfo.getBalance().isBlocked(), false);
            }
        }
        if ((elemTerms = (Element)XMLUtil.getFirstChildByName(elemRoot, "GenericText")) != null && XMLUtil.getStorageMode() == 0) {
            XMLGenericText text = new XMLGenericText(elemTerms);
            try {
                byte[] zippedText = Base64.decode(text.getText());
                text = new XMLGenericText(new String(ZLibTools.decompress(zippedText)));
            }
            catch (Exception e) {
                // empty catch block
            }
            this.setTerms(text);
        }
        Element biid = (Element)XMLUtil.getFirstChildByName(elemAccCert, "BiID");
        this.m_strBiID = XMLUtil.parseValue((Node)biid, "-1");
        this.m_theBI = null;
        this.decryptPrivateKey(elemRoot, a_passwordReader, !bActive);
    }

    public Element toXmlElement(Document a_doc) {
        return this.toXmlElement(a_doc, null, false);
    }

    public Element toXmlElement(Document a_doc, String a_password, boolean a_bDoNotDeactivate) {
        try {
            if (a_password != null && a_password.trim().equals("")) {
                return this.toXmlElement(a_doc, null, a_bDoNotDeactivate);
            }
            Element elemRoot = a_doc.createElement(XML_ELEMENT_NAME);
            elemRoot.setAttribute("version", VERSION);
            Element elemTmp = this.m_accountCertificate.toXmlElement(a_doc);
            elemRoot.appendChild(elemTmp);
            XMLUtil.setAttribute(elemRoot, XML_BACKUP_DONE, this.m_lBackupDone);
            if (this.m_encryptedPrivateKey != null) {
                if (!a_bDoNotDeactivate) {
                    XMLUtil.setAttribute(elemRoot, XML_ATTR_ACTIVE, false);
                }
                elemTmp = (Element)XMLUtil.importNode(a_doc, this.m_encryptedPrivateKey.getDocumentElement(), true);
                elemRoot.appendChild(elemTmp);
            } else {
                XMLUtil.setAttribute(elemRoot, XML_ATTR_ACTIVE, true);
                elemTmp = this.m_privateKey.toXmlElement(a_doc);
                elemRoot.appendChild(elemTmp);
                if (a_password != null) {
                    try {
                        XMLEncryption.encryptElement(elemTmp, a_password);
                    }
                    catch (Exception e) {
                        LogHolder.log(2, LogType.PAY, "Could not encrypt account key: " + e);
                    }
                }
            }
            Element elemTransCerts = a_doc.createElement("TransferCertificates");
            elemRoot.appendChild(elemTransCerts);
            if (this.m_transCerts != null) {
                Enumeration enumer = this.m_transCerts.elements();
                while (enumer.hasMoreElements()) {
                    XMLTransCert cert = (XMLTransCert)enumer.nextElement();
                    elemTransCerts.appendChild(cert.toXmlElement(a_doc));
                }
            }
            if (this.m_accountInfo != null) {
                elemTmp = this.m_accountInfo.toXmlElement(a_doc);
                elemRoot.appendChild(elemTmp);
            }
            if (this.m_terms != null) {
                String termsString = this.m_terms.getText();
                String encodedTerms = Base64.encode(ZLibTools.compress(termsString.getBytes()), true);
                XMLGenericText zippedTerms = new XMLGenericText(encodedTerms);
                elemTmp = zippedTerms.toXmlElement(a_doc);
                elemRoot.appendChild(elemTmp);
            }
            return elemRoot;
        }
        catch (Exception ex) {
            LogHolder.log(2, LogType.PAY, "Exception while creating PayAccount XML: " + ex);
            return null;
        }
    }

    public void addTransCert(XMLTransCert cert) throws Exception {
        this.m_transCerts.addElement(cert);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setAccountInfo(XMLAccountInfo info) throws Exception {
        boolean fire = false;
        if (info != null) {
            if (info.getBalance() != null && info.getBalance().getAccountNumber() != this.getAccountNumber()) {
                throw new IllegalArgumentException("Wrong account number! Expected: " + this.getAccountNumber() + " Value: " + info.getBalance().getAccountNumber());
            }
            this.setStatusUnknown(false);
        }
        if (this.m_accountInfo == null) {
            this.m_accountInfo = info;
            fire = true;
        } else {
            XMLAccountInfo xMLAccountInfo = this.m_accountInfo;
            synchronized (xMLAccountInfo) {
                String ccKey;
                XMLBalance retrievedBalance = info.getBalance();
                XMLBalance savedBalance = this.m_accountInfo.getBalance();
                PayMessage oldMessage = savedBalance.getMessage();
                PayMessage newMessage = retrievedBalance.getMessage();
                if (retrievedBalance.getTimestamp().after(savedBalance.getTimestamp())) {
                    this.m_accountInfo.setBalance(retrievedBalance);
                    this.setBlocked(this.m_accountInfo.getBalance().isBlocked(), false);
                    fire = true;
                    if (newMessage != null && !newMessage.getShortMessage().equals("")) {
                        if (oldMessage == null) {
                            this.fireMessageReceived(newMessage);
                        } else if (!newMessage.equals(oldMessage)) {
                            this.fireMessageRemoved(oldMessage);
                            this.fireMessageReceived(newMessage);
                        }
                    } else if (oldMessage != null && !oldMessage.getShortMessage().equals("")) {
                        this.fireMessageRemoved(oldMessage);
                    }
                }
                savedBalance.setMessage(newMessage);
                Enumeration[] compareCCs = new Enumeration[]{this.m_accountInfo.getCCs(), info.getCCs()};
                Hashtable<String, String> allCCKeys = new Hashtable<String, String>();
                for (int i = 0; i < compareCCs.length; ++i) {
                    while (compareCCs[i].hasMoreElements()) {
                        ccKey = ((XMLEasyCC)compareCCs[i].nextElement()).getConcatenatedPriceCertHashes();
                        allCCKeys.put(ccKey, ccKey);
                    }
                }
                Enumeration en = allCCKeys.keys();
                while (en.hasMoreElements()) {
                    ccKey = (String)en.nextElement();
                    XMLEasyCC myCC = this.m_accountInfo.getCC(ccKey);
                    XMLEasyCC newCC = info.getCC(ccKey);
                    if (myCC == null && newCC == null) {
                        throw new NullPointerException("no CC available for " + ccKey + " This must NEVER happen!");
                    }
                    if (newCC == null || myCC != null && newCC.getTransferredBytes() <= myCC.getTransferredBytes()) continue;
                    if (newCC.verify(this.m_accountCertificate.getPublicKey())) {
                        this.addCostConfirmation(newCC, false, false);
                        fire = true;
                        continue;
                    }
                    throw new Exception("The BI is trying to betray you with faked CostConfirmations");
                }
                this.m_accountInfo.addPastMonthlyVolumeBytes(info);
            }
        }
        if (fire) {
            this.fireChangeEvent();
        }
    }

    public boolean equals(Object a_account) {
        if (a_account == null || !(a_account instanceof PayAccount)) {
            return false;
        }
        PayAccount account = (PayAccount)a_account;
        return account.getAccountNumber() == this.getAccountNumber() && (account.m_strBiID == this.m_strBiID || account.m_strBiID != null && this.m_strBiID != null && account.m_strBiID.equals(this.m_strBiID));
    }

    public int hashCode() {
        return (this.getAccountNumber() + this.m_strBiID).hashCode();
    }

    public long getAccountNumber() {
        return this.m_accountCertificate.getAccountNumber();
    }

    public boolean hasExpired() {
        return this.hasExpired(new Timestamp(System.currentTimeMillis()));
    }

    public boolean hasExpired(Timestamp a_time) {
        XMLBalance balance = this.getBalance();
        Calendar calendarStart = new GregorianCalendar();
        GregorianCalendar calendarNow = new GregorianCalendar();
        if (balance != null) {
            if (balance.getStartDate() != null) {
                calendarStart.setTime(balance.getStartDate());
                calendarNow.setTime(a_time);
                calendarStart = XMLBalance.calculateEndDate(calendarStart, -2, 5);
                calendarStart.add(13, 1);
            }
            if ((this.getCurrentCredit() > 0L || this.getCurrentSpent() > 0L) && balance.getFlatEnddate() != null && balance.getFlatEnddate().before(a_time) || this.getVolumeBytesMonthly() > 0L && calendarStart.after(calendarNow)) {
                return true;
            }
        } else if (this.getCreationTime().before(new Date(System.currentTimeMillis() - 1209600000L))) {
            return true;
        }
        return false;
    }

    public boolean isCharged() {
        return this.isCharged(new Timestamp(System.currentTimeMillis()));
    }

    public boolean isCharged(Timestamp a_time) {
        XMLBalance balance = this.getBalance();
        if (balance == null) {
            return false;
        }
        Timestamp tNow = new Timestamp(System.currentTimeMillis());
        if (balance.getFlatEnddate().before(a_time)) {
            return false;
        }
        if (balance.getVolumeBytesMonthly() == 0L || balance.getStartDate() == null || XMLBalance.isSameMonthlyPeriod(a_time, tNow, balance.getStartDate(), false)) {
            return this.getCurrentCredit() > 0L;
        }
        return !XMLBalance.isLastMonthOfRate(balance.getFlatEnddate(), a_time, balance.getStartDate()) || balance.getLastMonthRemainingTraffic() > 0L;
    }

    public boolean isSamePaymentInstance(String a_PIID) {
        if (a_PIID == null || this.m_strBiID == null) {
            return false;
        }
        return a_PIID.equals(this.m_strBiID);
    }

    public boolean isBackupDone() {
        return this.m_lBackupDone > 0L;
    }

    public long getBackupTime() {
        return this.m_lBackupDone;
    }

    public void setBackupDone(long a_backupTime) {
        this.m_lBackupDone = a_backupTime;
    }

    protected void setStatusUnknown(boolean a_bStatusUnknown) {
        this.m_bStatusUnknown = a_bStatusUnknown;
    }

    public boolean isStatusUnknown() {
        return this.m_bStatusUnknown;
    }

    public boolean hasAccountInfo() {
        return this.m_accountInfo != null;
    }

    public XMLAccountCertificate getAccountCertificate() {
        return this.m_accountCertificate;
    }

    public Timestamp getCreationTime() {
        return this.m_accountCertificate.getCreationTime();
    }

    public Timestamp getBalanceValidTime() {
        if (this.m_accountInfo != null) {
            return this.m_accountInfo.getBalance().getValidTime();
        }
        return this.m_accountCertificate.getCreationTime();
    }

    public IMyPrivateKey getPrivateKey() {
        return this.m_privateKey;
    }

    public IMyPublicKey getPublicKey() {
        return this.m_accountCertificate.getPublicKey();
    }

    public long getDeposit() {
        if (this.m_accountInfo != null) {
            return this.m_accountInfo.getBalance().getDeposit();
        }
        return 0L;
    }

    public Transaction getTransaction() {
        if (this.m_accountInfo != null) {
            return this.m_accountInfo.getBalance().getTransaction();
        }
        return null;
    }

    public long getCurrentCreditCalculated() {
        if (this.m_accountInfo == null) {
            return Long.MIN_VALUE;
        }
        long jonDoCountedCredit = this.getCurrentCreditCalculatedAlsoNegative();
        if (jonDoCountedCredit < 0L) {
            jonDoCountedCredit = 0L;
        }
        return jonDoCountedCredit;
    }

    public boolean isUsed() {
        XMLAccountInfo info = this.m_accountInfo;
        if (info == null) {
            return false;
        }
        XMLBalance balance = info.getBalance();
        if (balance == null) {
            return false;
        }
        if (balance.getTransaction() != null) {
            return balance.getTransaction().isUsed();
        }
        return balance.getSpent() > 0L || balance.getVolumeBytesLeft() > 0L || info.getAllCCsTransferredBytes() > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentCreditCalculatedAlsoNegative() {
        long jonDoCountedCredit;
        XMLAccountInfo info = this.m_accountInfo;
        if (info == null) {
            return Long.MIN_VALUE;
        }
        XMLBalance balance = info.getBalance();
        if (balance == null) {
            return 0L;
        }
        XMLAccountInfo xMLAccountInfo = info;
        synchronized (xMLAccountInfo) {
            if (balance.getVolumeBytesMonthly() <= 0L) {
                jonDoCountedCredit = balance.getSpent() + balance.getVolumeBytesLeft() - info.getAllCCsTransferredBytes();
            } else {
                long lTotalVolumeBytes = balance.getVolumeBytesMonthly();
                Timestamp tNow = new Timestamp(System.currentTimeMillis());
                if (balance.getFlatEnddate().getTime() < tNow.getTime()) {
                    return 0L;
                }
                if (XMLBalance.isLastMonthOfRate(balance.getFlatEnddate(), tNow, balance.getStartDate())) {
                    lTotalVolumeBytes = balance.getLastMonthRemainingTraffic();
                } else if (balance.getOverusageBytes() > 0L && XMLBalance.isSameMonthlyPeriod(balance.getOverusageDate(), new Timestamp(System.currentTimeMillis()), balance.getStartDate(), true)) {
                    lTotalVolumeBytes += balance.getOverusageBytes();
                }
                jonDoCountedCredit = lTotalVolumeBytes - info.getAllCCsTransferredBytes();
                long diff = info.getBalance().getSpent() + info.getBalance().getVolumeBytesLeft() - jonDoCountedCredit;
                if (diff < 0L) {
                    jonDoCountedCredit += diff;
                }
            }
        }
        return jonDoCountedCredit;
    }

    public long getCurrentCreditFromBalance() {
        return this.getBalance().getVolumeBytesLeft();
    }

    public String toString() {
        return "" + this.getAccountNumber();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        Vector vector = this.m_accountListeners;
        synchronized (vector) {
            if (this.m_bLocked) {
                this.fireChangeEvent();
                this.m_bLocked = false;
            }
        }
    }

    public boolean isLocked() {
        return this.m_bLocked;
    }

    public boolean isBlocked() {
        return System.currentTimeMillis() - this.m_tBlocked < 900000L;
    }

    public void setBlocked(boolean a_bBlock) {
        this.setBlocked(a_bBlock, true);
    }

    private void setBlocked(boolean a_bBlock, boolean a_bFireChanged) {
        boolean bChanged = false;
        if (this.isBlocked() != a_bBlock) {
            bChanged = true;
        }
        this.m_tBlocked = a_bBlock ? System.currentTimeMillis() : 0L;
        if (bChanged && a_bFireChanged) {
            this.fireChangeEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentCredit() {
        XMLAccountInfo info = this.m_accountInfo;
        if (info != null) {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            XMLAccountInfo xMLAccountInfo = info;
            synchronized (xMLAccountInfo) {
                long jonDoCountedCredit = this.getCurrentCreditCalculated();
                if (jonDoCountedCredit < 0L || (info.getBalance().getVolumeBytesMonthly() == 0L || info.getBalance().getVolumeBytesMonthly() > 0L && XMLBalance.isSameMonthlyPeriod(info.getBalance().getMonthlyBytesUpdatedOn(), now, info.getBalance().getStartDate(), true)) && jonDoCountedCredit > this.getBalance().getVolumeBytesLeft()) {
                    return this.getBalance().getVolumeBytesLeft();
                }
                return jonDoCountedCredit;
            }
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getCurrentSpent() {
        XMLAccountInfo info = this.m_accountInfo;
        if (info != null) {
            XMLAccountInfo xMLAccountInfo = info;
            synchronized (xMLAccountInfo) {
                return info.getBalance().getSpent() + info.getBalance().getVolumeBytesLeft() - this.getCurrentCredit();
            }
        }
        return 0L;
    }

    public XMLAccountInfo getAccountInfo() {
        return this.m_accountInfo;
    }

    public XMLGenericText getTerms() {
        return this.m_terms;
    }

    public void setTerms(XMLGenericText xmlTerms) {
        this.m_termsDate = null;
        if (xmlTerms == null) {
            this.m_terms = null;
        }
        String termsHtml = null;
        if (xmlTerms != null) {
            termsHtml = xmlTerms.getText();
        }
        if (termsHtml == null || termsHtml.trim().equals("")) {
            this.m_terms = null;
        } else {
            this.m_terms = xmlTerms;
            int titleStart = termsHtml.indexOf("<title>");
            int titleEnd = termsHtml.indexOf("</title>");
            if (titleStart >= 0 && titleEnd >= 0) {
                try {
                    String dateString = termsHtml.substring(titleStart + "<title>".length(), titleEnd);
                    Calendar termsDate = Calendar.getInstance();
                    termsDate.setTime(new SimpleDateFormat("yyyy-MM-dd").parse(dateString));
                    this.m_termsDate = termsDate;
                }
                catch (ParseException e) {
                    LogHolder.log(4, LogType.PAY, e);
                    this.m_terms = null;
                }
            } else {
                LogHolder.log(4, LogType.PAY, "No valid title tag was found!");
                this.m_terms = null;
            }
        }
    }

    public Calendar getTermsDate() {
        return this.m_termsDate;
    }

    public Vector getTransCerts() {
        return this.m_transCerts;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long updateCurrentBytes(PacketCounter a_packetCounter) throws Exception {
        long tmp;
        if (PayAccountsFile.getInstance().getActiveAccount() != this) {
            throw new Exception("Error: Inactive account called to count used bytes!");
        }
        Object object = this.SYNC_BYTES;
        synchronized (object) {
            tmp = a_packetCounter.getAndResetBytesForPayment();
            if (tmp > 0L) {
                this.m_currentBytes += tmp;
            }
        }
        if (tmp > 0L) {
            this.fireChangeEvent();
        } else if (tmp < 0L) {
            throw new Exception("Negative payment bytes added! Bytes: " + tmp);
        }
        return tmp;
    }

    public void resetCurrentBytes() {
        this.m_currentBytes = 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateCurrentBytes(long a_additionalBytes) {
        Object object = this.SYNC_BYTES;
        synchronized (object) {
            this.m_currentBytes += a_additionalBytes;
        }
    }

    public long getCurrentBytes() {
        return this.m_currentBytes;
    }

    public long addCostConfirmation(XMLEasyCC cc, boolean a_bForcedAdd) throws Exception {
        return this.addCostConfirmation(cc, a_bForcedAdd, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long addCostConfirmation(XMLEasyCC cc, boolean a_bForcedAdd, boolean a_bFireChanged) throws Exception {
        long added;
        Object object = this.SYNC_BYTES;
        synchronized (object) {
            if (this.m_accountInfo == null) {
                this.m_accountInfo = new XMLAccountInfo();
                this.m_accountInfo.setAccountCallback(this);
            }
            if ((added = this.m_accountInfo.addCC(cc, a_bForcedAdd)) > 0L) {
                this.m_mySpent += added;
            }
        }
        if (a_bFireChanged) {
            this.fireChangeEvent();
        }
        return added;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addAccountListener(IAccountListener listener) {
        Vector vector = this.m_accountListeners;
        synchronized (vector) {
            if (listener != null) {
                this.m_accountListeners.addElement(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addMessageListener(IMessageListener listener) {
        Vector vector = this.m_messageListeners;
        synchronized (vector) {
            if (listener != null) {
                this.m_messageListeners.addElement(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeMessageListener(IMessageListener listener) {
        Vector vector = this.m_messageListeners;
        synchronized (vector) {
            this.m_messageListeners.removeElement(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireChangeEvent() {
        Vector vector = this.m_accountListeners;
        synchronized (vector) {
            Enumeration enumListeners = this.m_accountListeners.elements();
            while (enumListeners.hasMoreElements()) {
                ((IAccountListener)enumListeners.nextElement()).accountChanged(this);
            }
        }
    }

    private void fireMessageReceived(PayMessage message) {
        Enumeration enumListeners = ((Vector)this.m_messageListeners.clone()).elements();
        while (enumListeners.hasMoreElements()) {
            ((IMessageListener)enumListeners.nextElement()).messageReceived(message);
        }
    }

    private void fireMessageRemoved(PayMessage message) {
        Enumeration enumListeners = ((Vector)this.m_messageListeners.clone()).elements();
        while (enumListeners.hasMoreElements()) {
            ((IMessageListener)enumListeners.nextElement()).messageRemoved(message);
        }
    }

    public String getAffiliate() {
        XMLAccountInfo info = this.m_accountInfo;
        if (info == null) {
            return null;
        }
        return info.getBalance().getAffiliate();
    }

    public XMLBalance getBalance() {
        XMLAccountInfo info = this.m_accountInfo;
        if (info == null) {
            return null;
        }
        return info.getBalance();
    }

    public XMLAccountInfo fetchAccountInfo(boolean a_bForce) throws SecurityException, Exception {
        return this.fetchAccountInfo(a_bForce, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLAccountInfo fetchAccountInfo(boolean a_bForce, int a_connectionTimeout) throws SecurityException, Exception {
        if (!(a_bForce || PayAccountsFile.getInstance().isBalanceAutoUpdateEnabled() && !this.m_bAccountInfoUpdateRunning)) {
            return null;
        }
        if (this.getPrivateKey() == null) {
            throw new SecurityException("Account is encrypted and not usable!");
        }
        XMLAccountInfo info = null;
        this.m_theBI = this.getBI();
        if (this.m_theBI == null) {
            return null;
        }
        BIConnection biConn = null;
        Object object = this.SYNC_ACCOUNT_INFO_UPDATE;
        synchronized (object) {
            this.m_bAccountInfoUpdateRunning = true;
            try {
                biConn = new BIConnection(this.m_theBI);
                if (a_connectionTimeout > 0) {
                    biConn.connect(a_connectionTimeout);
                } else {
                    biConn.connect();
                }
                biConn.authenticate(this);
                info = biConn.getAccountInfo(this);
                Object var7_6 = null;
                if (biConn != null) {
                    biConn.disconnect();
                }
                this.m_bAccountInfoUpdateRunning = false;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (biConn != null) {
                    biConn.disconnect();
                }
                this.m_bAccountInfoUpdateRunning = false;
                throw throwable;
            }
            if (info != null) {
                this.m_lastAccountInfoUpdate = System.currentTimeMillis();
                this.setAccountInfo(info);
            }
        }
        if (info != null && info.getBalance().getAffiliate() != null) {
            this.fireChangeEvent();
        }
        return info;
    }

    public static boolean canDoMonthlyOverusage(PayAccount a_account, Timestamp a_tNow) {
        XMLBalance balance;
        return a_account != null && (balance = a_account.getBalance()) != null && balance.canDoMonthlyOverusage(a_tNow);
    }

    public long getVolumeBytesMonthly() {
        XMLBalance balance = this.getBalance();
        if (balance != null) {
            return balance.getVolumeBytesMonthly();
        }
        return 0L;
    }

    public double getCurrentOverusageFactor(Timestamp a_tNow) {
        XMLBalance balance = this.getBalance();
        if (balance != null && balance.isCurrentlyInOverusage(a_tNow)) {
            return balance.getOverusageFactor();
        }
        return 0.0;
    }

    public boolean canDoMonthlyOverusage(Timestamp a_tNow) {
        return PayAccount.canDoMonthlyOverusage(this, a_tNow);
    }

    public boolean isAccountInfoUpdated() {
        return this.m_lastAccountInfoUpdate > 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldUpdateAccountInfo() {
        Timestamp tStamp = new Timestamp(System.currentTimeMillis());
        if (this.hasExpired(tStamp) || this.getCurrentSpent() > 0L && this.getCurrentCredit() == 0L && !this.canDoMonthlyOverusage(tStamp)) {
            return false;
        }
        if (this.getCurrentSpent() < 0L && !this.m_bAccountInfoUpdateRunning) {
            return true;
        }
        if (!PayAccountsFile.getInstance().isBalanceAutoUpdateEnabled() || this.m_bAccountInfoUpdateRunning) {
            return false;
        }
        long lInterval = PayAccountsFile.getInstance().getActiveAccount() == this ? 900000L : 3600000L;
        if (this.m_lastAccountInfoUpdate == 0L) {
            if (this.m_accountInfo == null) {
                return false;
            }
            XMLAccountInfo xMLAccountInfo = this.m_accountInfo;
            synchronized (xMLAccountInfo) {
                if (this.m_accountInfo.getBalance() == null || this.m_accountInfo.getBalance().getTimestamp() == null || this.m_accountInfo.getBalance().getTimestamp().getTime() > System.currentTimeMillis() || this.m_accountInfo.getBalance().getTimestamp().getTime() < System.currentTimeMillis() - lInterval) {
                    return true;
                }
            }
        } else if (this.m_lastAccountInfoUpdate < System.currentTimeMillis() - lInterval) {
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLTransCert charge(XMLGenericStrings a_parameters) throws SecurityException, Exception {
        if (this.getPrivateKey() == null) {
            throw new SecurityException("Account is encrypted and not usable!");
        }
        BIConnection biConn = null;
        XMLTransCert transcert = null;
        biConn = new BIConnection(this.m_theBI);
        try {
            biConn.connect();
            biConn.authenticate(this);
            transcert = biConn.charge(a_parameters);
            Object var5_4 = null;
            biConn.disconnect();
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            biConn.disconnect();
            throw throwable;
        }
        this.m_transCerts.addElement(transcert);
        return transcert;
    }

    public void updated() {
        this.fireChangeEvent();
    }

    public String getPIID() {
        return this.m_strBiID;
    }

    public PaymentInstanceDBEntry getBI() {
        if (this.m_theBI == null) {
            this.m_theBI = PayAccountsFile.getInstance().getBI(this.m_strBiID);
        }
        return this.m_theBI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XMLAccountInfo requestMonthlyOverusage() throws Exception {
        XMLAccountInfo info;
        PaymentInstanceDBEntry bi = this.getBI();
        if (bi == null) {
            return null;
        }
        BIConnection biConn = new BIConnection(bi);
        Object object = this.SYNC_ACCOUNT_INFO_UPDATE;
        synchronized (object) {
            this.m_bAccountInfoUpdateRunning = true;
            try {
                biConn.connect();
                biConn.authenticate(this);
                info = biConn.requestMonthlyOverusage(this.getBalance().getOverusageFactorGeneral(), this);
                Object var6_5 = null;
                biConn.disconnect();
                this.m_bAccountInfoUpdateRunning = false;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                biConn.disconnect();
                this.m_bAccountInfoUpdateRunning = false;
                throw throwable;
            }
            if (info != null) {
                this.m_lastAccountInfoUpdate = System.currentTimeMillis();
                this.setAccountInfo(info);
            }
        }
        if (info != null) {
            this.fireChangeEvent();
        }
        return info;
    }

    public static String checkCouponCode(String a_code) {
        if (a_code == null) {
            return null;
        }
        StringTokenizer tokenizer = new StringTokenizer(a_code);
        a_code = "";
        while (tokenizer.hasMoreTokens()) {
            a_code = a_code + tokenizer.nextToken();
        }
        if (a_code.length() != 16) {
            return null;
        }
        a_code = a_code.toUpperCase();
        for (int i = 0; i < a_code.length(); ++i) {
            if (i == 0 && (PayAccountsFile.isNewUserLetter(a_code.charAt(i)) || PayAccountsFile.isPromotionLetter(a_code.charAt(i))) || a_code.charAt(i) >= '0' && a_code.charAt(i) <= '9' || a_code.charAt(i) >= 'A' && a_code.charAt(i) <= 'F') continue;
            return null;
        }
        return a_code;
    }

    public void decryptPrivateKey(IMiscPasswordReader a_passwordReader) throws Exception {
        if (this.m_encryptedPrivateKey != null) {
            this.decryptPrivateKey(this.m_encryptedPrivateKey, a_passwordReader, false);
        }
    }

    private void decryptPrivateKey(Node a_elemRoot, final IMiscPasswordReader a_passwordReader, boolean a_bDeactivated) throws Exception {
        if (this.m_privateKey != null || a_elemRoot == null) {
            return;
        }
        Element elemKey = (Element)XMLUtil.getFirstChildByName(a_elemRoot, "EncryptedData");
        if (elemKey != null) {
            try {
                if (a_bDeactivated) {
                    this.deactivate(elemKey);
                    return;
                }
                IMiscPasswordReader passwordReader = a_passwordReader != null ? new IMiscPasswordReader(){

                    public String readPassword(Object a_message) {
                        return a_passwordReader.readPassword(new String("" + PayAccount.this.m_accountCertificate.getAccountNumber()));
                    }
                } : a_passwordReader;
                LogHolder.log(7, LogType.PAY, "Decrypting account " + this.m_accountCertificate.getAccountNumber());
                XMLEncryption.decryptElement(elemKey, passwordReader);
            }
            catch (Exception a_e) {
                this.deactivate(elemKey);
                return;
            }
        }
        Element elemRsaKey = (Element)XMLUtil.getFirstChildByName(a_elemRoot, "RSAPrivateKey");
        Element elemDsaKey = (Element)XMLUtil.getFirstChildByName(a_elemRoot, "DSAPrivateKey");
        if (elemRsaKey != null) {
            if (a_bDeactivated) {
                this.deactivate(elemRsaKey);
                return;
            }
            this.m_privateKey = new MyRSAPrivateKey(elemRsaKey);
        } else if (elemDsaKey != null) {
            if (a_bDeactivated) {
                this.deactivate(elemDsaKey);
                return;
            }
            this.m_privateKey = new MyDSAPrivateKey(elemDsaKey);
        } else {
            throw new XMLParseException("No RSA and no DSA private key found");
        }
        this.m_encryptedPrivateKey = null;
    }

    private void deactivate(Element elemKey) throws Exception {
        this.m_privateKey = null;
        this.m_encryptedPrivateKey = XMLUtil.createDocument();
        this.m_encryptedPrivateKey.appendChild(XMLUtil.importNode(this.m_encryptedPrivateKey, elemKey, true));
    }
}

