/*
 * Decompiled with CFR 0.152.
 */
package anon.pay;

import java.net.MalformedURLException;
import java.net.URL;
import logging.LogHolder;
import logging.LogType;

public class PayMessage {
    private String m_shortMessage = null;
    private String m_messageText = null;
    private URL m_messageLink = null;

    public PayMessage(String a_shortMessage) {
        this.m_shortMessage = a_shortMessage;
    }

    public PayMessage(String a_shortMessage, String a_messageText, URL a_messageLink) {
        this.m_shortMessage = a_shortMessage;
        this.m_messageText = a_messageText;
        this.m_messageLink = a_messageLink;
    }

    public boolean equals(Object anotherObject) {
        if (!(anotherObject instanceof PayMessage)) {
            return false;
        }
        PayMessage otherMessage = (PayMessage)anotherObject;
        boolean shortMessageEqual = this.m_shortMessage.equals(otherMessage.getShortMessage());
        boolean messageTextEqual = this.m_messageText.equals(otherMessage.getMessageText());
        String thisLink = this.m_messageLink.toString();
        String otherLink = otherMessage.toString();
        boolean linkEqual = thisLink.equalsIgnoreCase(otherLink);
        return shortMessageEqual && messageTextEqual && linkEqual;
    }

    public void setShortMessage(String a_shortMessage) {
        this.m_shortMessage = a_shortMessage;
    }

    public String getShortMessage() {
        return this.m_shortMessage;
    }

    public void setMessageText(String a_messageText) {
        this.m_messageText = a_messageText;
    }

    public String getMessageText() {
        return this.m_messageText;
    }

    public void setMessageLink(String a_messageLink) {
        try {
            this.m_messageLink = new URL(a_messageLink);
        }
        catch (MalformedURLException ex) {
            LogHolder.log(7, LogType.PAY, "Could not get valid URL from the given String, messageLink will be null");
        }
    }

    public void setMessageLink(URL a_messageLink) {
        this.m_messageLink = a_messageLink;
    }

    public URL getMessageLink() {
        return this.m_messageLink;
    }
}

