/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.crypto.IMyPrivateKey;
import anon.crypto.IMyPublicKey;
import anon.crypto.XMLSignature;
import anon.pay.xml.XMLJapPublicKey;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.sql.Timestamp;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLAccountCertificate
implements IXMLEncodable {
    private IMyPublicKey m_publicKey;
    private Timestamp m_creationTime;
    private long m_accountNumber;
    private String m_biID;
    private Document m_docTheAccountCert;

    public XMLAccountCertificate(IMyPublicKey publicKey, long accountNumber, Timestamp creationTime, String biID) {
        this.m_publicKey = publicKey;
        this.m_accountNumber = accountNumber;
        this.m_creationTime = creationTime;
        this.m_biID = biID;
        this.m_docTheAccountCert = XMLUtil.createDocument();
        this.m_docTheAccountCert.appendChild(this.internal_toXmlElement(this.m_docTheAccountCert));
    }

    public XMLAccountCertificate(String xml) throws Exception {
        Document doc = XMLUtil.toXMLDocument(xml);
        this.setValues(doc.getDocumentElement());
        this.m_docTheAccountCert = doc;
    }

    public XMLAccountCertificate(byte[] xmldata) throws Exception {
        Document doc = XMLUtil.toXMLDocument(xmldata);
        this.setValues(doc.getDocumentElement());
        this.m_docTheAccountCert = doc;
    }

    public XMLAccountCertificate(Element xml) throws Exception {
        this.setValues(xml);
        this.m_docTheAccountCert = XMLUtil.createDocument();
        this.m_docTheAccountCert.appendChild(XMLUtil.importNode(this.m_docTheAccountCert, xml, true));
    }

    private void setValues(Element xml) throws Exception {
        if (!xml.getTagName().equals("AccountCertificate")) {
            throw new Exception("XMLAccountCertificate: cannot parse, wrong xml format!");
        }
        if (!xml.getAttribute("version").equals("1.0")) {
            throw new Exception("XMLAccountCertificate: cannot parse, cert version is " + xml.getAttribute("version") + " but 1.0 was expected.");
        }
        Element elem = (Element)XMLUtil.getFirstChildByName(xml, "AccountNumber");
        this.m_accountNumber = XMLUtil.parseValue((Node)elem, 0L);
        if (this.m_accountNumber == 0L) {
            throw new Exception("XMLAccountCertificate: cannot parse accountnumber");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "BiID");
        this.m_biID = XMLUtil.parseValue((Node)elem, "");
        if (this.m_biID.equals("")) {
            throw new Exception("XMLAccountCertificate: cannot parse BiID");
        }
        elem = (Element)XMLUtil.getFirstChildByName(xml, "CreationTime");
        String timestamp = XMLUtil.parseValue((Node)elem, "0");
        this.m_creationTime = Timestamp.valueOf(timestamp);
        elem = (Element)XMLUtil.getFirstChildByName(xml, "JapPublicKey");
        if (elem == null) {
            throw new Exception("XMLAccountCertificate: cannot parse public key");
        }
        this.m_publicKey = new XMLJapPublicKey(elem).getPublicKey();
    }

    private Element internal_toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement("AccountCertificate");
        elemRoot.setAttribute("version", "1.0");
        Element elem = a_doc.createElement("AccountNumber");
        XMLUtil.setValue((Node)elem, Long.toString(this.m_accountNumber));
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("BiID");
        XMLUtil.setValue((Node)elem, this.m_biID);
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("CreationTime");
        XMLUtil.setValue((Node)elem, this.m_creationTime.toString());
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("JapPublicKey");
        elemRoot.appendChild(elem);
        elem.setAttribute("version", "1.0");
        elem.appendChild(this.m_publicKey.toXmlElement(a_doc));
        return elemRoot;
    }

    public long getAccountNumber() {
        return this.m_accountNumber;
    }

    public Timestamp getCreationTime() {
        return this.m_creationTime;
    }

    public IMyPublicKey getPublicKey() {
        return this.m_publicKey;
    }

    public boolean sign(IMyPrivateKey key) {
        try {
            XMLSignature.sign((Node)this.m_docTheAccountCert, key, 0);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_docTheAccountCert.getDocumentElement(), true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getPIID() {
        return this.m_biID;
    }
}

