/*
 * Decompiled with CFR 0.152.
 */
package anon.pay.xml;

import anon.crypto.IMyPrivateKey;
import anon.crypto.XMLSignature;
import anon.util.IXMLEncodable;
import anon.util.XMLUtil;
import java.sql.Timestamp;
import java.util.Date;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLTransCert
implements IXMLEncodable {
    private Timestamp m_validTime;
    private Date m_receivedDate;
    private Date m_usedDate;
    private long m_accountNumber;
    private long m_transferNumber;
    private long m_deposit;
    private Document m_docTheTransCert;
    public static final String XML_ELEMENT_NAME_TRANSFER_CERTIFICATES = "TransferCertificates";
    public static final String XML_ELEMENT_NAME_TRANSFER_CERTIFICATE = "TransferCertificate";

    public XMLTransCert(long accountNumber, long transferNumber, long deposit, Timestamp validTime) {
        this.m_accountNumber = accountNumber;
        this.m_transferNumber = transferNumber;
        this.m_deposit = deposit;
        this.m_validTime = validTime;
        this.m_docTheTransCert = XMLUtil.createDocument();
        this.m_docTheTransCert.appendChild(this.internal_toXmlElement(this.m_docTheTransCert));
    }

    public XMLTransCert(String xml) throws Exception {
        Document doc = XMLUtil.toXMLDocument(xml);
        Element elemRoot = doc.getDocumentElement();
        this.setValues(elemRoot);
        this.m_docTheTransCert = doc;
    }

    public XMLTransCert(Element xml) throws Exception {
        this.setValues(xml);
        this.m_docTheTransCert = XMLUtil.createDocument();
        this.m_docTheTransCert.appendChild(XMLUtil.importNode(this.m_docTheTransCert, xml, true));
    }

    public XMLTransCert(Document xml) throws Exception {
        Element elemRoot = xml.getDocumentElement();
        this.setValues(elemRoot);
        this.m_docTheTransCert = xml;
    }

    public void setReceivedDate(Date a_date) {
        this.m_receivedDate = a_date;
        this.m_docTheTransCert = XMLUtil.createDocument();
        this.m_docTheTransCert.appendChild(this.internal_toXmlElement(this.m_docTheTransCert));
    }

    public void setUsedDate(Date a_date) {
        this.m_usedDate = a_date;
        this.m_docTheTransCert = XMLUtil.createDocument();
        this.m_docTheTransCert.appendChild(this.internal_toXmlElement(this.m_docTheTransCert));
    }

    public Date getReceivedDate() {
        return this.m_receivedDate;
    }

    public Date getUsedDate() {
        return this.m_usedDate;
    }

    public long getAccountNumber() {
        return this.m_accountNumber;
    }

    public long getTransferNumber() {
        return this.m_transferNumber;
    }

    public Timestamp getValidTime() {
        return this.m_validTime;
    }

    private void setValues(Element elemRoot) throws Exception {
        if (!elemRoot.getTagName().equals(XML_ELEMENT_NAME_TRANSFER_CERTIFICATE)) {
            throw new Exception("XMLTransCert wrong xml structure: " + XMLUtil.toString(elemRoot));
        }
        Element element = (Element)XMLUtil.getFirstChildByName(elemRoot, "AccountNumber");
        String str = XMLUtil.parseValue((Node)element, (String)null);
        this.m_accountNumber = Long.parseLong(str);
        element = (Element)XMLUtil.getFirstChildByName(elemRoot, "TransferNumber");
        str = XMLUtil.parseValue((Node)element, (String)null);
        this.m_transferNumber = Long.parseLong(str);
        element = (Element)XMLUtil.getFirstChildByName(elemRoot, "ValidTime");
        str = XMLUtil.parseValue((Node)element, (String)null);
        this.m_validTime = Timestamp.valueOf(str);
        element = (Element)XMLUtil.getFirstChildByName(elemRoot, "ReceivedDate");
        str = XMLUtil.parseValue((Node)element, (String)null);
        if (str != null) {
            this.m_receivedDate = new Date(Long.parseLong(str));
        }
    }

    private Element internal_toXmlElement(Document a_doc) {
        Element elemRoot = a_doc.createElement(XML_ELEMENT_NAME_TRANSFER_CERTIFICATE);
        elemRoot.setAttribute("version", "1.2");
        Element elem = a_doc.createElement("AccountNumber");
        XMLUtil.setValue((Node)elem, Long.toString(this.m_accountNumber));
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("TransferNumber");
        XMLUtil.setValue((Node)elem, Long.toString(this.m_transferNumber));
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("Deposit");
        XMLUtil.setValue((Node)elem, Long.toString(this.m_deposit));
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("ValidTime");
        XMLUtil.setValue((Node)elem, this.m_validTime.toString());
        elemRoot.appendChild(elem);
        elem = a_doc.createElement("ReceivedDate");
        if (this.m_receivedDate != null) {
            XMLUtil.setValue((Node)elem, this.m_receivedDate.getTime());
            elemRoot.appendChild(elem);
        }
        return elemRoot;
    }

    public Element toXmlElement(Document a_doc) {
        try {
            return (Element)XMLUtil.importNode(a_doc, this.m_docTheTransCert.getDocumentElement(), true);
        }
        catch (Exception e) {
            return null;
        }
    }

    public boolean sign(IMyPrivateKey key) {
        try {
            XMLSignature.sign((Node)this.m_docTheTransCert, key, 0);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }
}

