/*
 * Decompiled with CFR 0.152.
 */
package anon.shared;

import java.io.IOException;

final class IOQueue {
    private byte[] buff = new byte[10000];
    private int readPos = 0;
    private int writePos = 0;
    private boolean bWriteClosed = false;
    private boolean bReadClosed = false;
    private static final int BUFF_SIZE = 10000;
    private boolean bFull = false;

    public synchronized void write(byte[] in, int pos, int len) throws IOException {
        while (len > 0) {
            if (this.bReadClosed || this.bWriteClosed) {
                throw new IOException("IOQueue closed");
            }
            if (this.bFull) {
                this.notify();
                try {
                    this.wait();
                    continue;
                }
                catch (InterruptedException e) {
                    throw new IOException("IOQueue write interrupted");
                }
            }
            int toCopy = this.readPos <= this.writePos ? 10000 - this.writePos : this.readPos - this.writePos;
            if (toCopy > len) {
                toCopy = len;
            }
            System.arraycopy(in, pos, this.buff, this.writePos, toCopy);
            pos += toCopy;
            this.writePos += toCopy;
            len -= toCopy;
            if (this.writePos >= 10000) {
                this.writePos = 0;
            }
            if (this.readPos != this.writePos) continue;
            this.bFull = true;
        }
        this.notify();
    }

    public synchronized int read() throws IOException {
        while (true) {
            if (this.bReadClosed) {
                throw new IOException("IOQueue closed");
            }
            if (this.readPos != this.writePos || this.bFull) break;
            if (this.bWriteClosed) {
                return -1;
            }
            this.notify();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IOException("IOQueue read() interrupted");
            }
        }
        int i = this.buff[this.readPos++] & 0xFF;
        if (this.readPos >= 10000) {
            this.readPos = 0;
        }
        if (this.bFull) {
            this.bFull = false;
            this.notify();
        }
        return i;
    }

    public synchronized int read(byte[] in, int pos, int len) throws IOException {
        if (len <= 0) {
            return 0;
        }
        while (true) {
            if (this.bReadClosed) {
                throw new IOException("IOQueue closed");
            }
            if (this.readPos != this.writePos || this.bFull) break;
            if (this.bWriteClosed) {
                return -1;
            }
            this.notify();
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                throw new IOException("IOQueue read() interrupted");
            }
        }
        int toCopy = this.writePos <= this.readPos ? 10000 - this.readPos : this.writePos - this.readPos;
        if (toCopy > len) {
            toCopy = len;
        }
        System.arraycopy(this.buff, this.readPos, in, pos, toCopy);
        this.readPos += toCopy;
        if (this.readPos >= 10000) {
            this.readPos = 0;
        }
        if (this.bFull) {
            this.bFull = false;
            this.notify();
        }
        return toCopy;
    }

    public synchronized int available() {
        if (this.bFull) {
            return 10000;
        }
        if (this.readPos == this.writePos && !this.bFull) {
            return 0;
        }
        if (this.writePos <= this.readPos) {
            return 10000 - this.readPos;
        }
        return this.writePos - this.readPos;
    }

    public synchronized void closeWrite() {
        this.bWriteClosed = true;
        this.notify();
    }

    public synchronized void closeRead() {
        this.bReadClosed = true;
        this.notify();
    }

    public synchronized void finalize() throws Throwable {
        this.bReadClosed = true;
        this.bWriteClosed = true;
        this.notify();
        this.buff = null;
        super.finalize();
    }
}

