/*
 * Decompiled with CFR 0.152.
 */
package anon.tor;

import anon.AnonChannel;
import anon.AnonServerDescription;
import anon.AnonService;
import anon.AnonServiceEventListener;
import anon.IServiceContainer;
import anon.crypto.MyRandom;
import anon.error.AnonServiceException;
import anon.error.InvalidServiceException;
import anon.infoservice.Database;
import anon.infoservice.IMutableProxyInterface;
import anon.infoservice.ListenerInterface;
import anon.terms.TermsAndConditionConfirmation;
import anon.tor.Circuit;
import anon.tor.FirstOnionRouterConnection;
import anon.tor.FirstOnionRouterConnectionFactory;
import anon.tor.TorAnonServerDescription;
import anon.tor.TorSocksChannel;
import anon.tor.ordescription.InfoServiceORListFetcher;
import anon.tor.ordescription.ORDescriptor;
import anon.tor.ordescription.ORList;
import anon.tor.ordescription.PlainORListFetcher;
import anon.tor.util.DNSCacheEntry;
import java.io.IOException;
import java.net.ConnectException;
import java.security.SecureRandom;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class Tor
implements Runnable,
AnonService {
    public static final int MAX_ROUTE_LEN = 5;
    public static final int MIN_ROUTE_LEN = 2;
    public static final int DNS_TIME_OUT = 600000;
    private static Tor ms_theTorInstance = null;
    private ORList m_orList = new ORList(new PlainORListFetcher("moria.seul.org", 9031));
    private Vector m_allowedORNames;
    private Vector m_allowedFirstORNames;
    private Vector m_allowedExitNodeNames;
    private Circuit[] m_activeCircuits;
    private int m_MaxNrOfActiveCircuits = 5;
    private Object m_oActiveCircuitSync = new Object();
    private Object m_oStartStopSync = new Object();
    private FirstOnionRouterConnectionFactory m_firstORFactory = new FirstOnionRouterConnectionFactory(this);
    private Database m_DNSCache;
    private Hashtable m_CircuitForDestination;
    private Vector[] m_KeysForCircuit;
    private volatile boolean m_bIsStarted = false;
    private boolean m_bIsCreatingCircuit = false;
    private boolean m_useDNSCache = true;
    private int m_circuitLengthMin = 2;
    private int m_circuitLengthMax = 5;
    private int m_ConnectionsPerCircuit = 1000;
    private MyRandom m_rand = new MyRandom(new SecureRandom());
    public static final String DEFAULT_DIR_SERVER_ADDR = "moria.seul.org";
    public static final int DEFAULT_DIR_SERVER_PORT = 9031;
    private Thread m_circuitCreator;
    private volatile boolean m_bCloseCreator = false;
    private IMutableProxyInterface m_proxyInterface = null;
    static /* synthetic */ Class class$anon$tor$util$DNSCacheEntry;

    private Tor() {
        this.m_activeCircuits = new Circuit[this.m_MaxNrOfActiveCircuits];
        this.m_DNSCache = Database.getInstance(class$anon$tor$util$DNSCacheEntry == null ? (class$anon$tor$util$DNSCacheEntry = Tor.class$("anon.tor.util.DNSCacheEntry")) : class$anon$tor$util$DNSCacheEntry);
        this.m_CircuitForDestination = new Hashtable();
        this.m_KeysForCircuit = new Vector[this.m_MaxNrOfActiveCircuits];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateORList() {
        ORList oRList = this.m_orList;
        synchronized (oRList) {
            this.m_orList.updateList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized Circuit getCircuitForDestination(String addr, int port, Hashtable exludeCircuits) {
        int circnr;
        if (!this.m_bIsStarted) {
            return null;
        }
        Circuit c = null;
        if (!ListenerInterface.isValidIP(addr) && !ListenerInterface.isValidIP(addr = this.resolveDNS(addr))) {
            return null;
        }
        String key = addr + ":" + port;
        if (this.m_CircuitForDestination.containsKey(key) && (c = this.m_activeCircuits[circnr = ((Integer)this.m_CircuitForDestination.get(key)).intValue()]) != null && !c.isShutdown() && c.isAllowed(addr, port) && (exludeCircuits == null || !exludeCircuits.containsKey(c))) {
            return c;
        }
        for (int nr = 0; nr < this.m_MaxNrOfActiveCircuits; ++nr) {
            c = this.m_activeCircuits[nr];
            if (c == null || c.isShutdown() || !c.isAllowed(addr, port) || exludeCircuits != null && exludeCircuits.containsKey(c)) continue;
            this.m_CircuitForDestination.put(key, new Integer(nr));
            if (this.m_KeysForCircuit[nr] == null) {
                this.m_KeysForCircuit[nr] = new Vector();
            }
            this.m_KeysForCircuit[nr].addElement(key);
            return c;
        }
        Object object = this.m_oActiveCircuitSync;
        synchronized (object) {
            for (int i = 0; i < 5; ++i) {
                Object obj;
                Enumeration it;
                int circstart = this.m_rand.nextInt(this.m_MaxNrOfActiveCircuits);
                int circ = 0;
                for (int j = 0; j < this.m_MaxNrOfActiveCircuits; ++j) {
                    circ = circstart % this.m_MaxNrOfActiveCircuits;
                    if (this.m_activeCircuits[circ] == null || this.m_activeCircuits[circ].isShutdown()) {
                        if (this.m_KeysForCircuit[circ] != null) {
                            it = this.m_KeysForCircuit[circ].elements();
                            while (it.hasMoreElements()) {
                                obj = it.nextElement();
                                this.m_CircuitForDestination.remove(obj);
                            }
                            this.m_KeysForCircuit[circ] = null;
                        }
                        this.m_activeCircuits[circ] = this.createNewCircuit(addr, port);
                        if (this.m_activeCircuits[circ] == null || this.m_activeCircuits[circ].isShutdown()) break;
                        this.m_CircuitForDestination.put(key, new Integer(circ));
                        this.m_KeysForCircuit[circ] = new Vector();
                        this.m_KeysForCircuit[circ].addElement(key);
                        return this.m_activeCircuits[circ];
                    }
                    if (this.m_activeCircuits[circ].isAllowed(addr, port)) {
                        if (!this.m_KeysForCircuit[circ].contains(key)) {
                            this.m_CircuitForDestination.put(key, new Integer(circ));
                            this.m_KeysForCircuit[circ].addElement(key);
                        }
                        return this.m_activeCircuits[circ];
                    }
                    ++circstart;
                }
                if (this.m_activeCircuits[circ] == null || this.m_activeCircuits[circ].isShutdown()) continue;
                circ = circstart % this.m_MaxNrOfActiveCircuits;
                this.m_activeCircuits[circ].shutdown();
                it = this.m_KeysForCircuit[circ].elements();
                while (it.hasMoreElements()) {
                    obj = it.nextElement();
                    this.m_CircuitForDestination.remove(obj);
                }
                this.m_KeysForCircuit[circ] = null;
                this.m_activeCircuits[circ] = this.createNewCircuit(addr, port);
                if (this.m_activeCircuits[circ] == null || this.m_activeCircuits[circ].isShutdown()) continue;
                this.m_CircuitForDestination.put(key, new Integer(circ));
                this.m_KeysForCircuit[circ] = new Vector();
                this.m_KeysForCircuit[circ].addElement(key);
                return this.m_activeCircuits[circ];
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Circuit createNewCircuit(String addr, int port) {
        Circuit circuit;
        block24: {
            Circuit circuit2;
            block23: {
                Circuit circuit3;
                block22: {
                    if (!this.m_bIsStarted) {
                        return null;
                    }
                    Object object = this.m_oStartStopSync;
                    synchronized (object) {
                        this.m_bIsCreatingCircuit = true;
                    }
                    try {
                        try {
                            object = this.m_orList;
                            synchronized (object) {
                                Vector<ORDescriptor> orsForNewCircuit = new Vector<ORDescriptor>();
                                int circuitLength = this.m_rand.nextInt(this.m_circuitLengthMax - this.m_circuitLengthMin + 1) + this.m_circuitLengthMin;
                                Date listPublished = this.m_orList.getPublished();
                                if (this.m_orList.size() == 0 || listPublished != null && listPublished.getTime() < System.currentTimeMillis() - 3600000L) {
                                    this.updateORList();
                                    if (this.m_orList.size() == 0) {
                                        Circuit circuit4 = null;
                                        // MONITOREXIT @DISABLED, blocks:[17, 1, 2, 18, 8] lbl18 : MonitorExitStatement: MONITOREXIT : var3_3
                                        Object var16_10 = null;
                                        this.m_bIsCreatingCircuit = false;
                                        return circuit4;
                                    }
                                }
                                ORDescriptor ord = this.m_allowedFirstORNames != null ? this.m_orList.getByRandom(this.m_allowedFirstORNames) : this.m_orList.getByRandom(circuitLength);
                                LogHolder.log(7, LogType.TOR, "added as first: " + ord);
                                orsForNewCircuit.addElement(ord);
                                Vector possibleOrs = this.m_orList.getList();
                                Enumeration enumer = ((Vector)possibleOrs.clone()).elements();
                                while (enumer.hasMoreElements()) {
                                    ord = (ORDescriptor)enumer.nextElement();
                                    if (this.m_allowedExitNodeNames != null && !this.m_allowedExitNodeNames.contains(ord.getName())) {
                                        possibleOrs.removeElement(ord);
                                        continue;
                                    }
                                    if (addr != null && !ord.getAcl().isAllowed(addr, port)) {
                                        possibleOrs.removeElement(ord);
                                        continue;
                                    }
                                    if (!orsForNewCircuit.contains(ord)) continue;
                                    possibleOrs.removeElement(ord);
                                }
                                if (possibleOrs.size() <= 0) {
                                    circuit3 = null;
                                    // MONITOREXIT @DISABLED, blocks:[1, 2, 21, 8] lbl44 : MonitorExitStatement: MONITOREXIT : var3_3
                                    break block22;
                                }
                                ord = (ORDescriptor)possibleOrs.elementAt(this.m_rand.nextInt(possibleOrs.size()));
                                orsForNewCircuit.addElement(ord);
                                LogHolder.log(7, LogType.TOR, "added as last: " + ord);
                                for (int i = 2; i < circuitLength; ++i) {
                                    while (orsForNewCircuit.contains(ord = this.m_allowedORNames != null ? this.m_orList.getByRandom(this.m_allowedORNames) : this.m_orList.getByRandom(circuitLength))) {
                                    }
                                    LogHolder.log(7, LogType.TOR, "added " + ord);
                                    orsForNewCircuit.insertElementAt(ord, 1);
                                }
                                ORDescriptor firstORDescription = (ORDescriptor)orsForNewCircuit.elementAt(0);
                                FirstOnionRouterConnection firstOR = this.m_firstORFactory.createFirstOnionRouterConnection(firstORDescription);
                                if (firstOR == null) {
                                    LogHolder.log(7, LogType.TOR, "removed " + firstORDescription.getName());
                                    this.m_orList.remove(firstORDescription.getName());
                                    throw new IOException("Problem with router " + orsForNewCircuit + ". Cannot connect.");
                                }
                                Circuit circuit5 = firstOR.createCircuit(orsForNewCircuit);
                                this.m_bIsCreatingCircuit = false;
                                if (circuit5 == null) {
                                    circuit2 = null;
                                    // MONITOREXIT @DISABLED, blocks:[1, 2, 20, 8] lbl66 : MonitorExitStatement: MONITOREXIT : var3_3
                                    break block23;
                                }
                                circuit5.setMaxNrOfStreams(this.m_ConnectionsPerCircuit);
                                circuit = circuit5;
                            }
                            break block24;
                        }
                        catch (Exception e) {
                            this.m_bIsCreatingCircuit = false;
                            Circuit circuit6 = null;
                            Object var16_14 = null;
                            this.m_bIsCreatingCircuit = false;
                            return circuit6;
                        }
                    }
                    catch (Throwable throwable) {
                        Object var16_15 = null;
                        this.m_bIsCreatingCircuit = false;
                        throw throwable;
                    }
                }
                Object var16_11 = null;
                this.m_bIsCreatingCircuit = false;
                return circuit3;
            }
            Object var16_12 = null;
            this.m_bIsCreatingCircuit = false;
            return circuit2;
        }
        Object var16_13 = null;
        this.m_bIsCreatingCircuit = false;
        return circuit;
    }

    public static Tor getInstance() {
        if (ms_theTorInstance == null) {
            ms_theTorInstance = new Tor();
        }
        return ms_theTorInstance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean foundemptyslot = false;
        while (!this.m_bCloseCreator && !this.m_bCloseCreator) {
            Object object = this.m_oActiveCircuitSync;
            synchronized (object) {
                int index = -1;
                for (int i = 0; i < this.m_MaxNrOfActiveCircuits; ++i) {
                    if (this.m_activeCircuits[i] != null && !this.m_activeCircuits[i].isShutdown()) continue;
                    index = i;
                    break;
                }
                if (index != -1) {
                    foundemptyslot = true;
                    Circuit circ = this.createNewCircuit("141.76.46.1", 80);
                    if (circ == null) {
                        continue;
                    }
                    this.m_activeCircuits[index] = circ;
                }
            }
            if (foundemptyslot) {
                foundemptyslot = false;
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException ex) {}
                continue;
            }
            try {
                Thread.sleep(30000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.m_circuitCreator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void start(boolean startCircuits) throws IOException {
        Object object = this.m_oStartStopSync;
        synchronized (object) {
            this.m_bIsStarted = true;
            this.m_bCloseCreator = false;
            this.m_activeCircuits = new Circuit[this.m_MaxNrOfActiveCircuits];
            if (startCircuits) {
                this.m_circuitCreator = new Thread((Runnable)this, "TorCircuitCreator");
                this.m_circuitCreator.setDaemon(true);
                this.m_circuitCreator.start();
            } else {
                this.m_circuitCreator = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stop() {
        Object object = this.m_oStartStopSync;
        synchronized (object) {
            this.m_bIsStarted = false;
            this.m_bCloseCreator = true;
            if (this.m_circuitCreator != null) {
                try {
                    this.m_circuitCreator.interrupt();
                }
                catch (Exception e2) {
                    // empty catch block
                }
                try {
                    this.m_circuitCreator.join();
                }
                catch (InterruptedException ex) {
                    // empty catch block
                }
                this.m_circuitCreator = null;
            }
            if (this.m_bIsCreatingCircuit) {
                this.m_firstORFactory.closeAll();
                while (this.m_bIsCreatingCircuit) {
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            this.m_firstORFactory.closeAll();
        }
    }

    private void setCircuitLength(int min, int max) {
        if (max >= min && min >= 2 && max <= 5) {
            this.m_circuitLengthMax = max;
            this.m_circuitLengthMin = min;
        }
    }

    private void setConnectionsPerRoute(int i) {
        this.m_ConnectionsPerCircuit = i;
    }

    private void setORListServer(boolean bUseInfoService, String name, int port) {
        if (bUseInfoService) {
            this.m_orList.setFetcher(new InfoServiceORListFetcher());
        } else {
            this.m_orList.setFetcher(new PlainORListFetcher(name, port));
        }
    }

    public void setUseDNSCache(boolean usecache) {
        this.m_useDNSCache = usecache;
    }

    public AnonChannel createChannel(int type) throws ConnectException {
        if (type != 1) {
            return null;
        }
        try {
            return new TorSocksChannel(this);
        }
        catch (Exception e) {
            throw new ConnectException("Could not create Tor channel: " + e.getMessage());
        }
    }

    public AnonChannel createChannel(String addr, int port) throws ConnectException {
        try {
            Circuit c = this.getCircuitForDestination(addr, port, null);
            return c.createChannel(addr, port);
        }
        catch (Exception e) {
            throw new ConnectException("Error creating Tor channel: " + e.getMessage());
        }
    }

    public synchronized void initialize(AnonServerDescription torDirServer, IServiceContainer a_serviceContainer, TermsAndConditionConfirmation termsConfirmation, boolean a_bIsReconnect) throws AnonServiceException {
        if (!(torDirServer instanceof TorAnonServerDescription)) {
            throw new InvalidServiceException(torDirServer);
        }
        TorAnonServerDescription td = (TorAnonServerDescription)torDirServer;
        this.setORListServer(td.useInfoService(), td.getTorDirServerAddr(), td.getTorDirServerPort());
        this.setCircuitLength(td.getMinRouteLen(), td.getMaxRouteLen());
        this.setConnectionsPerRoute(td.getMaxConnectionsPerRoute());
        try {
            this.start(td.startCircuitsAtStartup());
        }
        catch (Exception e) {
            throw new AnonServiceException(torDirServer, e.getMessage(), -9);
        }
    }

    public int setProxy(IMutableProxyInterface a_Proxy) {
        this.m_proxyInterface = a_Proxy;
        return 0;
    }

    public IMutableProxyInterface getProxy() {
        return this.m_proxyInterface;
    }

    public void shutdown(boolean a_bResetTransferredBytes) {
        try {
            this.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void addEventListener(AnonServiceEventListener l) {
    }

    public void removeEventListeners() {
    }

    public void removeEventListener(AnonServiceEventListener l) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String resolveDNS(String name) {
        DNSCacheEntry entry;
        String resolvedIP = null;
        if (this.m_useDNSCache && (entry = (DNSCacheEntry)this.m_DNSCache.getEntryById(name)) != null) {
            LogHolder.log(7, LogType.TOR, "Resolved from Database : " + entry.getId() + " - " + entry.getIp());
            return entry.getIp();
        }
        Object object = this.m_oActiveCircuitSync;
        synchronized (object) {
            for (int i = 0; i < 3; ++i) {
                String s;
                int circ = this.m_rand.nextInt(this.m_MaxNrOfActiveCircuits);
                if (this.m_activeCircuits[circ] == null || this.m_activeCircuits[circ].isShutdown()) {
                    this.m_activeCircuits[circ] = this.createNewCircuit(null, -1);
                }
                if (this.m_activeCircuits[circ] == null || this.m_activeCircuits[circ].isShutdown() || (s = this.m_activeCircuits[circ].resolveDNS(name)) == null) continue;
                resolvedIP = s;
                break;
            }
        }
        if (resolvedIP != null) {
            entry = new DNSCacheEntry(name, resolvedIP, System.currentTimeMillis() + 600000L);
            this.m_DNSCache.update(entry);
            LogHolder.log(7, LogType.TOR, "Adding to Database : " + entry.getId() + " - " + entry.getIp());
        }
        return resolvedIP;
    }

    public boolean isConnected() {
        return this.m_bIsStarted;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

