/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import anon.crypto.CertificateInfoStructure;
import anon.crypto.JAPCertificate;
import anon.crypto.SignatureVerifier;
import anon.crypto.X509DistinguishedName;
import anon.util.CountryMapper;
import anon.util.JAPMessages;
import gui.CAListCellRenderer;
import gui.CertDetailsDialog;
import gui.dialog.JAPDialog;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.border.TitledBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CADialog
extends JAPDialog
implements Observer {
    private TitledBorder m_borderCert;
    private TitledBorder m_borderInfo;
    private JLabel m_labelDate;
    private JLabel m_labelCN;
    private JLabel m_labelE;
    private JLabel m_labelCSTL;
    private JLabel m_labelO;
    private JLabel m_labelOU;
    private JLabel m_labelDateData;
    private JLabel m_labelCNData;
    private JLabel m_labelEData;
    private JLabel m_labelCSTLData;
    private JLabel m_labelOData;
    private JLabel m_labelOUData;
    private JButton m_bttnCertView;
    private DefaultListModel m_listmodelCertList;
    private JList m_listCert;
    private JScrollPane m_scrpaneList;
    private Enumeration m_enumCerts;
    private JPanel m_panelCAInfo;
    private JPanel m_panelCAList;
    private JPanel m_rootPanel = new JPanel();

    public CADialog(Frame parent) {
        super(parent, "View accepted Certification Authorities", true);
        this.recreateRootPanel();
        SignatureVerifier.getInstance().getVerificationCertificateStore().addObserver(this);
        this.update(SignatureVerifier.getInstance().getVerificationCertificateStore(), null);
        this.setSize(550, 500);
        this.setResizable(false);
        this.setVisible(true, false);
    }

    private void updateInfoPanel(JAPCertificate a_cert) {
        String strCSTL = null;
        this.m_labelCNData.setText("");
        this.m_labelEData.setText("");
        this.m_labelCSTLData.setText("");
        this.m_labelOData.setText("");
        this.m_labelOUData.setText("");
        this.m_labelDateData.setText("");
        if (a_cert == null) {
            return;
        }
        StringBuffer strBuff = new StringBuffer();
        SimpleDateFormat sdf = new SimpleDateFormat("dd.MM.yyyy");
        strBuff.append(sdf.format(a_cert.getValidity().getValidFrom()));
        strBuff.append(" - ");
        strBuff.append(sdf.format(a_cert.getValidity().getValidTo()));
        this.m_labelDateData.setText(strBuff.toString());
        this.m_labelDateData.setToolTipText(strBuff.toString());
        X509DistinguishedName name = a_cert.getSubject();
        if (name.getCommonName() != null && name.getCommonName().trim().length() > 0) {
            this.m_labelCNData.setText(name.getCommonName().trim());
            this.m_labelCNData.setToolTipText(name.getCommonName().trim());
        }
        if (name.getEmailAddress() != null && name.getEmailAddress().trim().length() > 0) {
            this.m_labelEData.setText(name.getEmailAddress().trim());
            this.m_labelEData.setToolTipText(name.getEmailAddress().trim());
        } else if (name.getE_EmailAddress() != null && name.getE_EmailAddress().trim().length() > 0) {
            this.m_labelEData.setText(name.getE_EmailAddress());
            this.m_labelEData.setToolTipText(name.getE_EmailAddress());
        }
        if (name.getLocalityName() != null && name.getLocalityName().trim().length() > 0) {
            strCSTL = name.getLocalityName().trim();
        }
        if (name.getStateOrProvince() != null && name.getStateOrProvince().trim().length() > 0) {
            strCSTL = strCSTL != null ? strCSTL + ", " : "";
            strCSTL = strCSTL + name.getStateOrProvince().trim();
        }
        if (name.getCountryCode() != null) {
            String country;
            try {
                country = new CountryMapper(name.getCountryCode(), JAPMessages.getLocale()).toString();
            }
            catch (IllegalArgumentException a_e) {
                country = name.getCountryCode();
            }
            if (country.trim().length() > 0) {
                strCSTL = strCSTL != null ? strCSTL + ", " : "";
                strCSTL = strCSTL + country.trim();
            }
        }
        this.m_labelCSTLData.setText(strCSTL);
        this.m_labelCSTLData.setToolTipText(strCSTL);
        if (name.getOrganisation() != null && name.getOrganisation().trim().length() > 0) {
            this.m_labelOData.setText(name.getOrganisation().trim());
            this.m_labelOData.setToolTipText(name.getOrganisation().trim());
        }
        if (name.getOrganisationalUnit() != null && name.getOrganisationalUnit().trim().length() > 0) {
            this.m_labelOUData.setText(name.getOrganisationalUnit().trim());
            this.m_labelOUData.setToolTipText(name.getOrganisationalUnit().trim());
        }
    }

    public void recreateRootPanel() {
        JPanel panelRoot = this.getRootPanel();
        this.m_borderCert = new TitledBorder("Accepted Certification Authorities");
        this.m_panelCAList = this.createCertCAPanel();
        this.m_panelCAList.setBorder(this.m_borderCert);
        this.m_borderInfo = new TitledBorder("Certificate Authority information");
        this.m_panelCAInfo = this.createCertInfoPanel();
        this.m_panelCAInfo.setBorder(this.m_borderInfo);
        panelRoot.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 2.0;
        c.weighty = 2.0;
        c.fill = 1;
        c.insets = new Insets(10, 10, 10, 10);
        panelRoot.add((Component)this.m_panelCAList, c);
        ++c.gridy;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.fill = 2;
        c.insets = new Insets(0, 10, 10, 10);
        panelRoot.add((Component)this.m_panelCAInfo, c);
        this.getContentPane().add(this.m_rootPanel);
    }

    private JPanel createCertCAPanel() {
        JPanel r_panelCA = new JPanel();
        GridBagLayout panelLayoutCA = new GridBagLayout();
        r_panelCA.setLayout(panelLayoutCA);
        GridBagConstraints panelConstraintsCA = new GridBagConstraints();
        this.m_listmodelCertList = new DefaultListModel();
        this.m_listCert = new JList(this.m_listmodelCertList);
        this.m_listCert.setCellRenderer(new CAListCellRenderer());
        this.m_listCert.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (CADialog.this.m_listmodelCertList.getSize() == 0 || CADialog.this.m_listCert.getSelectedValue() == null) {
                    CADialog.this.updateInfoPanel(null);
                } else {
                    CertificateInfoStructure j = (CertificateInfoStructure)CADialog.this.m_listCert.getSelectedValue();
                    CADialog.this.updateInfoPanel(j.getCertificate());
                }
            }
        });
        this.m_listCert.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent a_event) {
                if (a_event.getClickCount() == 2) {
                    CADialog.this.showCert();
                }
            }
        });
        this.m_scrpaneList = new JScrollPane();
        this.m_scrpaneList.getViewport().add((Component)this.m_listCert, null);
        panelConstraintsCA.gridx = 0;
        panelConstraintsCA.gridy = 0;
        panelConstraintsCA.weightx = 1.0;
        panelConstraintsCA.weighty = 1.0;
        panelConstraintsCA.gridwidth = 1;
        panelConstraintsCA.insets = new Insets(0, 10, 10, 10);
        panelConstraintsCA.fill = 1;
        panelLayoutCA.setConstraints(this.m_scrpaneList, panelConstraintsCA);
        r_panelCA.add(this.m_scrpaneList);
        this.m_bttnCertView = new JButton("View");
        this.m_bttnCertView.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CADialog.this.showCert();
            }
        });
        panelConstraintsCA.gridx = 0;
        panelConstraintsCA.gridy = 1;
        panelConstraintsCA.weightx = 0.0;
        panelConstraintsCA.weighty = 0.0;
        panelConstraintsCA.fill = 0;
        panelConstraintsCA.insets = new Insets(5, 5, 5, 5);
        panelLayoutCA.setConstraints(this.m_bttnCertView, panelConstraintsCA);
        r_panelCA.add(this.m_bttnCertView);
        return r_panelCA;
    }

    private void showCert() {
        Object selected = this.m_listCert.getSelectedValue();
        if (selected != null) {
            CertDetailsDialog dialog = new CertDetailsDialog(this.m_rootPanel.getParent(), ((CertificateInfoStructure)this.m_listCert.getSelectedValue()).getCertificate().getX509Certificate(), true, null);
            dialog.setVisible(true);
        }
    }

    private JPanel createCertInfoPanel() {
        JPanel r_panelInfo = new JPanel();
        GridBagLayout panelLayoutInfo = new GridBagLayout();
        r_panelInfo.setLayout(panelLayoutInfo);
        GridBagConstraints panelConstraintsInfo = new GridBagConstraints();
        panelConstraintsInfo.anchor = 17;
        panelConstraintsInfo.weightx = 1.0;
        panelConstraintsInfo.insets = new Insets(0, 10, 0, 0);
        panelConstraintsInfo.gridx = 0;
        panelConstraintsInfo.gridy = 0;
        panelConstraintsInfo.gridwidth = 2;
        this.m_labelDate = new JLabel("Validity:");
        this.m_labelCN = new JLabel("Name:");
        this.m_labelE = new JLabel("eMail:");
        this.m_labelCSTL = new JLabel("Location:");
        this.m_labelO = new JLabel("Organisation:");
        this.m_labelOU = new JLabel("Unit:");
        this.m_labelDateData = new JLabel();
        this.m_labelCNData = new JLabel();
        this.m_labelEData = new JLabel();
        this.m_labelCSTLData = new JLabel();
        this.m_labelOData = new JLabel();
        this.m_labelOUData = new JLabel();
        panelConstraintsInfo.anchor = 18;
        panelConstraintsInfo.fill = 2;
        panelConstraintsInfo.gridwidth = 1;
        panelConstraintsInfo.gridx = 0;
        panelConstraintsInfo.gridy = 1;
        panelConstraintsInfo.weightx = 0.0;
        panelConstraintsInfo.insets = new Insets(10, 15, 0, 0);
        panelLayoutInfo.setConstraints(this.m_labelCN, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelCN);
        panelConstraintsInfo.gridx = 1;
        panelConstraintsInfo.gridy = 1;
        panelConstraintsInfo.weightx = 1.0;
        panelConstraintsInfo.insets = new Insets(10, 10, 0, 10);
        panelLayoutInfo.setConstraints(this.m_labelCNData, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelCNData);
        panelConstraintsInfo.anchor = 18;
        panelConstraintsInfo.gridx = 0;
        panelConstraintsInfo.gridy = 2;
        panelConstraintsInfo.weightx = 0.0;
        panelConstraintsInfo.insets = new Insets(10, 15, 0, 0);
        panelLayoutInfo.setConstraints(this.m_labelO, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelO);
        panelConstraintsInfo.gridx = 1;
        panelConstraintsInfo.gridy = 2;
        panelConstraintsInfo.weightx = 1.0;
        panelConstraintsInfo.insets = new Insets(10, 10, 0, 10);
        panelLayoutInfo.setConstraints(this.m_labelOData, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelOData);
        panelConstraintsInfo.anchor = 18;
        panelConstraintsInfo.gridx = 0;
        panelConstraintsInfo.gridy = 3;
        panelConstraintsInfo.weightx = 0.0;
        panelConstraintsInfo.insets = new Insets(10, 15, 0, 0);
        panelLayoutInfo.setConstraints(this.m_labelOU, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelOU);
        panelConstraintsInfo.gridx = 1;
        panelConstraintsInfo.gridy = 3;
        panelConstraintsInfo.weightx = 1.0;
        panelConstraintsInfo.insets = new Insets(10, 10, 0, 10);
        panelLayoutInfo.setConstraints(this.m_labelOUData, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelOUData);
        panelConstraintsInfo.anchor = 18;
        panelConstraintsInfo.gridx = 0;
        panelConstraintsInfo.gridy = 4;
        panelConstraintsInfo.weightx = 0.0;
        panelConstraintsInfo.insets = new Insets(10, 15, 0, 0);
        panelLayoutInfo.setConstraints(this.m_labelCSTL, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelCSTL);
        panelConstraintsInfo.gridx = 1;
        panelConstraintsInfo.gridy = 4;
        panelConstraintsInfo.weightx = 1.0;
        panelConstraintsInfo.insets = new Insets(10, 10, 0, 10);
        panelLayoutInfo.setConstraints(this.m_labelCSTLData, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelCSTLData);
        panelConstraintsInfo.anchor = 18;
        panelConstraintsInfo.gridx = 0;
        panelConstraintsInfo.gridy = 5;
        panelConstraintsInfo.weightx = 0.0;
        panelConstraintsInfo.insets = new Insets(10, 15, 0, 0);
        panelLayoutInfo.setConstraints(this.m_labelE, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelE);
        panelConstraintsInfo.gridx = 1;
        panelConstraintsInfo.gridy = 5;
        panelConstraintsInfo.weightx = 1.0;
        panelConstraintsInfo.insets = new Insets(10, 10, 0, 10);
        panelLayoutInfo.setConstraints(this.m_labelEData, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelEData);
        panelConstraintsInfo.anchor = 18;
        panelConstraintsInfo.gridx = 0;
        panelConstraintsInfo.gridy = 6;
        panelConstraintsInfo.fill = 2;
        panelConstraintsInfo.weightx = 0.0;
        panelConstraintsInfo.insets = new Insets(10, 15, 10, 0);
        panelLayoutInfo.setConstraints(this.m_labelDate, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelDate);
        panelConstraintsInfo.gridx = 1;
        panelConstraintsInfo.gridy = 6;
        panelConstraintsInfo.weightx = 1.0;
        panelConstraintsInfo.insets = new Insets(10, 10, 10, 10);
        panelLayoutInfo.setConstraints(this.m_labelDateData, panelConstraintsInfo);
        r_panelInfo.add(this.m_labelDateData);
        r_panelInfo.setVisible(true);
        return r_panelInfo;
    }

    public String getHelpContext() {
        return "index";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void update(Observable a_notifier, Object a_message) {
        Enumeration enumCerts = SignatureVerifier.getInstance().getVerificationCertificateStore().getAllCertificates().elements();
        CADialog cADialog = this;
        synchronized (cADialog) {
            if (a_notifier == SignatureVerifier.getInstance().getVerificationCertificateStore()) {
                int lastIndex = this.m_listCert.getSelectedIndex();
                this.m_listmodelCertList.clear();
                this.m_enumCerts = enumCerts;
                while (this.m_enumCerts.hasMoreElements()) {
                    CertificateInfoStructure j = (CertificateInfoStructure)this.m_enumCerts.nextElement();
                    if (j.getCertificateType() != 1) continue;
                    this.m_listmodelCertList.addElement(j);
                }
                this.m_listCert.setSelectedIndex(lastIndex);
            }
        }
    }

    private JPanel getRootPanel() {
        return this.m_rootPanel;
    }

    public void loadDefaultCertificates() {
        JAPCertificate defaultRootCert = null;
        Enumeration mixCertificates = JAPCertificate.getInstance("certificates/acceptedMixCAs/", true).elements();
        while (mixCertificates.hasMoreElements()) {
            defaultRootCert = (JAPCertificate)mixCertificates.nextElement();
            SignatureVerifier.getInstance().getVerificationCertificateStore().addCertificateWithoutVerification(defaultRootCert, 1, true, true);
        }
        mixCertificates = JAPCertificate.getInstance("certificates/acceptedPaymentInstances/", true).elements();
        while (mixCertificates.hasMoreElements()) {
            defaultRootCert = (JAPCertificate)mixCertificates.nextElement();
            SignatureVerifier.getInstance().getVerificationCertificateStore().addCertificateWithoutVerification(defaultRootCert, 7, true, true);
        }
    }
}

