/*
 * Decompiled with CFR 0.152.
 */
package gui.help;

import anon.platform.AbstractOS;
import anon.util.JAPMessages;
import gui.JAPHelpContext;
import gui.dialog.DialogContentPane;
import gui.dialog.FileChooserContentPane;
import gui.dialog.JAPDialog;
import gui.dialog.SimpleWizardContentPane;
import gui.dialog.WorkerContentPane;
import gui.help.IHelpModel;
import gui.help.JAPHelp;
import gui.help.JAPInternalHelpViewer;
import java.awt.Component;
import java.awt.Frame;
import java.net.URL;
import logging.LogHolder;
import logging.LogType;

public final class JAPExternalHelpViewer
extends JAPHelp {
    public static final String MSG_HELP_INSTALL = (class$gui$help$JAPExternalHelpViewer == null ? (class$gui$help$JAPExternalHelpViewer = JAPExternalHelpViewer.class$("gui.help.JAPExternalHelpViewer")) : class$gui$help$JAPExternalHelpViewer).getName() + "_helpInstall";
    public static final String MSG_HELP_INSTALL_PROGRESS = "helpInstallProgress";
    public static final String MSG_HELP_INSTALL_FAILED = (class$gui$help$JAPExternalHelpViewer == null ? (class$gui$help$JAPExternalHelpViewer = JAPExternalHelpViewer.class$("gui.help.JAPExternalHelpViewer")) : class$gui$help$JAPExternalHelpViewer).getName() + "_helpInstallFailed";
    private static final String MSG_HELP_PATH_CHOICE = (class$gui$help$JAPExternalHelpViewer == null ? (class$gui$help$JAPExternalHelpViewer = JAPExternalHelpViewer.class$("gui.help.JAPExternalHelpViewer")) : class$gui$help$JAPExternalHelpViewer).getName() + "_helpPathChoice";
    private static final String MSG_HELP_INTERNAL = (class$gui$help$JAPExternalHelpViewer == null ? (class$gui$help$JAPExternalHelpViewer = JAPExternalHelpViewer.class$("gui.help.JAPExternalHelpViewer")) : class$gui$help$JAPExternalHelpViewer).getName() + "_helpInstallOpenInternal";
    private static final String MSG_HELP_INSTALL_SUCCESS = (class$gui$help$JAPExternalHelpViewer == null ? (class$gui$help$JAPExternalHelpViewer = JAPExternalHelpViewer.class$("gui.help.JAPExternalHelpViewer")) : class$gui$help$JAPExternalHelpViewer).getName() + "_helpInstallSucceded";
    private Object SYNC_INSTALL = new Object();
    private boolean m_bInstallationDialogShown = false;
    private JAPHelp m_alternativeHelp = null;
    private IHelpModel m_helpModel;
    private long m_timeLastSetVisible = 0L;
    static /* synthetic */ Class class$gui$help$JAPExternalHelpViewer;

    JAPExternalHelpViewer(Frame a_parent, IHelpModel a_helpModel) {
        this.m_helpModel = a_helpModel;
        this.m_alternativeHelp = new JAPInternalHelpViewer(a_parent).getHelp();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean a_bVisible) {
        if (System.currentTimeMillis() - this.m_timeLastSetVisible < 1000L) {
            this.m_alternativeHelp.setContext(JAPHelpContext.INDEX_CONTEXT);
            this.m_alternativeHelp.setVisible(a_bVisible);
            return;
        }
        this.m_timeLastSetVisible = System.currentTimeMillis();
        JAPHelpContext.IHelpContext context = this.getHelpContext();
        if (this.getHelpContext() == null) {
            LogHolder.log(3, LogType.GUI, "Cannot show help externally: No help context specified");
            this.m_alternativeHelp.setContext(JAPHelpContext.INDEX_CONTEXT);
            this.m_alternativeHelp.setVisible(a_bVisible);
            return;
        }
        Component container = context.getHelpExtractionDisplayContext();
        if (!this.m_helpModel.isHelpPathDefined()) {
            if (container == null) {
                LogHolder.log(3, LogType.GUI, "Cannot show help externally: No display context specified");
                this.m_alternativeHelp.setContext(this.getHelpContext());
                this.m_alternativeHelp.setVisible(a_bVisible);
                return;
            }
            if (this.m_bInstallationDialogShown) {
                LogHolder.log(4, LogType.GUI, "Help installation dialog is already being shown. Cannot display help files!");
                return;
            }
            Object object = this.SYNC_INSTALL;
            synchronized (object) {
                this.m_bInstallationDialogShown = true;
                boolean bDialogShown = false;
                if (!(this.m_helpModel.isHelpPathDefined() || this.m_helpModel.isHelpPathChangeable() && (bDialogShown = this.showInstallDialog(container)))) {
                    this.m_bInstallationDialogShown = false;
                    LogHolder.log(3, LogType.GUI, "Cannot show help externally: Help installation failed (changeable: " + this.m_helpModel.isHelpPathChangeable() + " showDialog: " + bDialogShown + ")");
                    this.m_alternativeHelp.setContext(this.getHelpContext());
                    this.m_alternativeHelp.setVisible(a_bVisible);
                    return;
                }
                this.m_bInstallationDialogShown = false;
            }
        }
        URL helpURL = this.m_helpModel.getHelpURL(context.getHelpContext() + ".html");
        boolean bBrowserAvailable = true;
        if (helpURL == null || !(bBrowserAvailable = AbstractOS.getInstance().openURL(helpURL))) {
            if (container != null && this.showInstallDialog(container) && (helpURL = this.m_helpModel.getHelpURL(context.getHelpContext() + ".html")) != null) {
                AbstractOS.getInstance().openURL(helpURL);
            } else {
                bBrowserAvailable = false;
            }
        }
        if (!bBrowserAvailable) {
            LogHolder.log(3, LogType.GUI, "Error while trying to show context '" + context.getHelpContext() + "' in external help!");
            this.m_alternativeHelp.setContext(this.getHelpContext());
            this.m_alternativeHelp.setVisible(a_bVisible);
        }
    }

    private boolean showInstallDialog(Component a_container) {
        if (this.m_helpModel.getHelpPath() == null || !this.m_helpModel.isHelpPathChangeable()) {
            return false;
        }
        final JAPDialog dialog = new JAPDialog(a_container, JAPMessages.getString(MSG_HELP_INSTALL));
        final FileChooserContentPane fileChooser = new FileChooserContentPane(dialog, JAPMessages.getString(MSG_HELP_PATH_CHOICE), this.m_helpModel.getHelpPath(), 1, "__FILE_CHOOSER_OPEN"){

            public DialogContentPane.CheckError checkYesOK() {
                DialogContentPane.CheckError errors = super.checkYesOK();
                if (errors != null) {
                    return errors;
                }
                String pathValidation = JAPExternalHelpViewer.this.m_helpModel.helpPathValidityCheck(this.getFile());
                if (!pathValidation.equals("HELP_IS_VALID") && !pathValidation.equals("helpJonDoExists")) {
                    errors = new DialogContentPane.CheckError(JAPMessages.getString(pathValidation));
                }
                return errors;
            }

            public boolean isSkippedAsPreviousContentPane() {
                return true;
            }
        };
        Runnable run = new Runnable(){

            public void run() {
                JAPExternalHelpViewer.this.m_helpModel.setHelpPath(fileChooser.getFile());
            }
        };
        final WorkerContentPane workerPane = new WorkerContentPane(dialog, JAPMessages.getString(MSG_HELP_INSTALL_PROGRESS), fileChooser, run, this.m_helpModel.getHelpFileStorageObservable()){

            public boolean isSkippedAsNextContentPane() {
                return JAPExternalHelpViewer.this.m_helpModel.isHelpPathDefined() && fileChooser.getFile().getPath().equals(JAPExternalHelpViewer.this.m_helpModel.getHelpPath());
            }
        };
        SimpleWizardContentPane finish = new SimpleWizardContentPane(dialog, JAPMessages.getString(MSG_HELP_INSTALL_SUCCESS), workerPane){

            public DialogContentPane.CheckError checkUpdate() {
                if (workerPane.getProgressStatus() != 0) {
                    dialog.setTitle(JAPMessages.getString(JAPDialog.MSG_TITLE_ERROR));
                    this.setText("<font color='red'>" + JAPMessages.getString(MSG_HELP_INSTALL_FAILED) + " " + JAPMessages.getString(MSG_HELP_INTERNAL) + "</font>");
                }
                return null;
            }

            public boolean hideButtonCancel() {
                return true;
            }
        };
        fileChooser.pack();
        dialog.setResizable(false);
        dialog.setVisible(true);
        return workerPane.getProgressStatus() == 0;
    }

    protected JAPDialog getOwnDialog() {
        return null;
    }

    public URL getContextURL(String a_strContext) {
        URL url = this.m_helpModel.getHelpURL(a_strContext + ".html");
        if (url == null) {
            url = this.m_alternativeHelp.getContextURL(a_strContext);
        }
        return url;
    }

    public void loadCurrentContext() {
        if (this.getHelpContext() != null) {
            if (this.getHelpContext().getHelpExtractionDisplayContext() != null) {
                this.setVisible(true);
            } else {
                LogHolder.log(3, LogType.GUI, "Cannot show help externally: No display context specified");
                this.m_alternativeHelp.setContext(this.getHelpContext());
                this.m_alternativeHelp.loadCurrentContext();
            }
        } else {
            LogHolder.log(3, LogType.GUI, "Cannot show help externally: No help context specified");
            this.m_alternativeHelp.setContext(JAPHelpContext.INDEX_CONTEXT);
            this.m_alternativeHelp.loadCurrentContext();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

