/*
 * Decompiled with CFR 0.152.
 */
package mixconfig;

import anon.util.Util;
import java.awt.Toolkit;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class FloatDocument
extends PlainDocument {
    private double max;
    private double min;
    private int aCDigits_max = 0;

    public FloatDocument(String minval, String maxval) {
        this.max = Util.parseDouble(maxval);
        this.min = Util.parseDouble(minval);
        this.aCDigits_max = this.getACDigits(maxval);
    }

    int getPCDigits(float a_float) {
        Float fObj = new Float(a_float);
        String str = fObj.toString();
        int idx = str.indexOf(".");
        if (str.startsWith("-")) {
            String sstr = str.substring(1, idx);
            return sstr.length();
        }
        String sstr = str.substring(0, idx);
        return sstr.length();
    }

    int getACDigits(float a_float) {
        Float fObj = new Float(a_float);
        String str = fObj.toString();
        int idx = str.indexOf(".");
        String sstr = str.substring(idx, str.length() - 1);
        return sstr.length();
    }

    int getACDigits(String a_string) {
        int idx = a_string.indexOf(".");
        String sstr = a_string.substring(idx, a_string.length() - 1);
        return sstr.length();
    }

    @Override
    public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
        if (str == null) {
            return;
        }
        String p1 = this.getText(0, offset);
        String p2 = this.getText(offset, this.getLength() - offset);
        String res = "";
        boolean hasPoint = p1.indexOf(46) >= 0 || p2.indexOf(44) >= 0;
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) == '.' || str.charAt(i) == ',') {
                if (hasPoint) {
                    Toolkit.getDefaultToolkit().beep();
                    continue;
                }
                res = res + ".";
                hasPoint = true;
                continue;
            }
            if (this.min < 0.0 && str.charAt(i) == '-') {
                if (p1.length() == 0 && res.length() == 0) {
                    res = "-";
                    continue;
                }
                Toolkit.getDefaultToolkit().beep();
                continue;
            }
            if (!Character.isDigit(str.charAt(i))) {
                Toolkit.getDefaultToolkit().beep();
                continue;
            }
            if (hasPoint) {
                String all = p1 + p2;
                int idx = all.indexOf(".");
                int pt = all.length() - idx;
                if (pt > this.aCDigits_max) {
                    Toolkit.getDefaultToolkit().beep();
                    continue;
                }
                String sstr = str.substring(i, i + 1);
                float val = new Float(p1 + res + sstr + p2).floatValue();
                if (this.max > 0.0 && (double)val > this.max || this.min < 0.0 && (double)val < this.min) {
                    Toolkit.getDefaultToolkit().beep();
                    continue;
                }
                if (this.getACDigits(val) > this.aCDigits_max) {
                    Toolkit.getDefaultToolkit().beep();
                    continue;
                }
                res = res + sstr;
                continue;
            }
            String sstr = str.substring(i, i + 1);
            float val = new Float(p1 + res + sstr + p2).floatValue();
            if (this.max > 0.0 && (double)val > this.max || this.min < 0.0 && (double)val < this.min) {
                Toolkit.getDefaultToolkit().beep();
                continue;
            }
            res = res + sstr;
        }
        super.insertString(offset, res, attr);
    }
}

