/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.network;

import mixconfig.network.ConnectionData;
import mixconfig.network.ConnectionTableModel;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class IncomingConnectionTableModel
extends ConnectionTableModel {
    private static final String[] columnNames = new String[]{"No.", "Visibility", "Transport", "Host / FileName", "Port"};
    public static final int SERIAL_NR = 0;
    public static final int VISIBILITY = 1;
    public static final int TRANSPORT = 2;
    public static final int NAME = 3;
    public static final int PORT = 4;

    @Override
    public Object getValueAt(int row, int column) {
        ConnectionData data = this.getData(row);
        if (data == null) {
            return null;
        }
        switch (column) {
            case 0: {
                return new Integer(row + 1);
            }
            case 1: {
                return data.getVisibilityString();
            }
            case 2: {
                return new Integer(data.getTransport());
            }
            case 3: {
                return data.getHostname();
            }
            case 4: {
                return new Integer(data.getPort());
            }
        }
        return null;
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return Integer.class;
            }
            case 1: {
                return String.class;
            }
            case 3: {
                return String.class;
            }
            case 4: {
                return Integer.class;
            }
        }
        return Object.class;
    }

    @Override
    public int getColumnCount() {
        return columnNames.length;
    }

    @Override
    public String getColumnName(int col) {
        return columnNames[col];
    }

    public Element createAsElement(Document doc) {
        Element ifaces = doc.createElement("ListenerInterfaces");
        for (int i = 0; i < this.getRowCount(); ++i) {
            ifaces.appendChild(this.getData(i).toXmlElement(doc));
        }
        return ifaces;
    }

    public void readFromElement(Element iface) {
        if (iface.getTagName().equals("ListenerInterfaces")) {
            for (int i = this.getRowCount() - 1; i >= 0; --i) {
                this.deleteData(i);
            }
            for (Node child = iface.getFirstChild(); child != null; child = child.getNextSibling()) {
                ConnectionData data;
                if (child.getNodeType() != 1 || (data = ConnectionData.createFromElement("ListenerInterface", (Element)child)) == null) continue;
                this.addData(data);
            }
        }
    }
}

