/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.panels;

import anon.crypto.JAPCertificate;
import anon.util.JAPMessages;
import gui.JAPHelpContext;
import gui.MapBox;
import gui.TitledGridBagPanel;
import gui.dialog.JAPDialog;
import gui.help.JAPHelp;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import mixconfig.MixCertificateView;
import mixconfig.MixConfig;
import mixconfig.OperatorCertificateView;
import mixconfig.panels.CertPanel;
import mixconfig.panels.MixConfigPanel;

public abstract class OtherMixPanel
extends MixConfigPanel
implements ChangeListener,
JAPHelpContext.IHelpContext {
    public static final String MIX_TYPE_PREVIOUS = "Previous Mix";
    public static final String MIX_TYPE_NEXT = "Next Mix";
    public static final String TYPE_PROXY = "Proxy";
    private static final String MSG_CERT_NOT_VERIFYABLE = OtherMixPanel.class.getName() + "_certNotVerifyable";
    private String m_type;
    private CertPanel m_otherCert;
    private CertPanel m_otherOpCert;
    private JPanel m_operatorPanel;
    private JPanel m_locationPanel;
    private JTextField m_opOrgField;
    private JTextField m_opOrgUnitField;
    private JTextField m_opCountryField;
    private JTextField m_opUrlField;
    private JTextField m_opEmailField;
    private JTextField m_locCityField;
    private JTextField m_locCountryField;
    private JTextField m_locStateField;
    private JTextField m_locLongField;
    private JTextField m_locLatField;
    private JButton m_mapButton;
    private GridBagLayout m_layout = new GridBagLayout();
    private GridBagConstraints m_gbc;

    public OtherMixPanel(String a_mixType) {
        super(a_mixType);
        this.m_type = a_mixType;
        this.setLayout(this.m_layout);
        this.m_gbc = this.getInitialConstraints();
        this.m_otherCert = new CertPanel(a_mixType + " Certificate", "Hint: You will need to receive the public certificate from the operator of the other mix", (JAPCertificate)null, 2, 2);
        if (a_mixType == MIX_TYPE_PREVIOUS) {
            this.m_otherCert.setName("Certificates/PrevMixCertificate");
        } else if (a_mixType == MIX_TYPE_NEXT) {
            this.m_otherCert.setName("Certificates/NextMixCertificate");
        }
        this.m_otherCert.setChangedCertNotVerifyableMessage(JAPMessages.getString(MSG_CERT_NOT_VERIFYABLE), null);
        this.m_otherCert.setCertificateView(new MixCertificateView());
        this.m_otherCert.addChangeListener(this);
        this.m_gbc.gridx = 0;
        this.m_gbc.gridy = 0;
        this.add((Component)this.m_otherCert, this.m_gbc);
        this.m_otherOpCert = new CertPanel(a_mixType + " Operator Certificate", "Hint: You will need to receive the public certificate from the operator of the other mix", (JAPCertificate)null, 2, 2);
        if (a_mixType == MIX_TYPE_PREVIOUS) {
            this.m_otherOpCert.setName("Certificates/PrevOperatorCertificate");
        } else if (a_mixType == MIX_TYPE_NEXT) {
            this.m_otherOpCert.setName("Certificates/NextOperatorCertificate");
        }
        this.m_otherOpCert.setChangedCertNotVerifyableMessage(JAPMessages.getString(MSG_CERT_NOT_VERIFYABLE), null);
        this.m_otherOpCert.setCertificateView(new OperatorCertificateView());
        this.m_otherOpCert.addChangeListener(this);
        ++this.m_gbc.gridx;
        this.add((Component)this.m_otherOpCert, this.m_gbc);
        this.m_locationPanel = this.createLocationPanel();
        this.m_gbc.gridx = 0;
        ++this.m_gbc.gridy;
        this.add((Component)this.m_locationPanel, this.m_gbc);
        this.m_otherCert.setPreferredSize(new Dimension(this.m_locationPanel.getPreferredSize().width, this.m_otherCert.getPreferredSize().height));
        this.m_operatorPanel = this.createOperatorPanel();
        this.m_gbc.fill = 1;
        ++this.m_gbc.gridx;
        this.add((Component)this.m_operatorPanel, this.m_gbc);
    }

    protected JPanel getLocationPanel() {
        return this.m_locationPanel;
    }

    @Override
    public String getHelpContext() {
        return OtherMixPanel.class.getName();
    }

    public JPanel getOperatorPanel() {
        return this.m_operatorPanel;
    }

    private JPanel createLocationPanel() {
        TitledGridBagPanel panel = new TitledGridBagPanel("Location");
        this.m_locCityField = new JTextField(20);
        this.m_locCityField.setEditable(false);
        this.m_locCountryField = new JTextField(20);
        this.m_locCountryField.setEditable(false);
        this.m_locStateField = new JTextField(20);
        this.m_locStateField.setEditable(false);
        this.m_locLongField = new JTextField(7);
        this.m_locLongField.setEditable(false);
        this.m_locLatField = new JTextField(7);
        this.m_locLatField.setEditable(false);
        this.m_mapButton = new JButton("Show on map");
        this.m_mapButton.setActionCommand("Map");
        this.m_mapButton.setEnabled(true);
        this.m_mapButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (!OtherMixPanel.this.m_locLatField.getText().equals("") && !OtherMixPanel.this.m_locLongField.getText().equals("")) {
                    try {
                        MapBox mapBox = new MapBox(MixConfig.getMainWindow(), OtherMixPanel.this.m_locLatField.getText(), OtherMixPanel.this.m_locLongField.getText(), 8);
                        mapBox.setVisible(true);
                    }
                    catch (Exception ex) {
                        JAPDialog.showErrorDialog((Component)MixConfig.getMainWindow(), null, (Throwable)ex);
                    }
                }
            }
        });
        panel.addRow((Component)new JLabel("City"), (Component)this.m_locCityField, null);
        panel.addRow((Component)new JLabel("State"), (Component)this.m_locStateField, null);
        panel.addRow((Component)new JLabel("Country"), (Component)this.m_locCountryField, null);
        panel.addRow((Component)new JLabel("Longitude"), (Component)this.m_locLongField, this.m_mapButton);
        panel.addRow((Component)new JLabel("Latitude"), (Component)this.m_locLatField, null);
        return panel;
    }

    private JPanel createOperatorPanel() {
        this.m_opOrgField = new JTextField(20);
        this.m_opOrgField.setEditable(false);
        this.m_opOrgUnitField = new JTextField(20);
        this.m_opOrgUnitField.setEditable(false);
        this.m_opCountryField = new JTextField(20);
        this.m_opCountryField.setEditable(false);
        this.m_opUrlField = new JTextField(20);
        this.m_opUrlField.setEditable(false);
        this.m_opEmailField = new JTextField(20);
        this.m_opEmailField.setEditable(false);
        TitledGridBagPanel panel = new TitledGridBagPanel("Operator");
        panel.addRow(new JLabel("Organisation"), this.m_opOrgField);
        panel.addRow(new JLabel("Orga. Unit"), this.m_opOrgUnitField);
        panel.addRow(new JLabel("Country"), this.m_opCountryField);
        panel.addRow(new JLabel("URL"), this.m_opUrlField);
        panel.addRow(new JLabel("E-Mail"), this.m_opEmailField);
        return panel;
    }

    protected void enableCert(boolean a_enabled) {
        this.m_otherCert.setEnabled(a_enabled);
    }

    protected GridBagLayout getGridBagLayout() {
        return this.m_layout;
    }

    protected GridBagConstraints getGridBagConstraints() {
        return this.m_gbc;
    }

    protected CertPanel getMixCertPanel() {
        return this.m_otherCert;
    }

    protected CertPanel getMixOperatorCertPanel() {
        return this.m_otherOpCert;
    }

    @Override
    public Vector<String> check() {
        Vector<String> errors = new Vector<String>();
        if (this.getConfiguration().isRootPathVerificationEnabled()) {
            return errors;
        }
        if (!this.m_otherCert.isEnabled() && this.m_otherCert.getCert() != null) {
            errors.addElement(this.m_type + " Certificate is present, but there is no corresponding mix.");
        } else if (!this.getConfiguration().isAutoConfigurationAllowed() && this.m_otherCert.isEnabled() && this.m_otherCert.getCert() == null) {
            errors.addElement(this.m_type + " Certificate is missing in " + this.getPanelName() + " panel.");
        }
        return errors;
    }

    @Override
    public void paint(Graphics g) {
        super.paint(g);
        JAPHelp.getInstance().setContext(JAPHelpContext.createHelpContext("index"));
    }

    @Override
    public void stateChanged(ChangeEvent a_e) {
        if (a_e.getSource() == this.m_otherCert) {
            MixCertificateView certView = (MixCertificateView)this.m_otherCert.getCertificateView();
            this.m_locCityField.setText(certView.getLocalityName());
            this.m_locCountryField.setText(certView.getCountry());
            this.m_locStateField.setText(certView.getStateOrProvince());
            this.m_locLongField.setText(certView.getLongitude());
            this.m_locLatField.setText(certView.getLatitude());
            if (this.m_otherCert.getCert() != null && (certView.isCA() || certView.getCountry().length() == 0 || certView.getLocalityName().length() == 0)) {
                JAPDialog.showWarningDialog(MixConfig.getMainWindow(), JAPMessages.getString(MSG_WARNING_NO_MIX_CERT));
            }
        } else if (a_e.getSource() == this.m_otherOpCert) {
            this.m_otherCert.setAdditionalVerifier(this.m_otherOpCert.getCert());
            this.m_otherCert.updateCertificateIcon(false);
            OperatorCertificateView certView = (OperatorCertificateView)this.m_otherOpCert.getCertificateView();
            this.m_opOrgField.setText(certView.getOrganisation());
            this.m_opOrgUnitField.setText(certView.getOrganisationalUnit());
            this.m_opCountryField.setText(certView.getCountry());
            this.m_opUrlField.setText(certView.getURL());
            this.m_opEmailField.setText(certView.getEMail());
            if (!(this.m_otherOpCert.getCert() == null || certView.isCA() && certView.getCountry().length() != 0 && certView.getEMail().length() != 0 && certView.getOrganisation().length() != 0)) {
                JAPDialog.showWarningDialog(MixConfig.getMainWindow(), JAPMessages.getString(MSG_WARNING_NO_OPERATOR_CERT));
            }
        }
    }
}

