/*
 * Decompiled with CFR 0.152.
 */
package mixconfig.tools.dataretention;

import anon.crypto.MyRSAPrivateKey;
import anon.crypto.PKCS12;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.PublicKey;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mixconfig.tools.dataretention.DataRetentionLogFileHeader;
import mixconfig.tools.dataretention.DataRetentionSmartCard;

public class RetentionDlg
extends JFrame {
    static DataRetentionSmartCard anonLog = new DataRetentionSmartCard();
    private static byte[] testLogKey = new byte[]{49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49, 49};
    PublicKey m_publicKey;
    byte[] m_logKeyBlock;
    private static final byte FOOTER_LENGTH = 20;
    private JButton SetCurrentDate;
    private JButton authenticateUser;
    private JButton createTestLogs;
    private JButton jButton1;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanel3;
    private JScrollPane jScrollPane1;
    private JPasswordField m_adminPIN;
    private JTextField m_currentDate;
    private JTextArea m_logs;
    private JTextField m_logsPeriod;
    private JTextField m_testLogsPeriod;
    private JPasswordField m_userPIN;
    private JButton retrieveLogs;

    public RetentionDlg() {
        block6: {
            this.m_publicKey = null;
            this.m_logKeyBlock = null;
            this.initComponents();
            try {
                this.m_logs.append("Connecting to ANON card... ");
                if (anonLog.connectToSmartCard()) {
                    this.m_logs.append("OK\n");
                    this.m_logs.append("Retriving public key... ");
                    try {
                        this.m_publicKey = anonLog.retrievePublicKey();
                        if (this.m_publicKey != null) {
                            this.m_logs.append("OK\n");
                            this.m_logs.append(this.m_publicKey.toString() + "\n");
                            break block6;
                        }
                        this.m_logs.append("FAIL\n");
                    }
                    catch (Exception ex) {
                        this.m_logs.append("FAIL\n");
                        System.out.println("Exception : " + ex);
                    }
                    break block6;
                }
                throw new Exception();
            }
            catch (Exception ex) {
                this.m_logs.append("FAIL\n");
                System.out.println("Exception : " + ex);
            }
        }
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jButton1 = new JButton();
        this.jLabel2 = new JLabel();
        this.m_currentDate = new JTextField();
        this.SetCurrentDate = new JButton();
        this.m_adminPIN = new JPasswordField();
        this.jPanel2 = new JPanel();
        this.jLabel3 = new JLabel();
        this.authenticateUser = new JButton();
        this.retrieveLogs = new JButton();
        this.m_logsPeriod = new JTextField();
        this.jLabel4 = new JLabel();
        this.m_userPIN = new JPasswordField();
        this.jScrollPane1 = new JScrollPane();
        this.m_logs = new JTextArea();
        this.jPanel3 = new JPanel();
        this.m_testLogsPeriod = new JTextField();
        this.createTestLogs = new JButton();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("ANON Log access console");
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel1.setText("Admin PIN");
        this.jButton1.setText("Authenticate admin");
        this.jButton1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RetentionDlg.this.jButton1ActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Current date (ddmmyyy)");
        this.m_currentDate.setText("14122008");
        this.SetCurrentDate.setText("Set current date");
        this.SetCurrentDate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RetentionDlg.this.SetCurrentDateActionPerformed(evt);
            }
        });
        this.m_adminPIN.setText("12345678");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.m_currentDate).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.m_adminPIN, -1, 133, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.SetCurrentDate, -1, -1, Short.MAX_VALUE).addComponent(this.jButton1, -1, -1, Short.MAX_VALUE)).addContainerGap(13, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_adminPIN, -2, -1, -2).addComponent(this.jButton1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_currentDate, -2, -1, -2).addComponent(this.SetCurrentDate)).addContainerGap()));
        this.jPanel2.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jLabel3.setText("User PIN");
        this.authenticateUser.setText("Authenticate user");
        this.authenticateUser.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RetentionDlg.this.authenticateUserActionPerformed(evt);
            }
        });
        this.retrieveLogs.setText("Retrieve logs");
        this.retrieveLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                RetentionDlg.this.retrieveLogsActionPerformed(evt);
            }
        });
        this.m_logsPeriod.setText("31122008");
        this.jLabel4.setText("Logs date  (ddmmyyy)");
        this.m_userPIN.setText("1234");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.m_logsPeriod, GroupLayout.Alignment.TRAILING).addComponent(this.jLabel4).addComponent(this.jLabel3).addComponent(this.m_userPIN, -2, 134, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.retrieveLogs, -1, 129, Short.MAX_VALUE).addComponent(this.authenticateUser, -1, 129, Short.MAX_VALUE)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jLabel3).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_userPIN, -2, -1, -2).addComponent(this.authenticateUser)).addGap(10, 10, 10).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_logsPeriod, -2, -1, -2).addComponent(this.retrieveLogs)).addContainerGap(16, Short.MAX_VALUE)));
        this.m_logs.setColumns(20);
        this.m_logs.setRows(5);
        this.jScrollPane1.setViewportView(this.m_logs);
        this.jPanel3.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.m_testLogsPeriod.setText("11102008");
        this.createTestLogs.setText("Generate test logs");
        this.createTestLogs.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
            }
        });
        this.jLabel5.setText(".: Development test functions :.");
        this.jLabel6.setText("Logs date  (ddmmyyy)");
        GroupLayout jPanel3Layout = new GroupLayout(this.jPanel3);
        this.jPanel3.setLayout(jPanel3Layout);
        jPanel3Layout.setHorizontalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addContainerGap().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel5, -1, 279, Short.MAX_VALUE).addGroup(jPanel3Layout.createSequentialGroup().addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.jLabel6).addGap(158, 158, 158)).addGroup(jPanel3Layout.createSequentialGroup().addComponent(this.m_testLogsPeriod, -2, 132, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.createTestLogs, -1, 127, Short.MAX_VALUE))).addContainerGap()))));
        jPanel3Layout.setVerticalGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel3Layout.createSequentialGroup().addGap(5, 5, 5).addComponent(this.jLabel5, -2, 14, -2).addGap(18, 18, 18).addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(jPanel3Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_testLogsPeriod, -2, -1, -2).addComponent(this.createTestLogs)).addContainerGap(12, Short.MAX_VALUE)));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jPanel3, GroupLayout.Alignment.LEADING, 0, -1, Short.MAX_VALUE).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE)).addGap(18, 18, 18).addComponent(this.jScrollPane1, -1, 623, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING, false).addComponent(this.jScrollPane1, GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jPanel1, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel2, -2, -1, -2).addGap(18, 18, 18).addComponent(this.jPanel3, -2, -1, -2))).addGap(38, 38, 38)));
        this.pack();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.m_logs.append("\n");
        this.m_logs.append("Authenticating admin by PIN... ");
        try {
            if (anonLog.Admin_Authenticate(this.m_adminPIN.getText().getBytes())) {
                this.m_logs.append("OK\n");
            } else {
                this.m_logs.append("FAIL\n");
            }
        }
        catch (Exception ex) {
            this.m_logs.append("FAIL\n");
            System.out.println("Exception : " + ex);
        }
    }

    private void SetCurrentDateActionPerformed(ActionEvent evt) {
        this.m_logs.append("\n");
        try {
            byte day = (byte)Integer.parseInt(this.m_currentDate.getText(0, 2));
            byte month = (byte)Integer.parseInt(this.m_currentDate.getText(2, 2));
            short year = (short)Integer.parseInt(this.m_currentDate.getText(4, 4));
            this.m_logs.append("Setting current date '" + Integer.toString(day) + "." + Integer.toString(month) + "." + Integer.toString(year) + "' .... ");
            if (anonLog.Admin_SetCurrentDate(day, month, year)) {
                this.m_logs.append("OK\n");
            } else {
                this.m_logs.append("FAIL (Are you authenticated as admin?)\n");
            }
        }
        catch (Exception ex) {
            this.m_logs.append("FAIL (Are you authenticated as admin?)\n");
            System.out.println("Exception : " + ex);
        }
    }

    private void authenticateUserActionPerformed(ActionEvent evt) {
        this.m_logs.append("\n");
        this.m_logs.append("Authenticating user by PIN... ");
        try {
            if (anonLog.authenticateUser(this.m_userPIN.getText().getBytes())) {
                this.m_logs.append("OK\n");
            } else {
                this.m_logs.append("FAIL\n");
            }
        }
        catch (Exception ex) {
            this.m_logs.append("FAIL\n");
            System.out.println("Exception : " + ex);
        }
    }

    private void retrieveLogsActionPerformed(ActionEvent evt) {
        this.m_logs.append("\n");
        try {
            byte logDay = (byte)Integer.parseInt(this.m_logsPeriod.getText(0, 2));
            byte logMonth = (byte)Integer.parseInt(this.m_logsPeriod.getText(2, 2));
            short logYear = (short)Integer.parseInt(this.m_logsPeriod.getText(4, 4));
            this.m_logs.append("Retrieving logs for period '" + Integer.toString(logDay) + "." + Integer.toString(logMonth) + "." + Integer.toString(logYear) + "'\n");
            String dateString = Integer.toString(logDay) + Integer.toString(logMonth) + Integer.toString(logYear);
            String fileName = "c:\\ANONlog_" + dateString + ".txt";
            String fileNameOut = "c:\\ANONlog_" + dateString + ".txt.ret";
            FileInputStream in = new FileInputStream(fileName);
            FileOutputStream out = new FileOutputStream(fileNameOut);
            this.m_logs.append("Processing file '" + fileName + "'\n");
            this.m_logs.append("Writing into file '" + fileNameOut + "'\n");
            DataRetentionLogFileHeader header = new DataRetentionLogFileHeader();
            this.m_logs.append("Parsing header... ");
            header.parseFromFile(in);
            this.m_logs.append("OK\n");
            header.writeToFile(out);
            byte[] decrLogKey = null;
            this.m_logs.append("Retrieving log key... ");
            PKCS12 pkcs12 = PKCS12.getInstance((InputStream)new FileInputStream("c:/dataretentiontest.pfx"), "");
            MyRSAPrivateKey privKey = (MyRSAPrivateKey)pkcs12.getPrivateKey();
            decrLogKey = anonLog.decrpytSymmetricKey(header.getEncryptedKey(0));
            if (decrLogKey == null) {
                this.m_logs.append("FAIL (Are you authenticated as user?)\n");
                throw new Exception();
            }
            this.m_logs.append("OK\n");
            this.m_logs.append("Log key: " + anonLog.bytesToHex(decrLogKey) + "\n");
            int encrLogLineLength = header.getSizeOfLogLine();
            this.m_logs.append("Expected length of single log line: " + encrLogLineLength + "\n");
            File file = new File(fileName);
            long fileLength = file.length();
            int numLogLinesEntries = (int)((fileLength - (long)header.getLength() - 20L) / (long)encrLogLineLength);
            this.m_logs.append("Expected number of log entries: " + numLogLinesEntries + "\n");
            byte[] encrLogLine = new byte[encrLogLineLength];
            byte[] decrData = null;
            byte[] iv = null;
            int counter = 0;
            for (int i = 0; i < numLogLinesEntries; ++i) {
                in.read(encrLogLine);
                iv = anonLog.CreateIV(counter);
                decrData = anonLog.DecryptLogLineKey(decrLogKey, encrLogLine, iv);
                this.m_logs.append(" Log line " + counter + " : " + anonLog.bytesToHex(decrData) + "\n");
                out.write(decrData);
                ++counter;
            }
            int extraEntries = 0;
            if ((long)(numLogLinesEntries * encrLogLineLength) < fileLength - (long)header.getLength() - 20L) {
                byte[] tmpBuff = new byte[(int)(fileLength - (long)header.getLength() - 20L - (long)(numLogLinesEntries * encrLogLineLength))];
                in.read(tmpBuff);
                iv = anonLog.CreateIV(counter);
                decrData = anonLog.DecryptLogLineKey(decrLogKey, tmpBuff, iv);
                this.m_logs.append(" Log line " + counter + " : " + anonLog.bytesToHex(decrData) + "\n");
                extraEntries = tmpBuff.length / header.getSizeOfLogEntry();
            }
            byte[] footer = new byte[20];
            in.read(footer);
            this.m_logs.append("Verifying footer... ");
            int footerNumLogLines = anonLog.VerifyFooter(decrLogKey, footer, counter);
            this.m_logs.append("OK\n");
            this.m_logs.append("Number of log entries from footer: " + footerNumLogLines + "\n");
            if (numLogLinesEntries * header.getNrOfLogEntriesPerLogLine() + extraEntries != footerNumLogLines) {
                this.m_logs.append("ERROR: Number of log entries from footer differ from observed logs");
                throw new Exception();
            }
            out.write(footer);
            in.close();
            out.close();
            this.m_logs.append("\nDecrypted logs were succesfully written into file '" + fileNameOut + "'\n");
        }
        catch (Exception ex) {
            this.m_logs.append("FAIL\n");
        }
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new RetentionDlg().setVisible(true);
            }
        });
    }
}

