/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import HTTPClient.HTTPConnection;
import HTTPClient.ThreadInterruptedIOException;
import anon.AnonChannel;
import anon.AnonServerDescription;
import anon.AnonService;
import anon.AnonServiceEventListener;
import anon.IServiceContainer;
import anon.NotConnectedToMixException;
import anon.client.DataChainErrorListener;
import anon.client.DummyTrafficControlChannel;
import anon.client.FixedRatioChannelsDescription;
import anon.client.KeyExchangeManager;
import anon.client.MixPacket;
import anon.client.MixParameters;
import anon.client.Multiplexer;
import anon.client.PacketCounter;
import anon.client.SequentialChannelDataChain;
import anon.client.SingleChannelDataChain;
import anon.client.SocketHandler;
import anon.client.TestControlChannel;
import anon.client.TrustException;
import anon.client.TypeFilterDataChain;
import anon.client.UnknownProtocolVersionException;
import anon.client.replay.ReplayControlChannel;
import anon.client.replay.TimestampUpdater;
import anon.infoservice.HTTPConnectionFactory;
import anon.infoservice.IMutableProxyInterface;
import anon.infoservice.ImmutableProxyInterface;
import anon.infoservice.MixCascade;
import anon.pay.AIControlChannel;
import anon.pay.IAIEventListener;
import anon.pay.PayAccount;
import anon.terms.TermsAndConditionConfirmation;
import anon.terms.TermsAndConditionsReadException;
import anon.transport.connection.ConnectionException;
import anon.transport.connection.IStreamConnection;
import anon.transport.connection.SocketConnection;
import anon.util.JobQueue;
import anon.util.XMLParseException;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.Socket;
import java.security.SecureRandom;
import java.security.SignatureException;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class AnonClient
implements AnonService,
Observer,
DataChainErrorListener {
    private static boolean ENABLE_CONTROL_CHANNEL_TEST = false;
    public static final int DEFAULT_LOGIN_TIMEOUT = 30000;
    private static final int FAST_LOGIN_TIMEOUT = 4000;
    private static final int CONNECT_TIMEOUT = 8000;
    private static int m_loginTimeout = 30000;
    private static int m_loginTimeoutFastAvailable;
    private Multiplexer m_multiplexer = null;
    private JobQueue m_queuePacketCount;
    private IMutableProxyInterface m_proxyInterface;
    private Object m_internalSynchronization;
    private IServiceContainer m_serviceContainer;
    private Thread m_threadInitialise;
    private Object SYNC_SHUTDOWN = new Object();
    private Object m_internalSynchronizationForSocket;
    private Object m_internalSynchronizationForDummyTraffic;
    private SocketHandler m_socketHandler = null;
    private Vector m_eventListeners;
    private PacketCounter m_packetCounter = null;
    private DummyTrafficControlChannel m_dummyTrafficControlChannel = null;
    private int m_dummyTrafficInterval = -1;
    private KeyExchangeManager m_keyExchangeManager = null;
    private IStreamConnection m_streamConnection = null;
    private boolean m_connected = false;
    private IAIEventListener m_aiEventListener;

    public AnonClient() {
        this.m_internalSynchronization = new Object();
        this.m_internalSynchronizationForSocket = new Object();
        this.m_internalSynchronizationForDummyTraffic = new Object();
        this.m_eventListeners = new Vector();
        this.m_proxyInterface = new IMutableProxyInterface.DummyMutableProxyInterface();
        this.m_queuePacketCount = new JobQueue("AnonClient Packet count updater");
    }

    public AnonClient(IStreamConnection iStreamConnection) {
        this();
        this.m_streamConnection = iStreamConnection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int initialize(final AnonServerDescription anonServerDescription, final IServiceContainer iServiceContainer, final TermsAndConditionConfirmation termsAndConditionConfirmation) {
        if (!(anonServerDescription instanceof MixCascade)) {
            return -5;
        }
        final MixCascade mixCascade = (MixCascade)anonServerDescription;
        this.m_serviceContainer = iServiceContainer;
        StatusThread statusThread = new StatusThread(){
            int status;

            public int getStatus() {
                return this.status;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = AnonClient.this.m_internalSynchronization;
                synchronized (object) {
                    if (AnonClient.this.isConnected()) {
                        LogHolder.log(3, LogType.NET, "AnonClient was already connected when connecting!");
                        this.status = -4;
                        Thread thread = AnonClient.this.m_threadInitialise;
                        synchronized (thread) {
                            AnonClient.this.m_threadInitialise.notifyAll();
                        }
                        return;
                    }
                    IStreamConnection iStreamConnection = null;
                    if (AnonClient.this.m_streamConnection != null) {
                        iStreamConnection = AnonClient.this.m_streamConnection;
                        AnonClient.this.m_streamConnection = null;
                    } else {
                        try {
                            iStreamConnection = AnonClient.this.connectMixCascade(mixCascade, AnonClient.this.m_proxyInterface.getProxyInterface(false).getProxyInterface());
                        }
                        catch (InterruptedIOException interruptedIOException) {
                            this.status = -24;
                            Thread thread = AnonClient.this.m_threadInitialise;
                            synchronized (thread) {
                                AnonClient.this.m_threadInitialise.notifyAll();
                            }
                            return;
                        }
                    }
                    if (iStreamConnection == null) {
                        this.status = -6;
                        Thread thread = AnonClient.this.m_threadInitialise;
                        synchronized (thread) {
                            AnonClient.this.m_threadInitialise.notifyAll();
                        }
                        return;
                    }
                    this.status = AnonClient.this.initializeProtocol(iStreamConnection, anonServerDescription, iServiceContainer, termsAndConditionConfirmation);
                    Thread thread = AnonClient.this.m_threadInitialise;
                    synchronized (thread) {
                        AnonClient.this.m_threadInitialise.notifyAll();
                    }
                    return;
                }
            }
        };
        Object object = this.SYNC_SHUTDOWN;
        synchronized (object) {
            this.m_threadInitialise = new Thread(statusThread);
        }
        this.m_threadInitialise.start();
        try {
            this.m_threadInitialise.join();
        }
        catch (InterruptedException interruptedException) {
            Thread thread = this.m_threadInitialise;
            synchronized (thread) {
                while (this.m_threadInitialise.isAlive()) {
                    this.m_threadInitialise.interrupt();
                    try {
                        this.m_threadInitialise.wait(500L);
                    }
                    catch (InterruptedException interruptedException2) {}
                }
            }
            return -24;
        }
        return statusThread.getStatus();
    }

    public static void setLoginTimeout(int n) {
        if (n >= 1000) {
            m_loginTimeout = n;
        }
    }

    private static void resetInternalLoginTimeout() {
        int n = 30;
        m_loginTimeoutFastAvailable = Math.max(m_loginTimeout / 1000, m_loginTimeout / 4000);
        if (m_loginTimeoutFastAvailable > n) {
            m_loginTimeoutFastAvailable = n;
        }
    }

    private static int getInternalLoginTimeout(IServiceContainer iServiceContainer) {
        if (iServiceContainer != null && m_loginTimeoutFastAvailable > 0 && iServiceContainer.isReconnectedAutomatically() && iServiceContainer.isServiceAutoSwitched()) {
            --m_loginTimeoutFastAvailable;
            return 4000;
        }
        return m_loginTimeout;
    }

    public static int getLoginTimeout() {
        return m_loginTimeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int setProxy(IMutableProxyInterface iMutableProxyInterface) {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            this.m_proxyInterface = iMutableProxyInterface == null ? new IMutableProxyInterface.DummyMutableProxyInterface() : iMutableProxyInterface;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown(boolean bl) {
        Object object;
        Object object2 = this.m_internalSynchronizationForSocket;
        synchronized (object2) {
            if (this.m_socketHandler != null) {
                this.m_socketHandler.deleteObservers();
            }
        }
        object2 = this.m_internalSynchronization;
        synchronized (object2) {
            if (this.m_multiplexer != null) {
                this.m_multiplexer.close();
            }
        }
        object2 = this.m_internalSynchronizationForSocket;
        synchronized (object2) {
            if (this.m_socketHandler != null) {
                this.m_socketHandler.closeSocket();
                this.m_socketHandler = null;
            }
        }
        object2 = this.SYNC_SHUTDOWN;
        synchronized (object2) {
            if (this.m_threadInitialise != null) {
                object = this.m_threadInitialise;
                synchronized (object) {
                    while (this.m_threadInitialise.isAlive()) {
                        this.m_threadInitialise.interrupt();
                        try {
                            this.m_threadInitialise.wait(100L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                            break;
                        }
                    }
                }
            }
        }
        object2 = this.m_internalSynchronization;
        synchronized (object2) {
            if (this.m_multiplexer != null) {
                this.m_multiplexer.deleteObservers();
            }
            this.m_multiplexer = null;
            this.m_connected = false;
            object = this.m_internalSynchronizationForDummyTraffic;
            synchronized (object) {
                if (this.m_dummyTrafficControlChannel != null) {
                    this.m_dummyTrafficControlChannel.stop();
                    this.m_dummyTrafficControlChannel = null;
                }
            }
            if (this.m_packetCounter != null) {
                this.m_packetCounter.deleteObserver(this);
                if (bl) {
                    this.m_packetCounter = null;
                }
            }
            if (this.m_keyExchangeManager != null) {
                this.m_keyExchangeManager.removeCertificateLock();
                this.m_keyExchangeManager = null;
            }
        }
    }

    public boolean isConnected() {
        return this.m_connected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnonChannel createChannel(int n) throws ConnectException {
        Multiplexer multiplexer = null;
        KeyExchangeManager keyExchangeManager = null;
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            if (this.m_multiplexer == null) {
                throw new NotConnectedToMixException("AnonClient: createChannel(): The AN.ON client is currently not connected to a mixcascade.");
            }
            multiplexer = this.m_multiplexer;
            keyExchangeManager = this.m_keyExchangeManager;
        }
        object = keyExchangeManager.getFixedRatioChannelsDescription();
        if (object == null) {
            return new SingleChannelDataChain(multiplexer.getChannelTable(), this, n, keyExchangeManager.isChainProtocolWithFlowControl(), keyExchangeManager.getUpstreamSendMe(), keyExchangeManager.getDownstreamSendMe(), keyExchangeManager.isProtocolWithEnhancedChannelEncryption());
        }
        return new TypeFilterDataChain(new SequentialChannelDataChain(multiplexer.getChannelTable(), this, ((FixedRatioChannelsDescription)object).getChainTimeout()), n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEventListener(AnonServiceEventListener anonServiceEventListener) {
        Vector vector = this.m_eventListeners;
        synchronized (vector) {
            this.m_eventListeners.addElement(anonServiceEventListener);
        }
    }

    public void removeEventListeners() {
        this.m_eventListeners.removeAllElements();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeEventListener(AnonServiceEventListener anonServiceEventListener) {
        Vector vector = this.m_eventListeners;
        synchronized (vector) {
            this.m_eventListeners.removeElement(anonServiceEventListener);
        }
    }

    private void reconnect(final Object object) {
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                AnonClient.this.shutdown(!AnonClient.this.m_serviceContainer.isReconnectedAutomatically());
                Vector vector = AnonClient.this.m_eventListeners;
                synchronized (vector) {
                    final Enumeration enumeration = AnonClient.this.m_eventListeners.elements();
                    Thread thread = new Thread(new Runnable(){

                        public void run() {
                            if (object != null && object instanceof Exception) {
                                LogHolder.log(6, LogType.NET, (Exception)object);
                            }
                            while (enumeration.hasMoreElements()) {
                                ((AnonServiceEventListener)enumeration.nextElement()).connectionError();
                            }
                        }
                    }, "ConnectionError notification");
                    thread.setDaemon(true);
                    thread.start();
                }
            }
        }).start();
    }

    public void update(Observable observable, Object object) {
        if (observable == this.m_socketHandler && object instanceof IOException) {
            this.reconnect(object);
        } else if (observable == this.m_packetCounter) {
            JobQueue.Job job = new JobQueue.Job(true){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void runJob() {
                    Vector vector = AnonClient.this.m_eventListeners;
                    PacketCounter packetCounter = AnonClient.this.m_packetCounter;
                    if (vector != null && packetCounter != null) {
                        Vector vector2 = vector;
                        synchronized (vector2) {
                            Enumeration enumeration = vector.elements();
                            while (enumeration.hasMoreElements()) {
                                ((AnonServiceEventListener)enumeration.nextElement()).packetMixed(packetCounter.getProcessedPackets() * (long)MixPacket.getPacketSize());
                            }
                        }
                    }
                }
            };
            this.m_queuePacketCount.addJob(job);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataChainErrorSignaled() {
        Vector vector = this.m_eventListeners;
        synchronized (vector) {
            final Enumeration enumeration = this.m_eventListeners.elements();
            Thread thread = new Thread(new Runnable(){

                public void run() {
                    while (enumeration.hasMoreElements()) {
                        ((AnonServiceEventListener)enumeration.nextElement()).dataChainErrorSignaled();
                    }
                }
            }, "AnonClient: DataChainErrorSignaled notification");
            thread.setDaemon(true);
            thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setDummyTraffic(int n) {
        Object object = this.m_internalSynchronizationForDummyTraffic;
        synchronized (object) {
            this.m_dummyTrafficInterval = n;
            if (this.m_dummyTrafficControlChannel != null) {
                this.m_dummyTrafficControlChannel.setDummyTrafficInterval(n);
            }
        }
    }

    private IStreamConnection connectMixCascade(final MixCascade mixCascade, ImmutableProxyInterface immutableProxyInterface) throws InterruptedIOException {
        LogHolder.log(7, LogType.NET, "Trying to connect to MixCascade '" + mixCascade.toString() + "'...");
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Vector vector = AnonClient.this.m_eventListeners;
                synchronized (vector) {
                    Enumeration enumeration = AnonClient.this.m_eventListeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((AnonServiceEventListener)enumeration.nextElement()).connecting(mixCascade);
                    }
                }
            }
        }, "AnonClient: Connecting notification");
        thread.setDaemon(true);
        thread.start();
        Socket socket = null;
        for (int i = 0; i < mixCascade.getNumberOfListenerInterfaces() && socket == null && !Thread.currentThread().isInterrupted(); ++i) {
            try {
                HTTPConnection hTTPConnection = HTTPConnectionFactory.getInstance().createHTTPConnection(mixCascade.getListenerInterface(i), immutableProxyInterface);
                hTTPConnection.setTimeout(8000);
                socket = hTTPConnection.Connect();
                continue;
            }
            catch (InterruptedIOException interruptedIOException) {
                if (interruptedIOException instanceof ThreadInterruptedIOException) {
                    LogHolder.log(5, LogType.NET, "Interrupted while connecting to MixCascade '" + mixCascade.toString() + "'.");
                    throw interruptedIOException;
                }
                LogHolder.log(3, LogType.NET, "Timeout while connecting to MixCascade " + mixCascade.toString() + " via " + mixCascade.getListenerInterface(i).toString() + "!", interruptedIOException);
                continue;
            }
            catch (Exception exception) {
                LogHolder.log(3, LogType.NET, "Could not connect to MixCascade " + mixCascade.toString() + " via " + mixCascade.getListenerInterface(i).toString() + "!", exception);
            }
        }
        if (socket != null) {
            LogHolder.log(7, LogType.NET, "Connection to MixCascade '" + mixCascade.toString() + "' successfully established - starting key-exchange...");
            return new SocketConnection(socket);
        }
        LogHolder.log(3, LogType.NET, "Failed to connect to MixCascade '" + mixCascade.toString() + "'.");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int initializeProtocol(IStreamConnection iStreamConnection, final AnonServerDescription anonServerDescription, final IServiceContainer iServiceContainer, final TermsAndConditionConfirmation termsAndConditionConfirmation) {
        Object object = this.m_internalSynchronization;
        synchronized (object) {
            int n;
            Object object2;
            try {
                try {
                    iStreamConnection.setTimeout(AnonClient.getInternalLoginTimeout(iServiceContainer));
                }
                catch (ConnectionException connectionException) {
                    // empty catch block
                }
                object2 = this.m_internalSynchronizationForSocket;
                synchronized (object2) {
                    if (this.m_socketHandler != null) {
                        this.m_socketHandler.deleteObservers();
                    }
                    this.m_socketHandler = new SocketHandler(iStreamConnection);
                }
                object2 = new Vector();
                Thread thread = new Thread(new Runnable((Vector)object2){
                    private final /* synthetic */ Vector val$exceptionCache;
                    {
                        this.val$exceptionCache = vector;
                    }

                    public void run() {
                        boolean bl = true;
                        int n = 0;
                        try {
                            while (bl) {
                                try {
                                    AnonClient.this.m_keyExchangeManager = new KeyExchangeManager(AnonClient.this.m_socketHandler.getInputStream(), AnonClient.this.m_socketHandler.getOutputStream(), (MixCascade)anonServerDescription, iServiceContainer);
                                    bl = false;
                                }
                                catch (TermsAndConditionsReadException termsAndConditionsReadException) {
                                    if (!termsAndConditionConfirmation.confirmTermsAndConditions(termsAndConditionsReadException.getOperators(), termsAndConditionsReadException.getTermsTermsAndConditonsToRead())) {
                                        iServiceContainer.keepCurrentService(false);
                                        throw new InterruptedException("Client rejected T&C after reading.");
                                    }
                                    if (++n > 1) {
                                        LogHolder.log(3, LogType.NET, "Requesting t&cs after the first try is not allowed!");
                                        throw new InterruptedException("A second tc request must never be sent.");
                                    }
                                    AnonClient.this.m_socketHandler = new SocketHandler(AnonClient.this.connectMixCascade((MixCascade)anonServerDescription, AnonClient.this.m_proxyInterface.getProxyInterface(false).getProxyInterface()));
                                }
                            }
                        }
                        catch (Exception exception) {
                            this.val$exceptionCache.addElement(exception);
                        }
                    }
                }, "Login Thread");
                thread.start();
                thread.join();
                if (((Vector)object2).size() > 0) {
                    throw (Exception)((Vector)object2).firstElement();
                }
            }
            catch (UnknownProtocolVersionException unknownProtocolVersionException) {
                LogHolder.log(3, LogType.NET, unknownProtocolVersionException);
                this.closeSocketHandler();
                return -10;
            }
            catch (SignatureException signatureException) {
                LogHolder.log(2, LogType.CRYPTO, signatureException);
                this.closeSocketHandler();
                return -23;
            }
            catch (InterruptedException interruptedException) {
                LogHolder.log(6, LogType.NET, interruptedException);
                this.closeSocketHandler();
                return -24;
            }
            catch (TrustException trustException) {
                LogHolder.log(6, LogType.NET, trustException);
                this.closeSocketHandler();
                return -26;
            }
            catch (XMLParseException xMLParseException) {
                LogHolder.log(3, LogType.NET, xMLParseException);
                this.closeSocketHandler();
                return -27;
            }
            catch (Exception exception) {
                LogHolder.log(3, LogType.NET, exception);
                this.closeSocketHandler();
                return -1;
            }
            try {
                iStreamConnection.setTimeout(0);
            }
            catch (ConnectionException connectionException) {
                // empty catch block
            }
            this.m_multiplexer = new Multiplexer(this.m_socketHandler.getInputStream(), this.m_socketHandler.getOutputStream(), this.m_keyExchangeManager, new SecureRandom());
            this.m_socketHandler.addObserver(this);
            this.m_packetCounter = this.m_packetCounter != null ? new PacketCounter(this.m_packetCounter.getProcessedPackets()) : new PacketCounter();
            this.m_multiplexer.addObserver(this.m_packetCounter);
            this.m_packetCounter.addObserver(this);
            object2 = this.m_internalSynchronizationForDummyTraffic;
            synchronized (object2) {
                this.m_dummyTrafficControlChannel = new DummyTrafficControlChannel(this.m_multiplexer, iServiceContainer);
                this.m_dummyTrafficControlChannel.setDummyTrafficInterval(this.m_dummyTrafficInterval);
            }
            if (ENABLE_CONTROL_CHANNEL_TEST) {
                object2 = new TestControlChannel(this.m_multiplexer, iServiceContainer);
                ((TestControlChannel)object2).setMessageInterval(30000);
            }
            if ((n = this.finishInitialization(this.m_multiplexer, this.m_keyExchangeManager, this.m_packetCounter, iStreamConnection, iServiceContainer, this.m_keyExchangeManager.getConnectedCascade())) != 0) {
                this.shutdown(!iServiceContainer.isReconnectedAutomatically());
                return n;
            }
            this.connectionEstablished(anonServerDescription);
            return 0;
        }
    }

    public void connectionEstablished(final AnonServerDescription anonServerDescription) {
        AnonClient.resetInternalLoginTimeout();
        Thread thread = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Vector vector = AnonClient.this.m_eventListeners;
                synchronized (vector) {
                    Enumeration enumeration = AnonClient.this.m_eventListeners.elements();
                    while (enumeration.hasMoreElements()) {
                        ((AnonServiceEventListener)enumeration.nextElement()).connectionEstablished(anonServerDescription);
                    }
                }
            }
        }, "AnonClient: ConnectionEstablished notification");
        thread.setDaemon(true);
        thread.start();
        LogHolder.log(6, LogType.NET, "Connected to MixCascade '" + anonServerDescription.toString() + "'!");
        this.m_connected = true;
    }

    private int finishInitialization(Multiplexer multiplexer, KeyExchangeManager keyExchangeManager, PacketCounter packetCounter, IStreamConnection iStreamConnection, IServiceContainer iServiceContainer, MixCascade mixCascade) {
        MixParameters[] mixParametersArray;
        if (keyExchangeManager.isProtocolWithTimestamp()) {
            mixParametersArray = keyExchangeManager.getMixParameters();
            if (keyExchangeManager.getFirstMixSymmetricCipher() != null) {
                mixParametersArray = new MixParameters[keyExchangeManager.getMixParameters().length - 1];
                for (int i = 0; i < keyExchangeManager.getMixParameters().length - 1; ++i) {
                    mixParametersArray[i] = keyExchangeManager.getMixParameters()[i + 1];
                }
            }
            try {
                new TimestampUpdater(mixParametersArray, new ReplayControlChannel(multiplexer, iServiceContainer));
            }
            catch (Exception exception) {
                LogHolder.log(3, LogType.NET, "Fetching of timestamps failed - closing connection.", exception);
                return -1;
            }
        }
        mixParametersArray = new AIControlChannel(multiplexer, packetCounter, iServiceContainer, mixCascade);
        if (keyExchangeManager.isPaymentRequired()) {
            mixParametersArray.addAIListener(new IAIEventListener(){

                public void accountEmpty(PayAccount payAccount, MixCascade mixCascade) {
                    AnonClient.this.reconnect(null);
                }
            });
            mixParametersArray.setAILoginTimeout(m_loginTimeout);
            return mixParametersArray.sendAccountCert();
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSocketHandler() {
        Object object = this.m_internalSynchronizationForSocket;
        synchronized (object) {
            if (this.m_socketHandler != null) {
                this.m_socketHandler.closeSocket();
                this.m_socketHandler = null;
            }
        }
    }

    static {
        AnonClient.resetInternalLoginTimeout();
    }

    private static interface StatusThread
    extends Runnable {
        public int getStatus();
    }
}

