/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.AbstractDataChain;
import anon.client.AbstractDataChannel;
import anon.client.FixedRatioChannelsDescription;
import anon.client.IDataChannelFactory;
import anon.client.KeyExchangeManager;
import anon.client.Multiplexer;
import anon.client.SimulatedLimitedDataChannel;
import anon.client.UnlimitedDataChannel;
import anon.client.crypto.DefaultMixCipher;
import anon.client.crypto.FirstMixCipher;
import anon.client.crypto.IMixCipher;
import anon.client.crypto.KeyPool;
import anon.client.crypto.MixCipherChain;
import anon.client.crypto.SymCipher;

public class DefaultDataChannelFactory
implements IDataChannelFactory {
    private static final int SYMMETRIC_CIPHER_KEY_LENGTH = 16;
    private static final int SYMMETRIC_CIPHER_BLOCK_LENGTH = 16;
    private KeyExchangeManager m_keyExchangeManager;
    private Multiplexer m_multiplexer;

    public DefaultDataChannelFactory(KeyExchangeManager keyExchangeManager, Multiplexer multiplexer) {
        this.m_keyExchangeManager = keyExchangeManager;
        this.m_multiplexer = multiplexer;
    }

    public AbstractDataChannel createDataChannel(int n, AbstractDataChain abstractDataChain) {
        IMixCipher[] iMixCipherArray = new IMixCipher[this.m_keyExchangeManager.getMixParameters().length];
        for (int i = 0; i < iMixCipherArray.length; ++i) {
            byte[] byArray;
            SymCipher symCipher;
            if (i == 0 && this.m_keyExchangeManager.getFirstMixSymmetricCipher() != null) {
                symCipher = new SymCipher();
                if (this.m_keyExchangeManager.isProtocolWithEnhancedChannelEncryption()) {
                    byArray = new byte[32];
                } else {
                    byArray = new byte[16];
                    KeyPool.getKey(byArray);
                }
                symCipher.setEncryptionKeysAES(byArray);
                byte[] byArray2 = new byte[16];
                for (int j = 0; j < byArray2.length; ++j) {
                    byArray2[j] = -1;
                }
                symCipher.setIV2(byArray2);
                iMixCipherArray[i] = new FirstMixCipher(this.m_keyExchangeManager.getFirstMixSymmetricCipher(), symCipher);
                continue;
            }
            symCipher = new SymCipher();
            if (this.m_keyExchangeManager.isProtocolWithEnhancedChannelEncryption()) {
                byArray = new byte[32];
            } else {
                byArray = new byte[16];
                KeyPool.getKey(byArray);
            }
            symCipher.setEncryptionKeysAES(byArray);
            iMixCipherArray[i] = new DefaultMixCipher(this.m_keyExchangeManager.getMixParameters()[i], symCipher);
        }
        FixedRatioChannelsDescription fixedRatioChannelsDescription = this.m_keyExchangeManager.getFixedRatioChannelsDescription();
        if (fixedRatioChannelsDescription == null) {
            return new UnlimitedDataChannel(n, this.m_multiplexer, abstractDataChain, new MixCipherChain(iMixCipherArray));
        }
        return new SimulatedLimitedDataChannel(n, this.m_multiplexer, abstractDataChain, new MixCipherChain(iMixCipherArray), fixedRatioChannelsDescription.getChannelDownstreamPackets(), fixedRatioChannelsDescription.getChannelTimeout());
    }
}

