/*
 * Decompiled with CFR 0.152.
 */
package anon.client;

import anon.client.AbstractDataChain;
import anon.client.AbstractDataChannel;
import anon.client.DataChainErrorListener;
import anon.client.DataChainInputStreamQueueEntry;
import anon.client.DataChainSendOrderStructure;
import anon.client.IDataChannelCreator;
import anon.client.InternalChannelMessage;
import anon.client.InternalChannelMessageQueue;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Vector;
import logging.LogHolder;
import logging.LogType;

public class SingleChannelDataChain
extends AbstractDataChain {
    private static final short FLAG_FLOW_CONTROL = Short.MIN_VALUE;
    private static final int CLOSE_CELL_CONNECTION_ERROR = 1;
    private int m_chainType;
    private boolean m_supportFlowControl;
    private AbstractDataChannel m_associatedChannel;
    private boolean m_firstUpstreamPacket;
    private int m_downstreamSendMeCount;
    private int m_downstreamSendMeLimit;
    private boolean m_bEnhancedChannelEncryption;

    public SingleChannelDataChain(IDataChannelCreator iDataChannelCreator, DataChainErrorListener dataChainErrorListener, int n, boolean bl, int n2, int n3, boolean bl2) {
        super(iDataChannelCreator, dataChainErrorListener);
        this.m_chainType = n;
        this.m_supportFlowControl = bl;
        this.m_bEnhancedChannelEncryption = bl2;
        this.m_associatedChannel = this.createDataChannel();
        this.m_associatedChannel.getChannelMessageQueue().addObserver(this);
        this.m_firstUpstreamPacket = true;
        this.m_downstreamSendMeCount = 0;
        this.m_downstreamSendMeLimit = n3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutputBlockSize() {
        int n = 0;
        AbstractDataChannel abstractDataChannel = this.m_associatedChannel;
        synchronized (abstractDataChannel) {
            n = this.m_associatedChannel.getNextPacketRecommandedOutputBlocksize();
        }
        return Math.max(0, n - 3);
    }

    public void createPacketPayload(DataChainSendOrderStructure dataChainSendOrderStructure) {
        if (dataChainSendOrderStructure.getOrderData() != null) {
            int n;
            int n2 = n = Math.min(dataChainSendOrderStructure.getOrderData().length, dataChainSendOrderStructure.getChannelCell().length - 3);
            if (this.m_supportFlowControl && dataChainSendOrderStructure.getAdditionalProtocolData() instanceof Boolean && ((Boolean)dataChainSendOrderStructure.getAdditionalProtocolData()).booleanValue()) {
                n2 |= Short.MIN_VALUE;
            }
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            try {
                dataOutputStream.writeShort(n2);
                dataOutputStream.flush();
                if (this.m_firstUpstreamPacket) {
                    byteArrayOutputStream.write(this.m_chainType);
                    this.m_firstUpstreamPacket = false;
                } else {
                    byteArrayOutputStream.write(0);
                }
                byteArrayOutputStream.write(dataChainSendOrderStructure.getOrderData(), 0, n);
                byteArrayOutputStream.flush();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            System.arraycopy(byteArrayOutputStream.toByteArray(), 0, dataChainSendOrderStructure.getChannelCell(), 0, byteArrayOutputStream.toByteArray().length);
            dataChainSendOrderStructure.setProcessedBytes(n);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Vector vector = this.getMessageQueuesNotificationsList();
        try {
            while (!Thread.interrupted()) {
                InternalChannelMessage internalChannelMessage = null;
                InternalChannelMessageQueue internalChannelMessageQueue = null;
                Object object = vector;
                synchronized (object) {
                    while (vector.size() == 0) {
                        vector.wait();
                    }
                    internalChannelMessageQueue = (InternalChannelMessageQueue)vector.firstElement();
                    internalChannelMessage = internalChannelMessageQueue.getFirstMessage();
                    internalChannelMessageQueue.removeFirstMessage();
                    vector.removeElementAt(0);
                }
                switch (internalChannelMessage.getMessageCode()) {
                    case 1: {
                        try {
                            ++this.m_downstreamSendMeCount;
                            object = new ChainCell(internalChannelMessage.getMessageData());
                            if (this.m_supportFlowControl && this.m_downstreamSendMeCount >= this.m_downstreamSendMeLimit) {
                                LogHolder.log(7, LogType.NET, "got sendme - and packet counter is: " + this.m_downstreamSendMeCount);
                                DataChainSendOrderStructure dataChainSendOrderStructure = new DataChainSendOrderStructure(new byte[0]);
                                dataChainSendOrderStructure.setAdditionalProtocolData(new Boolean(true));
                                this.orderPacket(dataChainSendOrderStructure);
                                this.m_downstreamSendMeCount = 0;
                            }
                            this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(1, ((ChainCell)object).getPayloadData()));
                        }
                        catch (InvalidChainCellException invalidChainCellException) {
                            this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException(invalidChainCellException.toString())));
                        }
                        break;
                    }
                    case 2: {
                        this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(2, null));
                        try {
                            if (internalChannelMessage.getMessageData() != null && ((ChainCell)(object = new ChainCell(internalChannelMessage.getMessageData()))).getPayloadLength() == 0 && ((ChainCell)object).getPayloadType() == 1) {
                                this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException("SingleChannelDataChain: run(): Last mix signaled connection error.")));
                                this.propagateConnectionError();
                            }
                        }
                        catch (InvalidChainCellException invalidChainCellException) {
                            this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException(invalidChainCellException.toString())));
                        }
                        internalChannelMessageQueue.deleteObserver(this);
                        Thread.currentThread().interrupt();
                        break;
                    }
                    case 3: {
                        this.addInputStreamQueueEntry(new DataChainInputStreamQueueEntry(new IOException("SingleChannelDataChain: run(): Channel signaled an exception - closing chain.")));
                    }
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void orderPacket(DataChainSendOrderStructure dataChainSendOrderStructure) {
        AbstractDataChannel abstractDataChannel = this.m_associatedChannel;
        synchronized (abstractDataChannel) {
            this.m_associatedChannel.processSendOrder(dataChainSendOrderStructure);
        }
    }

    protected void outputStreamClosed() throws IOException {
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeDataChain() {
        AbstractDataChannel abstractDataChannel = this.m_associatedChannel;
        synchronized (abstractDataChannel) {
            try {
                this.m_associatedChannel.organizeChannelClose();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class ChainCell {
        private static final short DATALENGTH_MASK = 1023;
        private byte[] m_payloadData;
        private int m_payloadLen;
        private int m_payloadType;
        private boolean m_flowControlFlagSet;

        public ChainCell(byte[] byArray) throws InvalidChainCellException {
            if (byArray.length < 3) {
                throw new InvalidChainCellException("SingleChannelDataChain: ChainCell: Constructor: Length of ChainCell must be at least 3 bytes.");
            }
            int n = 0;
            try {
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray, 0, 3));
                n = dataInputStream.readShort();
                this.m_payloadType = dataInputStream.readByte();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.m_flowControlFlagSet = false;
            short s = (short)(n & 0xFFFFFC00);
            if (SingleChannelDataChain.this.m_supportFlowControl && (s & Short.MIN_VALUE) == Short.MIN_VALUE) {
                this.m_flowControlFlagSet = true;
            }
            this.m_payloadLen = n & 0x3FF;
            int n2 = 3;
            if (n2 + this.m_payloadLen > byArray.length) {
                throw new InvalidChainCellException("SingleChannelDataChain: ChainCell: Constructor: ChainCell has invalid length-field.");
            }
            this.m_payloadData = new byte[this.m_payloadLen];
            System.arraycopy(byArray, n2, this.m_payloadData, 0, this.m_payloadLen);
        }

        public byte[] getPayloadData() {
            return this.m_payloadData;
        }

        public int getPayloadType() {
            return this.m_payloadType;
        }

        public int getPayloadLength() {
            return this.m_payloadLen;
        }

        public boolean isFlowControlFlagSet() {
            return this.m_flowControlFlagSet;
        }
    }

    private class InvalidChainCellException
    extends Exception {
        public InvalidChainCellException(String string) {
            super(string);
        }
    }
}

