/*
 * Decompiled with CFR 0.152.
 */
package anon.crypto;

import anon.crypto.AbstractX509Extension;
import anon.util.Util;
import java.util.Enumeration;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;

public final class X509Extensions {
    private DERObjectIdentifier X509_EXTENSIONS_IDENTIFIER = new DERObjectIdentifier("1.2.840.113549.1.9.14");
    private static final Vector KNOWN_CERTIFICATE_EXTENSIONS = new Vector();
    private static final Vector KNOWN_CRL_EXTENSIONS = new Vector();
    private static final Vector KNOWN_CRL_ENTRY_EXTENSIONS = new Vector();
    private DERSet m_extensions;
    private Vector m_vecExtensions;

    public X509Extensions(AbstractX509Extension abstractX509Extension) {
        this(Util.toVector(abstractX509Extension));
    }

    public X509Extensions(Vector vector) {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        if (vector == null) {
            vector = new Vector();
        }
        this.m_vecExtensions = new Vector();
        for (int i = 0; i < vector.size(); ++i) {
            if (!(vector.elementAt(i) instanceof AbstractX509Extension)) {
                throw new IllegalArgumentException("X509 extension expected, but was: " + vector.elementAt(i));
            }
            this.m_vecExtensions.addElement(vector.elementAt(i));
            aSN1EncodableVector.add((DEREncodable)((AbstractX509Extension)vector.elementAt(i)).getBCExtension());
        }
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add((DEREncodable)this.X509_EXTENSIONS_IDENTIFIER);
        aSN1EncodableVector2.add((DEREncodable)new DERSet((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector)));
        this.m_extensions = new DERSet((DEREncodable)new DERSequence((DEREncodableVector)aSN1EncodableVector2));
    }

    X509Extensions(DERSet dERSet) {
        this.m_extensions = dERSet;
        this.m_vecExtensions = new Vector();
        if (this.m_extensions.size() == 0) {
            return;
        }
        DERSequence dERSequence = (DERSequence)this.m_extensions.getObjectAt(0);
        DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)dERSequence.getObjectAt(0);
        if (!dERObjectIdentifier.equals((Object)this.X509_EXTENSIONS_IDENTIFIER)) {
            throw new IllegalArgumentException("Wrong identifier: " + dERObjectIdentifier.getId());
        }
        dERSequence = (DERSequence)((DERSet)dERSequence.getObjectAt(1)).getObjectAt(0);
        for (int i = 0; i < dERSequence.size(); ++i) {
            this.m_vecExtensions.addElement(AbstractX509Extension.getInstance((DERSequence)dERSequence.getObjectAt(i)));
        }
    }

    X509Extensions(org.bouncycastle.asn1.x509.X509Extensions x509Extensions) {
        this(X509Extensions.createExtensionsFromX509Extensions(x509Extensions));
    }

    public int getSize() {
        return this.m_vecExtensions.size();
    }

    public AbstractX509Extension getExtension(int n) {
        return (AbstractX509Extension)this.m_vecExtensions.elementAt(n);
    }

    public AbstractX509Extension getExtension(String string) {
        for (int i = 0; i < this.m_vecExtensions.size(); ++i) {
            AbstractX509Extension abstractX509Extension = (AbstractX509Extension)this.m_vecExtensions.elementAt(i);
            if (!abstractX509Extension.getIdentifier().equals(string)) continue;
            return abstractX509Extension;
        }
        return null;
    }

    public Vector getExtensions(String string) {
        Vector<AbstractX509Extension> vector = new Vector<AbstractX509Extension>();
        for (int i = 0; i < this.m_vecExtensions.size(); ++i) {
            AbstractX509Extension abstractX509Extension = (AbstractX509Extension)this.m_vecExtensions.elementAt(i);
            if (!abstractX509Extension.getIdentifier().equals(string)) continue;
            vector.addElement(abstractX509Extension);
        }
        return vector;
    }

    public Vector getExtensions() {
        return (Vector)this.m_vecExtensions.clone();
    }

    DERSet getBCExtensions() {
        return this.m_extensions;
    }

    org.bouncycastle.asn1.x509.X509Extensions getBCX509Extensions() {
        return new org.bouncycastle.asn1.x509.X509Extensions((ASN1Sequence)((DERSequence)((DERSet)((DERSequence)this.m_extensions.getObjectAt(0)).getObjectAt(1)).getObjectAt(0)));
    }

    private static Vector createExtensionsFromX509Extensions(org.bouncycastle.asn1.x509.X509Extensions x509Extensions) {
        Vector<AbstractX509Extension> vector = new Vector<AbstractX509Extension>();
        if (x509Extensions == null) {
            return vector;
        }
        DERSequence dERSequence = (DERSequence)x509Extensions.getDERObject();
        for (int i = 0; i < dERSequence.size(); ++i) {
            vector.addElement(AbstractX509Extension.getInstance((DERSequence)dERSequence.getObjectAt(i)));
        }
        return vector;
    }

    protected boolean hasUnknownCriticalExtensions() {
        Enumeration enumeration = this.m_vecExtensions.elements();
        while (enumeration.hasMoreElements()) {
            AbstractX509Extension abstractX509Extension = (AbstractX509Extension)enumeration.nextElement();
            String string = abstractX509Extension.getIdentifier();
            if (!abstractX509Extension.isCritical() || KNOWN_CERTIFICATE_EXTENSIONS.contains(string) || KNOWN_CRL_EXTENSIONS.contains(string) || KNOWN_CRL_EXTENSIONS.contains(string)) continue;
            return true;
        }
        return false;
    }

    static {
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(org.bouncycastle.asn1.x509.X509Extensions.AuthorityKeyIdentifier.toString());
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(org.bouncycastle.asn1.x509.X509Extensions.SubjectKeyIdentifier.toString());
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(org.bouncycastle.asn1.x509.X509Extensions.BasicConstraints.toString());
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(org.bouncycastle.asn1.x509.X509Extensions.KeyUsage.toString());
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(org.bouncycastle.asn1.x509.X509Extensions.IssuerAlternativeName.toString());
        KNOWN_CERTIFICATE_EXTENSIONS.addElement(org.bouncycastle.asn1.x509.X509Extensions.SubjectAlternativeName.toString());
        KNOWN_CRL_EXTENSIONS.addElement(org.bouncycastle.asn1.x509.X509Extensions.AuthorityKeyIdentifier.toString());
        KNOWN_CRL_EXTENSIONS.addElement(org.bouncycastle.asn1.x509.X509Extensions.IssuerAlternativeName.toString());
        KNOWN_CRL_EXTENSIONS.addElement(org.bouncycastle.asn1.x509.X509Extensions.IssuingDistributionPoint.toString());
        KNOWN_CRL_ENTRY_EXTENSIONS.addElement(org.bouncycastle.asn1.x509.X509Extensions.CertificateIssuer.toString());
    }
}

